//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006-2012 Mikhail Fedotov <anyremote@mail.ru>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _DISPATCHER_H_
#define _DISPATCHER_H_

#include <glib.h>

#define DM_SET		1
#define DM_SETFILE	2
#define DM_SENDB	3
#define DM_SENDS	4
#define DM_CKPD 	5
#define DM_CMER 	6

#define DM_EVENT_INIT       98
#define DM_EVENT_DISCONNECT 99
#define DM_EVENT_EXIT	    100

typedef struct {
    int        type;
    int        size;
    void*      value;
    char*      file;
} dMessage;

typedef struct {
    //int      proto;
    int      mode;
    int      port; 
    GString  *portStr;
    gboolean connected;  
} ConnectInfo;

gpointer dispatcherRoutine	(gpointer thread);
void  	 sendToDispatcher  	(dMessage *buf);
void     parseCommand           (char* cmd);
void     closePort              (int final);

#endif
