#ifndef _MMAP_CACHE_H
#define _MMAP_CACHE_H 

#define MAX_FNAME_LENGTH 70

/* hash table entry */
struct ht_entry;
typedef struct ht_entry ht_entry;

typedef struct ctrl_block ctrl_block;

struct ctrl_block {
    char fname[MAX_FNAME_LENGTH+1];
    int fname_len;
    caddr_t addr;
    int size; 
    time_t mtime;
    int ref_counter;
    ctrl_block *next;
    /* pointer to the hash table entry where my overflow chain starts */
    ht_entry *hte; 
};

struct ht_entry {
    ctrl_block *cb; 
};

struct mmap_cache_status {
    long req_cnt;
    long hit_cnt;
    long cached_files_size; 
    int  cached_files;
};

typedef struct mmap_cache_status mmap_cache_status;

extern mmap_cache_status mc_stat;

#endif
