
#ifdef DEBUG

#include "aclogger.h"
#include "acfg.h"
#include <string.h>

#include <assert.h>
#include <iostream>
#include <sstream>
#include <meta.h>

#ifndef SPAMLEVEL
#define SPAMLEVEL 10
#endif

#define ASSERT(x) { if(acfg::debug > SPAMLEVEL*2) assert(x); }

#define ldbg_always(x) { const char *p=strrchr(__FILE__, cPathSep); p=p?(p+1):__FILE__; MYSTD::ostringstream __oss;\
	__oss << p <<":"<<__LINE__ <<"("<< pthread_self() << ") | "<< x; aclog::err(__oss.str().c_str());}
//#define ldbg(x) { MYSTD::cerr << x << MYSTD::endl;}
//#define dbgline { MYSTD::cerr << __FILE__ << ": " << __LINE__ << MYSTD::endl;}
//#define ASSERT(x) assert(x)

#define USRDBG(v, x) { if((v)<=acfg::debug) {ldbg_always(x);} }
//#define ldbg(x) { ldbg_always(x); }
//#define dbgline { dbgline_always ; }
#define ldbg(x) { USRDBG(SPAMLEVEL, x); }

#define dbgline { ldbg(__FILE__ << ": " << __LINE__); }

#else
#define ldbg_always(x)
#define dbgline_always
#define ldbgvl(v, x)
#define dbglvl(v)
#define ldbg(x)
#define dbgline
#define ASSERT(x)
#define USRDBG(v, x)
#endif

