
#include "reportgen.h"

#include "meta.h"
#include "acbuf.h"
#include "acfg.h"
#include "aclogger.h"

#include "lockable.h"
#include "filereader.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <glob.h>

#include <vector>
#include <iostream>

#include <stdio.h>

using namespace MYSTD;

reportgen::reportgen(int fd) : maintenance(fd)
{
}

void reportgen::Run(const string &s)
{
	SendDecoration(true);
	GenReport();
	SendDecoration(false);
}

void reportgen::GenReport()
{
	filereader reader;
	string sTempFile=acfg::confdir+sPathSep+"report.html";
	if(!reader.OpenFile(sTempFile))
	{
		SendMsg(string("Unable to open template file, ")+sTempFile);
		return;
	}
	next_line:
	string sLine;
	//double factor;
	int nRatWid(200);
	vector<char> buf(4000);
	string sName=GetHostname();
	
	while(reader.GetOneLine(sLine))
	{
		SetStyle(sLine);
		tStrPos repl;
		while (stmiss!=(repl=sLine.find("$SERVERIP")))
		{
			sLine.replace(repl, 9, sName);
			repl+=sName.length();
		}
		
		tStrPos pos=0, posPrev=0;
		while(true)
		{
			pos=sLine.find('@', posPrev);
			if (pos==stmiss)
			{
				SendMsg(sLine.substr(posPrev)+sCRLF);
				break;
			}
			SendMsg(sLine.substr(posPrev, pos-posPrev));
			pos++;
			if (pos>=sLine.length())
			{
				SendMsg("<font size=+2 color=red>Template error detected</font>");
				return;
			}
			switch (sLine[pos])
			{
			case ('H'):
			{
				gethostname(&buf[0], buf.size());
				SendMsg(&buf[0]);
				break;
			}
			/* bloat
			case ('F'):
			{
				factor=atof(sLine.c_str()+pos+1);
				if(FP_NORMAL!=fpclassify(factor))
					factor=1.0;
				break;
			}
			*/
			case ('W'):
			{
				nRatWid=atoi(sLine.c_str()+pos+1);
				goto next_line;
			}
			case ('T'):
			{
				vector<aclog::tRowData> data;
				aclog::GetStats(data);
				for(vector<aclog::tRowData>::iterator it=data.begin(); it!=data.end(); it++)
				{
					char tbuf[50];
					size_t zlen(0);
					ctime_r(&it->from, tbuf);
					struct tm *tmp=localtime(& it->from);
					if (!tmp) goto time_error;
					zlen=strftime(tbuf, sizeof(tbuf), TIMEFORMAT, tmp);
					if ( !zlen ) goto time_error;
					
					if (it->from!=it->to)
					{
						tmp=localtime(& it->to);
						if(!tmp) goto time_error;
						if ( 0 == strftime(tbuf+zlen, sizeof(tbuf)-zlen, " - " TIMEFORMAT , tmp))
							goto time_error;
					}
					
										
					snprintf(&buf[0], buf.size(), (sLine.substr(pos+1)+sCRLF).c_str(),	
							tbuf, it->count/1048576, int(it->ratioSent*nRatWid), int((1.0-it->ratioSent)*nRatWid));
					SendMsg(&buf[0]);
					continue;
					time_error:
					SendMsg(" Invalid time value detected, check the stats database. ");
				}
				goto next_line;
			}
			default:
				//out+="<b>Unknown template variable</b>";
				SendMsg(string("@")+sLine[pos]);
				break;
			}
			posPrev=pos+1;
		}

	}
}

