#!/usr/bin/env python
from setuptools import *

import aptdaemon

setup(name="aptdaemon",
      version=aptdaemon.__version__,
      description="DBus driven daemon for APT",
      author="Sebastian Heinlein",
      packages=["aptdaemon"],
      scripts=["aptd", "aptdcon"],
      test_suite = "nose.collector",
      license = "GNU LGPL",
      data_files=[("../etc/dbus-1/system.d/",
                   ["data/org.debian.apt.conf"]),
                  ("../etc/apt/apt.conf.d/",
                   ["data/20dbus"]),
                  ("share/dbus-1/system-services/",
                   ["data/org.debian.apt.service"]),
                  ("share/man/man1",
                   ["doc/aptd.1", "doc/aptdcon.1"]),
                  ("share/man/man7",
                   ["doc/org.debian.apt.7",
                    "doc/org.debian.apt.transaction.7"])],
      platforms = "posix")

