#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-

import os
#import gtk
from ConfigParser import RawConfigParser as ConfigParser

_config = ConfigParser()
get = _config.get
set = _config.set
getboolean = _config.getboolean
getint = _config.getint
getfloat = _config.getfloat
write = _config.write
options = _config.options

# -- dirs and files --
CONFIG_DIR  = os.path.expanduser("~/.aptoncd/")
if not os.path.isdir(CONFIG_DIR):
    os.makedirs(CONFIG_DIR)
CONFIG_FILE  = os.path.join(CONFIG_DIR, "config")

# -- some variables --
I18N_APP = "aptoncd"
I18N_DIR = "locale/"
GUI	= "aptoncd.glade"
VERSION = "0.1"
XML_FILE = os.path.join(CONFIG_DIR, 'conf.xml')
XML_CONTENTS = "content.xml"

# documentation directory
import locale
language = locale.setlocale(locale.LC_ALL, '')
end = language.find('.')
language = language[:end]
DOCDIR		= "doc/"
if os.path.isdir(DOCDIR+language):
	DOC	= DOCDIR + language+ "/index.xml"
else:
	DOC	= DOCDIR+ "C/index.xml"

# list constants
(LIST_INSTALL, LIST_CONTENTS, LIST_NAME, LIST_SHORTDESC,
 LIST_VERSION, LIST_LONG_DESCR, LIST_PKG) = range(7)

# listStore constants
(C_CHECKED, C_TITLE, C_CUSTOM, C_PKG, C_CANCHECK,C_DISABLED) = range(6) 

CD = 695 * 1024 * 1024
DVD = 4500 * 1024 * 1024

LOCAL_APT_FOLDER = "/var/cache/apt/archives/"

TMP_PATH = "/tmp/aptoncd/"
if not os.path.isdir(TMP_PATH):
    os.makedirs(TMP_PATH)

# -- write config --
def write(filename):
    if isinstance(filename, str):
        if not os.path.isdir(os.path.dirname(filename)):
            os.makedirs(os.path.dirname(filename))
        f = file(filename, "w")
    else: f = filename
    _config.write(f)
    f.close()

# -- load default values --
def init(*rc_files):
    initial = {
        # Configuration defaults

        "cache":
        {
            "isofile": "aptoncd.iso",
            "to": os.path.expanduser("~/aptoncd/"),
            "packages": os.path.expanduser("~/aptoncd/") + "packages/",
            "metapackage": "False"
        },
        
         "misc":
         {
           "version": "0.1",
         }

    }

    for section, values in initial.iteritems():
        _config.add_section(section)
        for key, value in values.iteritems():
            _config.set(section, key, value)

    _config.read(rc_files)

def state(arg):
    return _config.getboolean("settings", arg)
