<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE interface [
	<!ENTITY cr "&#xa;">
	<!ENTITY tab "&#x9;">
]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Stylesheet setup -->
<xsl:output method="text"/>
<xsl:strip-space elements="RiAPI"/>
<xsl:include href="api_utils.xsl"/>


<!-- Main entry point for matches. -->
<xsl:template match="RiAPI">
//------------------------------------------------------------------------------
//-------------------- Autogenerated header, do not edit. ----------------------
//------------------------------------------------------------------------------

// List of request names
const char* requestNames[] = {
<xsl:apply-templates select="Procedures/Procedure[Rib]" mode="request_name_array"/>
};

// List of handlers for requests
TqRequestHandler requestHandlers[] = {
<xsl:apply-templates select="Procedures/Procedure[Rib]" mode="request_handler_method_array"/>
};
</xsl:template>

<xsl:template match="Procedure" mode="request_name_array">
	<xsl:text>&tab;"</xsl:text>
	<xsl:value-of select="substring-after(Name,'Ri')"/>
	<xsl:text>",&cr;</xsl:text>
</xsl:template>

<xsl:template match="Procedure" mode="request_handler_method_array">
	<xsl:text>&tab;&amp;CqRibRequestHandler::handle</xsl:text>
	<xsl:value-of select="substring-after(Name,'Ri')"/>
	<xsl:text>,&cr;</xsl:text>
</xsl:template>

</xsl:stylesheet>
