# 
# make-lock.sh - create a lock directory
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*create a lock directory\\n"
		printf "usage: make-lock [options] lock-name\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Create a lock directory.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    -*)			printf "make-lock: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: make-lock [options] lock-name\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

lockname="$1"

################################################################
# Sanity Check and Process Defaults
# 



################################################################
# Make the Lock
# 

mkdir "+$lockname"
mkdir "+$lockname/+contents"

