# 
# branches.sh - print a list of branches in an archive
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "list the branches in an archive category\\n"
		printf "usage: branches [options] [category]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archive archive          specify the archive name\\n"
		printf "\\n"
		printf "Print a list of branches within CATEGORY.\\n"
		printf "\\n"
		printf "The output format is:\\n"
		printf "\\n"
		printf "	\"%%s\\n\" \"\$branch\" \\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "make-category: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "make-category: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;


    -*)			printf "branches: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -gt 1 ; then
  printf "usage: branches [options] [category]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

if test $# -ne 0 ; then
  cat="$1"
  shift
else
  cat=
fi

################################################################
# Sanity Check and Process Defaults
# 

if test -z "$cat" ; then
  version="`larch tree-version .`"
  if test -z "$archive" ; then
    archive="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --arch \"$version\"`"
  fi
  cat="`larch parse-package-name --basename \"$version\"`"
fi

larch valid-package-name -b -- "$cat"
archive="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --arch \"$cat\"`"
category="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --basename \"$cat\"`"


################################################################
# Establish an Archive Connection
# 

if test "$WITHARCHIVE" != "$archive" ; then
  exec larch with-archive -A "$archive" larch branches "$archive/$category"
fi



################################################################
# Print the List
# 

basere="([a-zA-Z]([a-zA-Z0-9]*(-[a-zA-Z0-9]+)?)*)"

wftp-home
wftp-cd "$category"
wftp-ls | grep -E "^($basere)(--$basere)?$" | sort

