
BEGIN {
        rev_seq = 0;
      }

{

  rev = $0;

  revs_in_order[rev_seq] = rev;
  ++rev_seq;

  if (system("test -e " rev "/,,patch-set/mod-dirs-index"))
    {
      is_full_source = 1;
    }
  else
    {
      is_full_source = 0;
    }
  
  while (getline < (rev "/,,index"))
    {
      loc = $1;
      tag = $2;

      if (!known_tags[tag])
	{
	  known_tags[tag] = 1;

	  if (is_full_source)
	    {
	      rev_changes[rev, tag] = "A";
	      new_names[rev, tag] = loc;
	    }
	  else
	    {
	      rev_changes[rev, tag] = "I";
	      new_names[rev, tag] = loc;
	    }
	}
    }

  if (!is_full_source)
    {
      for (x in orig_files)
	delete orig_files[x];
      for (x in mod_files)
	delete mod_files[x];

      for (x in orig_locs)
	delete orig_locs[x];
      for (x in mod_locs)
	delete mod_locs[x];

      while (getline < (rev "/,,patch-set/orig-files-index"))
	{
	  loc = $1;
	  tag = $2;

	  orig_locs[tag] = loc;
	  orig_files[tag] = 1;
	}

      while (getline < (rev "/,,patch-set/mod-files-index"))
	{
	  loc = $1;
	  tag = $2;

	  mod_locs[tag] = loc;
	  mod_files[tag] = 1;

	  if (!orig_files[tag])
	    {
	      rev_changes[rev, tag] = "A";
	      new_names[rev, tag] = loc;
	    }
	  else
	    {
	      patch_stem = rev "/,,patch-set/patches/" loc;

	      if (   !system("test -e " patch_stem ".link-mod") \
		  || !system("test -e " patch_stem ".modified") \
		  || !system("test -e " patch_stem ".patch") \
		  || !system("test -e " patch_stem ".meta-mod"))
		{
		  rev_changes[rev, tag] = rev_changes[rev, tag] "M";
		}

	      if (orig_locs[tag] != mod_locs[tag])
		{
		  rev_changes[rev, tag] = rev_changes[rev, tag] "R";
		  new_names[rev, tag] = loc;
		}
	    }
	}

      for (tag in orig_files)
	{
	  if (!mod_files[tag])
	    {
	      rev_changes[rev, tag] = rev_changes[rev, tag] "D";
	    }
	}

      for (x in orig_dirs)
	delete orig_dirs[x];
      for (x in mod_dirs)
	delete mod_dirs[x];

      for (x in orig_locs)
	delete orig_locs[x];
      for (x in mod_locs)
	delete mod_locs[x];

      while (getline < (rev "/,,patch-set/orig-dirs-index"))
	{
	  loc = $1;
	  tag = $2;

	  orig_locs[tag] = loc;
	  orig_dirs[tag] = 1;
	}

      while (getline < (rev "/,,patch-set/mod-dirs-index"))
	{
	  loc = $1;
	  tag = $2;

	  mod_locs[tag] = loc;
	  mod_dirs[tag] = 1;

	  if (!orig_dirs[tag])
	    {
	      rev_changes[rev, tag] = "A";
	      new_names[rev, tag] = loc;
	    }
	  else
	    {
	      patch_stem = rev "/,,patch-set/patches/" loc;

	      if (!system("test -e " patch_stem "/=dir-meta-mod"))
		{
		  rev_changes[rev, tag] = rev_changes[rev, tag] "M";
		}

	      if (orig_locs[tag] != mod_locs[tag])
		{
		  rev_changes[rev, tag] = rev_changes[rev, tag] "R";
		  new_names[rev, tag] = loc;
		}
	    }
	}

      for (tag in orig_dirs)
	{
	  if (!mod_dirs[tag])
	    {
	      rev_changes[rev, tag] = rev_changes[rev, tag] "D";
	    }
	}
    }
}


END {
       for (tag in known_tags)
	 {
	   printf("%s\n", tag);

	   for (x = 0; x < rev_seq; ++x)
	     {
	       if (rev_changes[revs_in_order[x], tag] != "")
		 {
		   printf("\t%s\t%s", revs_in_order[x], rev_changes[revs_in_order[x], tag]);
		   if (new_names[revs_in_order[x], tag] != "")
		     {
		       printf("\t%s", new_names[revs_in_order[x], tag]);
		     }
		   printf("\n");
		 }
	     }
	 }
      

    }


# tag: Tom Lord Sun Jan 27 04:14:43 2002 (library/file-history.awk)
#
