# 
# tree-version.sh - default version of a project tree
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "print the default version for a project tree\\n"
		printf "usage: tree-version [options] [dir]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Print the default version of project tree DIR (or\\n"
		printf "the current directory)."
		printf "\\n"
		printf "The version name is printed in fully qualified form:\\n"    
		printf "\\n"
		printf "	\"%%s/%%s\\\\n\"  \$archive \$version\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    -*)			printf "tree-version: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -gt 1 ; then
  printf "usage: tree-version [options] [dir]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

if test $# -eq 1 ; then
  dir="$1"
else
  dir="."
fi

cd "$dir"
dir="`pwd`"

################################################################
# Sanity Check and Process Defaults
# 

cd "$dir"
wdroot="`larch tree-root`"

################################################################
# Print the default version, if any.
# 

cd "$wdroot/{arch}"

if test -e ++default-version ; then
  answer="`cat ++default-version`"

  # be paranoid:
  # 
  larch valid-package-name -e tree-version --vsn -- "$answer"
  printf "%s\n" "$answer"
  exit 0
else
  printf "tree-version: no default version set for %s\\n" "$dir" 1>&2
  printf "  try \"larch set-tree-version --help\"\\n" 1>&2
  exit 1
fi
