/*
    Copyright (C) 2004 Paul Davis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: ardour_message.h,v 1.3 2005/12/02 07:26:39 essej Exp $

*/

#ifndef __ardour_message_h__
#define __ardour_message_h__

#include <string>

#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/label.h>

#include "ardour_dialog.h"

class ArdourMessage : public ArdourDialog
{
  public:
	enum ButtonState {
		OK_BUTTON = 1,
		YES_BUTTON = 2,
		NO_BUTTON  = 4,
		CANCEL_BUTTON = 8
	};
	
	ArdourMessage (Gtk::Window* parent, 
		       std::string name, std::string msg, 
		       bool grabfocus = true, 
		       bool autorun = true,
		       int button_state=OK_BUTTON);
	~ArdourMessage();

  private:
	Gtk::VBox   packer;
	Gtk::HBox   bpacker;
	Gtk::Button ok_button;
	Gtk::Button cancel_button;
	Gtk::Button yes_button;
	Gtk::Button no_button;
	Gtk::Label  label;
	
};

#endif // __ardour_message_h__
