/*
    Copyright (C) 2003 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: axis_view.cc,v 1.8 2004/11/29 03:04:32 pauld Exp $
*/

#include <cstdlib>
#include <cmath>

#include <algorithm>
#include <string>

#include <list>

#include <pbd/error.h>

#include <gtkmmext/utils.h>
#include <gtkmmext/selector.h>
#include <gtkmmext/gtk_ui.h>

#include <ardour/session.h>
#include <ardour/utils.h>

#include "public_editor.h"
#include "axis_view.h"
#include "i18n.h"

using namespace Gtk;
using namespace Gtkmmext;


list<GdkColor> AxisView::used_colors;

AxisView::AxisView (ARDOUR::Session& sess) : _session(sess)
{
	_selected = false;
}

AxisView::~AxisView()
{

}

GdkColor
AxisView::unique_random_color()
{
	GdkColor newcolor;
	
	while (1) {

		/* avoid neon/glowing tones by limiting them to the
		   "inner section" (paler) of a color wheel/circle.
		*/

		const int32_t max_saturation = 48000; // 65535 would open up the whole color wheel

		newcolor.red = random() % max_saturation;
		newcolor.blue = random() % max_saturation;
		newcolor.green = random() % max_saturation;

		if (used_colors.size() == 0) {
			used_colors.push_back (newcolor);
			return newcolor;
		}
		
		for (list<GdkColor>::iterator i = used_colors.begin(); i != used_colors.end(); ++i) {
			GdkColor c = *i;
			float rdelta, bdelta, gdelta;
			
			rdelta = newcolor.red - c.red;
			bdelta = newcolor.blue - c.blue;
			gdelta = newcolor.green - c.green;

			if (sqrt (rdelta*rdelta + bdelta*bdelta + gdelta*gdelta) > 25.0) {
				used_colors.push_back (newcolor);
				return newcolor;
			}
		}

		/* XXX need throttle here to make sure we don't spin for ever */
	}
}
