// -*- c++ -*-
//  Generated by gtkmmproc from ./../pixmap.gen_h -- DO NOT MODIFY!
#include <gtk--/pixmap.h>
#include <gtk--/private/pixmap_p.h>
#include <sys/stat.h>
//#include <unistd.h>
namespace Gtk
{


Pixmap::Pixmap() :
  Misc((GtkMisc*)(gtk_object_new(get_type(),0))),
  xpm_file_name_(0), data_(0)
{
  initialize_class();
  gtkobj()->pixmap = 0;
  gtkobj()->mask = 0;
}

Pixmap::Pixmap(const nstring &xpmfilename)
  : Misc((GtkMisc*)(gtk_object_new(get_type(),0))),
    xpm_file_name_(xpmfilename), data_(0)
{
  initialize_class();


  struct stat dummyBuf;

  if(!xpmfilename.null() // if there's actually a filename
     && stat(xpmfilename.gc_str(), &dummyBuf) == -1) // but the file doesn't exist
    {
      Gdk_Pixmap::warn_about_xpm_file_problem(xpmfilename); // whine
      xpm_file_name_ = ""; // forget that pixmap file
    }
  gtkobj()->pixmap = 0;
  gtkobj()->mask = 0;
}

Pixmap::Pixmap(const char * const *xpmdata)
  : Misc((GtkMisc*)(gtk_object_new(get_type(),0))),
    xpm_file_name_(0),data_(xpmdata)
{
  initialize_class();
  gtkobj()->pixmap = 0;
  gtkobj()->mask = 0;
}

Pixmap::Pixmap(const Gdk_Pixmap &val, const Gdk_Bitmap &mask)
  :     Misc((GtkMisc*)(gtk_object_new(get_type(),0))),
        xpm_file_name_(0),data_(0)
{
  initialize_class();
  GtkPixmap *pixmap;

  g_return_if_fail (val.connected());
  pixmap = (GtkPixmap*)gtkobject;

  gtk_pixmap_set (pixmap, val, mask);

}

void Pixmap::realize_impl()
{
  Misc::realize_impl();


  if (gtkobj()->pixmap) return;  // is the pixmap is already created, bail.

  load_xpm();
}


void Pixmap::load_xpm()
{
  Gdk_Bitmap bitmap;
  GtkWidget *widget=Widget::gtkobj();

  while (widget&&!widget->window)
    widget=widget->parent;

  g_return_if_fail (Widget::gtkobj()->style!=0);
  g_return_if_fail (widget!=0);

  Gdk_Window gdkwin=Gdk_Window(widget->window);
  GtkStyle *style=Widget::gtkobj()->style;
  Gdk_Pixmap pm = Gdk_Pixmap((GdkPixmap*)0);

  if (xpm_file_name_.length()) {
    pm.create_from_xpm(gdkwin,bitmap,
                       Gdk_Color(&style->bg[GTK_STATE_NORMAL]),
                       xpm_file_name_);

    // We don't need to pm anymore since create_from_xpm will default
    // to the internal default pixmap - note that this can happen only
    // in the unlikely case a .xpm gets deleted between the Gtk_Pixmap
    // construction and the actual realization of the widget - GL

  }
  else
  {
    if (!data_)
      data_ = Gdk_Pixmap::defaultPixmap;
    pm.create_from_xpm_d(gdkwin,bitmap,Gdk_Color(&style->bg[GTK_STATE_NORMAL]),data_);
  }

  gtk_pixmap_set (gtkobj(), pm, bitmap);
}

Pixmap::Pixmap(GtkPixmap *castitem)
  :     Misc(GTK_MISC(castitem)),
        xpm_file_name_(0),data_(0)
{
  initialize_class();
}

void Pixmap::unset()
{
  if (gtkobj()->pixmap)
    gdk_pixmap_unref (gtkobj()->pixmap);
  if (gtkobj()->pixmap_insensitive)
    gdk_pixmap_unref (gtkobj()->pixmap_insensitive);
  if (gtkobj()->mask)
    gdk_bitmap_unref (gtkobj()->mask);

  gtkobj()->pixmap = 0;
  gtkobj()->pixmap_insensitive = 0;
  gtkobj()->mask = 0;
}

void Pixmap::set(const gchar * const *data)
{
  data_=data;
  xpm_file_name_="";
  if (is_realized())
    load_xpm();
  else
    unset();
}

void Pixmap::set(const string &xpmfilename)
{
  data_=0;
  xpm_file_name_=xpmfilename;
  if (is_realized())
    load_xpm();
  else
    unset();
}


void
Pixmap::get(Gdk_Pixmap &pixmap, Gdk_Bitmap &mask) const
{
  GdkPixmap *pix;
  GdkBitmap *bit;
  gtk_pixmap_get(const_cast<GtkPixmap*>(gtkobj()),&pix,&bit);
  pixmap=Gdk_Pixmap(pix);
  mask=Gdk_Bitmap(bit);
}

}

namespace Gtk {
Gtk::Pixmap *wrap (GtkPixmap *o)
  {
    return static_cast<Gtk::Pixmap *> (Gtk::wrap_auto ((GtkObject *) (o)));
  }
}

namespace Gtk {
Pixmap_Class Pixmap::pixmap_class = {0};

Object* Pixmap_Class::wrap_new(GtkObject* o)
  {
    Object* cpp=manage(new Pixmap((GtkPixmap*)(o)));
    return cpp;
  }

bool Pixmap::isA( Object *checkcast)
  {
    return GTK_IS_PIXMAP(checkcast->gtkobj());
  }

GtkType Pixmap::get_type()
  {
    return pixmap_class.get_type();
  }

GtkType Pixmap_Class::get_type()
  {
    if (!type)
      {
        CppClassParent::CppObjectType::get_type();
        GtkTypeInfo info =
          {
            "Gtk__Pixmap",
            sizeof(BaseObjectType),
            sizeof(BaseClassType),
            (GtkClassInitFunc) class_init_function,
            (GtkObjectInitFunc) object_init_function,
            /* reserved_1 */ NULL,
            /* reserved_2 */ NULL,
            /*base_class_init_func */ (GtkClassInitFunc) NULL
          };
        type=gtk_type_unique(gtk_pixmap_get_type(), &info);
      }
    return type;
  }

const char* const Pixmap::signal_names[]={
   0};

void Pixmap::initialize_class()
  {

  }

void Pixmap_Class::class_init_function(GtkPixmapClass *klass)
  {
    CppClassParent::class_init_function((BaseClassParent*)klass);
  }

void Pixmap_Class::object_init_function(GtkPixmap *)
  {}

}

Gtk::Pixmap::~Pixmap() { destroy_(); }

void Gtk::Pixmap::set(const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask)
  {
    gtk_pixmap_set(gtkobj(),const_cast<GdkPixmap*>(pixmap.gdkobj()),const_cast<GdkBitmap*>(mask.gdkobj()));
  }

void Gtk::Pixmap::set_build_insensitive(bool build)
  {
    gtk_pixmap_set_build_insensitive(gtkobj(),build);
  }
