/*
    Copyright (C) 2004 Paul Davis
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: bindable_button.cc,v 1.1 2004/08/10 08:29:42 essej Exp $
*/

#include <string>
#include <climits>
#include <iostream>

#include <midi++/controllable.h>

#include <gtkmmext/gtk_ui.h>
#include <gtkmmext/bindable_button.h>

#include "i18n.h"

using namespace Gtkmmext;
using namespace std;

BindableToggleButton::BindableToggleButton (MIDI::Controllable *mc)
	: ToggleButton (),
	  prompter (GTK_WIN_POS_MOUSE, 30000, false),
	  midi_control (mc),
	  bind_button (2),
	  bind_statemask (GDK_CONTROL_MASK)

{			  
	init_events ();
}

BindableToggleButton::BindableToggleButton(MIDI::Controllable *mc, const string &label,gfloat x,gfloat y)
	: ToggleButton (label, x, y),
	  prompter (GTK_WIN_POS_MOUSE, 30000, false),
	  midi_control (mc),
	  bind_button (2),
	  bind_statemask (GDK_CONTROL_MASK)
{			  
	init_events ();
}


void
BindableToggleButton::init_events ()
{
	button_press_event.connect (slot (*this, &BindableToggleButton::button_press));

	prompter.unmap_event.connect (slot (*this, &BindableToggleButton::prompter_hiding));
	
	prompting = false;
	unprompting = false;
	
	if (midi_control) {
		midi_control->learning_started.connect (slot (*this, &BindableToggleButton::midicontrol_prompt));
		midi_control->learning_stopped.connect (slot (*this, &BindableToggleButton::midicontrol_unprompt));
	}
}

void
BindableToggleButton::set_bind_button_state (guint button, guint statemask)
{
	bind_button = button;
	bind_statemask = statemask;
}

void
BindableToggleButton::get_bind_button_state (guint &button, guint &statemask)
{
	button = bind_button;
	statemask = bind_statemask;
}

void
BindableToggleButton::midi_learn()
{
	if (midi_control) {
		prompting = true;
		midi_control->learn_about_external_control ();
	}
}


gint
BindableToggleButton::button_press (GdkEventButton *ev)
{
	
	if ((ev->state & bind_statemask) && ev->button == bind_button) { 
		midi_learn ();
		return TRUE;
	}

	return FALSE;
}

gint
BindableToggleButton::prompter_hiding (GdkEventAny *ev)
{
	if (unprompting) {
		if (midi_control) {
			midi_control->stop_learning();
		}
		unprompting = false;
	}
	
	return FALSE;
}


void
BindableToggleButton::midicontrol_set_tip ()

{
	if (midi_control) {
		// Gtkmmext::UI::instance()->set_tip (evbox, midi_control->control_description());
	}
}

void
BindableToggleButton::midicontrol_prompt ()

{
	if (prompting) {
		string prompt = _("operate MIDI controller now");
		prompter.set_text (prompt);
		Gtkmmext::UI::instance()->touch_display (&prompter);
		
		unprompting = true;
		prompting = false;
	}
}

void
BindableToggleButton::midicontrol_unprompt ()

{
	if (unprompting) {
		Gtkmmext::UI::instance()->touch_display (&prompter);
		unprompting = false;
	}
}


