/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

#ifndef ArgusUtil_h
#define ArgusUtil_h

#if !defined(__OpenBSD__) || !defined(_NETINET_IF_SYSTEM_H_)
#include <netinet/in_systm.h>
#define _NETINET_IF_SYSTEM_H_
#endif

#if defined(__OpenBSD__)
#ifndef _NETINET_IP_H_
#include <netinet/ip.h>
#define _NETINET_IP_H_
#endif
#else
#include <netinet/ip.h>
#endif


#include <argus_out.h>
#include <cons_out.h>

#include <CflowdFlowPdu.h>


typedef void (*proc)(void);

struct QUEUE_HEADER {
   struct QUEUE_HEADER *nxt;
   struct QUEUE_HEADER *prv;
   struct QUEUE *queue;
   struct timeval last_time, logtime;
};


struct QUEUE {
   struct QUEUE_HEADER *start;
   proc timerRoutine, logRoutine;
   unsigned int count;
};

struct HASH_TABLE_HEADER {
   struct HASH_TABLE_HEADER *nxt;
   struct HASH_TABLE_HEADER *prv;
   unsigned int hash;
};
 
struct HASH_TABLE {
   struct HASH_TABLE_HEADER **hash_array;
   unsigned int size;
};


struct FILE_ENTRY {
   struct FILE_ENTRY *nxt;
   char *str;
};


#define Version1        1
#define Version5        5
#define Version6        6
#define Version7        7
#define Version8        8

typedef struct ArgusRecord * (*ArgusNetFlowHandler)(u_char **);
 
struct ArgusRecord *ArgusNetFlowCallRecord (u_char **);
struct ArgusRecord *ArgusNetFlowDetailInt  (u_char **);
struct ArgusRecord *ArgusParseCiscoRecord (u_char **);


#ifdef ARGUS_SASL
#include <sasl.h>
#endif

#define ARGUS_DATA_SOURCE		0x01
#define ARGUS_CISCO_DATA_SOURCE		0x10

struct ARGUS_INPUT {
   struct ARGUS_INPUT *nxt;
   arg_uint32 addr;
   char *hostname;
   char *filename;
   FILE *pipe, *in, *out;
   int fd, major_version, minor_version;
   unsigned int status;
   unsigned short portnum;
   unsigned int ArgusLocalNet, ArgusNetMask;
   unsigned char *ArgusReadBuffer, *ArgusConvBuffer;
   unsigned char *ArgusReadPtr, *ArgusConvPtr, *ArgusReadBlockPtr;
   int ArgusReadSocketCnt, ArgusReadSocketSize;
   int ArgusReadSocketState, ArgusReadCiscoVersion;
   int ArgusReadSocketNum, ArgusReadSize;
   ArgusNetFlowHandler ArgusCiscoNetFlowParse;

#ifdef ARGUS_SASL
   sasl_conn_t *sasl_conn;
   int ArgusSaslBufCnt;
   unsigned char *ArgusSaslBuffer;
#endif

   struct ArgusRecord ArgusInitCon, ArgusManStart;
};


#define TSEQ_HASHSIZE      9029

#define HASHNAMESIZE  4096

#define ipaddr_string(p) getname((u_char *)(p))

#ifdef ArgusUtil

#define IPPROTOSTR 134

char *ip_proto_string [IPPROTOSTR] = {"ip", "icmp", "igmp", "ggp",
   "ipnip", "st", "tcp", "ucl", "egp", "igp", "bbn-rcc-mon", "nvp-ii",
   "pup", "argus", "emcon", "xnet", "chaos", "udp", "mux", "dcn-meas",
   "hmp", "prm", "xns-idp", "trunk-1", "trunk-2", "leaf-1", "leaf-2",
   "rdp", "irtp", "iso-tp4", "netblt", "mfe-nsp", "merit-inp", "sep",
   "3pc", "idpr", "xtp", "ddp", "idpr-cmtp", "tp++", "il", "ipv6",
   "sdrp", "ipv6-route", "ipv6-frag", "idrp", "rsvp", "gre", "mhrp", "bna",
   "esp", "ah", "i-nlsp", "swipe", "narp", "mobile", "tlsp", "skip",
   "ipv6-icmp", "ipv6-no", "ipv6-opts", "any", "cftp", "any", "sat-expak", "kryptolan",
   "rvd", "ippc", "any", "sat-mon", "visa", "ipcv", "cpnx", "cphb", "wsn",
   "pvp", "br-sat-mon", "sun-nd", "wb-mon", "wb-expak", "iso-ip", "vmtp",
   "secure-vmtp", "vines", "ttp", "nsfnet-igp", "dgp", "tcf", "igrp",
   "ospfigp", "sprite-rpc", "larp", "mtp", "ax.25", "ipip", "micp",
   "aes-sp3-d", "etherip", "encap", "pri-enc", "gmtp", "ifmp", "pnni",
   "pim", "aris", "scps", "qnx", "a/n", "ipcomp", "snp", "compaq-peer",
   "ipx-n-ip", "vrrp", "pgm", "zero", "l2tp", "ddx", "iatp", "stp", "srp",
   "uti", "smp", "ptp", "isis", "fire", "crtp", "crudp", "sccopmce", "iplt",
   "sps", "pipe", "sctp", "fc",
};


#if !defined(__OpenBSD__) || !defined(_NETINET_IP_ICMP_H_)
#include <netinet/ip_icmp.h>
#define _NETINET_IP_ICMP_H_
#endif

char *icmptypestr[ICMP_MAXTYPE + 1] = {
   "ECR", "   ", "   ", "UR", "SRC", "RED",
   "   ", "   ", "ECO", "RTA", "RTS", "TXD",
   "PAR", "TST", "TSR", "IRQ", "IRR", "MAS",
   "MSR",
};   


int ArgusSrcUserDataLen = 0;
int ArgusDstUserDataLen = 0;

void ArgusAdjustGlobalTime (struct timeval *);
u_int ArgusIndexNetworkRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);
u_int ArgusIndexRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);

int ArgusConvertInitialWriteStruct (struct WriteStruct *, struct ArgusRecord *);
int ArgusConvertWriteStruct (struct WriteStruct *, struct ArgusRecord *);

char *print_time(struct timeval *);
void print_date(struct ArgusRecord *, char *);

char *get_man_string (struct ArgusRecord *ptr);
char *get_tcp_string (struct ArgusRecord *ptr);
char *get_icmp_string (struct ArgusRecord *ptr);
char *get_udp_string (struct ArgusRecord *ptr);
char *get_ip_string (struct ArgusRecord *ptr);
char *get_arp_string (struct ArgusRecord *ptr);
char *get_nonip_string (struct ArgusRecord *ptr);

char *RaGetUserDataString (struct ArgusRecord *);

int ArgusEncode (const char *, int, char *, int);
int ArgusEncode64 (const char *, int, char *, int);
int ArgusEncodeAscii (const char *, int, char *, int);

extern unsigned int thisnet, localaddr, localnet, netmask;


#else

extern int ArgusSrcUserDataLen;
extern int ArgusDstUserDataLen;


extern void ArgusAdjustGlobalTime (struct timeval *);
extern u_int ArgusIndexNetworkRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);
extern u_int ArgusIndexRecord (struct ArgusRecord *, struct ArgusFarHeaderStruct **);

extern int ArgusConvertInitialWriteStruct (struct WriteStruct *, struct ArgusRecord *);
extern int ArgusConvertWriteStruct (struct WriteStruct *, struct ArgusRecord *);

extern char *print_time(struct timeval *);
extern void print_date(struct ArgusRecord *, char *);

extern char *get_man_string (struct ArgusRecord *ptr);
extern char *get_tcp_string (struct ArgusRecord *ptr);
extern char *get_icmp_string (struct ArgusRecord *ptr);
extern char *get_udp_string (struct ArgusRecord *ptr);
extern char *get_ip_string (struct ArgusRecord *ptr);
extern char *get_arp_string (struct ArgusRecord *ptr);
extern char *get_nonip_string (struct ArgusRecord *ptr);

extern char *RaGetUserDataString (struct ArgusRecord *);

extern int ArgusEncode (const char *, int, char *, int);
extern int ArgusEncode64 (const char *, int, char *, int);
extern int ArgusEncodeAscii (const char *, int, char *, int);

#endif 
#endif /* ArgusUtil_h */
