/*
 * Prototypes for debugging routines
 */
#if !defined(LIBYAHOO_DEBUG_H)
#define LIBYAHOO_DEBUG_H

#if defined(ENABLE_DEBUG)
int yahoo_dbg_Open(const char *file);
int yahoo_dbg_Disable(const char *key);
int yahoo_dbg_Enable(const char *key);
int yahoo_dbg_Print(const char *key, char *format, ...);
int yahoo_dbg_Close(void);
int yahoo_dbg_IsEnabled(char *key);

#else
inline int yahoo_dbg_Open(const char *file);
inline int yahoo_dbg_Disable(const char *key);
inline int yahoo_dbg_Enable(const char *key);
inline int yahoo_dbg_Print(const char *key, char *format, ...);
inline int yahoo_dbg_Close(void);
inline int yahoo_dbg_IsEnabled(const char *key);

#endif

char *yahoo_unraw_buffer(char *buffer, unsigned int len);

#define yahoo_dbg_NullCheck(x) ((x)?(x):("[NULL]"))

#endif
