//
//  Aria - yet another download tool
//  Copyright (C) 2000, 2001 Tatsuhiro Tsujikawa
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

// $Id: Options.cc,v 1.38 2001/10/17 13:06:34 tujikawa Exp $

// implementation of class Options

#include "Options.h"

Userdata::Userdata()
{
}

Userdata::Userdata(const string& username_in, const string& password_in)
{
  username = username_in;
  password = password_in;
}

Userdata::~Userdata()
{
}

void Userdata::set_userpasswd(const string& username_in, const string& password_in)
{
  username = username_in;
  password = password_in;
}

Options::Options(bool use_authentication_in,
		 const Userdata& user_in,
		 const string& store_dir_in,
		 const string& http_version_in,
		 PrewrittenHTMLType prewrittenHTMLType_in,
		 const string& prewrittenHTMLName_in,
		 bool sync_with_url_in,
		 RefererType referer_type_in,
		 const string& referer_in,
		 const string& useragent_in,
		 bool random_useragent_in,
		 bool use_http_proxy_in,
		 bool use_http_cache_in,
		 bool use_http_proxy_authentication_in,
		 const Userdata& http_proxy_user_in,
		 const Proxyserver& http_proxy_in,
		 unsigned int timedout_in,
		 unsigned int divide_in,
		 int rollback_bytes_in,
		 bool use_size_lower_limit_in,
		 int size_lower_limit_in,
		 bool use_no_redownload_in,
		 bool use_no_download_samename_in,
		 unsigned int recurse_in,
		 bool recurse_with_hostname_dir_in,
		 bool recurse_abs2rel_in,
		 bool recurse_force_convert_in,
		 bool recurse_del_comment_in,
		 bool recurse_del_javascript_in,
		 bool recurse_del_iframe_in,
		 bool recurse_no_other_host_in,
		 bool recurse_no_ascend_in,
		 bool recurse_relative_only_in,
		 bool recurse_referer_override_in,
		 bool recurse_follow_ftp_link_in,
		 bool recurse_convert_tilde_in,
		 bool recurse_no_redownload_in,
		 bool recurse_add_paste_in,
		 bool tag_href_in,
		 bool tag_src_in,
		 bool tag_background_in,
		 bool tag_code_in,
		 bool use_down_filter_in,
		 const list<string>& filter_down_target_list_in,
		 const list<string>& filter_nodown_target_list_in,
		 const list<string>& parse_target_list_in,
		 const list<string>& ign_domain_list_in,
		 FTP_Mode ftp_mode_in,
		 FTPretModeType ftp_ret_mode_in,
		 bool use_ftp_proxy_in,
		 bool use_ftp_proxy_authentication_in,
		 const Userdata& ftp_proxy_user_in,
		 const Proxyserver& ftp_proxy_in,
		 bool use_ftp_cache_in,
		 bool use_ftp_proxy_via_http_in,
		 FTPproxyLoginProcType ftp_proxy_login_proc_in,
		 bool ftp_nosend_quit_in,
		 int ftp_recurse_count_in,
		 bool ftp_use_filter_in,
		 bool ftp_allow_crawl_subdir_in,
		 bool ftp_no_ascend_in,
		 bool ftp_get_symlink_as_realfile_in,
		 bool ftp_recurse_add_paste_in,
		 const list<string>& ftp_filter_target_list_in,
		 bool delete_when_finish_in,
		 int retry_in,
		 int retry_repeat_in,
		 int retry_interval_in,
		 bool use_retry_404_in,
		 bool use_retry_503_in,
		 Status416HandlingType s416Handling_in,
		 bool use_no_redirection_in,
		 bool httpAcceptCompression_in,
		 bool dont_delete_without_crc_in,
		 bool no_crc_check_in,
		 bool ignore_crc_error_in,
		 bool use_content_md5_in,
		 bool cookie_delete_on_restart_in,
		 bool cookie_nosend_in,
		 bool cookieUserDefined_in,
		 const string& cookieUserDefinedString_in,
		 DownloadMethodType downm_type_in,
		 float speed_limit_in,
		 bool use_command_in,
		 bool use_exit_status_in,
		 const Command& command_in
		 )
{
  use_authentication = use_authentication_in;
  user = user_in;
  
  store_dir = store_dir_in;
  if(store_dir.at(store_dir.size()-1) != '/') {
    store_dir += "/";
  }
  if(http_version_in.size()) {
    http_version = http_version_in;
  } else {
    http_version = DEFAULT_HTTP_VERSION;
  }

  prewrittenHTMLType = prewrittenHTMLType_in;
  prewrittenHTMLName = prewrittenHTMLName_in;

  httpAcceptCompression = httpAcceptCompression_in;
  sync_with_url = sync_with_url_in;
  referer_type = referer_type_in;
  referer = referer_in;
  useragent = useragent_in;
  random_useragent = random_useragent_in;

  use_http_proxy = use_http_proxy_in;
  use_http_cache = use_http_cache_in;
  http_proxy = http_proxy_in;
  use_http_proxy_authentication = use_http_proxy_authentication_in;
  http_proxy_user = http_proxy_user_in;

  use_ftp_proxy = use_ftp_proxy_in;
  use_ftp_cache = use_ftp_cache_in;
  ftp_proxy = ftp_proxy_in;
  use_ftp_proxy_authentication = use_ftp_proxy_authentication_in;
  ftp_proxy_user = ftp_proxy_user_in;
  use_ftp_proxy_via_http = use_ftp_proxy_via_http_in;
  ftp_proxy_login_proc = ftp_proxy_login_proc_in;

  timedout = timedout_in;
  divide = divide_in;

  if(rollback_bytes_in < 0) {
    rollback_bytes = 0;
  } else {
    rollback_bytes = rollback_bytes_in;
  }
  use_size_lower_limit = use_size_lower_limit_in;
  if(size_lower_limit_in < 0) {
    size_lower_limit = 0;
  } else {
    size_lower_limit = size_lower_limit_in;
  }
  use_no_redownload = use_no_redownload_in;
  use_no_download_samename = use_no_download_samename_in;

  ftp_mode = ftp_mode_in;
  ftp_ret_mode = ftp_ret_mode_in;
  ftp_nosend_quit = ftp_nosend_quit_in;
  if(ftp_recurse_count_in < 1) ftp_recurse_count = 1;
  else ftp_recurse_count = ftp_recurse_count_in;
  ftp_use_filter = ftp_use_filter_in;
  ftp_allow_crawl_subdir = ftp_allow_crawl_subdir_in;
  ftp_no_ascend =  ftp_no_ascend_in;
  ftp_get_symlink_as_realfile =  ftp_get_symlink_as_realfile_in;
  ftp_recurse_add_paste = ftp_recurse_add_paste_in;
  ftp_filter_target_list =  ftp_filter_target_list_in;

  delete_when_finish = delete_when_finish_in;
  no_crc_check = no_crc_check_in;
  ignore_crc_error = ignore_crc_error_in;
  use_content_md5 = use_content_md5_in;

  if(retry_in < -1) {
    retry = -1;
  } else if(retry_in > MAXRETRY) {
    retry = MAXRETRY;
  } else {
    retry = retry_in;
  }

  retry_repeat = retry_repeat_in;

  if(retry_interval_in < 0) {
    retry_interval = 0;
  } else if(retry_interval_in > MAXRETRYINTERVAL) {
    retry_interval = MAXRETRYINTERVAL;
  } else {
    retry_interval = retry_interval_in;
  }

  use_retry_404 = use_retry_404_in;
  use_retry_503 = use_retry_503_in;
  s416Handling = s416Handling_in;
  use_no_redirection = use_no_redirection_in;

  dont_delete_without_crc = dont_delete_without_crc_in;
  cookie_delete_on_restart = cookie_delete_on_restart_in;
  cookie_nosend = cookie_nosend_in;
  cookieUserDefined = cookieUserDefined_in;
  cookieUserDefinedString = cookieUserDefinedString_in;

  if(recurse_in < 1) recurse_count = 1;
  else recurse_count = recurse_in;
  recurse_with_hostname_dir = recurse_with_hostname_dir_in;
  recurse_abs2rel = recurse_abs2rel_in;
  recurse_force_convert = recurse_force_convert_in;
  recurse_del_comment = recurse_del_comment_in;
  recurse_del_javascript = recurse_del_javascript_in;
  recurse_del_iframe = recurse_del_iframe_in;
  recurse_no_other_host = recurse_no_other_host_in;
  recurse_no_ascend = recurse_no_ascend_in;
  recurse_relative_only = recurse_relative_only_in;
  recurse_referer_override = recurse_referer_override_in;
  recurse_follow_ftp_link = recurse_follow_ftp_link_in;
  recurse_convert_tilde = recurse_convert_tilde_in;
  recurse_no_redownload = recurse_no_redownload_in;
  recurse_add_paste = recurse_add_paste_in;
  //documentroot_dir = store_dir_in;
  tag_href = tag_href_in;
  tag_src = tag_src_in;
  tag_background = tag_background_in;
  tag_code = tag_code_in;

  use_down_filter = use_down_filter_in;
  filter_down_target_list = filter_down_target_list_in;
  filter_nodown_target_list = filter_nodown_target_list_in;
  parse_target_list = parse_target_list_in;
  ign_domain_list = ign_domain_list_in;

  speed_limit = speed_limit_in;
  //printf("%f\n", speed_limit_in);
  //cerr << "inoptions" << speed_limit_in << endl;
  downm_type = downm_type_in;

  use_command = use_command_in;
  use_exit_status = use_exit_status_in;
  command = command_in;
}

Options::Options()
{
  use_authentication = DEFAULT_USE_AUTHENTICATION;

  user.username = DEFAULT_USER;
  user.password = DEFAULT_PASSWORD;

  char *current_dir = g_get_current_dir();
  store_dir = current_dir;
  g_free(current_dir);

  if(store_dir.at(store_dir.size()-1) != '/') {
    store_dir += "/";
  }
  http_version = DEFAULT_HTTP_VERSION;
  
  prewrittenHTMLType = DEFAULT_PREWRITTEN_HTML_TYPE;
  prewrittenHTMLName = DEFAULT_PREWRITTEN_HTML_NAME;

  httpAcceptCompression = DEFAULT_HTTP_ACCEPT_COMPRESSION;

  sync_with_url = DEFAULT_SYNC_WITH_URL;
  referer_type = DEFAULT_REFERER_INDEX;
  referer = DEFAULT_REFERER_STRING;
  useragent = "";
  random_useragent = DEFAULT_RANDOM_USERAGENT;

  use_http_proxy = DEFAULT_USE_HTTP_PROXY;
  use_http_cache = DEFAULT_USE_HTTP_CACHE;
  use_http_proxy_authentication = DEFAULT_USE_HTTP_PROXY_AUTHENTICATION;
  http_proxy_user.username = DEFAULT_HTTP_PROXY_USER;
  http_proxy_user.password = DEFAULT_HTTP_PROXY_PASSWORD;
  
  use_ftp_proxy = DEFAULT_USE_FTP_PROXY;
  use_ftp_proxy_authentication = DEFAULT_USE_FTP_PROXY_AUTHENTICATION;
  ftp_proxy_user.username = DEFAULT_FTP_PROXY_USER;
  ftp_proxy_user.password = DEFAULT_FTP_PROXY_PASSWORD;
  use_ftp_cache = DEFAULT_USE_FTP_CACHE;
  use_ftp_proxy_via_http = DEFAULT_USE_FTP_PROXY_VIA_HTTP;
  ftp_proxy_login_proc = DEFAULT_FTP_PROXY_LOGIN_PROC;

  timedout = DEFAULT_TIMEDOUT;
  divide = DEFAULT_DIVIDE;
  rollback_bytes = DEFAULT_ROLLBACK_BYTES;
  use_size_lower_limit = DEFAULT_USE_SIZE_LOWER_LIMIT;
  size_lower_limit = DEFAULT_SIZE_LOWER_LIMIT;
  use_no_redownload = DEFAULT_USE_NO_REDOWNLOAD;
  use_no_download_samename = DEFAULT_USE_NO_DOWNLOAD_SAMENAME;

  ftp_mode = DEFAULT_FTP_MODE;
  ftp_ret_mode = DEFAULT_FTP_RET_MODE;
  ftp_nosend_quit = DEFAULT_FTP_NOSEND_QUIT;
  ftp_recurse_count = DEFAULT_FTP_RECURSE_COUNT;
  ftp_use_filter = DEFAULT_FTP_USE_FILTER;
  ftp_allow_crawl_subdir = DEFAULT_FTP_ALLOW_CRAWL_SUBDIR;
  ftp_no_ascend =  DEFAULT_FTP_NO_ASCEND;
  ftp_get_symlink_as_realfile = DEFAULT_FTP_GET_SYMLINK_AS_REALFILE;
  ftp_recurse_add_paste = DEFAULT_FTP_RECURSE_ADD_PASTE;

  delete_when_finish = DEFAULT_IFDEL;
  no_crc_check = DEFAULT_NO_CRC_CHECKING;
  ignore_crc_error = DEFAULT_IGNORE_CRC_ERROR;
  use_content_md5 = DEFAULT_USE_CONTENT_MD5;
  retry = DEFAULT_RETRY;
  retry_repeat = DEFAULT_RETRY_REPEAT;
  retry_interval = DEFAULT_RETRY_INTERVAL;
  use_retry_404 = DEFAULT_FORCE_RETRY_404;
  use_retry_503 = DEFAULT_FORCE_RETRY_503;
  s416Handling = DEFAULT_STATUS_416_HANDLING;
  use_no_redirection = DEFAULT_USE_NO_REDIRECTION;

  dont_delete_without_crc = DEFAULT_IFCRC;
  cookie_delete_on_restart = DEFAULT_COOKIE_DELETE_ON_RESTART;
  cookie_nosend = DEFAULT_COOKIE_NOSEND;
  cookieUserDefined = DEFAULT_COOKIE_USERDEFINED;
  cookieUserDefinedString = DEFAULT_COOKIE_USERDEFINED_STRING;

  // remove_this!
  recurse_count = DEFAULT_RECURSE_COUNT;
  recurse_with_hostname_dir = DEFAULT_WITH_HOSTNAME_DIR;
  recurse_abs2rel = DEFAULT_ABS2REL;
  recurse_force_convert = DEFAULT_FORCE_CONVERT;
  recurse_del_comment = DEFAULT_DEL_COMMENT;
  recurse_del_javascript = DEFAULT_DEL_JAVASCRIPT;
  recurse_del_iframe = DEFAULT_DEL_IFRAME;
  recurse_no_other_host = DEFAULT_NO_OTHER_HOST;
  recurse_no_ascend = DEFAULT_NO_ASCEND;
  recurse_relative_only = DEFAULT_RELATIVE_ONLY;
  recurse_referer_override = DEFAULT_REFERER_OVERRIDE;
  recurse_follow_ftp_link = DEFAULT_FOLLOW_FTP_LINK;
  recurse_convert_tilde = DEFAULT_CONVERT_TILDE;
  recurse_no_redownload = DEFAULT_NO_REDOWNLOAD_HTTP_RECURSE;
  recurse_add_paste = DEFAULT_HTTP_RECURSE_ADD_PASTE;
  tag_href = DEFAULT_TAG_HREF;
  tag_src = DEFAULT_TAG_SRC;
  tag_background = DEFAULT_TAG_BACKGROUND;
  tag_code = DEFAULT_TAG_CODE;
  //documentroot_dir = store_dir;

  //filter_target_list = filter_target_list_in;
  //parse_target_list = parse_target_list_in;
  speed_limit = DEFAULT_SPEED_LIMIT;
  use_down_filter = DEFAULT_USE_DOWN_FILTER;
  downm_type = DOWNM_ALWAYSRESUME;

  use_command = DEFAULT_USE_COMMAND;
  use_exit_status = DEFAULT_USE_EXIT_STATUS;
}

Options::~Options()
{
}

void Options::Change_Values(bool use_authentication_in,
			    const Userdata& user_in,
			    const string& store_dir_in,
			    const string& http_version_in,
			    PrewrittenHTMLType prewrittenHTMLType_in,
			    const string& prewrittenHTMLName_in,
			    bool sync_with_url_in,
			    RefererType referer_type_in,
			    const string& referer_in,
			    const string& useragent_in,
			    bool random_useragent_in,
			    bool use_http_proxy_in,
			    bool use_http_cache_in,
			    bool use_http_proxy_authentication_in,
			    const Userdata& http_proxy_user_in,
			    const Proxyserver& http_proxy_in,
			    unsigned int timedout_in,
			    unsigned int divide_in,
			    int rollback_bytes_in,
			    bool use_size_lower_limit_in,
			    int size_lower_limit_in,
			    bool use_no_redownload_in,
			    bool use_no_download_samename_in,
			    unsigned int recurse_count_in,
			    bool recurse_with_hostname_dir_in,
			    bool recurse_abs2rel_in,
			    bool recurse_force_convert_in,
			    bool recurse_del_comment_in,
			    bool recurse_del_javascript_in,
			    bool recurse_del_iframe_in,
			    bool recurse_no_other_host_in,
			    bool recurse_no_ascend_in,
			    bool recurse_relative_only_in,
			    bool recurse_referer_override_in,
			    bool recurse_follow_ftp_link_in,
			    bool recurse_convert_tilde_in,
			    bool recurse_no_redownload_in,
			    bool recurse_add_paste_in,
			    bool tag_href_in,
			    bool tag_src_in,
			    bool tag_background_in,
			    bool tag_code_in,
			    bool use_down_filter_in,
			    const list<string>& filter_down_target_list_in,
			    const list<string>& filter_nodown_target_list_in,
			    const list<string>& parse_target_list_in,
			    const list<string>& ign_domain_list_in,
			    FTP_Mode ftp_mode_in,
			    FTPretModeType ftp_ret_mode_in,
			    bool use_ftp_proxy_in,
			    bool use_ftp_proxy_authentication_in,
			    const Userdata& ftp_proxy_user_in,
			    const Proxyserver& ftp_proxy_in,
			    bool use_ftp_cache_in,
			    bool use_ftp_proxy_via_http_in,
			    FTPproxyLoginProcType ftp_proxy_login_proc_in,
			    bool ftp_nosend_quit_in,
			    int ftp_recurse_count_in,
			    bool ftp_use_filter_in,
			    bool ftp_allow_crawl_subdir_in,
			    bool ftp_no_ascend_in,
			    bool ftp_get_symlink_as_realfile_in,
			    bool ftp_recurse_add_paste_in,
			    const list<string>& ftp_filter_target_list_in,
			    bool delete_when_finish_in,
			    int retry_in,
			    int retry_repeat_in,
			    int retry_interval_in,
			    bool use_retry_404_in,
			    bool use_retry_503_in,
			    Status416HandlingType s416Handling_in,
			    bool use_no_redirection_in,
			    bool httpAcceptCompression_in,
			    bool dont_delete_without_crc_in,
			    bool no_crc_check_in,
			    bool ignore_crc_error_in,
			    bool use_content_md5_in,
			    bool cookie_delete_on_restart_in,
			    bool cookie_nosend_in,
			    bool cookieUserDefined_in,
			    const string& cookieUserDefinedString_in,
			    DownloadMethodType downm_type_in,
			    float speed_limit_in,
			    bool use_command_in,
			    bool use_exit_status_in,
			    const Command& command_in
			    )
{
  use_authentication = use_authentication_in;
  user = user_in;

  store_dir = store_dir_in;

  if(store_dir.at(store_dir.size()-1) != '/') {
    store_dir += "/";
  }
  if(http_version_in.size()) {
    http_version = http_version_in;
  } else {
    http_version = DEFAULT_HTTP_VERSION;
  }

  prewrittenHTMLType = prewrittenHTMLType_in;
  prewrittenHTMLName = prewrittenHTMLName_in;

  httpAcceptCompression =  httpAcceptCompression_in;

  sync_with_url = sync_with_url_in;
  referer_type = referer_type_in;
  referer = referer_in;
  useragent = useragent_in;
  random_useragent = random_useragent_in;

  use_http_proxy = use_http_proxy_in;
  use_http_cache = use_http_cache_in;
  http_proxy = http_proxy_in;
  use_http_proxy_authentication = use_http_proxy_authentication_in;
  http_proxy_user = http_proxy_user_in;

  use_ftp_proxy = use_ftp_proxy_in;
  ftp_proxy = ftp_proxy_in;
  use_ftp_proxy_authentication = use_ftp_proxy_authentication_in;
  ftp_proxy_user = ftp_proxy_user_in;
  use_ftp_cache = use_ftp_cache_in;
  use_ftp_proxy_via_http = use_ftp_proxy_via_http_in;
  ftp_proxy_login_proc = ftp_proxy_login_proc_in;

  timedout = timedout_in;
  divide = divide_in;
  if(rollback_bytes_in < 0) {
    rollback_bytes = 0;
  } else {
    rollback_bytes = rollback_bytes_in;
  }
  use_size_lower_limit = use_size_lower_limit_in;
  if(size_lower_limit_in < 0) {
    size_lower_limit = 0;
  } else {
    size_lower_limit = size_lower_limit_in;
  }
  use_no_redownload = use_no_redownload_in;
  use_no_download_samename = use_no_download_samename_in;

  ftp_mode = ftp_mode_in;
  ftp_ret_mode = ftp_ret_mode_in;

  ftp_nosend_quit = ftp_nosend_quit_in;
  if(ftp_recurse_count_in < 1) ftp_recurse_count = 1;
  else ftp_recurse_count = ftp_recurse_count_in;

  ftp_use_filter = ftp_use_filter_in;
  ftp_allow_crawl_subdir = ftp_allow_crawl_subdir_in;
  ftp_no_ascend =  ftp_no_ascend_in;
  ftp_get_symlink_as_realfile =  ftp_get_symlink_as_realfile_in;
  ftp_filter_target_list =  ftp_filter_target_list_in;
  ftp_recurse_add_paste = ftp_recurse_add_paste_in;

  delete_when_finish = delete_when_finish_in;
  no_crc_check = no_crc_check_in;
  ignore_crc_error = ignore_crc_error_in;
  use_content_md5 = use_content_md5_in;
  retry = retry_in;
  retry_repeat = retry_repeat_in;
  retry_interval = retry_interval_in;
  use_retry_404 = use_retry_404_in;
  use_retry_503 = use_retry_503_in;
  s416Handling = s416Handling_in;
  use_no_redirection = use_no_redirection_in;

  dont_delete_without_crc = dont_delete_without_crc_in;
  cookie_delete_on_restart = cookie_delete_on_restart_in;
  cookie_nosend = cookie_nosend_in;
  cookieUserDefined = cookieUserDefined_in;
  cookieUserDefinedString = cookieUserDefinedString_in;

  if(recurse_count_in < 1) recurse_count = 1;
  else recurse_count = recurse_count_in;

  recurse_with_hostname_dir = recurse_with_hostname_dir_in;
  recurse_abs2rel = recurse_abs2rel_in;
  recurse_force_convert = recurse_force_convert_in;
  recurse_del_comment = recurse_del_comment_in;
  recurse_del_javascript = recurse_del_javascript_in;
  recurse_del_iframe = recurse_del_iframe_in;
  recurse_no_other_host = recurse_no_other_host_in;
  recurse_no_ascend = recurse_no_ascend_in;
  recurse_relative_only = recurse_relative_only_in;
  recurse_referer_override = recurse_referer_override_in;
  recurse_follow_ftp_link = recurse_follow_ftp_link_in;
  recurse_convert_tilde = recurse_convert_tilde_in;
  recurse_no_redownload = recurse_no_redownload_in;
  recurse_add_paste = recurse_add_paste_in;

  tag_href = tag_href_in;
  tag_src = tag_src_in;
  tag_background = tag_background_in;
  tag_code = tag_code_in;


  use_down_filter = use_down_filter_in;
  filter_down_target_list = filter_down_target_list_in;
  filter_nodown_target_list = filter_nodown_target_list_in;
  parse_target_list = parse_target_list_in;
  ign_domain_list = ign_domain_list_in;

  speed_limit = speed_limit_in;
  downm_type = downm_type_in;

  use_command = use_command_in;
  use_exit_status = use_exit_status_in;
  command = command_in;
}

bool Options::ret_use_no_download_samename() const
{
  return use_no_download_samename;
}

bool Options::ret_sync_with_URL() const
{
  return sync_with_url;
}

Options::DownloadMethodType Options::ret_downm_type() const
{
  return downm_type;
}

bool Is_in_list(const list<string>& target_list, const string& item)
{
  for(list<string>::const_iterator itr = target_list.begin();
      itr != target_list.end(); ++itr) {
    if(itr->size() < item.size()) {
      if(item.substr(item.size()-itr->size()) == *itr) return true;
    }
  }
  return false;

}

bool Is_in_list_by_pattern(const list<string>& target_list, const string& item)
{
  for(list<string>::const_iterator itr = target_list.begin();
      itr != target_list.end(); ++itr) {
    if(itr->size() < item.size()) {
      if(patternMatch(item, *itr)) return true;
    }
  }
  return false;

}

void Options::set_downm_type(DownloadMethodType downm_type_in)
{
  downm_type = downm_type_in;
}

const string& Options::ret_Useragent() const
{
  return useragent;
}

bool Options::Whether_use_authentication() const
{
  return(use_authentication);
}

const string& Options::ret_HTTP_version() const
{
  return http_version;
}

Options::PrewrittenHTMLType Options::getPrewrittenHTMLType() const
{
  return prewrittenHTMLType;
}

const string& Options::getPrewrittenHTMLName() const
{
  return prewrittenHTMLName;
}

Options::RefererType Options::ret_Referer_Type() const
{
  return(referer_type);
}

const string& Options::ret_Referer() const
{
  return(referer);
}

unsigned int Options::ret_Timed_Out() const
{
  return(timedout);
}

Options::FTP_Mode Options::ret_FTP_Mode() const
{
  return ftp_mode;
}

Options::FTPretModeType Options::ret_FTP_ret_mode() const
{
  return ftp_ret_mode;
}

bool Options::ret_FTP_nosend_quit() const
{
  return ftp_nosend_quit;
}

unsigned int Options::ret_FTP_recurse_count() const
{
  return ftp_recurse_count;
}

void Options::set_FTP_recurse_count(int count)
{
  if(count < 1) count = 1;
  ftp_recurse_count = count;
}

bool Options::ret_FTP_use_filter() const
{
  return ftp_use_filter;
}

void Options::set_FTP_use_filter(bool toggle)
{
  ftp_use_filter = toggle;
}

bool Options::ret_FTP_allow_crawl_subdir() const
{
  return ftp_allow_crawl_subdir;
}

void Options::set_FTP_allow_crawl_subdir(bool toggle)
{
  ftp_allow_crawl_subdir = toggle;
}

bool Options::ret_FTP_no_ascend() const
{
  return ftp_no_ascend;
}

void Options::set_FTP_no_ascend(bool toggle)
{
  ftp_no_ascend = toggle;
}

bool Options::ret_FTP_get_symlink_as_realfile() const
{
  return ftp_get_symlink_as_realfile;
}

void Options::set_FTP_get_symlink_as_realfile(bool toggle)
{
  ftp_get_symlink_as_realfile = toggle;
}

bool Options::ret_FTP_recurse_add_paste() const
{
  return ftp_recurse_add_paste;
}

void Options::set_FTP_recurse_add_paste(bool toggle)
{
  ftp_recurse_add_paste = toggle;
}

const list<string>& Options::ret_FTP_filter_target_list() const
{
  return ftp_filter_target_list;
}

const list<string>& Options::ret_FTP_activated_filter_target_list() const
{
  return ftp_active_filter_target_list;
}

void Options::set_FTP_filter_target_list(const list<string>& target_list)
{
  ftp_filter_target_list = target_list;
}

void Options::set_FTP_activated_filter_target_list(const list<string>& target_list)
{
  ftp_active_filter_target_list = target_list;
}

bool Options::Is_in_FTP_filter_target_list(const string& file) const
{
  return Is_in_list_by_pattern(ftp_active_filter_target_list, file);
}

int Options::ret_Retry() const
{
  return retry;
}

int Options::ret_Retry_repeat() const
{
  return retry_repeat;
}

int Options::ret_Retry_interval() const
{
  return retry_interval;
}

bool Options::ret_force_retry_404() const
{
  return use_retry_404;
}

bool Options::ret_force_retry_503() const
{
  return use_retry_503;
}

Options::Status416HandlingType Options::ret_status_416_handling() const
{
  return s416Handling;
}

bool Options::ret_use_no_redirection() const
{
  return use_no_redirection;
}

bool Options::ret_Delete_When_Finish() const
{
  return(delete_when_finish);
}

bool Options::ret_Dont_Delete_Without_CRC() const
{
  return(dont_delete_without_crc);
}

bool Options::ret_no_crc_checking() const
{
  return no_crc_check;
}

bool Options::ret_ignore_crc_error() const
{
  return ignore_crc_error;
}

bool Options::ret_use_content_md5() const
{
  return use_content_md5;
}

bool Options::ret_use_no_redownload() const
{
  return use_no_redownload;
}

const string& Options::ret_User() const
{
  return(user.username);
}

const string& Options::ret_Password() const
{
  return(user.password);
}

const string& Options::ret_http_proxy_User() const
{
  return(http_proxy_user.username);
}

const string& Options::ret_http_proxy_Password() const
{
  return(http_proxy_user.password);
}
 
const string& Options::ret_Store_Dir() const
{
  return store_dir;
}

unsigned int Options::ret_Divide() const
{
  return divide;
}

void Options::set_Divide(unsigned int divide_in)
{
  divide = divide_in;
}

int Options::ret_Rollback_bytes() const
{
  return rollback_bytes;
}

bool Options::ret_use_http_proxy() const
{
  return use_http_proxy;
}

bool Options::ret_use_http_cache() const
{
  return use_http_cache;
}

const Proxyserver& Options::ret_http_proxy() const
{
  return http_proxy;
}

void Options::set_Store_Dir(const string& store_dir_in)
{
  store_dir = store_dir_in;
  if(store_dir.at(store_dir.size()-1) != '/') {
    store_dir += "/";
  }
}

bool Options::ret_use_http_proxy_authentication() const
{
  return use_http_proxy_authentication;
}

void Options::set_use_http_proxy(bool flag)
{
  use_http_proxy = flag;
}

bool Options::ret_Random_useragent() const
{
  return random_useragent;
}

void Options::set_Referer_Type(RefererType referer_type_in)
{
  referer_type = referer_type_in;
}

void Options::set_Referer(const string& referer_in)
{
  referer = referer_in;
}

bool Options::ret_Cookie_delete_on_restart() const
{
  return cookie_delete_on_restart;
}

bool Options::ret_Cookie_nosend() const
{
  return cookie_nosend;
}

bool Options::getCookieUserDefined() const
{
  return cookieUserDefined;
}

const string& Options::getCookieUserDefinedString() const
{
  return cookieUserDefinedString;
}

// depth of recursive download
void Options::set_recurse_count(unsigned int n_rec)
{
  recurse_count = n_rec;
}

unsigned int Options::ret_recurse_count() const
{
  return recurse_count;
}

const list<string>& Options::ret_parse_target_list() const
{
  return parse_target_list;
}

const list<string>& Options::ret_filter_down_target_list() const
{
  return filter_down_target_list;
}

const list<string>& Options::ret_filter_nodown_target_list() const
{
  return filter_nodown_target_list;
}

const list<string>& Options::ret_ign_domain_list() const
{
  return ign_domain_list;
}

const list<string>& Options::ret_activated_parse_target_list() const
{
  return active_parse_target_list;
}

const list<string>& Options::ret_activated_filter_down_target_list() const
{
  return active_filter_down_target_list;
}

const list<string>& Options::ret_activated_filter_nodown_target_list() const
{
  return active_filter_nodown_target_list;
}

const list<string>& Options::ret_activated_ign_domain_list() const
{
  return active_ign_domain_list;
}

void Options::activate_parse_target_list(const list<string>& target_list)
{
  active_parse_target_list = target_list;
}

void Options::activate_filter_down_target_list(const list<string>& target_list)
{
  active_filter_down_target_list = target_list;
}

void Options::activate_filter_nodown_target_list(const list<string>& target_list)
{
  active_filter_nodown_target_list = target_list;
}

void Options::activate_ign_domain_list(const list<string>& target_list)
{
  active_ign_domain_list = target_list;
}

bool Options::Is_in_activated_parse_target_list(const string& filename) const
{
  return Is_in_list(active_parse_target_list, filename);
}

bool Options::Is_in_activated_filter_down_target_list(const string& filename) const {
  return Is_in_list_by_pattern(active_filter_down_target_list, filename);
}

bool Options::Is_in_activated_filter_nodown_target_list(const string& filename) const
{
  return Is_in_list(active_filter_nodown_target_list, filename);
  /*
  for(list<string>::const_iterator itr = active_filter_nodown_target_list.begin();
      itr != active_filter_nodown_target_list.end(); ++itr) {
    if(itr->size() < filename.size()) {
      if(filename.substr(filename.size()-itr->size()) == *itr) return true;
    }
  }
  return false;
  */
}

bool Options::Is_in_activated_ign_domain_list(const string& domain) const
{
  return Is_in_list(active_ign_domain_list, domain);
}

bool Options::ret_with_hostname_dir() const
{
  return recurse_with_hostname_dir;
}

bool Options::ret_abs2rel_url() const
{
  return recurse_abs2rel;
}

bool Options::ret_force_convert() const
{
  return recurse_force_convert;
}

bool Options::ret_no_other_host() const
{
  return recurse_no_other_host;
}

bool Options::ret_no_ascend() const
{
  return recurse_no_ascend;
}

bool Options::ret_only_relative_links() const
{
  return recurse_relative_only;
}

bool Options::ret_Referer_override() const
{
  return recurse_referer_override;
}

bool Options::ret_Follow_ftp_link() const
{
  return recurse_follow_ftp_link;
}

bool Options::ret_HTTP_recurse_add_paste() const
{
  return recurse_add_paste;
}

void Options::set_HTTP_recurse_add_paste(bool toggle)
{
  recurse_add_paste = toggle;
}

bool Options::ret_convert_tilde() const
{
  return recurse_convert_tilde;
}

bool Options::ret_use_tag_href() const
{
  return tag_href;
}

bool Options::ret_use_tag_src() const
{
  return tag_src;
}

bool Options::ret_use_tag_background() const
{
  return tag_background;
}

bool Options::ret_use_tag_code() const
{
  return tag_code;
}

void Options::set_with_hostname_dir(bool toggle)
{
  recurse_with_hostname_dir = toggle;
}

void Options::set_abs2rel_url(bool toggle)
{
  recurse_abs2rel = toggle;
}

void Options::set_force_convert(bool toggle)
{
  recurse_force_convert = toggle;
}

void Options::set_no_other_host(bool toggle)
{
  recurse_no_other_host = toggle;
}

// delete commets from file
void Options::set_delete_comment(bool toggle)
{
  recurse_del_comment = toggle;
}

bool Options::ret_delete_comment() const
{
  return recurse_del_comment;
}

// delete java scripts from file
void Options::set_delete_javascript(bool toggle)
{
  recurse_del_javascript = toggle;
}

bool Options::ret_delete_javascript() const
{
  return recurse_del_javascript;
}

void Options::set_delete_iframe(bool toggle)
{
  recurse_del_iframe = toggle;
}

bool Options::ret_delete_iframe() const
{
  return recurse_del_iframe;
}

void Options::set_no_ascend(bool toggle)
{
  recurse_no_ascend = toggle;
}

void Options::set_only_relative_links(bool toggle)
{
  recurse_relative_only = toggle;
}

void Options::set_Referer_override(bool toggle)
{
  recurse_referer_override = toggle;
}

void Options::set_Follow_ftp_link(bool toggle)
{
  recurse_follow_ftp_link = toggle;
}

void Options::set_convert_tilde(bool toggle)
{
  recurse_convert_tilde = toggle;
}

void Options::set_no_redownload_HTTP_recurse(bool toggle)
{
  recurse_no_redownload = toggle;
}

bool Options::ret_no_redownload_HTTP_recurse() const
{
  return recurse_no_redownload;
}

void Options::set_parse_target_list(const list<string>& target_list)
{
  parse_target_list = target_list;
}

void Options::set_filter_down_target_list(const list<string>& target_list)
{
  filter_down_target_list = target_list;
}

void Options::set_filter_nodown_target_list(const list<string>& target_list)
{
  filter_nodown_target_list = target_list;
}

void Options::set_ign_domain_list(const list<string>& target_list)
{
  ign_domain_list = target_list;
}

void Options::set_activated_parse_target_list(const list<string>& target_list)
{
  active_parse_target_list = target_list;
}

void Options::set_activated_filter_down_target_list(const list<string>& target_list)
{
  active_filter_down_target_list = target_list;
}

void Options::set_activated_filter_nodown_target_list(const list<string>& target_list)
{
  active_filter_nodown_target_list = target_list;
}

void Options::set_activated_ign_domain_list(const list<string>& target_list)
{
  active_ign_domain_list = target_list;
}

void Options::set_use_down_filter(bool toggle)
{
  use_down_filter = toggle;
}

bool Options::ret_use_down_filter() const
{
  return use_down_filter;
}

void Options::set_use_tag_href(bool toggle)
{
  tag_href = toggle;
}

void Options::set_use_tag_src(bool toggle)
{
  tag_src = toggle;
}
  
void Options::set_use_tag_background(bool toggle)
{
  tag_background = toggle;
}

void Options::set_use_tag_code(bool toggle)
{
  tag_code = toggle;
}

void Options::set_Delete_When_Finish(bool toggle)
{
  delete_when_finish = toggle;
}

void Options::set_Dont_Delete_Without_CRC(bool toggle)
{
  dont_delete_without_crc = toggle;
}

void Options::set_use_authentication(bool toggle)
{
  use_authentication = toggle;
}

void Options::set_userpasswd(const Userdata& userdata_in)
{
  user = userdata_in;
}

float Options::ret_speed_limit() const
{
  return speed_limit;
}

void Options::set_speed_limit(float speed)
{
  speed_limit = speed;
}

bool Options::ret_use_Command() const
{
  return use_command;
}

bool Options::ret_use_Exit_status() const
{
  return use_exit_status;
}

const Command& Options::ret_Command() const
{
  return command;
}

const string& Options::ret_ftp_proxy_User() const
{
  return ftp_proxy_user.username;
}

const string& Options::ret_ftp_proxy_Password() const
{
  return ftp_proxy_user.password;
}

bool Options::ret_use_ftp_proxy_authentication() const
{
  return use_ftp_proxy_authentication;
}

void Options::set_use_ftp_proxy(bool flag)
{
  use_ftp_proxy = flag;
}

bool Options::ret_use_ftp_proxy() const
{
  return use_ftp_proxy;
}

const Proxyserver& Options::ret_ftp_proxy() const
{
  return ftp_proxy;
}

bool Options::ret_use_ftp_cache() const
{
  return use_ftp_cache;
}

bool Options::ret_use_ftp_proxy_via_http() const
{
  return use_ftp_proxy_via_http;
}

Options::FTPproxyLoginProcType Options::ret_ftp_proxy_login_proc() const
{
  return ftp_proxy_login_proc;
}

bool Options::ret_use_size_lower_limit() const
{
  return use_size_lower_limit;
}

int Options::ret_size_lower_limit() const
{
  return size_lower_limit;
}

bool Options::ret_HTTP_accept_compression() const
{
  return httpAcceptCompression;
}
