#ifndef ARK_ENTITYHELPER_H
#define ARK_ENTITYHELPER_H

#include <vector>
#include <Ark/ArkWorld.h>

namespace Ark
{

   //  ========================================================================
   /// A particle system bound to an entity
   //  ========================================================================

   class ARK_DLL_API EntityPSys : public ParticleSys
   {
      public:
	 /// Definition strings used to create the psystem
	 String m_PosVel, m_Defs, m_Parts;
	 /// Psys pos (relative to entity pos)
	 Vector3 m_RelPos;
	 
	 /// True if the psys has changed
	 bool m_Changed;
	 
      public:
	 /// Make this particle system NULL
	 EntityPSys (World *world,
		     const String &posvel,
		     const String &defs,
		     const String &part) : 
	    ParticleSys (world, posvel, defs, part, world->GetCache()),
	    m_PosVel (posvel),
	    m_Defs (defs),
	    m_Parts (part),
	    m_Changed (true)
	 {
	    m_RelPos = m_Pos;
	 }

	 void Stop ()
	 {
	    ParticleSys::Stop();
	    m_Changed = true;
	 }
   };

   // An entity timer
   struct ARK_DLL_API EntityTimer
   {
	 int m_ID;
	 Ark::Timer m_Timer;
	 scalar m_Timeout;
      public:
	 EntityTimer (int id, scalar timeout)
	 {
	    m_ID = id;
	    m_Timeout = timeout;
	 }

	 EntityTimer ()
	 {
	    m_ID = 0;
	 }
   };

   class Entity;
   struct ARK_DLL_API EntityMessage
   {
      public:
	 Entity *m_Entity;
	 String m_Message;
	 std::vector<String> m_AnswerList;

      public:
	 EntityMessage (Entity *ent,
			const String &message,
			std::vector<String> *answer_list = NULL)
	 {
	    m_Entity = ent;
	    m_Message = message;
	    
	    if (answer_list)
	       m_AnswerList = *answer_list;
	 }

	 EntityMessage ()
	 {
	    m_Entity = NULL;
	 }
   };
   
   enum EntityGoalType
   {
      GOAL_NULL,
      GOAL_ENTITY,
      GOAL_POSITION
   };
   
   struct ARK_DLL_API EntityGoal
   { 
	 EntityGoalType m_Type;
	 Entity *m_Entity;
	 Vector3 m_Position;

      public:
	 EntityGoal () :
	    m_Type (GOAL_NULL),
	    m_Entity(NULL)
	 {}

	 EntityGoal (Entity *ent) :
	    m_Type (GOAL_ENTITY),
	    m_Entity(ent)
	 {}

	 EntityGoal (const Vector3 &v) :
	    m_Type (GOAL_POSITION),
	    m_Entity(NULL),
	    m_Position (v)
	 {}
   };
}

#endif
