/* $Id: ArkSkin.h,v 1.6 2003/03/20 17:23:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_SKIN_H
#define ARK_SKIN_H

#include <Ark/ArkMaterial.h>
#include <vector>

namespace Ark
{
	class Skin;
	typedef Ptr<Skin> SkinPtr;

   /**
    * A skin is a set of material to be used by a model. It can be
    * used to change the appearance of a model without changing its
    * geometry. This way, a lot of different characters can share the
    * same model geometry (less work for the graphic guy), while looking
    * different.
    */
   class ARK_DLL_API Skin : public Object
   {
      protected:
	 friend class Model;
	 
	 /// Set of material defined by this skin.
	 MaterialList m_Materials;

	 /// Load the skin from the given file.
	 bool Load (Cache* cache, const String &name);

      public:
	 /// Destroy the given skin.
	 virtual ~Skin ();
	 
	 /// Create an empty skin with the given name.
	 Skin (const String &name);

	 /// Insert a new material in this skin.
	 void Insert (const MaterialPtr& material);

	 /**
	  * Give the integer identifier corresponding to the 
	  * material name.
	  *
	  * Returns -1 if the material is not found
	  */
	 int Find (const Ark::String &name);

	 /// Get the material whith the given identifier.
	 Material* GetMaterial (int id);
   };


}

#endif
