/* $Id: ArkString.cpp,v 1.18 2003/03/09 21:32:33 teuf Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <iomanip>
#include <sstream>

#include <stdlib.h>
#include <locale.h>

#include <Ark/Ark.h>
#include <Ark/ArkString.h>


namespace Ark
{


String
QuoteString (const String& str)
{
    std::ostringstream os;
    os << "\"";

    for (unsigned int i = 0; i < str.size(); ++i)
    {
	switch (str[i])
	{
	    case '\n': os << "\\n"; break;
	    case '\b': os << "\\b"; break;
	    case '\r': os << "\\r"; break;
	    case '\t': os << "\\t"; break;

	    default:
		   if (isprint (str[i]))
		   {
		       os << str[i];
		   }
		   else
		   {
		       os << "\\x" << std::ios::hex << (int)str[i];
		   }
	}
    }

    os << "\"";

    return os.str();
}


String
UnquoteString (const String& str)
{
  if (str[0] != '"')
    return str;

  std::ostringstream os;

  for (unsigned int i = 1; str[i] != '"' && (i<str.size()); ++i)
  {
    if (str[i] == '\\')
    {
      ++i;

      switch (str[i])
      {
         case 'n': os << '\n'; break;
         case 'b': os << '\b'; break;
         case 'r': os << '\r'; break;
         case 't': os << '\t'; break;
	 case '"': os << '"'; break;
	 case '\\': os << '\\'; break;
      }
    }
    else if (str[i] != '"')
    {
      os << str[i];
    }
  }

  return os.str();
}


/* ======= Conversion =======
** The rule is if we can't parse a number in a string, we do not change the value
*/
bool 
StringToScalar(const String& str, scalar& res)
{
#ifndef WIN32
  // We must clean up locale to read std scalar and values
  char* loc = strdup( setlocale(LC_ALL, NULL) ); 
  setlocale(LC_ALL, "C");
#endif
  std::istringstream is( str );
  scalar x;

  is >> x;
  const bool ok = !is.fail();
  if (ok) res = x;
#ifndef WIN32
  // Restore previous locale
  setlocale(LC_ALL, loc);
  free( loc );
#endif
  return ok;
}


bool 
StringToInt(const String& str, int& res)
{
  std::istringstream is( str );
  int x;

  is >> x;
  const bool ok = !is.fail();
  if (ok) res = x;

  return ok;
}


String
ReplaceCwd (const String &fname, const String &reffname)
{
   if (fname.size() == 0 || fname[0] != '.')
      return fname;

   String ret = reffname;
   String::size_type slashpos = ret.rfind ('/');

   if (slashpos != String::npos)
      ret.resize (slashpos);

   ret += fname;
   return ret;
}

/** Get the basename of a filename (ie the filename without the directory
 * nor the extension).
 */
String Basename (const String &path)
{
   size_t point = path.find_last_of ('.');
   size_t slash = path.find_last_of ('/');
   
   if (point == String::npos && slash == String::npos)
	 return path;

   if (point == String::npos)
	 return path.substr (slash+1);

   if (slash == String::npos)
      return path.substr (0, point);
  
   if (slash < point)
      return path.substr (slash+1, point - (slash+1));
   else
      return path.substr (slash+1);
}

/** Get the extension part of a filename. */
String Extension (const String &path)
{
   size_t point = path.find_last_of ('.');

   if (point == String::npos) return "";
   else return path.substr (point);
}

/** Get the directory part of a filename. */
String Dirname (const String & path)
{
   size_t slash = path.find_last_of ('/');
   
   if (slash == String::npos) return ".";
   else return path.substr (0, slash);
}


}


