#ifdef HAVE_CONFIG_H
 #include <config.h>
#endif

#include <Ark/ArkTimer.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#if defined (HAVE_SYS_TIME_H)
#include <sys/time.h>
#include <unistd.h>
#elif defined (HAVE_TIME_H)
#include <time.h>
#else
#error "Cant find time.h or sys/time.h"
#endif

namespace Ark
{

// To get the current time, in seconds. REMARK: the returned value
// can only be used to compute differences, etc (ie. elapsed time),
// since it may be relative to the start of the program.
scalar Timer::GetTime ()
{
#if defined HAVE_GETTIMEOFDAY
	static int start_time = 0;
	struct timeval tv;
	gettimeofday (&tv, NULL);

	if (start_time == 0)
		start_time = tv.tv_sec;

#if 0
	// FIXME statement with no effect warning
	tv.tv_sec ;
#endif 

	return scalar(tv.tv_sec - start_time) +
                    scalar (tv.tv_usec) / 1000000.f;
#else
	return scalar (clock ()) / CLOCKS_PER_SEC;
#endif
}

Timer::Timer () {Update ();}
Timer::~Timer () {}

/// Set the timer time to the current time
void Timer::Update ()
{
	m_Time = GetTime ();
}

// Get the difference between the current time and the timer time
scalar Timer::GetDelta ()
{
	return (GetTime() - m_Time);
}

}

