#ifndef CLIENT_TERRAINVIEW_H
#define CLIENT_TERRAINVIEW_H

#include <Client/GLClient.h>

namespace Client
{
   
   class MessageView;
   class CameraControl;

   class TerrainView : public Widget
   {
	 // The last "thing" the mouse pointer hit.
	 Ark::Collision m_LastHit;
	 Ark::Vector3 m_LastMousePosition;

	 Ark::Timer m_Timer;
	 scalar m_PlayerRotY, m_PlayerRotYSpeed;
	 scalar m_PlayerSpeed;
	 CameraControl* m_Camera;
	 Client *m_Client;
	 MessageView *m_MessageView;

	 Ark::Timer m_FrameTimer;
	 int m_FrameCounter;
	 scalar m_FPS;
	 scalar m_ScreenX;
	 scalar m_ScreenY;
	 bool m_LastMousePositionCheck;

	 //void TraceMousePosition(const Ark::Vector3 &pointofview);
	 void TraceMousePosition(Ark::Renderer& renderer, const Ark::Vector3 &pov);
	 void ComputeScreenCoordinates();
      
      public:
	 TerrainView (UIRenderer *ui, Client *client);
	 virtual ~TerrainView ();

	 void Render (UIRenderer *ui);

	 void HandleMButton (bool down, int b, int x, int y);
	 void HandleKey (bool down, int mods, int key);
	 void HandleMotion (int state, int x, int y);
   };
}

#endif

