/* $Id: Collision.h,v 1.5 2003/02/14 05:21:18 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef COLLISION_H
#define COLLISION_H

#include <Ark/ArkModel.h>
#include <Ark/ArkCollision.h>

#include <vector>
#include "Opcode.h"

#undef Log

namespace Ark
{

   class CDModel;

   struct ARKCOLLISION_DLL_API CDSubmodel
   {
	 Opcode::OPCODE_Model *m_CDModel;
	 SubModel *m_Model;
	 CDModel *m_ColModel;
	 VertexBuffer m_SkelVB; // filled only when the model is animated.

	 /// indices for triangles, (a,b,c)
	 std::vector<udword> m_Triangles;
	 std::vector<udword> m_Materials;
   };

   extern void CD_GetTriangle (uint triangleindex,
			       Vector3 *points, 
			       int *mat,
			       CDSubmodel *mdl);


   class ARKCOLLISION_DLL_API CDRaytrace
   {
      private:
	 CDSubmodel *m_SubMdl;

	 Ray m_Ray;
	 Vector3 m_CenterCoeff;
	 Vector3 m_ExtentCoeff;

	 // Result
	 Vector3 m_Triangle[3];
	 int m_Material;
	 Vector3 m_Pos;

	 bool RayTest (const Opcode::AABBQuantizedNoLeafNode *node);
	 bool RayTest (const Opcode::QuantizedAABB *ab);

	 bool RayTest (Opcode::AABBQuantizedNoLeafTree *tree,
		       CDSubmodel *submdl);

      public:
	 CDRaytrace () : m_Ray (Vector3(0.0,0.0,0.0), Vector3(0.0,1.0,0.0))
	 {}

	 bool RayTest (const ModelState &ms,
		       const Ray &ray,
		       Collision &collision);
   };   

   /** */ 
   class ARKCOLLISION_DLL_API CDModel : public ColModel
   {
	 friend class CDSystem;
	 friend class CDRaytrace;
	 friend void CD_GetTriangle (uint triangleindex,
				     Vector3 *points, 
				     int *mat,
				     CDSubmodel *mdl);

	 std::vector<CDSubmodel*> m_SubModels;
	 Model *m_Model;
	 bool m_HasSkel;
	 Matrix44 *m_BoneMatrices;

      public:
	 CDModel ();
	 virtual ~CDModel();

	 void Build (Model *model);

      private:
	 CDSubmodel *BuildSubmodel (SubModel *mdl);
   };

   /**
    */
   class ARKCOLLISION_DLL_API CDSystem : public ColSystem
   {
	 Opcode::AABBTreeCollider m_TreeCollider;
	 CDRaytrace m_Raytracer;

      public:

	 CDSystem();

	 /**
	  * Destroy the given collision system. The collision models won't
	  * be destroyed, so you have to be careful to delete them before
	  * you call this destructor. Otherwise the effects are unpredictable.
	  */
	 virtual ~CDSystem ();

	 /**
	  * Returns true if a collision occurs between the two models
	  * given as arguments. In such a case, the function fills the fields
	  * of the pair structure.
	  *
	  * Remark : only the first collision is taken into account.
	  */
	 virtual bool TestCollision (ModelState &m1, ModelState &m2,
				     ColPair &pair);

	 /**
	  * Returns true if the ray hits the model given as first argument.
	  */
	 virtual bool RayTrace (ModelState &m1, const Ray &ray,
				Collision &col);

	 /** Return true if the given bounding box hits the model.
	  */
	 virtual bool BoxTest (ModelState &m1, const BBox &box);


	 /** Create a collision model from the given model. */
	 virtual ColModel *CreateModel (Model *from);
   };

}


#include <Ark/ArkFactoryDef.h>
ARK_REGISTER_DEF(ARKCOLLISION_DLL_API);


#endif

