/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "rFont.h"
#include "rScreen.h"
#include "tConfiguration.h"
#include <ctype.h>

#ifndef DEDICATED
#include "rRender.h"
//#include <GL/gl.h>
//#include <SDL.h>
#endif

rFont rFont::s_defaultFont("textures/font.png");
rFont rFont::s_defaultFontSmall("textures/font_s.png",32,5/128.0,9/128.0,1/128.0);
//rFont rFont::s_defaultFontSmall("textures/Font.png",0,16/256.0,32/256.0);
//rFont rFont::s_defaultFontSmall("textures/Font.png",0,1/16.0,1/8.0);

rFont::rFont(const char *fileName,int Offset,REAL CWidth,REAL CHeight,REAL op):
  rTexture(rTEX_FONT,fileName,0,0),
  offset(Offset),cwidth(CWidth),cheight(CHeight),
  onepixel(op)
{StoreAlpha();}

rFont::~rFont(){}

// displays c
#ifndef DEDICATED
void rFont::Render(unsigned char c,REAL left,REAL top,REAL right,REAL bot){
  if(31<c && 128>c && sr_glOut){
    Select(true);

    c-=offset;
    
    int x=c%16;
    int y=c/16;

    REAL ttop=y*cheight+onepixel*.5;
    REAL tbot=(y+1)*cheight-onepixel*.5;
    REAL tleft=x*cwidth+onepixel*.5;
    REAL tright=(x+1)*cwidth-onepixel*.5;

    BeginQuads();
    glTexCoord2f(tleft,ttop);
    glVertex2f(   left, top);

    glTexCoord2f(tright,ttop);
    glVertex2f(   right, top);

    glTexCoord2f(tright,tbot);
    glVertex2f(   right, bot);

    glTexCoord2f(tleft,tbot);
    glVertex2f(   left, bot);
    RenderEnd();
  }
}
#endif

// **************************************************

rTextField::rTextField(REAL Left,REAL Top,
                 REAL Cwidth,REAL Cheight,
		 rFont *f)
:buffer(0),width(int((1-Left)/Cwidth)),parIndent(0),
left(Left),top(Top),cwidth(Cwidth),cheight(Cheight),
F(f),x(0),y(0),realx(0),cursor(0),cursorPos(0){
  if (cwidth*sr_screenWidth<16 || cheight*sr_screenHeight<32)
    F=&rFont::s_defaultFontSmall;
  if (cwidth*sr_screenWidth<10)
    cwidth=10/REAL(sr_screenWidth);
  if (cheight*sr_screenHeight<18)
    cheight=18/REAL(sr_screenHeight);

  r=g=b=1;
  useColor=false;
  buffer.SetLen(0);
  /*
  top=(int(top*sr_screenHeight)+.5)/REAL(sr_screenHeight);  
  left=(int(left*sr_screenWidth)+.5)/REAL(sr_screenWidth);
  */
}


rTextField::~rTextField(){
  FlushLine();

#ifndef DEDICATED
  if (cursor && sr_glOut){
    if (cursor==2)
      glColor4f(1,1,1,.5);
    else
      glColor3f(1,1,0);
    
    //    glDisable(GL_TEXTURE);
    glDisable(GL_TEXTURE_2D);
    
    BeginLines();
    glVertex2f(cursor_x,cursor_y);
    glVertex2f(cursor_x,cursor_y-cheight);
    RenderEnd();
  }
#endif
}

void rTextField::FlushLine(int len,bool newline){
#ifndef DEDICATED
  int i;
  if (useColor && sr_glOut)
    glColor3f(r,g,b);
  for(i=0;i<=len;i++){
    REAL l=left+realx*cwidth;
    REAL t=top-y*cheight;

    if(0==cursorPos--){
      cursor_x=l;
      cursor_y=t;
    }
    if (i<len){
      F->Render(buffer[realx],l,t,l+cwidth,t-cheight);
      realx++;
    }
  }

#endif
  /*
  for(i=0;i<buffer.Len()-len;i++)
    buffer[i]=buffer[i+len];

  buffer.SetLen(buffer.Len()-len);
  */

  if (newline){
    y++;
    realx=x=0;
  }
  /*
  else
  x+=len;*/
}

void rTextField::FlushLine(bool newline){
  FlushLine(buffer.Len()-realx,newline);
}

rTextField & rTextField::operator<<(unsigned char c){
  switch(c){
  case('\n'):
    FlushLine();
    buffer.SetLen(0);
    break;
  default:
    buffer[x++]=c;
    if (x>=width){ // overflow! insert newline
      int i=x-1;
      while (!isspace(buffer(i)) && i>0) i--;

      bool force=false;
      if (x-i>=width-parIndent){
	i=x;
	force=true;
      }


      FlushLine(i);

      if (force)
	cursorPos++;
    
      for(int j=0;j<parIndent;j++){
	buffer[x++]=' ';
      }
      i++;
      while (i<width)
	buffer[x++]=buffer[i++];
      buffer.SetLen(x);
      buffer[x]='\0';
      if (cursorPos>=0)
	cursorPos+=parIndent;
    }
  }
  return *this;
}


static int RTC(REAL x){
  int ret=int(x*255);
  if (ret<0)
    ret=0;
  if (ret>255)
    ret=255;
  return ret;
}

static REAL CTR(int x){
  return x/255.0;
}


static char hex_array[]="0123456789abcdef";

char int_to_hex(int i){
  if (i<0 || i >15)
    return 'Q';
  else
    return hex_array[i];
}

int hex_to_int(char c){
  int ret=0;
  for(int i=15;i>=0;i--)
    if (hex_array[i]==c)
      ret=i;
  return ret;
}


bool sr_colorStrings=true;

static tConfItem<bool> cs("COLOR_STRINGS","Print colored strings",sr_colorStrings);


char *ColorString(REAL r,REAL g,REAL b){
  static int x=0;
  
  if (sr_colorStrings){
    x++;
    if (x>=4)
      x=0;
    
    static unsigned char cs[4][9];
    cs[x][0]='0';
    cs[x][1]='x';
    
    int RGB[3];
    RGB[0]=RTC(r);
    RGB[1]=RTC(g);
    RGB[2]=RTC(b);
    
    for(int i=0;i<3;i++){
      int lp=RGB[i]%16;
      int hp=(RGB[i]-lp)/16;
      cs[x][2+2*i]=int_to_hex(hp);
      cs[x][2+2*i+1]=int_to_hex(lp);
    }
    cs[x][8]=0;
    
    return reinterpret_cast<char *>(cs[x]);
  }
  else
    return "";
}


char in_ColorString[9];

rTextField & rTextField::StringOutput(const char *c){
  while (*c!='\0'){
    if (*c=='0' && strlen(c)>=8 && c[1]=='x'){
      
      useColor=true;
      FlushLine(false);

      if (cursorPos>7 || cursorPos<=0)
	cursorPos-=7;
      else 
	cursorPos=0;

      r=CTR(hex_to_int(c[2])*16+hex_to_int(c[3]));
      g=CTR(hex_to_int(c[4])*16+hex_to_int(c[5]));
      b=CTR(hex_to_int(c[6])*16+hex_to_int(c[7]));
      c+=8;
    }
    else
      operator<<(*(c++));
  }
  return *this;
}

  
tString RemoveColors(const char *c){
  tString s;
  while (*c!='\0'){
    if (*c=='0' && strlen(c)>=8 && c[1]=='x'){
      c+=8;
    }
    else
      s << (*(c++));
  }
  return s;
}

  
void DisplayText(REAL x,REAL y,REAL w,REAL h,const char *text,int center,int cursor,int cursorPos){
  rTextField c(x-(center+1)*strlen(text)*.5*w,y+h*.5,w,h);
  if (center==-1)
    c.SetWidth(int((1-x)/w));
  else
    c.SetWidth(10000);

  c.SetIndent(5);
  if (cursor)
    c.SetCursor(cursor,cursorPos);
  c << text;  
}

