/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __RIPPERPAGE_H__
#define __RIPPERPAGE_H__

#include <qbuttongroup.h>

#include "_ripperpage.h"
#include "_lookupdlg.h"

#include "configdlg.h"
#include "device.h"
#include "encoderopts.h"

/*========================================================*/

class QListViewItem;

class ArsonRipperPage : public ArsonRipperPageBase, public ArsonConfigPage
{
	Q_OBJECT

public:
	ArsonRipperPage (ArsonConfig &cfg, ArsonConfigDlg *pdlg, QWidget *parent);

private:
	virtual void browse_clicked (void);
	virtual void add_lookup (void);
	virtual void del_lookup (void);
	virtual void preset_changed (const QString &name);
	virtual void add_preset (void);
	virtual void del_preset (void);
	virtual void upd_preset (void);
	virtual void default_vbr (void);
	virtual void encoder_changed (int enc);
	virtual void encoder_help (void);

   // Index File Tab
   void indexFilePageSetup(void);
   void ifOutput_popup (void);
   void ifCreation_toggled (void);
   
	void getOpts (ArsonEncoderOpts &opts);
	void setOpts (const ArsonEncoderOpts &opts);

	void updateDevs (const char *dev, const ArsonDeviceList &dl);
	void handleCheckboxes (bool save);
	void setupQuality (void);

	ArsonEncoderPresets m_presets;
	ArsonDeviceUiList m_devs;

private slots:
	void lookup_selected (QListViewItem *pi);
	void lookup_selected (void);
	void on_dev_changed (const ArsonDeviceList &dl);
	void format_code_popup (void);
	void comment_popup (void);
	void on_accept (void);
};

/*========================================================*/

class ArsonLookup;

class ArsonLookupDlg : public ArsonLookupDlgBase
{
public:
	ArsonLookupDlg (QWidget *parent);

	ArsonLookup *result (void) const;
private:
	virtual void type_changed (int type);
	virtual void browse_clicked (void);
};

/*========================================================*/
#endif	/*	__RIPPERPAGE_H__	*/
