#include <recursive-lock.h>

#include <origin.h>

static gboolean *_used = NULL;
static guint _instance[ORIGIN_MAX];

static GStaticMutex _origin_mutex = G_STATIC_MUTEX_INIT;
static GStaticPrivate _origin_private = G_STATIC_PRIVATE_INIT;

#define _origin_lock() recursive_lock(&_origin_mutex, &_origin_private)
#define _origin_unlock() recursive_unlock(&_origin_mutex, &_origin_private)

OriginId origin_register_id()
{
  guint i;
  OriginId id;
  
  _origin_lock();

  if (!_used)
    {
      _used = g_new0(gboolean, ORIGIN_MAX);
      memset(_instance, 0, sizeof(guint)*ORIGIN_MAX);
    }

  for (i = 0; i < ORIGIN_MAX; i++)
    if (!_used[i])
      break;

  g_assert(i < ORIGIN_MAX);

  id.id = i;
  _used[i] = TRUE;
  id.instance = _instance[i];

  _origin_unlock();

  g_message("ORIGIN: Registered %i.%i.", id.id, id.instance);

  return id;
}

void origin_unregister_id(OriginId id)
{
  guint i;

  _origin_lock();

  g_message("ORIGIN: Unregistering id %i.%i.", id.id, id.instance);
  g_assert(_used && _instance);
  g_assert(_used[id.id] && (_instance[id.id] == id.instance));

  _used[id.id] = FALSE;
  _instance[id.id]++;

  for (i = 0; i < ORIGIN_MAX; i++)
    if (_used[i])
      break;

  if (i >= ORIGIN_MAX)
    {
      g_free(_used);
      _used = NULL;
    }

  _origin_unlock();
}


void origin_reset(Origin *o)
{
  g_assert(o);
  memset(o, 0, sizeof(Origin));
}

void origin_set(Origin *o, OriginId id, gboolean b)
{
  g_assert(o && (id.id < ORIGIN_MAX));

  if (b)
    {
      o->enabled[id.id] = TRUE;
      o->instance[id.id] = id.instance;
    }
  else if (o->instance[id.id] == id.instance)
    o->enabled[id.id] = FALSE;
}

gboolean origin_is_set(Origin *o, OriginId id)
{
  g_assert(o);

  if (o->enabled[id.id])
    return o->instance[id.id] == id.instance;

  return FALSE;
}


void origin_merge(Origin *a, Origin *b)
{
  int i;

  g_assert(a && b);

  for (i = 0; i < ORIGIN_MAX; i++)
    if (b->enabled[i])
      if (!a->enabled[i] || (b->instance[i] > a->instance[i]))
        {
          a->enabled[i] = TRUE;
          a->instance[i] = b->instance[i];
        }
}
