------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--                      G N A T E L I M . E R R O R S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            1.11
--                                                                          --
--            Copyright (C) 1998-2001 Ada Core Technologies, Inc.           --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to  the  Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by Ada Core Technologies Inc  (http://www.gnat.com) --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides handling of warnings and errors

package Gnatelim.Errors is

   pragma Elaborate_Body;

   Fatal_Error : exception;

   procedure Error (Msg : Wide_String);
   pragma No_Return (Error);
   --  Issues an error Msg on Standard_Error, then raises Fatal_Error;

   Warning_Indent_Level : Integer := 0;
   --  All warning messages are indented by this number of spaces.

   procedure Warning (Msg : Wide_String; Force : Boolean := False);
   --  If Debug_Mode is set ON, issues a warning Msg on Standard_Error. If
   --  Force is set ON, issies Msg on Standard_Error if Quiet_Mode is set OFF,
   --  independently of the value of the Debug_Mode flag. Does nothing if
   --  Quiet_Mode is ON

end Gnatelim.Errors;
