------------------------------------------------------------------------------
--                                                                          --
--                           GNATSTUB COMPONENTS                            --
--                                                                          --
--                       G N A T S T U B . O P T I O N S                    --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--           Copyright (c) 1997-2004, Free Software Foundation, Inc.        --
--                                                                          --
-- Gnatstub is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnatstub is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Gnatstub is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT).                                                         --
--                                                                          --
-- Gnatstub  was  originally  developed  by  Alexei Kuchumov  as a part of  --
-- collaboration  between  Software  Engineering  Laboratory of  the Swiss  --
-- Federal  Institute  of  Technology  in  Lausanne, Switzerland, and  the  --
-- Scientific  Research  Computer  Center  of the  Moscow State University, --
-- Russia.  This  work  was  supported  by  a grant from the Swiss National --
-- Science Foundation,  no 7SUPJ048247, funding a project  "Development of  --
-- ASIS for GNAT with industry quality".                                    --
--                                                                          --
-- Gnatstub  is  now  maintained  by  Ada  Core  Technologies  Inc          --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

--  This package defines variables for storing Gnatstub options and parameters,
--  as well as some internal parameters used by gnatstub

with GNAT.OS_Lib; use GNAT.OS_Lib;

package Gnatstub.Options is

   Initialized : Boolean := False;
   --  set to True by Initialize, if initialization is successful

   subtype String_Ptr is String_Access;

   -------------
   -- Options --
   -------------

   Alphabetical_Ordering : Boolean := False;
   --  If this flag is set ON, gnatstub orders the local bodies alphabetically.

   Indent : constant Natural := 3;
   --  Indentation in the outputted source, is not set from command line.

   Verbose_Mode : Boolean := False;
   --  If this flag is set ON, gnatstub generates the message about itself,
   --  including ASIS/GNAT version with which it is built

   Quiet_Mode : Boolean := False;
   --  If this flag is set ON, gnatstub does not generate a confirmation
   --  in case when the sample body has successfully been created

   Overwrite_Body : Boolean := False;
   --  Should an existing body be overwritten

   type Sampler_Header is (
      No_Header,
      --  no header should be put into a body sample being created (default)
      Stand_Header,
      --  a sample comment header will be placed into a body sample
      From_Spec);
      --  a comment header from the spec will be placed into a body sampler

   Header : Sampler_Header := No_Header;

   Overwrite_Tree : Boolean := False;
   --  in case, if the current directory already contains the tree file with
   --  the name corresponding to Gnatstub parameter, indicates whether or not
   --  this file should be overwritten

   Delete_Tree : Boolean := True;
   --  indicates if Gnatstub should delete the tree file created by itself.

   Reuse_Tree : Boolean := False;
   --  indicates if the existing tree should be reused

   Indent_Level : Natural := 3;
   --  indentation level

   Max_Body_Line_Length : Natural := 79;
   --  maximum line length in the body file being generated

   ------------------------------
   -- File and Directory names --
   ------------------------------

   File_Name : String_Ptr;
   --  The name of file that contains processed unit. This is the only one
   --  obligatory parameter. Only one unit name may be given. The name
   --  should be the name of the source file, it has to follow the GNAT
   --  file name conventions (in particular, it has to have .ads suffix).
   --  the file name may or may not contain the path information.

   Short_File_Name : String_Ptr;
   --  File name without directory information

   Full_File_Name : String_Ptr;
   --  Fully qualified normalized name of the argument file

   Tree_Name : String_Ptr;
   --  we need it in more, then one routine, so we define it here
   Body_Name : String_Ptr;

   Full_Body_Name : String_Ptr;
   --  Fully qualified normalized name of the body file

   Destination_Dir : String_Ptr;
   --  directory to put the sampler body in

   ----------------------
   -- Status variables --
   ----------------------

   Tree_Exists : Boolean := False;
   --  if the tree file has been created or has been found as existing
   --  during the initialization

   Dir_Count : Natural := 0;
   --  the number of '-I' options in command line

   File_Name_Len         : Natural;
   File_Name_First       : Natural;
   File_Name_Last        : Natural;
   Short_File_Name_Len   : Natural;
   Short_File_Name_First : Natural;
   Short_File_Name_Last  : Natural;
   --  To simplify dealing with the spec file name

   Fatal_Error     : exception;
   --  Raised if the sample body can not be correctly generated because of any
   --  reason

   Parameter_Error : exception;
   --  Raised if gnatstub received a wrong option/paratmener or a wrong
   --  combination of parameters.

end Gnatstub.Options;
