.TH asmail 1 "01 Nov 2004" "Version 1.7"
.UC
.SH NAME
\fBasmail\fP \- the AfterStep e-mail monitor
.SH SYNOPSIS
.B asmail
[-h] [-V] [-v] [-nox]
        [-insecure]
        [-noconfig]
        [-f \fIresource file\fP]
        [-geometry \fIX geometry specification\fP]
        [-iconic]
        [-withdrawn]
.SH DESCRIPTION
The \fBasmail\fP is a X11 application that acts as
an e-mail monitor for a number of various format mailboxes.
The \fBasmail\fP provides a distinctive Afterstep
window manager look and feel and features multiple
options to allow the customization.

Basically, the tool shows you the following:
.PP
- The background image changes depending on whether
  there is e-mail in your mailboxes or not.
  Custom images may be loaded and used for animation
  sequences.
.PP
- The tool will display the number of e-mails waiting
  in each mailbox and/or the total numbers for all
  mailboxes together.
.PP
- For each mailbox, there is a status indicator that
  shows whether the update is running at this moment
  and indicates if there is an error. The same indicator
  shows up next to the summary line.

The folowing indicators are used for the status display:

  \fBR\fP  An update on the mailbox is running at this moment.
     For small mailboxes with fast access, you may never
     actually see it - so fast it disappears.

  \fBL\fP  An error occured that has to do with the login
     procedure. Most probably, your name/password
     combination was not accepted by the server.

  \fBC\fP  A connection problem. \fBasmail\fP could not
     connect to the server for some reason. The reasons
     may be many - server down, network unreachable,
     service not available and so on.

  \fBT\fP  A time-out has occured while \fBasmail\fP was
     waiting for the server's answer. If you have a
     frequent problem with this but the server seems
     to be available in other applicaitons, try 
     increasing the "timeout" setting for the mailbox.

  \fBF\fP  This is an indicator of a general error condition.
     Something is wrong, maybe the configuration is not
     correct, or the mailbox is not readable. Check the
     output of \fBasmail\fP by running from the terminal -
     this should give you an idea of what is wrong.

The resource files may be specified with a command line
option. The logic of \fBasmail\fP is simple: first it parses 
the resource file that you specified on the command line.
If you do not specify the resource file on the command
line, \fBasmail\fP will look in the default location (~/.asmailrc).
If it exists, \fBasmail\fP will parse that one. If no
configuration file was given on the command line and
there is no configuration file in the default location,
\fBasmail\fP will attempt to monitor the mailbox specified
by the \fB$MAILBOX\fP environment variable.

\fBHow asmail distinguishes between old and new mail.\fP

The \fBUNIX mailbox\fP format does not contain any indication
on the outside. The mailbox must be parsed to check if some
e-mail is new. Parsing the mailbox is an expensive operation,
especially if the mailbox is large. \fBasmail\fP checks the
mailbox file modification time with the \fBstat\fP(2) 
system call. When the file modification time changes, the
mailbox is parsed. The lines "\fBFrom \fP" are counted and
taken to be the number of e-mails in the box. After each
"\fBFrom \fP" line, asmail looks for the "\fBStatus:\fP"
header. This header contains flags when the message was 
seen and read. Messages without this header line (or with
an empty header) are considered to be new.

The \fBMaildir\fP format is very well-behaved. There are
separate folders for old and new e-mails so we just count
the number of files in "\fBcur\fP" and "\fBnew\fP" subdirectories.
The "\fBtmp\fP" subdirectory is ignored since this is the
temporary storage and is not supposed to be taken into account.

The \fBmH\fP format is somewhere between Maildir and the
UNIX mailbox formats. It is used by mh, nmh, balsa and xfmail 
among others. The messages are all stored in separate 
files, one message per file, and all of the messages in a 
single directory. Each message file is named with an increasing
number, so the first message recieved in the mailbox is stored
as "1" and the 39th message is stored as "39". 
There are two ways that the status of the messages are kept
track of. Traditionally, the mH tools used a file called
"\fB.mh_sequences\fP", which is stored in the mH directory,
to keep track of status. This file contains a series of 
sequences, each one starting with a token followed by a colon and 
then by a series of message numebrs, representing the messages
that belong to that sequence. It looks something like this:
.RS
unseen: 1 2 3-5 19 25-31
.RE
Although there are many sequences, some standard and 
some user-defined, if the \fBuse-mh-sequences\fP
configuration option is set to "yes" for that mailbox, then asmail
will parse this file, looking for the "unseen" sequence to determine
how many messages are new.
Some mail clients don't use the .mh_sequences file and
instead treat the files in the mH mailbox just like a 
collection of seperate messages from a UNIX mailbox. So,
if the \fBuse-mh-sequences\fP configuration option is set to 
"no", or is not specified at all, then asmail will parse 
all of the files in the mH directory, searching for the 
\fBStatus\fP header. Therefore, this mode is definitely 
the most "processor hungry" format from the point of view 
of \fBasmail\fP.
mh, nmh, and newer versions of balsa utilize the .mh_sequences 
file, while older versions of balsa and xfmail 
do not.  It is not known how other clients treat
mH mailboxes.

The \fBPOP3\fP protocol does not support the notion of new
or old e-mail. Your e-mail client keeps a list of messages
and can tell whether you read one of them or not. Since
\fBasmail\fP does not keep a list of messages there is no
way to tell a new message from the old one. Ok, so what
we do is assume that all e-mail is new at start-up. This is
a logical assumption for most of the people because they
store the e-mail locally and remove it from the server. 
Others are out of luck. Now, when the number of messages
decreases, we assume that you read all your e-mail and 
deleted some, so all messages are marked as old. When the
number of messages increases, we assume that the new mail
arrived and we report the additional mail as new.

The \fBIMAP\fP protocol is very well behaved, it reports
the number of new e-mails and the number of old e-mails
if you ask politely :) Since we open the mailbox in read-only
mode, we do not cause any status changes for the mailbox
on the server. The \fBIMAP\fP server will store a special
e-mail into your mailbox if it is in UNIX format. This
e-mail allows the server to keep track of the new and old
e-mails. The server will not report this e-mail into the
number of e-mails, so that if you check your \fBUNIX mailbox\fP
directly the number of messages will be one more.

.SH CONFIGURATION OPTIONS
.IP "-h"
.RS
prints a short description and usage message.
.RE
.IP "-V"
.RS
Version control. Prints out the version of the program.
.RE
.IP "-v"
.RS
Verbose mode. In this mode, \fBasmail\fP will print the
information about mailboxes onto the controlling terminal.
The information includes: number of updates requested,
per mailbox: thread PID, [\fBR\fP]unning or idle, any
errors are signalled with leters (see above) and the
number of e-mails in the format new/old. This mode is
useful for debugging or could be used to monitor mailboxes
without X Windows interface (give the \fB-nox\fP option).
.RE
.IP "-f resource file"
.RS
Specifies the alternative location for the resource file.
The default location is ~/.asmailrc If the alternative
file is specified, the default location is ignored.
.RE
.IP "-geometry X geometry specification"
.RS
Specifies the size and position of the application
on the screen in the standard X11 format (see
\fBXParseGeometry (3x)\fP for details):

[=][<width>{xX}<height>][{+-}<xoffset>{+-}<yoffset>]
.RE
.IP "-noconfig"
.RS
Forces \fBasmail\fP to ignore the resource file even if
one is present. \fBasmail\fP will run with all default
settings and check the Unix mailbox specified by the
\fB$MAIL\fP environment variable.
.RE
.IP "-nox"
.RS
Starts the \fBasmail\fP application in the terminal-only
mode. The X Windows interface is not started. The configuration
file is still parsed as usual though.

This option implies \fB-v\fP option.
.RE
.IP "-insecure"
.RS
Usually, \fBasmail\fP will check that the resource file
has the \fB600\fP mode, that is there are no access rights
for "group" and "others". If such access rights are granted,
\fBasmail\fP will complain and exit. This is done to make
you remember the passwords you put into the resource file.
If there are no passwords stored in the file (e.g. you are
using UNIX mailbox on the local machine) the check is not
applied.

This option forces \fBasmail\fP to continue operation even
if the resource file has insecure permissions and passwords
are stored in that file.
.RE
.IP "-iconic"
.RS
This option will cause \fBasmail\fP to start up as an icon
rather than as a normal window. The application can still
be de-iconized and iconized as usual.
.RE
.IP "-withdrawn"
.RS
This option will cause \fBasmail\fP to start up in a so-called
"withdrawn" mode. This mode is used by \fBWindowMaker\fP
window manager to dock the application into their version 
of the \fBWharf\fP.
.RE
.SH RESOURCE FILE SYNTAX
The syntax of the resource file is described in a separate
man page under \fBasmailrc\fP (5).
.SH INVOCATION
\fBasmail\fP can be called in different ways.  The most 
common invocation is the command line:
.nf

	user@host[1]% asmail &

.fi
Another way to call \fBasmail\fP is from the window manager:
.nf

	*Wharf "asmail" nil Swallow "asmail" /usr/local/bin/asmail &

.fi
This line, when placed in the \fIwharf\fP file in the users Afterstep
configuration directory will cause \fBasmail\fP to become a
button on the \fBWharf (1)\fP button bar under the \fBafterstep (1)\fP
window manager.

.SH BUGS
My programs do not have bugs, they just develop random
features ;-)
.PP
Well, there are limitations. All the strings for the
color names, file names, and other strings have the
length limit of 256 characters (terminating zero included). 
The program will complain about very long names in the
configuration file.
.PP
The number of mailboxes is not limited by the space on the icon
but the stats will be chopped (not shown) if you have too
many and they do not fit into the icon.
Make sure you pick up a tall icon if you have many mailboxes
and want to see info on each of them because they are shown from
the top down and there is no way to change this.
.PP
The information about mailboxes will not appear when you use
"shaped" windows with transparency if it is printed in the
transparent area.
.PP
\fBasmail\fP may interfere with your mail client program
when you use the POP3 server. There is no way to login to
the POP3 server twice (from the mail client and \fBasmail\fP),
so there is an inherent race condition between the two.
The one that tries to log in second, will fail. \fBasmail\fP
logs out immediately after checking so your mail client
will have a much higher chance of precluding \fBasmail\fP
from logging in than the other way around.
.PP
If the program is not satisfied with the specification of
one of the mailboxes, it will print an error message, set
the status for that mailbox to \fBF\fP (Failed) and exit
the thread (only the thread that is responsible for handling 
that particular mailbox). Other mailboxes will be checked normally.
Check the standard output of the tool to see what the
problem is.
.SH FILES
.I ~/.asmailrc
.SH "SEE ALSO"
.BR asmailrc (5)
.BR afterstep (1)
.SH COPYRIGHTS
Copyright (c) 2002-2003  Albert Dorofeev <albert@tigr.net>

Distributed under GNU General Public License v2 ; 
see LICENSE file for more informations.
.SH AUTHORS
Albert "Tigr" Dorofeev <albert@tigr.net>

See the README file for credits.
.sp
