// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __PointCutContext_h__
#define __PointCutContext_h__

#include <set>
using namespace std;

#include "Puma/Array.h"
#include "Puma/Stack.h"

#include "Binding.h"
#include "JoinPointModel.h"

using namespace Puma;

namespace Puma {
  class CFunctionInfo;
  class CArgumentInfo;
  class CObjectInfo;
  class ACAspectInfo;
  class CTranslationUnit;
  class ErrorStream;
  class CTree;
}

class PointCutExpr;

typedef Array<const CArgumentInfo*> ArgSet;

class PointCutContext {
  JoinPointModel &_jpm;
  CFunctionInfo *_func;
  JPL_Aspect *_aspect;
  int _per_aspect_cflows;

  // new pointcut evaluation data members
  Stack<ArgSet*> _arg_bindings;
  int _in_arg;
  bool _in_result;
  bool _in_that;
  bool _in_target;
  bool _pseudo_true;
  set<PointCutExpr*> _cflow_exprs;

  CFunctionInfo *lookup_pointcut(ACAspectInfo *ai, CFunctionInfo *fi);

public:

  PointCutContext (JoinPointModel &jpm) :
    _jpm (jpm), _func (0), _aspect (0), _per_aspect_cflows (0),
    _in_arg (-1), _in_result (false), _in_that (false), _in_target (false),
    _pseudo_true (false) {
  }

  JoinPointModel &jpm () { return _jpm; }

  CFunctionInfo *func (CFunctionInfo *new_func) {
    CFunctionInfo *result = _func;
    _func = new_func;
    return result;
  }
  CFunctionInfo *func () const { return _func; }
  void concrete_aspect (JPL_Aspect &ai) { _aspect = &ai; _per_aspect_cflows = 0; }
//  ACAspectInfo *aspect_info () const { return _aspect; }
  CFunctionInfo *lookup_pointcut (CFunctionInfo *func, ErrorStream &err,
				  CTree *node);
  bool in_project (CObjectInfo *obj);

  // used for semantic analysis of pointcut expressions
  Stack<ArgSet*> &arg_bindings () { return _arg_bindings; }

  // used for context binding in args()
  bool in_arg () const { return _in_arg >= 0; }
  void set_arg (int a) { _in_arg = a; }
  int get_arg () const { return _in_arg; }

  // used for context binding in result()
  bool in_result () const { return _in_result; }
  void enter_result () { _in_result = true; }
  void leave_result () { _in_result = false; }

  // used for context binding in that()
  bool in_that () const { return _in_that; }
  void enter_that () { _in_that = true; }
  void leave_that () { _in_that = false; }

  // used for context binding in target()
  bool in_target () const { return _in_target; }
  void enter_target () { _in_target = true; }
  void leave_target () { _in_target = false; }

  // that or within was evaluated as true, because we have a pseudo call
  void pseudo_true (bool val) { _pseudo_true = val; }
  bool is_pseudo_true () const { return _pseudo_true; }
  
  // cflow trigger management
  int cflow (PointCutExpr *pce) {
    _cflow_exprs.insert (pce);
    return _per_aspect_cflows++;
  }
  const set<PointCutExpr*> &cflows () { return _cflow_exprs; }
  void cflow_reset () { _cflow_exprs.clear (); }
};

#endif // __PointCutContext_h__
