/** \file libassogiate/mime-directory.hh */
/*
 * This file is part of assoGiate,
 * an editor of the file types database for GNOME.
 *
 * Copyright (C) 2007 Kevin Daughtridge <kevin@kdau.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef LIBASSOGIATE__MIME_DIRECTORY_HH
#define LIBASSOGIATE__MIME_DIRECTORY_HH

#include <libassogiate/mime-package.hh>

/******************************************************************************/
namespace assoGiate {
/******************************************************************************/

/******************************************************************************/
class MimeDirectory : public NodeMapExtender {
/******************************************************************************/

public:

	static MimeDirectory* create(const std::string& data_dir,
		Location type) throw(MimeDatabaseLoadError,
		Glib::FileError);

	static MimeDirectory* load(const std::string& data_dir,
		Location type) throw(MimeDatabaseLoadError);

	virtual ~MimeDirectory();
	
	std::string get_data_dir() const throw();
	std::string get_mime_dir() const throw();
	std::string get_packages_dir() const throw();
	
	virtual void extend_node_map(MimeNodeMap& node_map) throw();

	void reload() throw(MimeDatabaseLoadError);
	sigc::signal<void> signal_changed() throw();

private:

	MimeDirectory(const std::string& data_dir, Location type)
		throw(MimeDatabaseLoadError);
	
	void clear() throw();
	
	void on_monitor_event(const Gnome::Vfs::MonitorHandle& handle,
		const ustring& monitor_uri, const ustring& info_uri,
		Gnome::Vfs::MonitorEventType type) throw();

	std::string m_data_dir, m_mime_dir, m_packages_dir;
	Location m_type;
	
	std::list<MimePackage*> m_packages;
	
	Gnome::Vfs::MonitorHandle m_monitor;
	sigc::signal<void> s_changed;
	
}; /* class MimeDirectory */

} /* namespace assoGiate */

#endif /* LIBASSOGIATE__MIME_DIRECTORY_HH */
