// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright 2000-2001 Stefanus Du Toit and Alistair Riddoch.
// Automatically generated using gen_cc.py.

#ifndef ATLAS_OBJECTS_ENTITY_ACCOUNT_H
#define ATLAS_OBJECTS_ENTITY_ACCOUNT_H

#include <Atlas/Objects/Entity/AdminEntity.h>


namespace Atlas { namespace Objects { namespace Entity { 

/** Base class for accounts

Later in hierarchy tree objtype changes to 'object' when actual game objects are made.

*/
class Account : public AdminEntity
{
  public:
    /// Construct a Account instance.
    Account();
  protected:
    /// Constructor for sub-classes.
    Account(const char *,const char *);
  public:
    /// Default destructor.
    virtual ~Account();

    /// Create a new class for Account.
    static Account Class();

    /// Check whether the attribute "name" exists.
    virtual bool hasAttr(const std::string& name)const;
    /// Retrieve the attribute "name". Throws NoSuchAttrException if it does
    /// not exist.
    virtual Atlas::Message::Element getAttr(const std::string& name)
            const throw (NoSuchAttrException);
    /// Set the attribute "name" to the value given by"attr"
    virtual void setAttr(const std::string& name,
                         const Atlas::Message::Element& attr);
    /// Remove the attribute "name". This will not work for static attributes.
    virtual void removeAttr(const std::string& name);

    /// Send the contents of this object to a Bridge.
    virtual void sendContents(Atlas::Bridge* b) const;

    /// Convert this object to a Message::Element.
    virtual Atlas::Message::Element asObject() const;

    /// Convert this object to a Message::Element::MapType.
    virtual Atlas::Message::Element::MapType asMap() const;

    /// Set the "password" attribute.
    inline void setPassword(const std::string& val);

    /// Retrieve the "password" attribute.
    inline const std::string& getPassword() const;
    /// Retrieve the "password" attribute as a non-const reference.
    inline std::string& getPassword();

protected:
    std::string attr_password;

    inline void sendPassword(Atlas::Bridge*) const;

};

//
// Inlined member functions follow.
//

void Account::setPassword(const std::string& val)
{
    attr_password = val;
}

const std::string& Account::getPassword() const
{
    return attr_password;
}

std::string& Account::getPassword()
{
    return attr_password;
}


} } } // namespace Atlas::Objects::Entity

#endif // ATLAS_OBJECTS_ENTITY_ACCOUNT_H
