/****************************************************************
**
** Attal : Lords of Doom
**
** calendar.h
** class for managing days, weeks, months
**
** Version : $Id: calendar.h,v 1.5 2004/09/17 18:44:14 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 02/01/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef CALENDAR_H
#define CALENDAR_H
 
 
// generic include files
// include files for QT
#include <qobject.h>
#include <qptrlist.h>
#include <qptrvector.h>
// application specific include files
 
 
/*              ------------------------------
 *                         Calendar
 *              ------------------------------ */

/** comment for the class */
class Calendar : public QObject
{
	Q_OBJECT
public:
	/** Constructor */
	Calendar();
	
	/** Set date before first day (first week, first month) */
	void reinit();
	
	/** Go to next day */
	void newDay();
	
	/** Return the current day */
	uint getDay() { return _day; }

	/** Return the current week */
	uint getWeek() { return _week; }

	/** Return the current month */
	uint getMonth() { return _month; }
	
	/** Return the current year */
	uint getYear() { return _year; }
	
	QString getDate(); 

signals:
	/** Signal when date change */
	void sig_changed();

private:
	uint _day, _daym, _week, _month, _year;
};

/** comment for the class */
class CalendarModel
{
 
public:
	/** Constructor */
	CalendarModel();

	/** Destructor */
	virtual ~CalendarModel();

	QString getLevelName(uint level, uint num);
	 
	void setLevelName(uint level, uint num, const QString & name);
	
	uint getLevelValue(uint level);

	void setLevelValue( uint level , uint value );

protected:
	uint _level[3];
	QPtrVector<QString> * _name;

};


 
#endif // CALENDAR_H   
