/****************************************************************
**
** Attal : Lords of Doom
**
** propertiesLord.cpp
** this is a template for all .cpp files
**
** Version : $Id: propertiesLord.cpp,v 1.16 2004/12/11 13:39:40 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 07/12/2002
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "propertiesLord.h"

// generic include files
// include files for QT
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qtable.h>
#include <qmessagebox.h>
// application specific include files
#include "libCommon/artefactManager.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericLord.h"

#include "libClient/askWidget.h"
#include "libClient/gui.h"
#include "libClient/imageTheme.h"

extern DataTheme DataTheme;
extern QString IMAGE_PATH;
extern ImageTheme ImageTheme;

//
// ----- PropertiesLord -----
//

PropertiesLord::PropertiesLord( QPtrList<GenericPlayer> * players, QWidget  * parent, const char * name )
	:QTabDialog( parent, name, true )
{
	setCaption( tr( "Lord properties" ) );
	_players = players;
	_lord = 0;

	_general = new PropertiesLordGeneral( players, this );
	_units = new PropertiesLordUnits( this );
	_artefacts = new PropertiesLordArtefacts( this );
       _warMachines = new PropertiesLordWarMachines( this );
       _technics = new PropertiesLordTechnics( this );

	addTab( _general, tr( "General" ) );
	addTab( _units, tr( "Units" ) );
	addTab( _artefacts, tr( "Artefacts" ) );
	addTab( _warMachines, tr( "War Machines" ) );
	addTab( _technics, tr( "Technics" ) );
	setOkButton();
	setCancelButton();
}

void PropertiesLord::accept()
{
	if (_units->hasNoneUnits ())
	{
		QMessageBox::warning( this, tr( "Lord's properties error" ),
    		tr( "The lord must have at least 1 unit" ) );
		return;
	}

	_general->accept();
	_units->accept();
	_artefacts->accept();
	_warMachines->accept();
	_technics->accept();
	QTabDialog::accept();
}

void PropertiesLord::init( GenericLord * lord, uint * ids, int numLords )
{
	_lord = lord;
	_general->init( lord, ids, numLords );
	_units->init( lord );
	_artefacts->init( lord );
       _warMachines->init ( lord );
       _technics->init ( lord );
}

//
// ----- GeneralCharacteristic-----
//

GeneralCharacteristic::GeneralCharacteristic (int number, QWidget* parent , const char * )
    : PixmapSpinBox( parent )
{
    _num = number;

    setFrameStyle (QFrame::Panel | QFrame::Raised);
    setLineWidth ( 1 );

    getPixmap ();

    QString text = getText ();

    PixmapSpinBox::init (&_pix, text, true);
};

void GeneralCharacteristic::init (GenericLord* lord)
{
    LordCharac charac = (LordCharac)_num;

    int value = lord->getBaseCharac ( charac );

    setRange( 0, 10000 );
    setValue( value );
}

void GeneralCharacteristic::save ( GenericLord* lord )
{
    int value = getValue( );

    LordCharac charac = (LordCharac)_num;

    lord->setBaseCharac( charac, value);
}

void GeneralCharacteristic::getPixmap ()
{
    QString path = IMAGE_PATH + "misc/ico_";

    LordCharac charac = (LordCharac)_num;
    switch (charac)
    {
        case ATTACK: {
            path += "attack"; break; }
        case DEFENSE: {
            path += "defense"; break; }
        case POWER: {
            path += "power"; break; }
        case KNOWLEDGE: {
            path += "knowledge"; break; }
        case MAXMOVE: {
            path += "move"; break; }
	case MOVE: break;
        case MAXTECHNICPOINT: break;
	case TECHNICPOINT: break;
        case MORALE: {
            path += "morale"; break; }
        case LUCK: {
            path += "luck"; break; }
        case VISION: {
            path += "vision"; break; }
        case EXPERIENCE: {
            path += "experience"; break; }        
    }

    path += ".png";
    if (!_pix.load (path)) {
        _pix.resize (10,10);
        _pix.fill ();
    }
    
}


QString GeneralCharacteristic::getText ()
{
	QString text = "";

	LordCharac charac = (LordCharac)_num;

	switch( charac ) {
        case ATTACK:
		text = "Attack";
		break;
        case DEFENSE:
		text = "Defense";
		break;
        case POWER:
		text = "Power";
	    break;
        case KNOWLEDGE:
		text = "Knowledge";
		break;
	case MOVE:
		break;
	case MAXMOVE:
		text = "Maxmove";
		break;
	case MAXTECHNICPOINT:
		break;
	case TECHNICPOINT:
		break;
	case MORALE:
		text = "Morale";
		break;
	case LUCK:
		text = "Luck";
		break;
	case VISION:
		text = "Vision";
		break;
        case EXPERIENCE:
		text = "Experience";
		break;
	}

	return text;
}

//
// ----- PropertiesLordGeneral -----
//

PropertiesLordGeneral::PropertiesLordGeneral( QPtrList<GenericPlayer> * players, QWidget * parent, const char * name )
: QWidget( parent, name )
{
       QLabel* playerLabel = new QLabel( this );
       playerLabel->setText( tr( "Select player:" ) );
       FIXEDSIZE (playerLabel);

	_lord = 0;
	_comboPlayer = new QComboBox( this );
	FIXEDSIZE( _comboPlayer );
       _comboPlayer->setFixedWidth (250);

       _listLords = new QListBox (this);
       _listLords->setFixedSize (250, 150);

       _faceLord = new QLabel (this);

       _defaultButton = new QPushButton (this);
       _defaultButton->setText( tr( "Default" ) );
       FIXEDSIZE (_defaultButton);

       connect( _defaultButton, SIGNAL( clicked () ), this, SLOT( slot_defaultButtonPushed() ) );

	QVBoxLayout * layout = new QVBoxLayout;
       layout->setSpacing( 5 );
       layout->addWidget (playerLabel , 1, Qt::AlignHCenter);
	layout->addWidget( _comboPlayer , 1 , Qt::AlignHCenter);
       layout->addWidget (_listLords, 1);
       layout->addWidget (_faceLord, 1, Qt::AlignHCenter);
       layout->addWidget (_defaultButton, 1, Qt::AlignHCenter);
	layout->activate();

	_players = players;

       QGridLayout* gridLayout = new QGridLayout ( 5 , 2);
       gridLayout->setSpacing (2);

       int secondNum = 1;

       for (int num = 0; num < 9; )
       {
           if (
	     ((LordCharac)secondNum == MOVE)
	   || ((LordCharac)secondNum == TECHNICPOINT)
	   || ((LordCharac)secondNum == MAXTECHNICPOINT)
	      )
	      {
	      	secondNum++;
	      }
	      else
	      {
		generalChar[num] = new GeneralCharacteristic (secondNum , this);
		secondNum++;

		FIXEDSIZE (generalChar[num]);
		gridLayout->addWidget (generalChar[num],  (num) / 2 , num % 2);

		num++;
	      }
       }

       gridLayout->activate ();

       QHBoxLayout* hlayout = new QHBoxLayout (this);
       hlayout->addLayout (layout);
       hlayout->addLayout (gridLayout , 1);
       hlayout->activate ();
}

void PropertiesLordGeneral::init( GenericLord * lord, uint * ids, uint numLords )
{
	uint num;
	uint i;
	_lord = lord;
	_comboPlayer->clear();
	for( i = 0; i < _players->count(); i++ ) {
		QString title = QString::number( i ) + " - " + _players->at( i )->getName();
		_comboPlayer->insertItem( title, i );
	}

	if( lord->getOwner() ) {
		_comboPlayer->setCurrentItem( lord->getOwner()->getNum() );
	} else {
		_comboPlayer->setCurrentItem( 0 );
	}

       for( num = 0; num < 9; num++ ) {
		generalChar[num]->init(lord);
       }

       uint cnt = 0;
       uint nbLords = DataTheme.lords.count();
       for( num = 1; num < nbLords; num++ ) {
		bool isIdUsed = false;
		for( i = 0; i < numLords; i++ ) {
			if( num == ids[i] ) {
				isIdUsed = true;
			}
		}

		if( !isIdUsed ) {
           		QString string = QString::number (num) + " - " +
				DataTheme.lords.at(num)->getName() + " (" +
				DataTheme.creatures.getRace( DataTheme.lords.at(num)->getRace () )->getName()  + ")";
           		_listLords->insertItem( string );
			_ids[cnt] = num;
			cnt++;
	   	}
       }

       connect( _listLords, SIGNAL( selectionChanged() ), this, SLOT( slot_lordChanged() ) );

       	int numInList = 0;
	for( i = 0; i < cnt; i++ ) {
		if( _ids[i] == lord->getId() ) {
			numInList = i;
		}
	}

       _listLords->setCurrentItem( numInList );
       	slot_lordChanged();
}

void PropertiesLordGeneral::slot_lordChanged ()
{
    int index = _listLords->currentItem ();

    QPixmap* pix = ImageTheme.getLordPixmap(_ids[index] );

    if (!pix) return;

    _faceLord->setPixmap (*pix);
}

void PropertiesLordGeneral::slot_defaultButtonPushed ()
{
    int index = _listLords->currentItem ();
    
    GenericLord lord;

    lord.setId(_ids[index]);

    for (int num = 0; num < 9; num++)
    {
        generalChar[num]->init(&lord);
    }

}

void PropertiesLordGeneral::accept()
{
       if (_lord->getId() != _ids[_listLords->currentItem ()])
       {
           _lord->setId(_ids[_listLords->currentItem ()]);
       }

	if( _lord->getOwner() ) {
		_lord->getOwner()->removeLord( _lord );
	}
	_lord->setOwner( _players->at( _comboPlayer->currentItem() ) );
        _players->at( _comboPlayer->currentItem() )->addLord( _lord );

       for (int num = 0; num < 9; num++)
       {
           generalChar[num]->save(_lord);
       }


}

//
// ----- PropertiesLordUnits -----
//

PropertiesLordUnits::PropertiesLordUnits( QWidget * parent, const char * name )
: QWidget( parent, name )
{
	_lord = 0;

	QHBoxLayout * layH1 = new QHBoxLayout();
	QHBoxLayout * layH2 = new QHBoxLayout();

	for( int i = 0; i < MAX_UNIT; i++ ) {
		_troop[i] = new EditTroop( i, this );
		if( i <= (MAX_UNIT / 2 ) ) {
			layH1->addWidget( _troop[i] );
		} else {
			layH2->addWidget( _troop[i] );
		}
	}
	layH1->addStretch( 1 );
	layH2->addStretch( 1 );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setSpacing( 5 );
	layout->addLayout( layH1 );
	layout->addLayout( layH2 );
	layout->addStretch( 1 );
	layout->activate();
}

void PropertiesLordUnits::init( GenericLord * lord )
{
	_lord = lord;

	for( int i = 0; i < MAX_UNIT; i++ ) {
		_troop[i]->init (_lord->getUnit (i));
	}
}

void PropertiesLordUnits::accept()
{
	for( int i = 0; i < MAX_UNIT; i++ ) {
		_troop[i]->save( i, _lord );
	}
}

bool PropertiesLordUnits::hasNoneUnits ()
{
	bool hasUnits = false;

	for( int i = 0; i < MAX_UNIT; i++ ) {
		if (_troop[i]->hasUnits ())
		{
			hasUnits = true;
		}
	}

	return (!hasUnits);
}

//
// ----- EditTroop -----
//

EditTroop::EditTroop( int num, QWidget * parent, const char * name )
	: QFrame( parent, name )
{
	_unit = 0;
	setFrameStyle( QFrame::Panel | QFrame::Raised );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );

	QLabel * label = new QLabel( this );
	label->setText( "Unit " + QString::number( num ) );
	FIXEDSIZE( label );
	layout->addWidget( label );

	_race = new AskCombo( tr( "Race : " ), this );
	_race->setCurrentItem( 0 );
	layout->addWidget( _race );

	_name = new AskCombo( tr( "Name : " ), this );
	layout->addWidget( _name );

	_number = new AskInt( tr( "Number : " ), this );
	_number->setMaxValue( 65535 );
	layout->addWidget( _number );

	layout->addStretch( 1 );
	layout->activate();

	updateData();

	connect( _race, SIGNAL( sig_activated( int ) ), SLOT( slot_raceChanged( int ) ) );
}

bool EditTroop::hasUnits ()
{
	return (_number->getValue () > 0);
}

void EditTroop::slot_raceChanged( int race )
{
	_name->clear();
	for( uint i = 0; i < DataTheme.creatures.getRace( race )->count(); i++ ) {
		_name->insertItem( DataTheme.creatures.getRace( race )->at( i )->getName() );
	}
}

void EditTroop::updateData()
{
	int race = _race->currentItem();
	uint i;

	_race->clear();
	for( i = 0; i < DataTheme.countRace(); i++ ) {
		_race->insertItem( DataTheme.creatures.getRace( i )->getName() );
	}
	if( _unit ) {
		_race->setCurrentItem( _unit->getRace() );
	} else {
		_race->setCurrentItem( race );
	}

	_name->clear();
	for( i = 0; i < DataTheme.creatures.getRace( _race->currentItem() )->count(); i++ ) {
		_name->insertItem( DataTheme.creatures.getRace( _race->currentItem() )->at( i )->getName() );
	}
}

void EditTroop::clear()
{
	_race->setCurrentItem( 0 );
	_name->setCurrentItem( 0 );
	_number->setValue( 0 );
}

void EditTroop::init( GenericFightUnit * unit )
{
	_unit = unit;
	if( unit ) {
		_race->setCurrentItem( unit->getRace() );
		slot_raceChanged( unit->getRace() );
		_name->setCurrentItem( unit->getLevel() );
		_number->setValue( unit->getNumber() );
	} else {
		clear();
	}
}

void EditTroop::save( int i, GenericLord * lord )
{
	GenericFightUnit * unit = lord->getUnit( i );

	if( _number->getValue() > 0 ) {
		if( ! unit ) {
			unit = new GenericFightUnit();
		}
		unit->setCreature( _race->currentItem(), _name->currentItem() );
		unit->setNumber( _number->getValue() );
		lord->setUnit( i, unit );
	} else {
		if( unit ) {
			delete unit;
		}
		lord->setUnit( i, 0 );
	}
}

void EditTroop::save( int i, GenericBase * base )
{
	GenericFightUnit * unit = base->getUnit( i );

	if( _number->getValue() > 0 ) {
		if( ! unit ) {
			unit = new GenericFightUnit();
		}
		unit->setCreature( _race->currentItem(), _name->currentItem() );
		unit->setNumber( _number->getValue() );
		base->setUnit( i, unit );
	} else {
		if( unit ) {
			delete unit;
		}
		base->setUnit( i, 0 );
	}
}


//
// ----- PropertiesLordArtefacts -----
//

PropertiesLordArtefacts::PropertiesLordArtefacts( QWidget * parent, const char * name )
: QWidget( parent, name )
{
	_lord = 0;

	// main layout
	QHBoxLayout * mainLayout = new QHBoxLayout( this );

	QPushButton * addButton = new QPushButton( this );
	QPushButton * removeButton = new QPushButton( this );

	addButton->setText( "->" );
	removeButton->setText( "<-" );

	_artefactsList = new QTable( DataTheme.artefacts.count(), 1, this );
	_artefactsList->setLeftMargin( 1 );
	_artefactsList->setTopMargin( 40 );
	_artefactsList->setColumnStretchable( 0, true );
	_artefactsList->setReadOnly( true );
	_artefactsList->setShowGrid( false );
	_artefactsList->setSelectionMode( QTable::SingleRow );
	_artefactsList->horizontalHeader()->setLabel( 0, tr( "Common artefacts list" ) );

	_lordsArtefactsList = new QTable( DataTheme.artefacts.count(), 1, this );
	_lordsArtefactsList->setLeftMargin( 1 );
	_lordsArtefactsList->setTopMargin( 40 );
	_lordsArtefactsList->setColumnStretchable( 0, true );
	_lordsArtefactsList->setReadOnly( true );
	_lordsArtefactsList->setShowGrid( false );
	_lordsArtefactsList->setSelectionMode( QTable::SingleRow );
	_lordsArtefactsList->horizontalHeader()->setLabel( 0, tr( "Lord's artefacts list" ) );

	QGridLayout* gridLayout = new QGridLayout( 5 , 1, 20 );
	gridLayout->addWidget( addButton, 1, 0, Qt::AlignCenter );
	gridLayout->addWidget( removeButton, 3, 0, Qt::AlignCenter );

	mainLayout->setMargin( 20 );
	mainLayout->addWidget( _artefactsList, 3 );
	mainLayout->addLayout( gridLayout, 2 );
	mainLayout->addWidget( _lordsArtefactsList, 3 );

	connect( addButton, SIGNAL( clicked() ), this, SLOT( slot_addButtonPushed() ) );
	connect( removeButton, SIGNAL( clicked() ), this, SLOT( slot_removeButtonPushed() ) );
}

void PropertiesLordArtefacts::init( GenericLord * lord )
{
	_lord = lord;
	fillArtefactsList();
}

void PropertiesLordArtefacts::accept()
{
	_lord->getArtefactManager()->clearArtefacts();

	uint nbArtefacts = DataTheme.artefacts.count();
	for( uint i = 0; i < nbArtefacts; i++ ) {
        	if( _artefacts[i] ) {
			_lord->getArtefactManager()->addArtefact( i );
        	}
	}
}

void PropertiesLordArtefacts::fillArtefactsList ()
{
	uint nbArtefacts = DataTheme.artefacts.count();

	for( uint id = 0; id < nbArtefacts; id++ ) {
		GenericArtefactModel* artefactModel = DataTheme.artefacts.at(id);
		QString artefactName = artefactModel->getName();
		QPixmap* pix = ImageTheme.getArtefactIcon( id );

		_artefactsList->setText (id, 0, artefactName);
		_artefactsList->setPixmap (id, 0, *pix);
		_artefactsList->adjustRow (id);

		_lordsArtefactsList->setText (id, 0, artefactName);
		_lordsArtefactsList->setPixmap (id, 0, *pix);
		_lordsArtefactsList->adjustRow (id);

		_artefacts[id] = false;

		for( uint cnt = 0; cnt < _lord->getArtefactManager()->getArtefactNumber(); cnt++ ) {
			GenericLordArtefact* lordsArtefact = _lord->getArtefactManager()->getArtefact(cnt);
			if( lordsArtefact->getType() == id ) {
				_artefacts[id] = true;
			}
		}
	}

	refreshArtefactsList ();
}

void PropertiesLordArtefacts::slot_addButtonPushed()
{
	if( _artefactsList->numSelections() <= 0 ) {
		return;
	}

	QTableSelection sel = _artefactsList->selection( 0 );

	int row = sel.topRow();

	_artefacts[ row ] = true;

	refreshArtefactsList();
}

void PropertiesLordArtefacts::slot_removeButtonPushed()
{
	if( _lordsArtefactsList->numSelections() <= 0 ) {
		return;
	}

	QTableSelection sel = _lordsArtefactsList->selection( 0 );
	
	int row = sel.topRow();

	_artefacts[ row ] = false;

	refreshArtefactsList();
}

void PropertiesLordArtefacts::refreshArtefactsList ()
{
	uint nbArtefacts = DataTheme.artefacts.count();

	for( uint i = 0; i < nbArtefacts; i++ ) {
        	if( ! _artefacts[i] ) {
			_artefactsList->showRow( i );
			_lordsArtefactsList->hideRow( i );
        	} else {
			_artefactsList->hideRow( i );
			_lordsArtefactsList->showRow( i );
        	}
	}

	_artefactsList->repaintContents();
	_lordsArtefactsList->repaintContents();

	/// XXX: It's not ideal, I know - may be YOU can do it better :)
}

//
// ----- PropertiesLordWarMachines -----
//

PropertiesLordWarMachines::PropertiesLordWarMachines( QWidget * parent, const char * name )
: QWidget( parent, name )
{
	_lord = 0;

     // main layout
     QHBoxLayout* mainLayout = new QHBoxLayout (this);

     QPushButton* addButton = new QPushButton (this);
     QPushButton* removeButton = new QPushButton (this);

     addButton->setText ("->");
     removeButton->setText ("<-");

     _warMachinesList = new QTable (DataTheme.machines.count (), 1, this);
     _warMachinesList->setLeftMargin (1);
     _warMachinesList->setTopMargin (40);
     _warMachinesList->setColumnStretchable (0, true);
     _warMachinesList->setReadOnly (true);
     _warMachinesList->setShowGrid (false);
     _warMachinesList->setSelectionMode (QTable::SingleRow);
     _warMachinesList->horizontalHeader()->setLabel (0, tr( "Common war machines list" ) );

     _lordsWarMachinesList = new QTable (DataTheme.machines.count (), 1, this);
     _lordsWarMachinesList->setLeftMargin (1);
     _lordsWarMachinesList->setTopMargin (40);
     _lordsWarMachinesList->setColumnStretchable (0, true);
     _lordsWarMachinesList->setReadOnly (true);
     _lordsWarMachinesList->setShowGrid (false);
     _lordsWarMachinesList->setSelectionMode (QTable::SingleRow);
     _lordsWarMachinesList->horizontalHeader()->setLabel( 0, tr( "Lord's war machines list" ) );

     QGridLayout* gridLayout = new QGridLayout (5 , 1, 20);
     gridLayout->addWidget (addButton,1,0, Qt::AlignCenter);
     gridLayout->addWidget (removeButton,3,0, Qt::AlignCenter);

     mainLayout->setMargin (20);
     mainLayout->addWidget (_warMachinesList, 3);
     mainLayout->addLayout (gridLayout , 2);
     mainLayout->addWidget (_lordsWarMachinesList, 3);

     connect (addButton, SIGNAL (clicked ()), this, SLOT (addButtonPushed ()));

     connect (removeButton, SIGNAL (clicked ()), this, SLOT (removeButtonPushed ()));
}

void PropertiesLordWarMachines::init( GenericLord * lord )
{
    _lord = lord;

     fillWarMachinesList ();
}

void PropertiesLordWarMachines::accept()
{
	uint nbMachineLord = _lord->getMachineNumber();

	for( uint num = 0; num < nbMachineLord; num++ ) {
		_lord->removeMachine( 0 );
	}

	uint nbMachine = DataTheme.machines.count();
	for( uint id = 0; id < nbMachine; id++ ) {
        	if( _warMachines[id] ) {
			_lord->addMachine( id );
		}
	}
}

void PropertiesLordWarMachines::fillWarMachinesList ()
{
	uint nbMachines = DataTheme.machines.count();
	for( uint id = 0; id < nbMachines; id++ ) {
		QString machineName = DataTheme.machines.at(id)->getName();
		//  XXX: We need it !  QPixmap* pix = ImageTheme.getWarMachineIcon( id );

		_warMachinesList->setText( id, 0, machineName );
		// XXX:         _warMachinesList->setPixmap (id, 0, *pix);
		_warMachinesList->adjustRow( id );

		_lordsWarMachinesList->setText (id, 0, machineName);
		// XXX:        _lordsWarMachinesList->setPixmap (id, 0, *pix);
		_lordsWarMachinesList->adjustRow (id);

		_warMachines[id] = false;

         	for( uint cnt = 0; cnt < _lord->getMachineNumber(); cnt++) {
             		if( _lord->getMachine(cnt) == id ) {
                 		_warMachines[id] = true;
             		}
         	}
    	}

   	refreshWarMachinesList();
}

void PropertiesLordWarMachines::addButtonPushed ()
{
   if (_warMachinesList->numSelections () <= 0) return;

   QTableSelection sel = _warMachinesList->selection (0);

   int row = sel.topRow ();

   _warMachines[row] = true;

   refreshWarMachinesList ();
}

void PropertiesLordWarMachines::removeButtonPushed ()
{
   if (_lordsWarMachinesList->numSelections () <= 0) return;

   QTableSelection sel = _lordsWarMachinesList->selection (0);

   int row = sel.topRow ();

   _warMachines[row] = false;

   refreshWarMachinesList ();
}

void PropertiesLordWarMachines::refreshWarMachinesList ()
{
	uint nbMachines = DataTheme.machines.count();
    	for( uint id = 0; id < nbMachines; id++ ) {
        	if( ! _warMachines[id] ) {
			_warMachinesList->showRow (id);
			_lordsWarMachinesList->hideRow (id);
        	} else {
			_warMachinesList->hideRow (id);
			_lordsWarMachinesList->showRow (id);
		}
	}

	_warMachinesList->repaintContents ();
	_lordsWarMachinesList->repaintContents ();
}

//
// ----- PropertiesLordTechnics -----
//

PropertiesLordTechnics::PropertiesLordTechnics( QWidget * parent, const char * name )
: QWidget( parent, name )
{
	_lord = 0;

     // main layout
     QHBoxLayout* mainLayout = new QHBoxLayout (this);

     QPushButton* addButton = new QPushButton (this);
     QPushButton* removeButton = new QPushButton (this);

     addButton->setText ("->");
     removeButton->setText ("<-");

     _technicsList = new QTable (DataTheme.techList.count (), 1, this);
     _technicsList->setLeftMargin (1);
     _technicsList->setTopMargin (40);
     _technicsList->setColumnStretchable (0, true);
     _technicsList->setReadOnly (true);
     _technicsList->setShowGrid (false);
     _technicsList->setSelectionMode (QTable::SingleRow);
     _technicsList->horizontalHeader()->setLabel (0, tr( "Common technics list" ) );

     _lordsTechnicsList = new QTable (DataTheme.techList.count (), 1, this);
     _lordsTechnicsList->setLeftMargin (1);
     _lordsTechnicsList->setTopMargin (40);
     _lordsTechnicsList->setColumnStretchable (0, true);
     _lordsTechnicsList->setReadOnly (true);
     _lordsTechnicsList->setShowGrid (false);
     _lordsTechnicsList->setSelectionMode (QTable::SingleRow);
     _lordsTechnicsList->horizontalHeader()->setLabel (0, tr( "Lord's technics list" ) );

     QGridLayout* gridLayout = new QGridLayout (5 , 1, 20);
     gridLayout->addWidget (addButton,1,0, Qt::AlignCenter);
     gridLayout->addWidget (removeButton,3,0, Qt::AlignCenter);

     mainLayout->setMargin (20);
     mainLayout->addWidget (_technicsList, 3);
     mainLayout->addLayout (gridLayout , 2);
     mainLayout->addWidget (_lordsTechnicsList, 3);

     connect (addButton, SIGNAL (clicked ()), this, SLOT (addButtonPushed ()));

     connect (removeButton, SIGNAL (clicked ()), this, SLOT (removeButtonPushed ()));
}

void PropertiesLordTechnics::init( GenericLord * lord )
{
    _lord = lord;

     fillTechnicsList ();
}

void PropertiesLordTechnics::accept()
{
   /* XXX:   (class GeneralLord must be updated: there is TechnicalBook, but it's too... it's not ready :) )
    for (int num = 0; num < _lord->getTechnicsNumber(); num++)
    {
        _lord->removeTechnic(0);
    }
  */
	uint nbTech = DataTheme.techList.count();
    	for( uint id = 0; id < nbTech; id++ ) {
        	if( _technics[id] ) {
			/* XXX:
				_lord->addTechnic( id );
            		*/
        	}
    	}
}

void PropertiesLordTechnics::fillTechnicsList ()
{
	uint nbTech = DataTheme.techList.count();
	for( uint id = 0; id < nbTech; id++ ) {
		QString technicName = DataTheme.techList.at(id)->getName();
		//  XXX: We need it !  QPixmap* pix = ImageTheme.getTechnicIcon( id );

		_technicsList->setText (id, 0, technicName);
		// XXX:         _technicsList->setPixmap (id, 0, *pix);
		_technicsList->adjustRow (id);

		_lordsTechnicsList->setText( id, 0, technicName );
		// XXX:        _lordsTechnicsList->setPixmap (id, 0, *pix);
		_lordsTechnicsList->adjustRow (id);

		_technics[id] = false;

         /* XXX:
         for (int cnt = 0; cnt < _lord->getTechnicsNumber(); cnt++)
         {
             if (_lord->getTechnic(cnt) == id)
             {
                 _technics[id] = true;
             }
         }

         */
	}

	refreshTechnicsList();
}

void PropertiesLordTechnics::addButtonPushed ()
{
   if (_technicsList->numSelections () <= 0) return;

   QTableSelection sel = _technicsList->selection (0);

   int row = sel.topRow ();

   _technics[row] = true;

   refreshTechnicsList ();
}

void PropertiesLordTechnics::removeButtonPushed ()
{
   if (_lordsTechnicsList->numSelections () <= 0) return;

   QTableSelection sel = _lordsTechnicsList->selection (0);

   int row = sel.topRow ();

   _technics[row] = false;

   refreshTechnicsList ();
}

void PropertiesLordTechnics::refreshTechnicsList ()
{
	uint nbTech = DataTheme.techList.count();
	for( uint id = 0; id < nbTech; id++ ) {
        	if( !_technics[id] ) {
			_technicsList->showRow (id);
			_lordsTechnicsList->hideRow (id);
        	} else {
			_technicsList->hideRow (id);
			_lordsTechnicsList->showRow (id);
		}
	}

	_technicsList->repaintContents();
	_lordsTechnicsList->repaintContents();
}





















