/* Test of fmax() function. Random cases.
   $Id: fmax-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases	*/
    long x, y;		/* args		*/
    long z;		/* result	*/
} t[] = {

    /* x, y, fmax(x,y)	*/
    { 0x3d0a9ad5,0xc0258b61,0x3d0a9ad5 }, /*   1:  3.3839066e-02 -2.5866320e+00  3.3839066e-02 */
    { 0x41a2fb9a,0x435e4b67,0x435e4b67 }, /*   2:  2.0372852e+01  2.2229454e+02  2.2229454e+02 */
    { 0xbd5c2e0d,0xbba89d2f,0xbba89d2f }, /*   3: -5.3754855e-02 -5.1456909e-03 -5.1456909e-03 */
    { 0xbf1c236d,0xbaf61c89,0xbaf61c89 }, /*   4: -6.0991555e-01 -1.8776815e-03 -1.8776815e-03 */
    { 0x436cb8f6,0xe8944c44,0x436cb8f6 }, /*   5:  2.3672250e+02 -5.6025367e+24  2.3672250e+02 */
    { 0xbed2cd76,0x3d624d94,0x3d624d94 }, /*   6: -4.1172379e-01  5.5249766e-02  5.5249766e-02 */
    { 0x3b356e3a,0x43983eff,0x43983eff }, /*   7:  2.7684108e-03  3.0449216e+02  3.0449216e+02 */
    { 0xbe997578,0xc96154df,0xbe997578 }, /*   8: -2.9972434e-01 -9.2295794e+05 -2.9972434e-01 */
    { 0x43dd9cf0,0xbffd85da,0x43dd9cf0 }, /*   9:  4.4322607e+02 -1.9806473e+00  4.4322607e+02 */
    { 0x457eca64,0x324efb62,0x457eca64 }, /*  10:  4.0766494e+03  1.2047936e-08  4.0766494e+03 */
    { 0x442aaeae,0xbbda6fbd,0x442aaeae }, /*  11:  6.8272937e+02 -6.6661523e-03  6.8272937e+02 */
    { 0x319396a1,0x85c8b561,0x319396a1 }, /*  12:  4.2953876e-09 -1.8874538e-35  4.2953876e-09 */
    { 0xb68c103e,0xbe966c72,0xb68c103e }, /*  13: -4.1742160e-06 -2.9379612e-01 -4.1742160e-06 */
    { 0x40c6bc63,0x112e9bc5,0x40c6bc63 }, /*  14:  6.2104964e+00  1.3774180e-28  6.2104964e+00 */
    { 0xad253623,0xc6b05eef,0xad253623 }, /*  15: -9.3911849e-12 -2.2575467e+04 -9.3911849e-12 */
    { 0x3ed2a937,0xbd30a704,0x3ed2a937 }, /*  16:  4.1144726e-01 -4.3128029e-02  4.1144726e-01 */
    { 0x47447b80,0xc6073cf9,0x47447b80 }, /*  17:  5.0299500e+04 -8.6552432e+03  5.0299500e+04 */
    { 0xbc6269b2,0xbe902628,0xbc6269b2 }, /*  18: -1.3819145e-02 -2.8154111e-01 -1.3819145e-02 */
    { 0xc44c1efc,0x3e8d6627,0x3e8d6627 }, /*  19: -8.1648413e+02  2.7616999e-01  2.7616999e-01 */
    { 0x4299d7be,0x4a23fcd5,0x4a23fcd5 }, /*  20:  7.6921371e+01  2.6867732e+06  2.6867732e+06 */
    { 0xd6643163,0xc5c5eb18,0xc5c5eb18 }, /*  21: -6.2725191e+13 -6.3333867e+03 -6.3333867e+03 */
    { 0x3ea6960c,0x3c953894,0x3ea6960c }, /*  22:  3.2536352e-01  1.8215455e-02  3.2536352e-01 */
    { 0x3ffcd143,0x3dc53ebe,0x3ffcd143 }, /*  23:  1.9751362e+00  9.6311077e-02  1.9751362e+00 */
    { 0xc39601af,0xc19b6f5a,0xc19b6f5a }, /*  24: -3.0001315e+02 -1.9429371e+01 -1.9429371e+01 */
    { 0xc22fd42e,0xb3cd1170,0xb3cd1170 }, /*  25: -4.3957207e+01 -9.5492283e-08 -9.5492283e-08 */
    { 0xb44610c8,0x3040a74a,0x3040a74a }, /*  26: -1.8446292e-07  7.0086925e-10  7.0086925e-10 */
    { 0x402511dd,0x3c51058b,0x402511dd }, /*  27:  2.5792153e+00  1.2757669e-02  2.5792153e+00 */
    { 0x45dc798e,0x3ee729d6,0x45dc798e }, /*  28:  7.0551943e+03  4.5149106e-01  7.0551943e+03 */
    { 0x44f140c6,0x478a00a0,0x478a00a0 }, /*  29:  1.9300242e+03  7.0657250e+04  7.0657250e+04 */
    { 0xbbb97a4b,0xc2c01d77,0xbbb97a4b }, /*  30: -5.6603304e-03 -9.6057549e+01 -5.6603304e-03 */
    { 0x31c1ccbc,0xc2065b71,0x31c1ccbc }, /*  31:  5.6403149e-09 -3.3589298e+01  5.6403149e-09 */
    { 0x3e698dfc,0xc0330a57,0x3e698dfc }, /*  32:  2.2808069e-01 -2.7975061e+00  2.2808069e-01 */
    { 0x3ada9aa2,0xbf37b3b0,0x3ada9aa2 }, /*  33:  1.6678164e-03 -7.1758556e-01  1.6678164e-03 */
    { 0x4672b7b3,0xbfd88f83,0x4672b7b3 }, /*  34:  1.5533925e+04 -1.6918796e+00  1.5533925e+04 */
    { 0x3b620c0b,0xc04d34b7,0x3b620c0b }, /*  35:  3.4492041e-03 -3.2063425e+00  3.4492041e-03 */
    { 0x3bdcbfbc,0xbed59f8b,0x3bdcbfbc }, /*  36:  6.7367237e-03 -4.1723284e-01  6.7367237e-03 */
    { 0xba7839e8,0xb27d1272,0xb27d1272 }, /*  37: -9.4690779e-04 -1.4730732e-08 -1.4730732e-08 */
    { 0xc2d8939b,0xc490bce0,0xc2d8939b }, /*  38: -1.0828829e+02 -1.1579023e+03 -1.0828829e+02 */
    { 0x421ed8b6,0xc05a7984,0x421ed8b6 }, /*  39:  3.9711632e+01 -3.4136667e+00  3.9711632e+01 */
    { 0xbe919bca,0x3be1ad88,0x3be1ad88 }, /*  40: -2.8439170e-01  6.8871416e-03  6.8871416e-03 */
    { 0xc6828417,0xbbe50a03,0xbbe50a03 }, /*  41: -1.6706045e+04 -6.9897189e-03 -6.9897189e-03 */
    { 0xbc1d4ef9,0x4221ce37,0x4221ce37 }, /*  42: -9.6013481e-03  4.0451382e+01  4.0451382e+01 */
    { 0x46fbd28a,0xc566e53a,0x46fbd28a }, /*  43:  3.2233270e+04 -3.6943267e+03  3.2233270e+04 */
    { 0xbc6fa5a1,0xc3a3c2f1,0xbc6fa5a1 }, /*  44: -1.4626891e-02 -3.2752298e+02 -1.4626891e-02 */
    { 0xc0760f37,0xbeba35e6,0xbeba35e6 }, /*  45: -3.8446786e+00 -3.6369246e-01 -3.6369246e-01 */
    { 0x3987d977,0xc06d7ae3,0x3987d977 }, /*  46:  2.5911230e-04 -3.7106254e+00  2.5911230e-04 */
    { 0xc09e011b,0x403a6629,0x403a6629 }, /*  47: -4.9376349e+00  2.9124854e+00  2.9124854e+00 */
    { 0x40813086,0xc056c4e5,0x40813086 }, /*  48:  4.0371733e+00 -3.3557675e+00  4.0371733e+00 */
    { 0xbb83bf77,0x44c983c3,0x44c983c3 }, /*  49: -4.0206271e-03  1.6121176e+03  1.6121176e+03 */
    { 0x43dba854,0x3feb97ad,0x43dba854 }, /*  50:  4.3931506e+02  1.8405663e+00  4.3931506e+02 */
    { 0x3d758258,0x40508148,0x40508148 }, /*  51:  5.9938759e-02  3.2578907e+00  3.2578907e+00 */
    { 0x3e866005,0xbaf6bbe5,0x3e866005 }, /*  52:  2.6245132e-01 -1.8824307e-03  2.6245132e-01 */
    { 0xbd7b8b9c,0xc5690c8c,0xbd7b8b9c }, /*  53: -6.1412439e-02 -3.7287842e+03 -6.1412439e-02 */
    { 0xc01f41c4,0xbecfa93d,0xbecfa93d }, /*  54: -2.4883890e+00 -4.0558806e-01 -4.0558806e-01 */
    { 0xbd1ce5dc,0xc038c288,0xbd1ce5dc }, /*  55: -3.8305148e-02 -2.8868732e+00 -3.8305148e-02 */
    { 0x3af15d15,0x42648975,0x42648975 }, /*  56:  1.8414581e-03  5.7134235e+01  5.7134235e+01 */
    { 0x3c49fd70,0x3eb733d1,0x3eb733d1 }, /*  57:  1.2328491e-02  3.5781720e-01  3.5781720e-01 */
    { 0x9059e716,0x3cabd226,0x3cabd226 }, /*  58: -4.2973726e-29  2.0974230e-02  2.0974230e-02 */
    { 0xc014d0a9,0xc1dc4963,0xc014d0a9 }, /*  59: -2.3252356e+00 -2.7535833e+01 -2.3252356e+00 */
    { 0xb4d808db,0xbfe2f1ed,0xb4d808db }, /*  60: -4.0239578e-07 -1.7730080e+00 -4.0239578e-07 */
    { 0x3eeb41ae,0x3c47d5f8,0x3eeb41ae }, /*  61:  4.5948547e-01  1.2197010e-02  4.5948547e-01 */
    { 0x426ea5b9,0xc1b5fea4,0x426ea5b9 }, /*  62:  5.9661839e+01 -2.2749336e+01  5.9661839e+01 */
    { 0xc205a72e,0xbf282efa,0xbf282efa }, /*  63: -3.3413261e+01 -6.5696681e-01 -6.5696681e-01 */
    { 0xbd21b872,0x3672f1f0,0x3672f1f0 }, /*  64: -3.9482541e-02  3.6201636e-06  3.6201636e-06 */
    { 0xc6fe0fd0,0x36a4768c,0x36a4768c }, /*  65: -3.2519906e+04  4.9013815e-06  4.9013815e-06 */
    { 0x461f91c0,0x30d35a2e,0x461f91c0 }, /*  66:  1.0212438e+04  1.5377901e-09  1.0212438e+04 */
    { 0x3ebb140e,0x416ff308,0x416ff308 }, /*  67:  3.6538738e-01  1.4996834e+01  1.4996834e+01 */
    { 0xc2ef722c,0x3b5760a2,0x3b5760a2 }, /*  68: -1.1972299e+02  3.2863994e-03  3.2863994e-03 */
    { 0xc37a3af0,0x4b4bf56c,0x4b4bf56c }, /*  69: -2.5023022e+02  1.3366636e+07  1.3366636e+07 */
    { 0x407b6bce,0xb9f5fe1a,0x407b6bce }, /*  70:  3.9284549e+00 -4.6919362e-04  3.9284549e+00 */
    { 0xc00cd322,0x405f6cc1,0x405f6cc1 }, /*  71: -2.2003865e+00  3.4910128e+00  3.4910128e+00 */
    { 0xa0232015,0xbe938947,0xa0232015 }, /*  72: -1.3817252e-19 -2.8815672e-01 -1.3817252e-19 */
    { 0x2b925df6,0xbf800000,0x2b925df6 }, /*  73:  1.0400003e-12 -1.0000000e+00  1.0400003e-12 */
    { 0x377dfa27,0xbce3ba54,0x377dfa27 }, /*  74:  1.5138218e-05 -2.7798809e-02  1.5138218e-05 */
    { 0xa4906882,0x42b329ba,0x42b329ba }, /*  75: -6.2627088e-17  8.9581497e+01  8.9581497e+01 */
    { 0xbcc1a4b7,0xbeafe1bd,0xbcc1a4b7 }, /*  76: -2.3638112e-02 -3.4351912e-01 -2.3638112e-02 */
    { 0xbc43425e,0xbe7ee9b0,0xbc43425e }, /*  77: -1.1917679e-02 -2.4893832e-01 -1.1917679e-02 */
    { 0x3ecde7d9,0x4634cb1e,0x4634cb1e }, /*  78:  4.0215948e-01  1.1570779e+04  1.1570779e+04 */
    { 0xbf800000,0xbc2b31a0,0xbc2b31a0 }, /*  79: -1.0000000e+00 -1.0448843e-02 -1.0448843e-02 */
    { 0x49847f05,0x3ccfd735,0x49847f05 }, /*  80:  1.0854086e+06  2.5371173e-02  1.0854086e+06 */
    { 0x3eee2c09,0xbd2282ce,0x3eee2c09 }, /*  81:  4.6517971e-01 -3.9675526e-02  4.6517971e-01 */
    { 0xbb3f599f,0xbc5e5bb5,0xbb3f599f }, /*  82: -2.9197705e-03 -1.3571669e-02 -2.9197705e-03 */
    { 0x46cdb053,0x392e01ed,0x46cdb053 }, /*  83:  2.6328162e+04  1.6594651e-04  2.6328162e+04 */
    { 0x41db5470,0xc4a55da0,0x41db5470 }, /*  84:  2.7416229e+01 -1.3229258e+03  2.7416229e+01 */
    { 0x3e7195f1,0x3a508241,0x3e7195f1 }, /*  85:  2.3592354e-01  7.9539797e-04  2.3592354e-01 */
    { 0x40199133,0xb492e6af,0x40199133 }, /*  86:  2.3994873e+00 -2.7362464e-07  2.3994873e+00 */
    { 0xc04f1f72,0x4590936b,0x4590936b }, /*  87: -3.2362943e+00  4.6264272e+03  4.6264272e+03 */
    { 0xbd43f5ff,0x429c2c6e,0x429c2c6e }, /*  88: -4.7842022e-02  7.8086777e+01  7.8086777e+01 */
    { 0xbf48b49c,0xba740e34,0xba740e34 }, /*  89: -7.8400588e-01 -9.3099778e-04 -9.3099778e-04 */
    { 0xc0ad52de,0x3eded4a5,0x3eded4a5 }, /*  90: -5.4163656e+00  4.3521610e-01  4.3521610e-01 */
    { 0x38cb8e4b,0x3ea998cd,0x3ea998cd }, /*  91:  9.7062984e-05  3.3124390e-01  3.3124390e-01 */
    { 0x3fd759cf,0x3ceeb365,0x3fd759cf }, /*  92:  1.6824282e+00  2.9138276e-02  1.6824282e+00 */
    { 0xbe7267ab,0xc058515f,0xbe7267ab }, /*  93: -2.3672359e-01 -3.3799665e+00 -2.3672359e-01 */
    { 0xbe997618,0x3d32046b,0x3d32046b }, /*  94: -2.9972911e-01  4.3461245e-02  4.3461245e-02 */
    { 0x290b975f,0x3c4cbe37,0x3c4cbe37 }, /*  95:  3.0995494e-14  1.2496523e-02  1.2496523e-02 */
    { 0xcaffdccd,0xbcbfe308,0xbcbfe308 }, /*  96: -8.3841025e+06 -2.3423687e-02 -2.3423687e-02 */
    { 0x408c9f9e,0xc1e0420a,0x408c9f9e }, /*  97:  4.3944845e+00 -2.8032246e+01  4.3944845e+00 */
    { 0xd134da83,0x539a483b,0x539a483b }, /*  98: -4.8547508e+10  1.3252736e+12  1.3252736e+12 */
    { 0x421b09cc,0xbaeb1b62,0x421b09cc }, /*  99:  3.8759567e+01 -1.7937238e-03  3.8759567e+01 */
    { 0xc222c4a3,0xc3936f35,0xc222c4a3 }, /* 100: -4.0692028e+01 -2.9486880e+02 -4.0692028e+01 */
    { 0xc2f3a377,0xbeff0597,0xbeff0597 }, /* 101: -1.2181927e+02 -4.9808952e-01 -4.9808952e-01 */
    { 0x3f0a2fa7,0xc413a550,0x3f0a2fa7 }, /* 102:  5.3978962e-01 -5.9058301e+02  5.3978962e-01 */
    { 0xbbbb4a57,0x3ab4a655,0x3ab4a655 }, /* 103: -5.7156491e-03  1.3782481e-03  1.3782481e-03 */
    { 0x44fc1c76,0xc44e9c02,0x44fc1c76 }, /* 104:  2.0168894e+03 -8.2643762e+02  2.0168894e+03 */
    { 0x3eb88dd5,0x3bc01bae,0x3eb88dd5 }, /* 105:  3.6045709e-01  5.8626747e-03  3.6045709e-01 */
    { 0x3bd08995,0x3e9306d6,0x3e9306d6 }, /* 106:  6.3640573e-03  2.8716153e-01  2.8716153e-01 */
    { 0x3b117ad5,0xc189b38b,0x3b117ad5 }, /* 107:  2.2198458e-03 -1.7212667e+01  2.2198458e-03 */
    { 0x41c40c44,0xbebf41ec,0x41c40c44 }, /* 108:  2.4505989e+01 -3.7354982e-01  2.4505989e+01 */
    { 0xbb500e09,0xc167d7a4,0xbb500e09 }, /* 109: -3.1746647e-03 -1.4490147e+01 -3.1746647e-03 */
    { 0x3a1c8e7c,0xbee1532a,0x3a1c8e7c }, /* 110:  5.9721596e-04 -4.4008762e-01  5.9721596e-04 */
    { 0x407ae25d,0x3aa68293,0x407ae25d }, /* 111:  3.9200661e+00  1.2703709e-03  3.9200661e+00 */
    { 0xbd007e60,0xc32d5828,0xbd007e60 }, /* 112: -3.1370521e-02 -1.7334436e+02 -3.1370521e-02 */
    { 0xc0616788,0xc25ea4cd,0xc0616788 }, /* 113: -3.5219440e+00 -5.5660938e+01 -3.5219440e+00 */
    { 0xc3a9cc49,0x3d396da1,0x3d396da1 }, /* 114: -3.3959598e+02  4.5270566e-02  4.5270566e-02 */
    { 0x10ab0810,0x46c0f797,0x46c0f797 }, /* 115:  6.7460030e-29  2.4699795e+04  2.4699795e+04 */
    { 0x3a2a32fb,0x3d4d662e,0x3d4d662e }, /* 116:  6.4925820e-04  5.0146274e-02  5.0146274e-02 */
    { 0xbd93ec27,0x4299c568,0x4299c568 }, /* 117: -7.2227769e-02  7.6885559e+01  7.6885559e+01 */
    { 0xbbfc03e7,0xfe05d1d4,0xbbfc03e7 }, /* 118: -7.6908949e-03 -4.4469203e+37 -7.6908949e-03 */
    { 0x42aff0f5,0xbec4e06e,0x42aff0f5 }, /* 119:  8.7970619e+01 -3.8452476e-01  8.7970619e+01 */
    { 0xbbeba7ee,0x3f800000,0x3f800000 }, /* 120: -7.1916496e-03  1.0000000e+00  1.0000000e+00 */
    { 0xc1ffbae4,0xc349ab41,0xc1ffbae4 }, /* 121: -3.1966255e+01 -2.0166896e+02 -3.1966255e+01 */
    { 0x3f2051c0,0x2525a0d6,0x3f2051c0 }, /* 122:  6.2624741e-01  1.4365962e-16  6.2624741e-01 */
    { 0x3f800000,0xc1fc47ad,0x3f800000 }, /* 123:  1.0000000e+00 -3.1534998e+01  1.0000000e+00 */
    { 0x3c61a6b8,0x4248e040,0x4248e040 }, /* 124:  1.3772659e-02  5.0218994e+01  5.0218994e+01 */
    { 0xcecb8c2d,0x426c1080,0x426c1080 }, /* 125: -1.7074807e+09  5.9016113e+01  5.9016113e+01 */
    { 0x97983b7c,0xb20ce409,0x97983b7c }, /* 126: -9.8377857e-25 -8.2009217e-09 -9.8377857e-25 */
    { 0x4471514e,0x43dec821,0x4471514e }, /* 127:  9.6527039e+02  4.4556351e+02  9.6527039e+02 */
    { 0xc26d62f6,0xbe8fd30a,0xbe8fd30a }, /* 128: -5.9346642e+01 -2.8090698e-01 -2.8090698e-01 */
    { 0xc42aa9e1,0x44137050,0x44137050 }, /* 129: -6.8265436e+02  5.8975488e+02  5.8975488e+02 */
    { 0x40688bdb,0xbe5ffc3a,0x40688bdb }, /* 130:  3.6335361e+00 -2.1873561e-01  3.6335361e+00 */
    { 0xc61c6bb4,0x3b1ac4f8,0x3b1ac4f8 }, /* 131: -1.0010926e+04  2.3615938e-03  2.3615938e-03 */
    { 0x404683d7,0x6026d7b4,0x6026d7b4 }, /* 132:  3.1017969e+00  4.8089103e+19  4.8089103e+19 */
    { 0xc3dbabd4,0xbff377f5,0xbff377f5 }, /* 133: -4.3934241e+02 -1.9020983e+00 -1.9020983e+00 */
    { 0x2cb2a692,0x428c2926,0x428c2926 }, /* 134:  5.0775573e-12  7.0080368e+01  7.0080368e+01 */
    { 0x7f120c75,0x403037a0,0x7f120c75 }, /* 135:  1.9413197e+38  2.7533951e+00  1.9413197e+38 */
    { 0xbc367588,0x46bbe589,0x46bbe589 }, /* 136: -1.1136420e-02  2.4050768e+04  2.4050768e+04 */
    { 0xc2d1635b,0x1ab5e91a,0x1ab5e91a }, /* 137: -1.0469405e+02  7.5236441e-23  7.5236441e-23 */
    { 0x41aa7df9,0xc29c274e,0x41aa7df9 }, /* 138:  2.1311510e+01 -7.8076767e+01  2.1311510e+01 */
    { 0x3a7eafe5,0xba307d02,0x3a7eafe5 }, /* 139:  9.7155414e-04 -6.7324948e-04  9.7155414e-04 */
    { 0xbefdf6a5,0xc02bcb0a,0xbefdf6a5 }, /* 140: -4.9602237e-01 -2.6842675e+00 -4.9602237e-01 */
    { 0xbabf1eca,0xbef32d8e,0xbabf1eca }, /* 141: -1.4581319e-03 -4.7495693e-01 -1.4581319e-03 */
    { 0x3d9018b1,0xc28d018b,0x3d9018b1 }, /* 142:  7.0359595e-02 -7.0503014e+01  7.0359595e-02 */
    { 0xca03e2f2,0x44329e6b,0x44329e6b }, /* 143: -2.1608285e+06  7.1447528e+02  7.1447528e+02 */
    { 0x567312e2,0x3ebd53fc,0x567312e2 }, /* 144:  6.6815607e+13  3.6978137e-01  6.6815607e+13 */
    { 0xbb366ff0,0xc3e56b4a,0xbb366ff0 }, /* 145: -2.7837716e-03 -4.5883820e+02 -2.7837716e-03 */
    { 0x3f0c2edb,0x31f20dfa,0x3f0c2edb }, /* 146:  5.4758996e-01  7.0447159e-09  5.4758996e-01 */
    { 0x43824cb9,0x86b7ec8e,0x43824cb9 }, /* 147:  2.6059940e+02 -6.9184535e-35  2.6059940e+02 */
    { 0xbec3641f,0xc2edac8f,0xbec3641f }, /* 148: -3.8162324e-01 -1.1883703e+02 -3.8162324e-01 */
    { 0x420164d9,0xbf53bfcf,0x420164d9 }, /* 149:  3.2348484e+01 -8.2714552e-01  3.2348484e+01 */
    { 0xafbe4d4b,0x3d2de790,0x3d2de790 }, /* 150: -3.4615719e-10  4.2457163e-02  4.2457163e-02 */
    { 0x43710af5,0x3f800000,0x43710af5 }, /* 151:  2.4104280e+02  1.0000000e+00  2.4104280e+02 */
    { 0x3fee38b2,0xbb857907,0x3fee38b2 }, /* 152:  1.8611052e+00 -4.0732655e-03  1.8611052e+00 */
    { 0xb7595a08,0x41ed4dfd,0x41ed4dfd }, /* 153: -1.2955170e-05  2.9663080e+01  2.9663080e+01 */
    { 0xc02e4820,0xb833b54b,0xb833b54b }, /* 154: -2.7231522e+00 -4.2845768e-05 -4.2845768e-05 */
    { 0x52023008,0x3c130077,0x52023008 }, /* 155:  1.3978789e+11  8.9722788e-03  1.3978789e+11 */
    { 0x427cf01c,0x4546d177,0x4546d177 }, /* 156:  6.3234482e+01  3.1810916e+03  3.1810916e+03 */
    { 0xbcdab3a9,0xc1c82b1d,0xbcdab3a9 }, /* 157: -2.6696997e-02 -2.5021051e+01 -2.6696997e-02 */
    { 0x84f25363,0xbc9c8680,0x84f25363 }, /* 158: -5.6970505e-36 -1.9107103e-02 -5.6970505e-36 */
    { 0xbd092d5f,0x23575317,0x23575317 }, /* 159: -3.3490535e-02  1.1672768e-17  1.1672768e-17 */
    { 0x445a8e12,0xc1569aad,0x445a8e12 }, /* 160:  8.7421985e+02 -1.3412763e+01  8.7421985e+02 */
    { 0xaed4395d,0xb2a7c7b5,0xaed4395d }, /* 161: -9.6508336e-11 -1.9532175e-08 -9.6508336e-11 */
    { 0x40514656,0x36911e62,0x40514656 }, /* 162:  3.2699180e+00  4.3248738e-06  3.2699180e+00 */
    { 0xc076560e,0x3b23dd65,0x3b23dd65 }, /* 163: -3.8490024e+00  2.5003788e-03  2.5003788e-03 */
    { 0xb27ddfed,0x3c1df066,0x3c1df066 }, /* 164: -1.4777453e-08  9.6398350e-03  9.6398350e-03 */
    { 0xc2d37989,0xbcd5c91e,0xbcd5c91e }, /* 165: -1.0573737e+02 -2.6096877e-02 -2.6096877e-02 */
    { 0x37f3e10a,0xc3a47a5a,0x37f3e10a }, /* 166:  2.9072649e-05 -3.2895587e+02  2.9072649e-05 */
    { 0x49323268,0xc05c3b2d,0x49323268 }, /* 167:  7.2989450e+05 -3.4411118e+00  7.2989450e+05 */
    { 0xe4c15b57,0x3e960504,0x3e960504 }, /* 168: -2.8534427e+22  2.9300702e-01  2.9300702e-01 */
    { 0x59ee66ae,0xbb7841c5,0x59ee66ae }, /* 169:  8.3879927e+15 -3.7880999e-03  8.3879927e+15 */
    { 0xc0b84390,0x3b8feeab,0x3b8feeab }, /* 170: -5.7582474e+00  4.3924651e-03  4.3924651e-03 */
    { 0xb9a606cc,0x56ca68e1,0x56ca68e1 }, /* 171: -3.1667051e-04  1.1127590e+14  1.1127590e+14 */
    { 0x36b5b7f1,0xbd4f6237,0x36b5b7f1 }, /* 172:  5.4156340e-06 -5.0630774e-02  5.4156340e-06 */
    { 0x3c8c4f8f,0x465bb6ad,0x465bb6ad }, /* 173:  1.7127780e-02  1.4061669e+04  1.4061669e+04 */
    { 0xb1e26b03,0x3ead488b,0x3ead488b }, /* 174: -6.5896315e-09  3.3844408e-01  3.3844408e-01 */
    { 0x3f0e37cf,0xc396524d,0x3f0e37cf }, /* 175:  5.5553907e-01 -3.0064297e+02  5.5553907e-01 */
    { 0x3f800000,0xc9e92f51,0x3f800000 }, /* 176:  1.0000000e+00 -1.9102501e+06  1.0000000e+00 */
    { 0x3ecca70f,0x42bb778f,0x42bb778f }, /* 177:  3.9971206e-01  9.3733513e+01  9.3733513e+01 */
    { 0xbee2a02d,0x3ee7a4b2,0x3ee7a4b2 }, /* 178: -4.4262829e-01  4.5242840e-01  4.5242840e-01 */
    { 0x304960ce,0x44c1b93a,0x44c1b93a }, /* 179:  7.3260942e-10  1.5497883e+03  1.5497883e+03 */
    { 0xbeafd9a8,0x402754a2,0x402754a2 }, /* 180: -3.4345746e-01  2.6145406e+00  2.6145406e+00 */
    { 0xc0571d0f,0xaf9d82aa,0xaf9d82aa }, /* 181: -3.3611486e+00 -2.8650976e-10 -2.8650976e-10 */
    { 0xc6da0994,0xadec8a50,0xadec8a50 }, /* 182: -2.7908789e+04 -2.6891517e-11 -2.6891517e-11 */
    { 0x3f0c8236,0x4416d00b,0x4416d00b }, /* 183:  5.4886186e-01  6.0325067e+02  6.0325067e+02 */
    { 0xc03d6679,0xc03869ac,0xc03869ac }, /* 184: -2.9593794e+00 -2.8814497e+00 -2.8814497e+00 */
    { 0x3ec4a85a,0x2dac5e34,0x3ec4a85a }, /* 185:  3.8409692e-01  1.9595971e-11  3.8409692e-01 */
    { 0xb7fce6fa,0xbb75c8a3,0xb7fce6fa }, /* 186: -3.0148298e-05 -3.7503622e-03 -3.0148298e-05 */
    { 0xc06070ca,0x407c6585,0x407c6585 }, /* 187: -3.5068841e+00  3.9436963e+00  3.9436963e+00 */
    { 0x3c29143b,0xc69c8267,0x3c29143b }, /* 188:  1.0319765e-02 -2.0033201e+04  1.0319765e-02 */
    { 0x4010ffaa,0xc20078a0,0x4010ffaa }, /* 189:  2.2656045e+00 -3.2117798e+01  2.2656045e+00 */
    { 0x424a19f2,0xc0608a04,0x424a19f2 }, /* 190:  5.0525337e+01 -3.5084238e+00  5.0525337e+01 */
    { 0xcb36561d,0x4009f67f,0x4009f67f }, /* 191: -1.1949597e+07  2.1556699e+00  2.1556699e+00 */
    { 0xc22a27ce,0x4a194b95,0x4a194b95 }, /* 192: -4.2538872e+01  2.5115892e+06  2.5115892e+06 */
    { 0xc0009413,0x54757977,0x54757977 }, /* 193: -2.0090377e+00  4.2172193e+12  4.2172193e+12 */
    { 0xc812465f,0xb7782ded,0xb7782ded }, /* 194: -1.4978548e+05 -1.4792645e-05 -1.4792645e-05 */
    { 0x3b77c8d0,0x3d0b2d58,0x3d0b2d58 }, /* 195:  3.7808903e-03  3.3978790e-02  3.3978790e-02 */
    { 0x3b1fcb85,0xc2e21469,0x3b1fcb85 }, /* 196:  2.4382782e-03 -1.1303986e+02  2.4382782e-03 */
    { 0xbec82a70,0xc89b926a,0xbec82a70 }, /* 197: -3.9094877e-01 -3.1861131e+05 -3.9094877e-01 */
    { 0x43b54907,0xafc5c48d,0x43b54907 }, /* 198:  3.6257053e+02 -3.5973749e-10  3.6257053e+02 */
    { 0x3bfc1ac2,0xc17fa62f,0x3bfc1ac2 }, /* 199:  7.6936195e-03 -1.5978072e+01  7.6936195e-03 */
    { 0x38a7ea4e,0x4046f561,0x4046f561 }, /* 200:  8.0068232e-05  3.1087267e+00  3.1087267e+00 */
    { 0xc55663ab,0x3eb4e5d5,0x3eb4e5d5 }, /* 201: -3.4302292e+03  3.5331598e-01  3.5331598e-01 */
    { 0x63e231dd,0xc71d5e37,0x63e231dd }, /* 202:  8.3451144e+21 -4.0286215e+04  8.3451144e+21 */
    { 0x3e78ed82,0x40a52aed,0x40a52aed }, /* 203:  2.4309352e-01  5.1614900e+00  5.1614900e+00 */
    { 0x383d356c,0xb8ea3933,0x383d356c }, /* 204:  4.5110864e-05 -1.1168644e-04  4.5110864e-05 */
    { 0x43b34b36,0x3d9584b7,0x43b34b36 }, /* 205:  3.5858759e+02  7.3007040e-02  3.5858759e+02 */
    { 0xba5caadc,0x894b8525,0x894b8525 }, /* 206: -8.4177940e-04 -2.4497840e-33 -2.4497840e-33 */
    { 0xbc77f97e,0x3b6d951b,0x3b6d951b }, /* 207: -1.5135167e-02  3.6252204e-03  3.6252204e-03 */
    { 0xc01b37d2,0x4293f141,0x4293f141 }, /* 208: -2.4252820e+00  7.3971199e+01  7.3971199e+01 */
    { 0xbd5b9487,0x3ef0946c,0x3ef0946c }, /* 209: -5.3608444e-02  4.6988237e-01  4.6988237e-01 */
    { 0x43887509,0xc04baece,0x43887509 }, /* 210:  2.7291434e+02 -3.1825442e+00  2.7291434e+02 */
    { 0xbff9cc27,0x3fef06e5,0x3fef06e5 }, /* 211: -1.9515427e+00  1.8673979e+00  1.8673979e+00 */
    { 0x46269945,0xb5081c3e,0x46269945 }, /* 212:  1.0662317e+04 -5.0705046e-07  1.0662317e+04 */
    { 0x3b42bd34,0x401e9d2a,0x401e9d2a }, /* 213:  2.9714825e-03  2.4783425e+00  2.4783425e+00 */
    { 0xbf106933,0xbe7ce028,0xbe7ce028 }, /* 214: -5.6410521e-01 -2.4694884e-01 -2.4694884e-01 */
    { 0xc029a389,0xbd9582f2,0xbd9582f2 }, /* 215: -2.6506064e+00 -7.3003665e-02 -7.3003665e-02 */
    { 0x3bc4fe25,0x3877611f,0x3bc4fe25 }, /* 216:  6.0117417e-03  5.8979840e-05  6.0117417e-03 */
    { 0xc1fb3850,0xc1282adb,0xc1282adb }, /* 217: -3.1402496e+01 -1.0510463e+01 -1.0510463e+01 */
    { 0xbf800000,0xc01711fb,0xbf800000 }, /* 218: -1.0000000e+00 -2.3604724e+00 -1.0000000e+00 */
    { 0x396f8399,0xca5ba56a,0x396f8399 }, /* 219:  2.2841840e-04 -3.5986825e+06  2.2841840e-04 */
    { 0xbec36def,0x45f9b008,0x45f9b008 }, /* 220: -3.8169810e-01  7.9900039e+03  7.9900039e+03 */
    { 0x31b53dc8,0xbb95331d,0x31b53dc8 }, /* 221:  5.2748170e-09 -4.5532123e-03  5.2748170e-09 */
    { 0x3d4572d3,0xc02302ef,0x3d4572d3 }, /* 222:  4.8205208e-02 -2.5470541e+00  4.8205208e-02 */
    { 0xbff42dcf,0xc01e9dac,0xbff42dcf }, /* 223: -1.9076480e+00 -2.4783735e+00 -1.9076480e+00 */
    { 0x3ea49c53,0xc3d34640,0x3ea49c53 }, /* 224:  3.2150516e-01 -4.2254883e+02  3.2150516e-01 */
    { 0x427cf7c8,0xc003a67d,0x427cf7c8 }, /* 225:  6.3241974e+01 -2.0570366e+00  6.3241974e+01 */
    { 0xbebdd061,0xbbbcf1e8,0xbbbcf1e8 }, /* 226: -3.7073043e-01 -5.7661422e-03 -5.7661422e-03 */
    { 0xbd9294e5,0x40676afc,0x40676afc }, /* 227: -7.1573056e-02  3.6159048e+00  3.6159048e+00 */
    { 0x45733eb0,0xb8481926,0x45733eb0 }, /* 228:  3.8919180e+03 -4.7707137e-05  3.8919180e+03 */
    { 0x3b73e1ee,0xc93f503b,0x3b73e1ee }, /* 229:  3.7213522e-03 -7.8361969e+05  3.7213522e-03 */
    { 0xc460a10b,0xc69971c5,0xc460a10b }, /* 230: -8.9851630e+02 -1.9640885e+04 -8.9851630e+02 */
    { 0x4285ae2c,0x3de14a18,0x4285ae2c }, /* 231:  6.6840179e+01  1.1000460e-01  6.6840179e+01 */
    { 0x403459cb,0xbe777af0,0x403459cb }, /* 232:  2.8179805e+00 -2.4167991e-01  2.8179805e+00 */
    { 0xa7590a9b,0x3e6c0180,0x3e6c0180 }, /* 233: -3.0120549e-15  2.3047447e-01  2.3047447e-01 */
    { 0xeff5e8a7,0xc7312510,0xc7312510 }, /* 234: -1.5221017e+29 -4.5349062e+04 -4.5349062e+04 */
    { 0xc0c7e9b4,0xc02d1f24,0xc02d1f24 }, /* 235: -6.2472782e+00 -2.7050257e+00 -2.7050257e+00 */
    { 0xb9d6ce5c,0xc69c2467,0xb9d6ce5c }, /* 236: -4.0971010e-04 -1.9986201e+04 -4.0971010e-04 */
    { 0xc00cfe09,0xbec1013d,0xbec1013d }, /* 237: -2.2030051e+00 -3.7696257e-01 -3.7696257e-01 */
    { 0xbd4f2f4c,0xc7bbfda8,0xbd4f2f4c }, /* 238: -5.0582215e-02 -9.6251312e+04 -5.0582215e-02 */
    { 0xf8958121,0x44449b4f,0x44449b4f }, /* 239: -2.4258477e+34  7.8642670e+02  7.8642670e+02 */
    { 0xc02311b2,0x41cb0ca3,0x41cb0ca3 }, /* 240: -2.5479550e+00  2.5381170e+01  2.5381170e+01 */
    { 0xbc7c0b2d,0x3badeaee,0x3badeaee }, /* 241: -1.5383524e-02  5.3075468e-03  5.3075468e-03 */
    { 0xbf9f9aef,0xbc919442,0xbc919442 }, /* 242: -1.2469157e+00 -1.7770890e-02 -1.7770890e-02 */
    { 0x401b39d1,0xbc0f10bd,0x401b39d1 }, /* 243:  2.4254038e+00 -8.7320181e-03  2.4254038e+00 */
    { 0x3cbd3845,0x441fa09f,0x441fa09f }, /* 244:  2.3098120e-02  6.3850970e+02  6.3850970e+02 */
    { 0x3c29e8c2,0xc0216fa5,0x3c29e8c2 }, /* 245:  1.0370435e-02 -2.5224392e+00  1.0370435e-02 */
    { 0xb3a20689,0x331e737b,0x331e737b }, /* 246: -7.5449016e-08  3.6892271e-08  3.6892271e-08 */
    { 0xc302793a,0x4407a788,0x4407a788 }, /* 247: -1.3047354e+02  5.4261768e+02  5.4261768e+02 */
    { 0x524545c1,0x2b1fa3bf,0x524545c1 }, /* 248:  2.1181971e+11  5.6715391e-13  2.1181971e+11 */
    { 0xbcc6413a,0xc041a331,0xbcc6413a }, /* 249: -2.4201024e-02 -3.0255854e+00 -2.4201024e-02 */
    { 0xb504d832,0x3a3d4de6,0x3a3d4de6 }, /* 250: -4.9488438e-07  7.2213856e-04  7.2213856e-04 */
    { 0xbf038d7c,0xc440708c,0xbf038d7c }, /* 251: -5.1387763e-01 -7.6975854e+02 -5.1387763e-01 */
    { 0xbd2c17d9,0xbb38c21b,0xbb38c21b }, /* 252: -4.2014930e-02 -2.8191868e-03 -2.8191868e-03 */
    { 0xbaf50f02,0x3e9555da,0x3e9555da }, /* 253: -1.8696489e-03  2.9167062e-01  2.9167062e-01 */
    { 0x406188ef,0xbd0a1b65,0x406188ef }, /* 254:  3.5239828e+00 -3.3717532e-02  3.5239828e+00 */
    { 0xbc9f8ad8,0x3d2c617f,0x3d2c617f }, /* 255: -1.9475386e-02  4.2085167e-02  4.2085167e-02 */
    { 0x3be806ee,0x382f6151,0x3be806ee }, /* 256:  7.0809042e-03  4.1813884e-05  7.0809042e-03 */
    { 0x48e7988e,0xbeb5a58b,0x48e7988e }, /* 257:  4.7430844e+05 -3.5477862e-01  4.7430844e+05 */
    { 0xc1a83669,0x3b271373,0x3b271373 }, /* 258: -2.1026567e+01  2.5493770e-03  2.5493770e-03 */
    { 0x3e907669,0x4344adb6,0x4344adb6 }, /* 259:  2.8215340e-01  1.9667856e+02  1.9667856e+02 */
    { 0xbe90739b,0x469b2de7,0x469b2de7 }, /* 260: -2.8213200e-01  1.9862951e+04  1.9862951e+04 */
    { 0xc079a78f,0xc1da68fb,0xc079a78f }, /* 261: -3.9008520e+00 -2.7301260e+01 -3.9008520e+00 */
    { 0x25251155,0xbefb9746,0x25251155 }, /* 262:  1.4317341e-16 -4.9138850e-01  1.4317341e-16 */
    { 0xbd86d428,0x3f800000,0x3f800000 }, /* 263: -6.5834343e-02  1.0000000e+00  1.0000000e+00 */
    { 0xbd00b2cb,0xc603496b,0xbd00b2cb }, /* 264: -3.1420510e-02 -8.4023545e+03 -3.1420510e-02 */
    { 0xc2d54c8e,0x414f88d0,0x414f88d0 }, /* 265: -1.0664952e+02  1.2970901e+01  1.2970901e+01 */
    { 0x3c51734c,0x3dbf32b5,0x3dbf32b5 }, /* 266:  1.2783837e-02  9.3358435e-02  9.3358435e-02 */
    { 0x3eb0d69b,0xc2597855,0x3eb0d69b }, /* 267:  3.4538731e-01 -5.4367512e+01  3.4538731e-01 */
    { 0x3cdc982d,0xc0789638,0x3cdc982d }, /* 268:  2.6928032e-02 -3.8841686e+00  2.6928032e-02 */
    { 0xbff027ac,0x3834c079,0x3834c079 }, /* 269: -1.8762107e+00  4.3094598e-05  4.3094598e-05 */
    { 0xb961fd98,0x3622cd93,0x3622cd93 }, /* 270: -2.1552143e-04  2.4259541e-06  2.4259541e-06 */
    { 0xbce49ece,0xc481193d,0xbce49ece }, /* 271: -2.7907755e-02 -1.0327887e+03 -2.7907755e-02 */
    { 0x317a3c69,0xb638b59d,0x317a3c69 }, /* 272:  3.6414127e-09 -2.7523849e-06  3.6414127e-09 */
    { 0xc706144d,0x42197c7f,0x42197c7f }, /* 273: -3.4324301e+04  3.8371578e+01  3.8371578e+01 */
    { 0xc027c13b,0x51616afd,0x51616afd }, /* 274: -2.6211689e+00  6.0510163e+10  6.0510163e+10 */
    { 0xc07d2c5a,0xf6662106,0xc07d2c5a }, /* 275: -3.9558320e+00 -1.1668926e+33 -3.9558320e+00 */
    { 0xb9e52cf8,0x3ecb1f3a,0x3ecb1f3a }, /* 276: -4.3711788e-04  3.9672261e-01  3.9672261e-01 */
    { 0xbf800000,0x45b57517,0x45b57517 }, /* 277: -1.0000000e+00  5.8066362e+03  5.8066362e+03 */
    { 0xc55d8e82,0xc05b431d,0xc05b431d }, /* 278: -3.5449067e+03 -3.4259713e+00 -3.4259713e+00 */
    { 0xbd113bd4,0xc05e2962,0xbd113bd4 }, /* 279: -3.5457447e-02 -3.4712758e+00 -3.5457447e-02 */
    { 0x3e7f405e,0x403a977d,0x403a977d }, /* 280:  2.4926898e-01  2.9154961e+00  2.9154961e+00 */
    { 0x3d7b52af,0xc43a7980,0x3d7b52af }, /* 281:  6.1358150e-02 -7.4589844e+02  6.1358150e-02 */
    { 0x338be75f,0x3ac29697,0x3ac29697 }, /* 282:  6.5147781e-08  1.4845905e-03  1.4845905e-03 */
    { 0xc2276904,0x3e921288,0x3e921288 }, /* 283: -4.1852554e+01  2.8529763e-01  2.8529763e-01 */
    { 0xca08e8d3,0x432b28d5,0x432b28d5 }, /* 284: -2.2431248e+06  1.7115950e+02  1.7115950e+02 */
    { 0x3d3876a8,0xb310bee7,0x3d3876a8 }, /* 285:  4.5035034e-02 -3.3701237e-08  4.5035034e-02 */
    { 0xbf2fa744,0xbc17af19,0xbc17af19 }, /* 286: -6.8614602e-01 -9.2580551e-03 -9.2580551e-03 */
    { 0x403e3990,0xdc75919c,0x403e3990 }, /* 287:  2.9722633e+00 -2.7648587e+17  2.9722633e+00 */
    { 0xc255c3fb,0x404320f0,0x404320f0 }, /* 288: -5.3441387e+01  3.0488853e+00  3.0488853e+00 */
    { 0xbd1397c9,0xb79402fc,0xb79402fc }, /* 289: -3.6033425e-02 -1.7644365e-05 -1.7644365e-05 */
    { 0xbea82a3f,0xbc707779,0xbc707779 }, /* 290: -3.2844731e-01 -1.4676922e-02 -1.4676922e-02 */
    { 0xb3a97636,0x3c18b635,0x3c18b635 }, /* 291: -7.8911782e-08  9.3207853e-03  9.3207853e-03 */
    { 0xc040417a,0xcc0c16ef,0xc040417a }, /* 292: -3.0039964e+00 -3.6723644e+07 -3.0039964e+00 */
    { 0x3ee14f02,0x50f5149a,0x50f5149a }, /* 293:  4.4005591e-01  3.2894145e+10  3.2894145e+10 */
    { 0xbee14565,0x43dc33a7,0x43dc33a7 }, /* 294: -4.3998256e-01  4.4040353e+02  4.4040353e+02 */
    { 0xbfd81151,0xbc1d666b,0xbc1d666b }, /* 295: -1.6880285e+00 -9.6069379e-03 -9.6069379e-03 */
    { 0x357a49c0,0x46462f81,0x46462f81 }, /* 296:  9.3239578e-07  1.2683876e+04  1.2683876e+04 */
    { 0x405f1ee2,0xbea922d8,0x405f1ee2 }, /* 297:  3.4862599e+00 -3.3034396e-01  3.4862599e+00 */
    { 0x41c9cfbe,0xbcb8a745,0x41c9cfbe }, /* 298:  2.5226437e+01 -2.2540698e-02  2.5226437e+01 */
    { 0x40af3446,0xc069b60f,0x40af3446 }, /* 299:  5.4751310e+00 -3.6517370e+00  5.4751310e+00 */
    { 0x406586bf,0xbe918c4a,0x406586bf }, /* 300:  3.5863492e+00 -2.8427345e-01  3.5863492e+00 */
    { 0x3d58a656,0xc9b698c6,0x3d58a656 }, /* 301:  5.2893005e-02 -1.4958328e+06  5.2893005e-02 */
    { 0xc0033b60,0xc0513a60,0xc0033b60 }, /* 302: -2.0504990e+00 -3.2691879e+00 -2.0504990e+00 */
    { 0x402c2547,0x439aeade,0x439aeade }, /* 303:  2.6897752e+00  3.0983490e+02  3.0983490e+02 */
    { 0x3f209eb4,0xb785b8e9,0x3f209eb4 }, /* 304:  6.2742162e-01 -1.5940941e-05  6.2742162e-01 */
    { 0xc23b95c2,0xc26b24bb,0xc23b95c2 }, /* 305: -4.6896248e+01 -5.8785870e+01 -4.6896248e+01 */
    { 0x7f050b51,0x407d4c41,0x7f050b51 }, /* 306:  1.7684608e+38  3.9577792e+00  1.7684608e+38 */
    { 0xc1d09f25,0xc14721c2,0xc14721c2 }, /* 307: -2.6077707e+01 -1.2445742e+01 -1.2445742e+01 */
    { 0xbcb9ebba,0x3c2f2319,0x3c2f2319 }, /* 308: -2.2695411e-02  1.0689520e-02  1.0689520e-02 */
    { 0x41cf3573,0xc00e2f86,0x41cf3573 }, /* 309:  2.5901098e+01 -2.2216506e+00  2.5901098e+01 */
    { 0x40318022,0x44dc8d52,0x44dc8d52 }, /* 310:  2.7734456e+00  1.7644163e+03  1.7644163e+03 */
    { 0xaaa4e9a4,0x4fce404d,0x4fce404d }, /* 311: -2.9294373e-13  6.9206410e+09  6.9206410e+09 */
    { 0x445fd484,0x3ae5f463,0x445fd484 }, /* 312:  8.9532056e+02  1.7544146e-03  8.9532056e+02 */
    { 0x42c14570,0x3a008e6a,0x42c14570 }, /* 313:  9.6635620e+01  4.9040338e-04  9.6635620e+01 */
    { 0xbec00580,0x3ea19829,0x3ea19829 }, /* 314: -3.7504196e-01  3.1561401e-01  3.1561401e-01 */
    { 0xbce954d6,0xba3d49ad,0xba3d49ad }, /* 315: -2.8482836e-02 -7.2207564e-04 -7.2207564e-04 */
    { 0xda579f93,0xc1b5ae7d,0xc1b5ae7d }, /* 316: -1.5173143e+16 -2.2710199e+01 -2.2710199e+01 */
    { 0xbca8ec4a,0xbed53525,0xbca8ec4a }, /* 317: -2.0620484e-02 -4.1642109e-01 -2.0620484e-02 */
    { 0xbd573d34,0xc36d68b7,0xbd573d34 }, /* 318: -5.2548602e-02 -2.3740904e+02 -5.2548602e-02 */
    { 0x405f9cec,0x405fb879,0x405fb879 }, /* 319:  3.4939528e+00  3.4956343e+00  3.4956343e+00 */
    { 0xc056e8a6,0xa3e431ff,0xa3e431ff }, /* 320: -3.3579497e+00 -2.4740984e-17 -2.4740984e-17 */
    { 0x3b9ae263,0x434c8839,0x434c8839 }, /* 321:  4.7266944e-03  2.0453212e+02  2.0453212e+02 */
    { 0x388c931f,0x3ebedcc1,0x3ebedcc1 }, /* 322:  6.7031237e-05  3.7277797e-01  3.7277797e-01 */
    { 0xc73550b7,0x407217c4,0x407217c4 }, /* 323: -4.6416715e+04  3.7827005e+00  3.7827005e+00 */
    { 0xd464eccb,0xc20d2f33,0xc20d2f33 }, /* 324: -3.9329011e+12 -3.5296093e+01 -3.5296093e+01 */
    { 0xc210bb0f,0x400b4171,0x400b4171 }, /* 325: -3.6182674e+01  2.1758692e+00  2.1758692e+00 */
    { 0x40186766,0xc3309308,0x40186766 }, /* 326:  2.3813109e+00 -1.7657434e+02  2.3813109e+00 */
    { 0xbcc92b7f,0x3e3aa431,0x3e3aa431 }, /* 327: -2.4556873e-02  1.8226697e-01  1.8226697e-01 */
    { 0x4124e439,0x1b238f99,0x4124e439 }, /* 328:  1.0305718e+01  1.3529443e-22  1.0305718e+01 */
    { 0xc574a378,0x3c2ae17f,0x3c2ae17f }, /* 329: -3.9142168e+03  1.0429739e-02  1.0429739e-02 */
    { 0x4266c6e9,0x42c4eb98,0x42c4eb98 }, /* 330:  5.7694248e+01  9.8460144e+01  9.8460144e+01 */
    { 0xbaa19f42,0x3c898ca5,0x3c898ca5 }, /* 331: -1.2330788e-03  1.6790697e-02  1.6790697e-02 */
    { 0xbbb963be,0x3eb5280d,0x3eb5280d }, /* 332: -5.6576421e-03  3.5382119e-01  3.5382119e-01 */
    { 0x430c4ef6,0xc096e8f7,0x430c4ef6 }, /* 333:  1.4030844e+02 -4.7159381e+00  1.4030844e+02 */
    { 0xbeaa3b04,0x40373e26,0x40373e26 }, /* 334: -3.3248150e-01  2.8631682e+00  2.8631682e+00 */
    { 0xc04fb445,0xc9444537,0xc04fb445 }, /* 335: -3.2453778e+00 -8.0392344e+05 -3.2453778e+00 */
    { 0xc5f13d5d,0x3d5c86ab,0x3d5c86ab }, /* 336: -7.7196704e+03  5.3839367e-02  5.3839367e-02 */
    { 0xc23efa7d,0xbc02908c,0xbc02908c }, /* 337: -4.7744617e+01 -7.9690330e-03 -7.9690330e-03 */
    { 0x41dcd14f,0x41acb395,0x41dcd14f }, /* 338:  2.7602201e+01  2.1587687e+01  2.7602201e+01 */
    { 0xc0102850,0x3680a40d,0x3680a40d }, /* 339: -2.2524605e+00  3.8337953e-06  3.8337953e-06 */
    { 0x081a5f03,0x3960bbf6,0x3960bbf6 }, /* 340:  4.6454375e-34  2.1432326e-04  2.1432326e-04 */
    { 0xbfec7e08,0xbb48ce17,0xbb48ce17 }, /* 341: -1.8475962e+00 -3.0640417e-03 -3.0640417e-03 */
    { 0xbed3c25d,0xae5e04af,0xae5e04af }, /* 342: -4.1359225e-01 -5.0481116e-11 -5.0481116e-11 */
    { 0xc02d0db4,0xc3c9fe72,0xc02d0db4 }, /* 343: -2.7039614e+00 -4.0398785e+02 -2.7039614e+00 */
    { 0xc053e57c,0xbd63aff3,0xbd63aff3 }, /* 344: -3.3108816e+00 -5.5587720e-02 -5.5587720e-02 */
    { 0x4094f2e4,0x42d0a7c3,0x42d0a7c3 }, /* 345:  4.6546497e+00  1.0432766e+02  1.0432766e+02 */
    { 0x3ce1f839,0xb9e205dc,0x3ce1f839 }, /* 346:  2.7584182e-02 -4.3110445e-04  2.7584182e-02 */
    { 0x3c7f8448,0x44923ee4,0x44923ee4 }, /* 347:  1.5595503e-02  1.1699653e+03  1.1699653e+03 */
    { 0x43e6e17b,0x3f6bbe63,0x43e6e17b }, /* 348:  4.6176157e+02  9.2087382e-01  4.6176157e+02 */
    { 0x3c0f045f,0xc09c213a,0x3c0f045f }, /* 349:  8.7290695e-03 -4.8790560e+00  8.7290695e-03 */
    { 0x3e81c1d2,0x402e4f04,0x402e4f04 }, /* 350:  2.5343186e-01  2.7235727e+00  2.7235727e+00 */
    { 0x3a6aed07,0x3e8f1e7c,0x3e8f1e7c }, /* 351:  8.9617114e-04  2.7952945e-01  2.7952945e-01 */
    { 0xc2a1b138,0xbfdf6e3c,0xbfdf6e3c }, /* 352: -8.0846130e+01 -1.7455516e+00 -1.7455516e+00 */
    { 0x3eafcf20,0x44c320d2,0x44c320d2 }, /* 353:  3.4337711e-01  1.5610256e+03  1.5610256e+03 */
    { 0x316091e2,0xb3f65075,0x316091e2 }, /* 354:  3.2679215e-09 -1.1469903e-07  3.2679215e-09 */
    { 0xbad316e9,0xc27d8958,0xbad316e9 }, /* 355: -1.6104850e-03 -6.3384125e+01 -1.6104850e-03 */
    { 0x3ee741bc,0xb1f2bae2,0x3ee741bc }, /* 356:  4.5167339e-01 -7.0643731e-09  4.5167339e-01 */
    { 0x3b0c1598,0x4b21f327,0x4b21f327 }, /* 357:  2.1375176e-03  1.0613543e+07  1.0613543e+07 */
    { 0xc1970524,0x3ea36bdc,0x3ea36bdc }, /* 358: -1.8877510e+01  3.1918228e-01  3.1918228e-01 */
    { 0x42cbf2d0,0x103aa224,0x42cbf2d0 }, /* 359:  1.0197424e+02  3.6806941e-29  1.0197424e+02 */
    { 0xca62dbeb,0x41c9d15f,0x41c9d15f }, /* 360: -3.7168588e+06  2.5227232e+01  2.5227232e+01 */
    { 0x3f287963,0xbbbdd232,0x3f287963 }, /* 361:  6.5810221e-01 -5.7928795e-03  6.5810221e-01 */
    { 0x3eac154c,0x46cf8ea0,0x46cf8ea0 }, /* 362:  3.3609998e-01  2.6567312e+04  2.6567312e+04 */
    { 0x33961689,0xc0883c57,0x33961689 }, /* 363:  6.9890184e-08 -4.2573657e+00  6.9890184e-08 */
    { 0xc507149b,0xcd94bc04,0xc507149b }, /* 364: -2.1612878e+03 -3.1191872e+08 -2.1612878e+03 */
    { 0xc04ec96f,0x3e853d5f,0x3e853d5f }, /* 365: -3.2310445e+00  2.6023385e-01  2.6023385e-01 */
    { 0x4058f73d,0xc7b5a9b1,0x4058f73d }, /* 366:  3.3900902e+00 -9.3011383e+04  3.3900902e+00 */
    { 0xc1d6c4bd,0xc5e0aefa,0xc1d6c4bd }, /* 367: -2.6846064e+01 -7.1898721e+03 -2.6846064e+01 */
    { 0x3eb63747,0xc36521cb,0x3eb63747 }, /* 368:  3.5589048e-01 -2.2913200e+02  3.5589048e-01 */
    { 0xc03ae378,0xbc586a87,0xbc586a87 }, /* 369: -2.9201336e+00 -1.3208992e-02 -1.3208992e-02 */
    { 0x4266d5aa,0x3ec613b5,0x4266d5aa }, /* 370:  5.7708656e+01  3.8686910e-01  5.7708656e+01 */
    { 0x3b621979,0xbed73928,0x3b621979 }, /* 371:  3.4500046e-03 -4.2035794e-01  3.4500046e-03 */
    { 0x3fffab1c,0xc19dc57b,0x3fffab1c }, /* 372:  1.9974093e+00 -1.9721426e+01  1.9974093e+00 */
    { 0x3d099f67,0x1e86af37,0x3d099f67 }, /* 373:  3.3599284e-02  1.4260269e-20  3.3599284e-02 */
    { 0xc20c4014,0x3ed95ebf,0x3ed95ebf }, /* 374: -3.5062576e+01  4.2455098e-01  4.2455098e-01 */
    { 0x3d346fc5,0xc3dfa34f,0x3d346fc5 }, /* 375:  4.4051904e-02 -4.4727585e+02  4.4051904e-02 */
    { 0x42e181d7,0x3c057101,0x42e181d7 }, /* 376:  1.1275359e+02  8.1446180e-03  1.1275359e+02 */
    { 0x3a7ef22d,0xbc4b1ba7,0x3a7ef22d }, /* 377:  9.7254181e-04 -1.2396730e-02  9.7254181e-04 */
    { 0x421005f6,0xc031afb4,0x421005f6 }, /* 378:  3.6005821e+01 -2.7763491e+00  3.6005821e+01 */
    { 0xc3dbf159,0xbe9e4b9a,0xbe9e4b9a }, /* 379: -4.3988553e+02 -3.0917054e-01 -3.0917054e-01 */
    { 0x405b03bf,0x34b636fd,0x405b03bf }, /* 380:  3.4221036e+00  3.3940151e-07  3.4221036e+00 */
    { 0x3f800000,0x4264f1bb,0x4264f1bb }, /* 381:  1.0000000e+00  5.7236065e+01  5.7236065e+01 */
    { 0xbc6ef7f9,0xba1d2029,0xba1d2029 }, /* 382: -1.4585488e-02 -5.9938669e-04 -5.9938669e-04 */
    { 0x49b86d6c,0x3c0e1420,0x49b86d6c }, /* 383:  1.5108295e+06  8.6717904e-03  1.5108295e+06 */
    { 0xc318436c,0x4034be4a,0x4034be4a }, /* 384: -1.5226337e+02  2.8241143e+00  2.8241143e+00 */
    { 0xc05345e7,0x546f4056,0x546f4056 }, /* 385: -3.3011415e+00  4.1103062e+12  4.1103062e+12 */
    { 0x3bddc796,0xbc23bbcd,0x3bddc796 }, /* 386:  6.7681773e-03 -9.9935057e-03  6.7681773e-03 */
    { 0x406cbee9,0xafdef493,0x406cbee9 }, /* 387:  3.6991522e+00 -4.0555345e-10  3.6991522e+00 */
    { 0xf901bd76,0xc34ac0f2,0xc34ac0f2 }, /* 388: -4.2103064e+34 -2.0275369e+02 -2.0275369e+02 */
    { 0xbef9b845,0x496606c6,0x496606c6 }, /* 389: -4.8773399e-01  9.4218838e+05  9.4218838e+05 */
    { 0xba3a4c5a,0xbae51e3d,0xba3a4c5a }, /* 390: -7.1067142e-04 -1.7480325e-03 -7.1067142e-04 */
    { 0x3abceacb,0xbd0ae218,0x3abceacb }, /* 391:  1.4413235e-03 -3.3907026e-02  1.4413235e-03 */
    { 0xfc529ebd,0x422e9c0d,0x422e9c0d }, /* 392: -4.3744077e+36  4.3652393e+01  4.3652393e+01 */
    { 0x2feddfea,0x3bade301,0x3bade301 }, /* 393:  4.3269149e-10  5.3066020e-03  5.3066020e-03 */
    { 0xba8e1f1f,0x3eb9bfcb,0x3eb9bfcb }, /* 394: -1.0843015e-03  3.6279139e-01  3.6279139e-01 */
    { 0x3ed5c87f,0xc3fd150d,0x3ed5c87f }, /* 395:  4.1754529e-01 -5.0616446e+02  4.1754529e-01 */
    { 0x40524679,0x39c8b3be,0x40524679 }, /* 396:  3.2855513e+00  3.8280891e-04  3.2855513e+00 */
    { 0x919fbe17,0x35e16fcf,0x35e16fcf }, /* 397: -2.5202929e-28  1.6796347e-06  1.6796347e-06 */
    { 0xa7cc58c2,0x40684c65,0x40684c65 }, /* 398: -5.6717606e-15  3.6296628e+00  3.6296628e+00 */
    { 0xc930b472,0x426c7d42,0x426c7d42 }, /* 399: -7.2378312e+05  5.9122322e+01  5.9122322e+01 */
    { 0xb5bcdbfc,0xbd49cd1c,0xb5bcdbfc }, /* 400: -1.4071115e-06 -4.9267873e-02 -1.4071115e-06 */
    { 0x3c961bca,0xca539441,0x3c961bca }, /* 401:  1.8323798e-02 -3.4665122e+06  1.8323798e-02 */
    { 0xad1b7b09,0xc32c6eee,0xad1b7b09 }, /* 402: -8.8380492e-12 -1.7243332e+02 -8.8380492e-12 */
    { 0x3b8cf4ed,0xbd659d09,0x3b8cf4ed }, /* 403:  4.3016584e-03 -5.6057964e-02  4.3016584e-03 */
    { 0x3a04fb6f,0x36fcf7be,0x3a04fb6f }, /* 404:  5.0728669e-04  7.5390262e-06  5.0728669e-04 */
    { 0xc1ca1e11,0xb832452d,0xb832452d }, /* 405: -2.5264681e+01 -4.2502932e-05 -4.2502932e-05 */
    { 0xc32a8a77,0x0e2af623,0x0e2af623 }, /* 406: -1.7054088e+02  2.1072628e-30  2.1072628e-30 */
    { 0xbb17966f,0xc38c99b7,0xbb17966f }, /* 407: -2.3130437e-03 -2.8120090e+02 -2.3130437e-03 */
    { 0xc0531f3a,0xc0267488,0xc0267488 }, /* 408: -3.2987809e+00 -2.6008625e+00 -2.6008625e+00 */
    { 0xc58e2ac1,0x43528540,0x43528540 }, /* 409: -4.5493442e+03  2.1052051e+02  2.1052051e+02 */
    { 0x403ef9a5,0x3ea2b183,0x403ef9a5 }, /* 410:  2.9839871e+00  3.1776056e-01  2.9839871e+00 */
    { 0x4212ba7a,0xceaf6d3a,0x4212ba7a }, /* 411:  3.6682106e+01 -1.4715855e+09  3.6682106e+01 */
    { 0xc1d1946f,0xbd8d8942,0xbd8d8942 }, /* 412: -2.6197477e+01 -6.9109455e-02 -6.9109455e-02 */
    { 0x4718e041,0x475f3c04,0x475f3c04 }, /* 413:  3.9136254e+04  5.7148016e+04  5.7148016e+04 */
    { 0xc6826ee8,0x2eddf417,0x2eddf417 }, /* 414: -1.6695453e+04  1.0093276e-10  1.0093276e-10 */
    { 0x3b4acdf1,0x3a5c080e,0x3b4acdf1 }, /* 415:  3.0945505e-03  8.3935342e-04  3.0945505e-03 */
    { 0x3bf10a24,0xb757a63f,0x3bf10a24 }, /* 416:  7.3559452e-03 -1.2853706e-05  7.3559452e-03 */
    { 0xbe55411c,0x3e94d66c,0x3e94d66c }, /* 417: -2.0825619e-01  2.9069841e-01  2.9069841e-01 */
    { 0x3c8749f8,0x47cc21d5,0x47cc21d5 }, /* 418:  1.6514763e-02  1.0451566e+05  1.0451566e+05 */
    { 0x427cc545,0x3bab4615,0x427cc545 }, /* 419:  6.3192646e+01  5.2268603e-03  6.3192646e+01 */
    { 0xc6c227fc,0xc2fdec9e,0xc2fdec9e }, /* 420: -2.4851992e+04 -1.2696214e+02 -1.2696214e+02 */
    { 0xbe9c544b,0x3e6b6ef9,0x3e6b6ef9 }, /* 421: -3.0533060e-01  2.2991551e-01  2.2991551e-01 */
    { 0x3175ee59,0xbefb3e86,0x3175ee59 }, /* 422:  3.5787677e-09 -4.9071139e-01  3.5787677e-09 */
    { 0xb68e99f9,0x403ad153,0x403ad153 }, /* 423: -4.2498546e-06  2.9190261e+00  2.9190261e+00 */
    { 0xbecbd270,0x43518f4b,0x43518f4b }, /* 424: -3.9808989e-01  2.0955974e+02  2.0955974e+02 */
    { 0x436ae517,0x12b4dab5,0x436ae517 }, /* 425:  2.3489488e+02  1.1413512e-27  2.3489488e+02 */
    { 0xad48dacc,0x4025a4d2,0x4025a4d2 }, /* 426: -1.1417266e-11  2.5881848e+00  2.5881848e+00 */
    { 0xba5034e8,0x5b350148,0x5b350148 }, /* 427: -7.9424540e-04  5.0948380e+16  5.0948380e+16 */
    { 0x9437733b,0x41f99329,0x41f99329 }, /* 428: -9.2618641e-27  3.1196856e+01  3.1196856e+01 */
    { 0xa1e3d629,0x4063a3e5,0x4063a3e5 }, /* 429: -1.5438806e-18  3.5568783e+00  3.5568783e+00 */
    { 0x41b09714,0xbd0a22be,0x41b09714 }, /* 430:  2.2073769e+01 -3.3724539e-02  2.2073769e+01 */
    { 0xbb82cb35,0x3c82d9c6,0x3c82d9c6 }, /* 431: -3.9915093e-03  1.5972983e-02  1.5972983e-02 */
    { 0x42ad5bc8,0x4270869a,0x42ad5bc8 }, /* 432:  8.6679260e+01  6.0131447e+01  8.6679260e+01 */
    { 0xbec88070,0xc427a3d1,0xbec88070 }, /* 433: -3.9160490e-01 -6.7055963e+02 -3.9160490e-01 */
    { 0xc0213cbe,0xc015d282,0xc015d282 }, /* 434: -2.5193324e+00 -2.3409734e+00 -2.3409734e+00 */
    { 0xbc42c81f,0x426f280b,0x426f280b }, /* 435: -1.1888533e-02  5.9789104e+01  5.9789104e+01 */
    { 0x41c6aa1b,0x4551109e,0x4551109e }, /* 436:  2.4833059e+01  3.3450386e+03  3.3450386e+03 */
    { 0x3ce109b9,0xc1c4e8d3,0x3ce109b9 }, /* 437:  2.7470456e-02 -2.4613684e+01  2.7470456e-02 */
    { 0x9c565733,0x3e8ca0e6,0x3e8ca0e6 }, /* 438: -7.0919363e-22  2.7466506e-01  2.7466506e-01 */
    { 0xc4c28d46,0x6230f480,0x6230f480 }, /* 439: -1.5564148e+03  8.1606126e+20  8.1606126e+20 */
    { 0xc1a9c1b8,0x3a58c904,0x3a58c904 }, /* 440: -2.1219589e+01  8.2696998e-04  8.2696998e-04 */
    { 0xbb99ef38,0x9d8ee0c0,0x9d8ee0c0 }, /* 441: -4.6977066e-03 -3.7819473e-21 -3.7819473e-21 */
    { 0xc44ffed6,0xbc40caa3,0xbc40caa3 }, /* 442: -8.3198181e+02 -1.1767062e-02 -1.1767062e-02 */
    { 0xc3aeb3b3,0xbeccc229,0xbeccc229 }, /* 443: -3.4940390e+02 -3.9991882e-01 -3.9991882e-01 */
    { 0x3604d6fa,0x931484d0,0x3604d6fa }, /* 444:  1.9794666e-06 -1.8745708e-27  1.9794666e-06 */
    { 0x3e766505,0xc27f31ba,0x3e766505 }, /* 445:  2.4061973e-01 -6.3798561e+01  2.4061973e-01 */
    { 0xc1fa68fe,0x434c5f12,0x434c5f12 }, /* 446: -3.1301266e+01  2.0437137e+02  2.0437137e+02 */
    { 0xb993e894,0xb896d8a8,0xb896d8a8 }, /* 447: -2.8211309e-04 -7.1929127e-05 -7.1929127e-05 */
    { 0xbc2844ba,0xc3071977,0xbc2844ba }, /* 448: -1.0270292e-02 -1.3509947e+02 -1.0270292e-02 */
    { 0xb9d44dde,0x3eb1a6b5,0x3eb1a6b5 }, /* 449: -4.0493807e-04  3.4697500e-01  3.4697500e-01 */
    { 0x49334a9e,0x46a26922,0x49334a9e }, /* 450:  7.3437788e+05  2.0788566e+04  7.3437788e+05 */
    { 0xb6b6c8f3,0x3ffbe7db,0x3ffbe7db }, /* 451: -5.4474162e-06  1.9680132e+00  1.9680132e+00 */
    { 0x6d5a209f,0x3ee1067f,0x6d5a209f }, /* 452:  4.2191980e+27  4.3950269e-01  4.2191980e+27 */
    { 0x3c18b642,0xc01ad372,0x3c18b642 }, /* 453:  9.3207974e-03 -2.4191556e+00  9.3207974e-03 */
    { 0xc1ff689b,0x4201d152,0x4201d152 }, /* 454: -3.1926077e+01  3.2454414e+01  3.2454414e+01 */
    { 0xc141e594,0xbb83c4a8,0xbb83c4a8 }, /* 455: -1.2118549e+01 -4.0212460e-03 -4.0212460e-03 */
    { 0x6f8a89f5,0xc905c888,0x6f8a89f5 }, /* 456:  8.5751422e+28 -5.4797650e+05  8.5751422e+28 */
    { 0x3e639bd7,0x4039aa68,0x4039aa68 }, /* 457:  2.2227417e-01  2.9010258e+00  2.9010258e+00 */
    { 0x3ec79188,0xac902191,0x3ec79188 }, /* 458:  3.8978219e-01 -4.0964528e-12  3.8978219e-01 */
    { 0x3d473d6e,0x38446a2e,0x3d473d6e }, /* 459:  4.8642568e-02  4.6828929e-05  4.8642568e-02 */
    { 0x45e0cd4c,0xc0551f9e,0x45e0cd4c }, /* 460:  7.1936621e+03 -3.3300548e+00  7.1936621e+03 */
    { 0xc0348c43,0x4b40a34b,0x4b40a34b }, /* 461: -2.8210609e+00  1.2624715e+07  1.2624715e+07 */
    { 0x43d9421a,0x3d484d82,0x43d9421a }, /* 462:  4.3451642e+02  4.8902042e-02  4.3451642e+02 */
    { 0x3f5d84b2,0xbc984e29,0x3f5d84b2 }, /* 463:  8.6530602e-01 -1.8591957e-02  8.6530602e-01 */
    { 0x5227fe94,0x4060e059,0x5227fe94 }, /* 464:  1.8038266e+11  3.5136931e+00  1.8038266e+11 */
    { 0xc1eb12c6,0x334cce04,0x334cce04 }, /* 465: -2.9384167e+01  4.7684821e-08  4.7684821e-08 */
    { 0xc477cd98,0x42559156,0x42559156 }, /* 466: -9.9121240e+02  5.3391930e+01  5.3391930e+01 */
    { 0xbc9a3267,0xc2e7e925,0xbc9a3267 }, /* 467: -1.8822862e-02 -1.1595536e+02 -1.8822862e-02 */
    { 0xaf585235,0x429dd9ab,0x429dd9ab }, /* 468: -1.9674291e-10  7.8925133e+01  7.8925133e+01 */
    { 0xc085535c,0xd5e1e696,0xc085535c }, /* 469: -4.1664257e+00 -3.1047559e+13 -4.1664257e+00 */
    { 0x41265a2d,0x3bfbd53d,0x41265a2d }, /* 470:  1.0397016e+01  7.6853321e-03  1.0397016e+01 */
    { 0xbeb600ad,0xc24c557a,0xbeb600ad }, /* 471: -3.5547391e-01 -5.1083473e+01 -3.5547391e-01 */
    { 0xd9a76e14,0xbb921041,0xbb921041 }, /* 472: -5.8909192e+15 -4.4575040e-03 -4.4575040e-03 */
    { 0xbb5bbd25,0x409216a7,0x409216a7 }, /* 473: -3.3529487e-03  4.5652652e+00  4.5652652e+00 */
    { 0x41b6b033,0xc21e54ba,0x41b6b033 }, /* 474:  2.2836035e+01 -3.9582741e+01  2.2836035e+01 */
    { 0xc29d4857,0x4211b05d,0x4211b05d }, /* 475: -7.8641289e+01  3.6422230e+01  3.6422230e+01 */
    { 0x4577e8a8,0xb61878b3,0x4577e8a8 }, /* 476:  3.9665410e+03 -2.2720021e-06  3.9665410e+03 */
    { 0x46dbab6b,0x40a79815,0x46dbab6b }, /* 477:  2.8117709e+04  5.2373147e+00  2.8117709e+04 */
    { 0x3832d9f6,0xbc33ad2f,0x3832d9f6 }, /* 478:  4.2641499e-05 -1.0966583e-02  4.2641499e-05 */
    { 0x4ba5eda5,0xbc86063b,0x4ba5eda5 }, /* 479:  2.1748554e+07 -1.6360393e-02  2.1748554e+07 */
    { 0xcc305d96,0xbc13c964,0xbc13c964 }, /* 480: -4.6233176e+07 -9.0201832e-03 -9.0201832e-03 */
    { 0x3f238086,0xc3cdb7f6,0x3f238086 }, /* 481:  6.3867986e-01 -4.1143719e+02  6.3867986e-01 */
    { 0xbffc7aa1,0x3f800000,0x3f800000 }, /* 482: -1.9724923e+00  1.0000000e+00  1.0000000e+00 */
    { 0xc8ae7693,0xb9f88a72,0xb9f88a72 }, /* 483: -3.5730059e+05 -4.7405396e-04 -4.7405396e-04 */
    { 0xbe89777e,0x3fe581cf,0x3fe581cf }, /* 484: -2.6848978e-01  1.7930239e+00  1.7930239e+00 */
    { 0xbe61638c,0xc1d98eee,0xbe61638c }, /* 485: -2.2010630e-01 -2.7194790e+01 -2.2010630e-01 */
    { 0x3ee700a0,0xc025150d,0x3ee700a0 }, /* 486:  4.5117664e-01 -2.5794098e+00  4.5117664e-01 */
    { 0xc202fc5a,0xb6520a55,0xb6520a55 }, /* 487: -3.2746437e+01 -3.1298453e-06 -3.1298453e-06 */
    { 0xbc6d6eff,0xb8465bb6,0xb8465bb6 }, /* 488: -1.4491796e-02 -4.7292291e-05 -4.7292291e-05 */
    { 0xa5926639,0xc4a2d664,0xa5926639 }, /* 489: -2.5396232e-16 -1.3026997e+03 -2.5396232e-16 */
    { 0xc2dc2bf4,0x416c06d3,0x416c06d3 }, /* 490: -1.1008585e+02  1.4751666e+01  1.4751666e+01 */
    { 0xbb3096e8,0x41cd5ccf,0x41cd5ccf }, /* 491: -2.6945416e-03  2.5670317e+01  2.5670317e+01 */
    { 0x3c08ea12,0xbfeae5a3,0x3c08ea12 }, /* 492:  8.3565880e-03 -1.8351330e+00  8.3565880e-03 */
    { 0x3c21ffeb,0xc87d341b,0x3c21ffeb }, /* 493:  9.8876758e-03 -2.5928042e+05  9.8876758e-03 */
    { 0xbcefd239,0xbd441336,0xbcefd239 }, /* 494: -2.9275047e-02 -4.7869883e-02 -2.9275047e-02 */
    { 0xc2069901,0x430d15e0,0x430d15e0 }, /* 495: -3.3649418e+01  1.4108545e+02  1.4108545e+02 */
    { 0x37e58841,0x3f09fb24,0x3f09fb24 }, /* 496:  2.7362375e-05  5.3898835e-01  5.3898835e-01 */
    { 0x61fcf9b9,0xc325bbc9,0x61fcf9b9 }, /* 497:  5.8332174e+20 -1.6573354e+02  5.8332174e+20 */
    { 0xbc9a6cb1,0xb0a5d8d9,0xb0a5d8d9 }, /* 498: -1.8850656e-02 -1.2066962e-09 -1.2066962e-09 */
    { 0xbc2f868c,0x609b6f76,0x609b6f76 }, /* 499: -1.0713231e-02  8.9602404e+19  8.9602404e+19 */
    { 0xc206ba8a,0x4031e3bc,0x4031e3bc }, /* 500: -3.3682167e+01  2.7795248e+00  2.7795248e+00 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x,y,z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	y.lo = pgm_read_dword (& t[i].y);
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = fmax (x.fl, y.fl);
	
	if (   v.lo == z.lo
	    || (isnan(v.fl) && isnan(z.fl))	)
	  continue;
	x_exit (i+1);
    }
    return 0;
}
