/* Test of log() function. 500 random cases.
   $Id: log-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* argument	*/
    long z;		/* log(x)	*/
} t[] = {

    /* x, log(x)	*/
    { 0x462341c0,0x4114113c }, /*   1:  1.0448438e+04  9.2542076e+00 */
    { 0x48ee277a,0x41518f83 }, /*   2:  4.8773981e+05  1.3097537e+01 */
    { 0x40cabff2,0x3fec517c }, /*   3:  6.3359308e+00  1.8462367e+00 */
    { 0x6eb68c29,0x4283058a }, /*   4:  2.8247858e+28  6.5510818e+01 */
    { 0x101b381b,0xc2834ff6 }, /*   5:  3.0611582e-29 -6.5656174e+01 */
    { 0x4101d5e8,0x4005fedb }, /*   6:  8.1147232e+00  2.0936801e+00 */
    { 0x3af6c210,0xc0c8cd91 }, /*   7:  1.8826146e-03 -6.2750936e+00 */
    { 0x3e4ecf10,0xbfccc237 }, /*   8:  2.0196176e-01 -1.5996770e+00 */
    { 0x31da4c42,0xc196fe8c }, /*   9:  6.3533045e-09 -1.8874290e+01 */
    { 0x3ead94df,0xbf8a7466 }, /*  10:  3.3902642e-01 -1.0816772e+00 */
    { 0x4423fc70,0x40cf8def }, /*  11:  6.5594434e+02  6.4860759e+00 */
    { 0x39432d5e,0xc1096cb1 }, /*  12:  1.8613550e-04 -8.5890360e+00 */
    { 0x3d5be772,0xc03b2c3b }, /*  13:  5.3687520e-02 -2.9245746e+00 */
    { 0x41218172,0x4013f703 }, /*  14:  1.0094103e+01  2.3119514e+00 */
    { 0x49144637,0x415511bc }, /*  15:  6.0733144e+05  1.3316830e+01 */
    { 0x40cb2189,0x3fec8f0a }, /*  16:  6.3478436e+00  1.8481152e+00 */
    { 0x41e1fa25,0x4055d2d1 }, /*  17:  2.8247141e+01  3.3409922e+00 */
    { 0x3f800000,0x00000000 }, /*  18:  1.0000000e+00  0.0000000e+00 */
    { 0x41591c09,0x4026e669 }, /*  19:  1.3569345e+01  2.6078131e+00 */
    { 0x174916d1,0xc25ec5d7 }, /*  20:  6.4975401e-25 -5.5693203e+01 */
    { 0x58109e9b,0x4208585c }, /*  21:  6.3604352e+14  3.4086288e+01 */
    { 0x3e19785b,0xbff2f08b }, /*  22:  1.4987318e-01 -1.8979658e+00 */
    { 0x3db4ec9e,0xc01b4c70 }, /*  23:  8.8341936e-02 -2.4265404e+00 */
    { 0x3bb62c8a,0xc0a626e0 }, /*  24:  5.5595087e-03 -5.1922455e+00 */
    { 0x2a248b83,0xc1ec6ef3 }, /*  25:  1.4614529e-13 -2.9554174e+01 */
    { 0x4509b547,0x40f653c3 }, /*  26:  2.2033298e+03  7.6977248e+00 */
    { 0x406de7a0,0x3fa80ff9 }, /*  27:  3.7172623e+00  1.3129874e+00 */
    { 0x444c143c,0x40d68dbc }, /*  28:  8.1631616e+02  6.7048016e+00 */
    { 0x3ea2b445,0xbf92bcf0 }, /*  29:  3.1778160e-01 -1.1463909e+00 */
    { 0x39e416a0,0xc0f7ae99 }, /*  30:  4.3504406e-04 -7.7400632e+00 */
    { 0x6ecf3c4a,0x4283467b }, /*  31:  3.2068141e+28  6.5637657e+01 */
    { 0x3d7d2c81,0xc03227f9 }, /*  32:  6.1810020e-02 -2.7836897e+00 */
    { 0x4067be19,0x3fa4b407 }, /*  33:  3.6209776e+00  1.2867440e+00 */
    { 0x4a50ac73,0x4170b7a2 }, /*  34:  3.4189088e+06  1.5044832e+01 */
    { 0x45357d01,0x40ff2934 }, /*  35:  2.9038127e+03  7.9737797e+00 */
    { 0x48f23354,0x4151d485 }, /*  36:  4.9602662e+05  1.3114385e+01 */
    { 0x45c51417,0x410bfd4a }, /*  37:  6.3065112e+03  8.7493382e+00 */
    { 0x4732ddf9,0x412bb589 }, /*  38:  4.5789973e+04  1.0731820e+01 */
    { 0x5016149e,0x41b84395 }, /*  39:  1.0071734e+10  2.3032999e+01 */
    { 0x47e707a5,0x413ae4da }, /*  40:  1.1828729e+05  1.1680872e+01 */
    { 0x3380fe17,0xc18505c0 }, /*  41:  6.0066832e-08 -1.6627808e+01 */
    { 0x2d47facc,0xc1c99a22 }, /*  42:  1.1367528e-11 -2.5200260e+01 */
    { 0x36c55b34,0xc140b2de }, /*  43:  5.8816750e-06 -1.2043669e+01 */
    { 0x7e5323de,0x42ae49ac }, /*  44:  7.0163335e+37  8.7143890e+01 */
    { 0x39d2456a,0xc0fa48e6 }, /*  45:  4.0106039e-04 -7.8213987e+00 */
    { 0x44eaed1c,0x40f13d23 }, /*  46:  1.8794097e+03  7.5387130e+00 */
    { 0x3af0411b,0xc0c9a861 }, /*  47:  1.8329950e-03 -6.3018041e+00 */
    { 0x468d8e4e,0x411ce027 }, /*  48:  1.8119152e+04  9.8047247e+00 */
    { 0x35b0cf95,0xc158a367 }, /*  49:  1.3173436e-06 -1.3539893e+01 */
    { 0x4fd66f5e,0x41b592d0 }, /*  50:  7.1952456e+09  2.2696686e+01 */
    { 0x39ea958b,0xc0f6c88f }, /*  51:  4.4743376e-04 -7.7119823e+00 */
    { 0x470a4c83,0x412797f0 }, /*  52:  3.5404512e+04  1.0474594e+01 */
    { 0x3b494cfb,0xc0b92344 }, /*  53:  3.0716050e-03 -5.7855549e+00 */
    { 0x2ed29bf4,0xc1b88d60 }, /*  54:  9.5773972e-11 -2.3069031e+01 */
    { 0x40fb5820,0x4003e8dc }, /*  55:  7.8545074e+00  2.0610876e+00 */
    { 0x4a9a67e4,0x4176fd1a }, /*  56:  5.0595700e+06  1.5436792e+01 */
    { 0x3f800000,0x00000000 }, /*  57:  1.0000000e+00  0.0000000e+00 */
    { 0x48eb02b9,0x41515916 }, /*  58:  4.8130178e+05  1.3084249e+01 */
    { 0x38f54051,0xc110dc65 }, /*  59:  1.1694490e-04 -9.0538073e+00 */
    { 0x4b6c7973,0x41847316 }, /*  60:  1.5497587e+07  1.6556194e+01 */
    { 0x49514a33,0x415a9573 }, /*  61:  8.5725119e+05  1.3661487e+01 */
    { 0x3d65ad1a,0xc03863e0 }, /*  62:  5.6073286e-02 -2.8810959e+00 */
    { 0x38160449,0xc123d0dc }, /*  63:  3.5766778e-05 -1.0238491e+01 */
    { 0x42916753,0x408929e9 }, /*  64:  7.2701805e+01  4.2863660e+00 */
    { 0x3f800000,0x00000000 }, /*  65:  1.0000000e+00  0.0000000e+00 */
    { 0x41512d28,0x40248488 }, /*  66:  1.3073524e+01  2.5705891e+00 */
    { 0x3b413ec8,0xc0ba71d4 }, /*  67:  2.9486883e-03 -5.8263950e+00 */
    { 0x484c2395,0x4144011e }, /*  68:  2.0903833e+05  1.2250273e+01 */
    { 0x36b12452,0xc1426d7b }, /*  69:  5.2792393e-06 -1.2151729e+01 */
    { 0x3e446b6f,0xbfd35b1f }, /*  70:  1.9181608e-01 -1.6512183e+00 */
    { 0x404accff,0x3f93a0ad }, /*  71:  3.1687620e+00  1.1533409e+00 */
    { 0x4ba7b839,0x41873f12 }, /*  72:  2.1983346e+07  1.6905796e+01 */
    { 0x49626796,0x415bd769 }, /*  73:  9.2735338e+05  1.3740090e+01 */
    { 0x41592d4a,0x4026eb7f }, /*  74:  1.3573557e+01  2.6081235e+00 */
    { 0x410dadfd,0x400b952c }, /*  75:  8.8549776e+00  2.1809797e+00 */
    { 0x40939648,0x3fc3abdc }, /*  76:  4.6120949e+00  1.5286822e+00 */
    { 0x41352a6c,0x401b5113 }, /*  77:  1.1322857e+01  2.4268234e+00 */
    { 0x3f800000,0x00000000 }, /*  78:  1.0000000e+00  0.0000000e+00 */
    { 0x39fb9556,0xc0f48b72 }, /*  79:  4.7985715e-04 -7.6420221e+00 */
    { 0x444c907c,0x40d6a132 }, /*  80:  8.1825757e+02  6.7071772e+00 */
    { 0x41345657,0x401b05fb }, /*  81:  1.1271079e+01  2.4222400e+00 */
    { 0x3e350e74,0xbfddc7e6 }, /*  82:  1.7681295e-01 -1.7326629e+00 */
    { 0x73589f59,0x428fd730 }, /*  83:  1.7162599e+31  7.1920288e+01 */
    { 0x3f800000,0x00000000 }, /*  84:  1.0000000e+00  0.0000000e+00 */
    { 0x45734693,0x410444bf }, /*  85:  3.8924109e+03  8.2667837e+00 */
    { 0x362b541f,0xc14e0d49 }, /*  86:  2.5529951e-06 -1.2878243e+01 */
    { 0x35dbf460,0xc1552515 }, /*  87:  1.6387894e-06 -1.3321553e+01 */
    { 0x6143178b,0x423b72ff }, /*  88:  2.2492572e+20  4.6862301e+01 */
    { 0x3b48fe58,0xc0b92fc7 }, /*  89:  3.0669179e-03 -5.7870822e+00 */
    { 0x388a744d,0xc11a0241 }, /*  90:  6.6020155e-05 -9.6255503e+00 */
    { 0x405a084b,0x3f9ce5b9 }, /*  91:  3.4067562e+00  1.2257606e+00 */
    { 0x4045781b,0x3f9037af }, /*  92:  3.0854557e+00  1.1266993e+00 */
    { 0x44de6e9e,0x40ef7d73 }, /*  93:  1.7794568e+03  7.4840636e+00 */
    { 0x3de3b298,0xc00c951a }, /*  94:  1.1118048e-01 -2.1966004e+00 */
    { 0x3f800000,0x00000000 }, /*  95:  1.0000000e+00  0.0000000e+00 */
    { 0x355b625d,0xc16046d9 }, /*  96:  8.1726995e-07 -1.4017297e+01 */
    { 0x537d3985,0x41ddb84b }, /*  97:  1.0875917e+12  2.7714987e+01 */
    { 0x74af532a,0x42939390 }, /*  98:  1.1112533e+32  7.3788208e+01 */
    { 0x3dd5d297,0xc0109b31 }, /*  99:  1.0440557e-01 -2.2594721e+00 */
    { 0x41147f00,0x400e970f }, /* 100:  9.2810059e+00  2.2279699e+00 */
    { 0x38d5ab9b,0xc1131106 }, /* 101:  1.0188595e-04 -9.1916561e+00 */
    { 0x3e7a55f6,0xbfb44f41 }, /* 102:  2.4446854e-01 -1.4086686e+00 */
    { 0x0f46a724,0xc285976c }, /* 103:  9.7943438e-30 -6.6795746e+01 */
    { 0x3dce684b,0xc012dd77 }, /* 104:  1.0078486e-01 -2.2947671e+00 */
    { 0x3add7219,0xc0cc4432 }, /* 105:  1.6894966e-03 -6.3833246e+00 */
    { 0x4133faa7,0x401ae569 }, /* 106:  1.1248694e+01  2.4202521e+00 */
    { 0x4085f764,0x3fb746f5 }, /* 107:  4.1864491e+00  1.4318529e+00 */
    { 0x33b1097d,0xc1827d58 }, /* 108:  8.2439307e-08 -1.6311203e+01 */
    { 0x38cdec36,0xc113a84e }, /* 109:  9.8191595e-05 -9.2285900e+00 */
    { 0x31abc217,0xc198e99a }, /* 110:  4.9988205e-09 -1.9114063e+01 */
    { 0x3dffe2c5,0xc0051ce1 }, /* 111:  1.2494425e-01 -2.0798876e+00 */
    { 0x60238f01,0x423532e7 }, /* 112:  4.7142559e+19  4.5299709e+01 */
    { 0x41a83d0b,0x4042f0b2 }, /* 113:  2.1029806e+01  3.0459409e+00 */
    { 0x3e4dd9b7,0xbfcd5a6b }, /* 114:  2.0102583e-01 -1.6043218e+00 */
    { 0x3e218755,0xbfec6398 }, /* 115:  1.5774281e-01 -1.8467894e+00 */
    { 0x40f99b04,0x40037720 }, /* 116:  7.8001728e+00  2.0541458e+00 */
    { 0x3c39319a,0xc08f71ef }, /* 117:  1.1303330e-02 -4.4826579e+00 */
    { 0x3ad7bd61,0xc0cd1a0b }, /* 118:  1.6459638e-03 -6.4094291e+00 */
    { 0x3fca2b20,0x3eea0537 }, /* 119:  1.5794411e+00  4.5707104e-01 */
    { 0x40295ce5,0x3f79210c }, /* 120:  2.6462948e+00  9.7316051e-01 */
    { 0x360173d8,0xc1528944 }, /* 121:  1.9289928e-06 -1.3158512e+01 */
    { 0x3ad43de7,0xc0cd9ff5 }, /* 122:  1.6192765e-03 -6.4257760e+00 */
    { 0x40d37690,0x3ff1b44c }, /* 123:  6.6082230e+00  1.8883147e+00 */
    { 0x3a96ab8f,0xc0d896cf }, /* 124:  1.1495220e-03 -6.7684093e+00 */
    { 0x542a9cd7,0x41e5a6b5 }, /* 125:  2.9311031e+12  2.8706400e+01 */
    { 0x3de14fa6,0xc00d41bb }, /* 126:  1.1001520e-01 -2.2071369e+00 */
    { 0x13f5cd19,0xc27160ba }, /* 127:  6.2048937e-27 -6.0344460e+01 */
    { 0x3b45e85a,0xc0b9ae87 }, /* 128:  3.0198307e-03 -5.8025546e+00 */
    { 0x211577d4,0xc22881f9 }, /* 129:  5.0641755e-19 -4.2126926e+01 */
    { 0x3dd1aed9,0xc011db80 }, /* 130:  1.0238428e-01 -2.2790222e+00 */
    { 0x1fe0630f,0xc22f3348 }, /* 131:  9.5031569e-20 -4.3800079e+01 */
    { 0x38ec0c14,0xc1117913 }, /* 132:  1.1255607e-04 -9.0920591e+00 */
    { 0x69c3b7d9,0x426a9896 }, /* 133:  2.9576091e+25  5.8649010e+01 */
    { 0x547273a4,0x41e87663 }, /* 134:  4.1652889e+12  2.9057806e+01 */
    { 0x411a8a00,0x40112497 }, /* 135:  9.6586914e+00  2.2678583e+00 */
    { 0x4af8eeae,0x417ea156 }, /* 136:  8.1570150e+06  1.5914389e+01 */
    { 0x449e15e5,0x40e48fff }, /* 137:  1.2646842e+03  7.1425776e+00 */
    { 0x1c3fafbd,0xc2433d0d }, /* 138:  6.3423735e-22 -4.8809620e+01 */
    { 0x3d79a7e4,0xc0330d3d }, /* 139:  6.0951129e-02 -2.7976830e+00 */
    { 0x3e86f6f0,0xbfaaa9f9 }, /* 140:  2.6360273e-01 -1.3333122e+00 */
    { 0x378ca63a,0xc12ff017 }, /* 141:  1.6766706e-05 -1.0996116e+01 */
    { 0x48b943ad,0x414d8ade }, /* 142:  3.7942141e+05  1.2846403e+01 */
    { 0x3b6c55a6,0xc0b400df }, /* 143:  3.6061793e-03 -5.6251063e+00 */
    { 0x2fbc73cf,0xc1ae59e5 }, /* 144:  3.4279288e-10 -2.1793894e+01 */
    { 0x2e75c3c7,0xc1bcdcca }, /* 145:  5.5880436e-11 -2.3607807e+01 */
    { 0x3003d847,0xc1aba9eb }, /* 146:  4.7964871e-10 -2.1457968e+01 */
    { 0x78120e5b,0x429cea49 }, /* 147:  1.1849477e+34  7.8457588e+01 */
    { 0x45affc19,0x410a2d9a }, /* 148:  5.6315122e+03  8.6361332e+00 */
    { 0x3f800000,0x00000000 }, /* 149:  1.0000000e+00  0.0000000e+00 */
    { 0x39bd679e,0xc0fda10e }, /* 150:  3.6126090e-04 -7.9259100e+00 */
    { 0x3b68d18f,0xc0b47ba9 }, /* 151:  3.5525297e-03 -5.6400952e+00 */
    { 0x43d8efb5,0x40c253fa }, /* 152:  4.3387271e+02  6.0727510e+00 */
    { 0x2d51a990,0xc1c9394c }, /* 153:  1.1917925e-11 -2.5152977e+01 */
    { 0x45189d5a,0x40f99dbc }, /* 154:  2.4418345e+03  7.8005047e+00 */
    { 0x3dd38d92,0xc0114a07 }, /* 155:  1.0329737e-01 -2.2701433e+00 */
    { 0x2b5f3a21,0xc1dee72b }, /* 156:  7.9306185e-13 -2.7862875e+01 */
    { 0x2ffbb151,0xc1ac0948 }, /* 157:  4.5782625e-10 -2.1504532e+01 */
    { 0x44e6524b,0x40f09af9 }, /* 158:  1.8425717e+03  7.5189176e+00 */
    { 0x6a82ba8a,0x426e86ea }, /* 159:  7.9020631e+25  5.9631752e+01 */
    { 0x40a6085b,0x3fd2bed3 }, /* 160:  5.1885200e+00  1.6464485e+00 */
    { 0x2f2f9071,0xc1b4768b }, /* 161:  1.5967473e-10 -2.2557882e+01 */
    { 0x43078fe8,0x409d1a0d }, /* 162:  1.3556213e+02  4.9094300e+00 */
    { 0x3d9822bd,0xc02663e1 }, /* 163:  7.4285008e-02 -2.5998461e+00 */
    { 0x2f3cc05c,0xc1b3e237 }, /* 164:  1.7166840e-10 -2.2485456e+01 */
    { 0x3e0c5d71,0xbffe5d69 }, /* 165:  1.3707520e-01 -1.9872257e+00 */
    { 0x4061f702,0x3fa178b7 }, /* 166:  3.5307012e+00  1.2614964e+00 */
    { 0x4bd362ce,0x418918f6 }, /* 167:  2.7706780e+07  1.7137188e+01 */
    { 0x4911475b,0x4154be23 }, /* 168:  5.9506169e+05  1.3296420e+01 */
    { 0x360d5dba,0xc15120a9 }, /* 169:  2.1065193e-06 -1.3070474e+01 */
    { 0x417eecc5,0x40312d24 }, /* 170:  1.5932805e+01  2.7683802e+00 */
    { 0x396de93f,0xc10641ba }, /* 171:  2.2688972e-04 -8.3910465e+00 */
    { 0x3eb2f957,0xbf8689ed }, /* 172:  3.4955856e-01 -1.0510842e+00 */
    { 0x3525f790,0xc164bdc6 }, /* 173:  6.1827541e-07 -1.4296331e+01 */
    { 0x44dfbc68,0x40efad54 }, /* 174:  1.7898877e+03  7.4899082e+00 */
    { 0x40d36483,0x3ff1a95f }, /* 175:  6.6060195e+00  1.8879813e+00 */
    { 0x48a560c2,0x414bb9c4 }, /* 176:  3.3869406e+05  1.2732853e+01 */
    { 0x4116cb41,0x400f92a6 }, /* 177:  9.4246225e+00  2.2433257e+00 */
    { 0x3db06371,0xc01cec6d }, /* 178:  8.6127169e-02 -2.4519303e+00 */
    { 0x369826a9,0xc144dc64 }, /* 179:  4.5344536e-06 -1.2303806e+01 */
    { 0x3d4df18b,0xc03f5eda }, /* 180:  5.0279181e-02 -2.9901643e+00 */
    { 0x43ccc8d2,0x40c07bbe }, /* 181:  4.0956891e+02  6.0151052e+00 */
    { 0x0a9d4530,0xc292890b }, /* 182:  1.5144576e-32 -7.3267662e+01 */
    { 0x3a421e7d,0xc0e6a964 }, /* 183:  7.4050558e-04 -7.2081776e+00 */
    { 0x3def9535,0xc0095379 }, /* 184:  1.1698381e-01 -2.1457198e+00 */
    { 0x3855f49a,0xc11e22b1 }, /* 185:  5.1010960e-05 -9.8834696e+00 */
    { 0x3f800000,0x00000000 }, /* 186:  1.0000000e+00  0.0000000e+00 */
    { 0x3e26d1dd,0xbfe8436e }, /* 187:  1.6290994e-01 -1.8145578e+00 */
    { 0x444ab04b,0x40d655bc }, /* 188:  8.1075458e+02  6.6979656e+00 */
    { 0x7af9248e,0x42a4ea2c }, /* 189:  6.4681167e+35  8.2457367e+01 */
    { 0x40409e4e,0x3f8d08b2 }, /* 190:  3.0096622e+00  1.1018279e+00 */
    { 0x409acb76,0x3fc9c64e }, /* 191:  4.8373365e+00  1.5763643e+00 */
    { 0x38b19394,0xc11606eb }, /* 192:  8.4675063e-05 -9.3766890e+00 */
    { 0x3f800000,0x00000000 }, /* 193:  1.0000000e+00  0.0000000e+00 */
    { 0x571563d7,0x4202ee07 }, /* 194:  1.6425604e+14  3.2732449e+01 */
    { 0x3de0d505,0xc00d6499 }, /* 195:  1.0978130e-01 -2.2092650e+00 */
    { 0x48898538,0x4148c636 }, /* 196:  2.8164175e+05  1.2548391e+01 */
    { 0x411f76d8,0x40132699 }, /* 197:  9.9665146e+00  2.2992308e+00 */
    { 0x37570744,0xc1343c77 }, /* 198:  1.2816690e-05 -1.1264762e+01 */
    { 0x6569757a,0x4252591a }, /* 199:  6.8904903e+22  5.2587013e+01 */
    { 0x47b015b5,0x41368c74 }, /* 200:  9.0155414e+04  1.1409290e+01 */
    { 0x3a83e659,0xc0dcd8c2 }, /* 201:  1.0063156e-03 -6.9014597e+00 */
    { 0x38cb8c93,0xc113d7cb }, /* 202:  9.7059783e-05 -9.2401838e+00 */
    { 0x463526f3,0x4115bb45 }, /* 203:  1.1593737e+04  9.3582201e+00 */
    { 0x3a536f57,0xc0e3ed6c }, /* 204:  8.0656022e-04 -7.1227322e+00 */
    { 0x35be062c,0xc1577c34 }, /* 205:  1.4157899e-06 -1.3467823e+01 */
    { 0x0bcc9e98,0xc28f3c83 }, /* 206:  7.8816567e-32 -7.1618187e+01 */
    { 0x3bed9d09,0xc09da667 }, /* 207:  7.2513861e-03 -4.9265628e+00 */
    { 0x45a80c4c,0x41097095 }, /* 208:  5.3775371e+03  8.5899858e+00 */
    { 0x3dbf0104,0xc017d42b }, /* 209:  9.3263656e-02 -2.3723247e+00 */
    { 0x4502376e,0x40f48986 }, /* 210:  2.0834644e+03  7.6417875e+00 */
    { 0x39300c8c,0xc10b132d }, /* 211:  1.6789342e-04 -8.6921816e+00 */
    { 0x34787d5c,0xc17476d7 }, /* 212:  2.3142405e-07 -1.5279014e+01 */
    { 0x488c7a31,0x41491d59 }, /* 213:  2.8769753e+05  1.2569665e+01 */
    { 0x3d823767,0xc03058d2 }, /* 214:  6.3582234e-02 -2.7554212e+00 */
    { 0x4ab02048,0x41791833 }, /* 215:  5.7713000e+06  1.5568408e+01 */
    { 0x467dd64d,0x411b2114 }, /* 216:  1.6245575e+04  9.6955757e+00 */
    { 0x446ac4c8,0x40db0961 }, /* 217:  9.3907471e+02  6.8448949e+00 */
    { 0x3d9c5585,0xc024a5df }, /* 218:  7.6334991e-02 -2.5726240e+00 */
    { 0x40b4b619,0x3fdd96d0 }, /* 219:  5.6472287e+00  1.7311649e+00 */
    { 0x4c0e74ef,0x418b7c4a }, /* 220:  3.7344188e+07  1.7435688e+01 */
    { 0x34f43cec,0xc169a667 }, /* 221:  4.5492868e-07 -1.4603126e+01 */
    { 0x4090e4e2,0x3fc1506e }, /* 222:  4.5279398e+00  1.5102670e+00 */
    { 0x4c9b0445,0x4191b4e6 }, /* 223:  8.1273384e+07  1.8213329e+01 */
    { 0x2348ce42,0xc21c3c80 }, /* 224:  1.0885699e-17 -3.9059082e+01 */
    { 0x38d767a7,0xc112efe8 }, /* 225:  1.0271306e-04 -9.1835709e+00 */
    { 0x495df9f3,0x415b8680 }, /* 226:  9.0921519e+05  1.3720337e+01 */
    { 0x46c2be87,0x4121fabf }, /* 227:  2.4927264e+04  1.0123717e+01 */
    { 0x3e514aa6,0xbfcb3b2c }, /* 228:  2.0438632e-01 -1.5877433e+00 */
    { 0x3529ced5,0xc1646010 }, /* 229:  6.3258386e-07 -1.4273453e+01 */
    { 0x4ed8fae0,0x41aa93d8 }, /* 230:  1.8201600e+09  2.1322189e+01 */
    { 0x3c09c87e,0xc098e87c }, /* 231:  8.4096175e-03 -4.7783794e+00 */
    { 0x41a2b274,0x4040cbf5 }, /* 232:  2.0337135e+01  3.0124485e+00 */
    { 0x33b548d8,0xc1824cca }, /* 233:  8.4417195e-08 -1.6287495e+01 */
    { 0x3f800000,0x00000000 }, /* 234:  1.0000000e+00  0.0000000e+00 */
    { 0x3a99fcc7,0xc0d7e467 }, /* 235:  1.1748307e-03 -6.7466311e+00 */
    { 0x41119446,0x400d5207 }, /* 236:  9.0986996e+00  2.2081316e+00 */
    { 0x410a318b,0x4009fcfe }, /* 237:  8.6370955e+00  2.1560664e+00 */
    { 0x47b31659,0x4136d1b5 }, /* 238:  9.1692695e+04  1.1426198e+01 */
    { 0x3eb2738c,0xbf86e9c1 }, /* 239:  3.4853780e-01 -1.0540086e+00 */
    { 0x41019f6a,0x4005e3f9 }, /* 240:  8.1014194e+00  2.0920393e+00 */
    { 0x47c27b1e,0x41382377 }, /* 241:  9.9574234e+04  1.1508658e+01 */
    { 0x34bc5d46,0xc16dce66 }, /* 242:  3.5085594e-07 -1.4862890e+01 */
    { 0x1a8bbc2c,0xc24cd219 }, /* 243:  5.7793061e-23 -5.1205173e+01 */
    { 0x4316f119,0x40a08a66 }, /* 244:  1.5094179e+02  5.0168943e+00 */
    { 0x359afb90,0xc15abf1f }, /* 245:  1.1547108e-06 -1.3671660e+01 */
    { 0x4dcfb187,0x419f2322 }, /* 246:  4.3556477e+08  1.9892155e+01 */
    { 0x34385a07,0xc1793dba }, /* 247:  1.7169087e-07 -1.5577570e+01 */
    { 0x1e670688,0xc23766c6 }, /* 248:  1.2230389e-20 -4.5850365e+01 */
    { 0x3a386505,0xc0e84e68 }, /* 249:  7.0340961e-04 -7.2595711e+00 */
    { 0x44817194,0x40de2a7f }, /* 250:  1.0355493e+03  6.9426875e+00 */
    { 0x3e732a80,0xbfb80774 }, /* 251:  2.3746681e-01 -1.4377275e+00 */
    { 0x6bf8db16,0x4276a5ae }, /* 252:  6.0169641e+26  6.1661797e+01 */
    { 0x3c04022c,0xc09a4739 }, /* 253:  8.0571584e-03 -4.8211942e+00 */
    { 0x4140e8b5,0x401f5619 }, /* 254:  1.2056813e+01  2.4896300e+00 */
    { 0x45cb00af,0x410c769a }, /* 255:  6.4960854e+03  8.7789555e+00 */
    { 0x40ab9beb,0x3fd6f94d }, /* 256:  5.3627830e+00  1.6794831e+00 */
    { 0x45c0faa5,0x410ba730 }, /* 257:  6.1753306e+03  8.7283173e+00 */
    { 0x30244232,0xc1a9e7bc }, /* 258:  5.9756922e-10 -2.1238152e+01 */
    { 0x1443dcf6,0xc26f8380 }, /* 259:  9.8885610e-27 -5.9878418e+01 */
    { 0x3553639e,0xc160dee8 }, /* 260:  7.8748587e-07 -1.4054420e+01 */
    { 0x4faba390,0x41b3cae7 }, /* 261:  5.7592463e+09  2.2474073e+01 */
    { 0x3f800000,0x00000000 }, /* 262:  1.0000000e+00  0.0000000e+00 */
    { 0x43abad85,0x40bad72d }, /* 263:  3.4335562e+02  5.8387666e+00 */
    { 0x32804e6c,0xc19027ce }, /* 264:  1.4936823e-08 -1.8019436e+01 */
    { 0x3dc19daf,0xc016f5a3 }, /* 265:  9.4539039e-02 -2.3587425e+00 */
    { 0x49adadb7,0x4162b09e }, /* 266:  1.4227749e+06  1.4168119e+01 */
    { 0x3d32c57e,0xc0486d16 }, /* 267:  4.3645374e-02 -3.1316581e+00 */
    { 0x3de70740,0xc00ba72d }, /* 268:  1.1280680e-01 -2.1820786e+00 */
    { 0x3d5cdf4b,0xc03ae442 }, /* 269:  5.3923886e-02 -2.9201818e+00 */
    { 0x3dc72e19,0xc015256f }, /* 270:  9.7255893e-02 -2.3304098e+00 */
    { 0x3da648c3,0xc020b2ec }, /* 271:  8.1193469e-02 -2.5109205e+00 */
    { 0x4045cf8c,0x3f907051 }, /* 272:  3.0907927e+00  1.1284276e+00 */
    { 0x42803015,0x40852195 }, /* 273:  6.4093910e+01  4.1603494e+00 */
    { 0x3711a616,0xc13a7827 }, /* 274:  8.6813434e-06 -1.1654334e+01 */
    { 0x49cf0628,0x41657ffe }, /* 275:  1.6959410e+06  1.4343748e+01 */
    { 0x39644f32,0xc106ea77 }, /* 276:  2.1773277e-04 -8.4322424e+00 */
    { 0x3f800000,0x00000000 }, /* 277:  1.0000000e+00  0.0000000e+00 */
    { 0x60eb307f,0x42396c9f }, /* 278:  1.3557748e+20  4.6356075e+01 */
    { 0x396aba39,0xc10678e9 }, /* 279:  2.2385352e-04 -8.4045191e+00 */
    { 0x46bf66f4,0x4121b3d8 }, /* 280:  2.4499477e+04  1.0106407e+01 */
    { 0x41ef8981,0x40598d97 }, /* 281:  2.9942141e+01  3.3992670e+00 */
    { 0x4008baf6,0x3f42562c }, /* 282:  2.1364112e+00  7.5912738e-01 */
    { 0x44dc2880,0x40ef2945 }, /* 283:  1.7612656e+03  7.4737878e+00 */
    { 0x49476bba,0x4159cf99 }, /* 284:  8.1682762e+05  1.3613183e+01 */
    { 0x4721294f,0x412a0a95 }, /* 285:  4.1257309e+04  1.0627584e+01 */
    { 0x3b005a47,0xc0c789d1 }, /* 286:  1.9585059e-03 -6.2355733e+00 */
    { 0x45ab27f7,0x4109bba5 }, /* 287:  5.4769956e+03  8.6083117e+00 */
    { 0x39131a5a,0xc10df2f0 }, /* 288:  1.4028829e-04 -8.8718109e+00 */
    { 0x4819eae9,0x413f7c7a }, /* 289:  1.5761164e+05  1.1967890e+01 */
    { 0x3de77c4b,0xc00b86c9 }, /* 290:  1.1303004e-01 -2.1801016e+00 */
    { 0x4153161f,0x40251975 }, /* 291:  1.3192901e+01  2.5796788e+00 */
    { 0x34c63711,0xc16cfd9b }, /* 292:  3.6920440e-07 -1.4811915e+01 */
    { 0x3692c415,0xc1456ffc }, /* 293:  4.3739660e-06 -1.2339840e+01 */
    { 0x40e719b6,0x3ffd1227 }, /* 294:  7.2218885e+00  1.9771165e+00 */
    { 0x62368ea9,0x4240ba90 }, /* 295:  8.4189679e+20  4.8182190e+01 */
    { 0x4a37fc21,0x416eb3df }, /* 296:  3.0144082e+06  1.4918914e+01 */
    { 0x6abac6a3,0x426ff443 }, /* 297:  1.1289912e+26  5.9988537e+01 */
    { 0x40c026a9,0x3fe57223 }, /* 298:  6.0047193e+00  1.7925457e+00 */
    { 0x409821fc,0x3fc78de4 }, /* 299:  4.7541485e+00  1.5590177e+00 */
    { 0x38848342,0xc11ab5e9 }, /* 300:  6.3186992e-05 -9.6694117e+00 */
    { 0x3b713d69,0xc0b35895 }, /* 301:  3.6810285e-03 -5.6045632e+00 */
    { 0x39ace78e,0xc10045de }, /* 302:  3.2978918e-04 -8.0170574e+00 */
    { 0x39dbc2bf,0xc0f8df4a }, /* 303:  4.1916032e-04 -7.7772570e+00 */
    { 0x456fb027,0x410407e5 }, /* 304:  3.8350095e+03  8.2519274e+00 */
    { 0x3b488ae1,0xc0b9422e }, /* 305:  3.0600356e-03 -5.7893286e+00 */
    { 0x4b0dd6c6,0x41805c42 }, /* 306:  9.2955580e+06  1.6045048e+01 */
    { 0x2bbfe8df,0xc1da9130 }, /* 307:  1.3636001e-12 -2.7320892e+01 */
    { 0x49af63b1,0x4162d8c5 }, /* 308:  1.4367901e+06  1.4177922e+01 */
    { 0x3d4787b1,0xc0416531 }, /* 309:  4.8713390e-02 -3.0218012e+00 */
    { 0x4364ed84,0x40adde78 }, /* 310:  2.2892780e+02  5.4334068e+00 */
    { 0x412e0d7a,0x4018c0d3 }, /* 311:  1.0878290e+01  2.3867691e+00 */
    { 0x4072c6d9,0x3faaa83d }, /* 312:  3.7933867e+00  1.3332592e+00 */
    { 0x40fd5aa9,0x40046b5b }, /* 313:  7.9173169e+00  2.0690525e+00 */
    { 0x396f5a82,0xc10628f8 }, /* 314:  2.2826533e-04 -8.3850021e+00 */
    { 0x3d4ac6ac,0xc0405ccc }, /* 315:  4.9505875e-02 -3.0056639e+00 */
    { 0x40c87ee7,0x3feae325 }, /* 316:  6.2654910e+00  1.8350569e+00 */
    { 0x331f05c3,0xc188e4b0 }, /* 317:  3.7025313e-08 -1.7111664e+01 */
    { 0x464cd210,0x4117b23f }, /* 318:  1.3108516e+04  9.4810171e+00 */
    { 0x3ddf9926,0xc00dbec3 }, /* 319:  1.0917883e-01 -2.2147682e+00 */
    { 0x3dd88d23,0xc00fcb6e }, /* 320:  1.0573795e-01 -2.2467914e+00 */
    { 0x40d27910,0x3ff11a7e }, /* 321:  6.5772781e+00  1.8836210e+00 */
    { 0x0bab27c3,0xc28f97f2 }, /* 322:  6.5926631e-32 -7.1796768e+01 */
    { 0x3dcfaae9,0xc01279bc }, /* 323:  1.0140020e-01 -2.2886801e+00 */
    { 0x459f6454,0x410897f8 }, /* 324:  5.1005410e+03  8.5371017e+00 */
    { 0x42d8aadf,0x4095ed4b }, /* 325:  1.0833373e+02  4.6852164e+00 */
    { 0x5eba88a9,0x422d6826 }, /* 326:  6.7205895e+18  4.3351707e+01 */
    { 0x40a52a29,0x3fd21314 }, /* 327:  5.1613965e+00  1.6412072e+00 */
    { 0x3dd99ddf,0xc00f7b06 }, /* 328:  1.0625815e-01 -2.2418838e+00 */
    { 0x5ac29611,0x4217652a }, /* 329:  2.7385573e+16  3.7848793e+01 */
    { 0x2a10de63,0xc1ed73c7 }, /* 330:  1.2866925e-13 -2.9681532e+01 */
    { 0x3db61a6b,0xc01ae206 }, /* 331:  8.8917576e-02 -2.4200454e+00 */
    { 0x3de00b94,0xc00d9e0a }, /* 332:  1.0939708e-01 -2.2127709e+00 */
    { 0x4158cbf7,0x4026ceca }, /* 333:  1.3549796e+01  2.6063714e+00 */
    { 0x3d41323a,0xc04375b8 }, /* 334:  4.7167040e-02 -3.0540600e+00 */
    { 0x48f2695d,0x4151d817 }, /* 335:  4.9645891e+05  1.3115256e+01 */
    { 0x52652d17,0x41d1d4cd }, /* 336:  2.4607600e+11  2.6228907e+01 */
    { 0x3dc4fa03,0xc015dbb1 }, /* 337:  9.6179985e-02 -2.3415339e+00 */
    { 0x43915257,0x40b581d1 }, /* 338:  2.9064328e+02  5.6720967e+00 */
    { 0x44b5ddb2,0x40e90bf9 }, /* 339:  1.4549280e+03  7.2827115e+00 */
    { 0x38f68800,0xc110c713 }, /* 340:  1.1755526e-04 -9.0486021e+00 */
    { 0x24c3f499,0xc2140430 }, /* 341:  8.4982134e-17 -3.7004089e+01 */
    { 0x3bc6b819,0xc0a35ebe }, /* 342:  6.0644266e-03 -5.1053152e+00 */
    { 0x712b59a9,0x4289d396 }, /* 343:  8.4848527e+29  6.8913254e+01 */
    { 0x3edaf8e1,0xbf5970f6 }, /* 344:  4.2768005e-01 -8.4937990e-01 */
    { 0x40ecd3dd,0x40001a28 }, /* 345:  7.4008622e+00  2.0015965e+00 */
    { 0x4113bc80,0x400e4304 }, /* 346:  9.2335205e+00  2.2228403e+00 */
    { 0x445767a9,0x40d84834 }, /* 347:  8.6161969e+02  6.7588139e+00 */
    { 0x44e98413,0x40f10bd0 }, /* 348:  1.8681273e+03  7.5326920e+00 */
    { 0x40d09290,0x3feff148 }, /* 349:  6.5178909e+00  1.8745508e+00 */
    { 0x475afe8c,0x412ef294 }, /* 350:  5.6062547e+04  1.0934223e+01 */
    { 0x334abd91,0xc186f344 }, /* 351:  4.7204200e-08 -1.6868782e+01 */
    { 0x3eeee60c,0xbf432522 }, /* 352:  4.6659887e-01 -7.6228535e-01 */
    { 0x474e6d4e,0x412e0082 }, /* 353:  5.2845305e+04  1.0875124e+01 */
    { 0x3dab6f37,0xc01ebf2c }, /* 354:  8.3708219e-02 -2.4804182e+00 */
    { 0x39df341e,0xc0f85ff2 }, /* 355:  4.2572705e-04 -7.7617121e+00 */
    { 0x216ca45a,0xc226ab7b }, /* 356:  8.0177428e-19 -4.1667461e+01 */
    { 0x43e6f657,0x40c45536 }, /* 357:  4.6192453e+02  6.1354017e+00 */
    { 0x3682f809,0xc1474270 }, /* 358:  3.9031770e-06 -1.2453720e+01 */
    { 0x3593e9a6,0xc15b7e5e }, /* 359:  1.1020354e-06 -1.3718351e+01 */
    { 0x418dd1f9,0x403801f1 }, /* 360:  1.7727526e+01  2.8751185e+00 */
    { 0x3a97e714,0xc0d85411 }, /* 361:  1.1589252e-03 -6.7602620e+00 */
    { 0x57fc9b09,0x4207cdaf }, /* 362:  5.5548560e+14  3.3950863e+01 */
    { 0x36c6a602,0xc1409823 }, /* 363:  5.9201857e-06 -1.2037143e+01 */
    { 0x43cc5832,0x40c06a20 }, /* 364:  4.0868903e+02  6.0129547e+00 */
    { 0x600cb873,0x423498e5 }, /* 365:  4.0559924e+19  4.5149311e+01 */
    { 0x48ce4e17,0x414f437b }, /* 366:  4.2251272e+05  1.2953975e+01 */
    { 0x333ca0a9,0xc1878709 }, /* 367:  4.3918281e-08 -1.6940935e+01 */
    { 0x379d3940,0xc12e27cc }, /* 368:  1.8742518e-05 -1.0884716e+01 */
    { 0x48e2b3ed,0x4150c5ab }, /* 369:  4.6428741e+05  1.3048259e+01 */
    { 0x48001811,0x413c8c3b }, /* 370:  1.3116827e+05  1.1784236e+01 */
    { 0x3da42be9,0xc021846b }, /* 371:  8.0161877e-02 -2.5237072e+00 */
    { 0x3957c9ce,0xc107d17e }, /* 372:  2.0579176e-04 -8.4886456e+00 */
    { 0x39f48509,0xc0f574be }, /* 373:  4.6638426e-04 -7.6705008e+00 */
    { 0x5089f81b,0x41bd22d3 }, /* 374:  1.8517907e+10  2.3642004e+01 */
    { 0x349c037f,0xc170d23a }, /* 375:  2.9059808e-07 -1.5051325e+01 */
    { 0x37944295,0xc12f183d }, /* 376:  1.7673980e-05 -1.0943418e+01 */
    { 0x41b5e0c3,0x4047ede3 }, /* 377:  2.2734747e+01  3.1238945e+00 */
    { 0x414bad9e,0x4022d01e }, /* 378:  1.2729887e+01  2.5439525e+00 */
    { 0x3a042066,0xc0f2f8f2 }, /* 379:  5.0402281e-04 -7.5928888e+00 */
    { 0x5431e5d8,0x41e5fc57 }, /* 380:  3.0562614e+12  2.8748213e+01 */
    { 0x355dac17,0xc1601c59 }, /* 381:  8.2579339e-07 -1.4006921e+01 */
    { 0x3e54a4a7,0xbfc93296 }, /* 382:  2.0765935e-01 -1.5718563e+00 */
    { 0x41140d54,0x400e65ff }, /* 383:  9.2532539e+00  2.2249753e+00 */
    { 0x41826cda,0x4032a59d }, /* 384:  1.6303150e+01  2.7913582e+00 */
    { 0x464ecfb1,0x4117d9de }, /* 385:  1.3235923e+04  9.4906902e+00 */
    { 0x44a55326,0x40e5fecd }, /* 386:  1.3225984e+03  7.1873536e+00 */
    { 0x23205f35,0xc21d22bd }, /* 387:  8.6937783e-18 -3.9283924e+01 */
    { 0x47b6efcc,0x413728d1 }, /* 388:  9.3663594e+04  1.1447465e+01 */
    { 0x47b2b187,0x4136c8b1 }, /* 389:  9.1491055e+04  1.1423997e+01 */
    { 0x415dba38,0x40283f3e }, /* 390:  1.3857964e+01  2.6288600e+00 */
    { 0x3af9b6b3,0xc0c86c07 }, /* 391:  1.9051641e-03 -6.2631869e+00 */
    { 0x576850ea,0x4204b229 }, /* 392:  2.5543422e+14  3.3173985e+01 */
    { 0x3dec2e54,0xc00a3dc7 }, /* 393:  1.1532274e-01 -2.1600206e+00 */
    { 0x3dd09a96,0xc012300a }, /* 394:  1.0185735e-01 -2.2841821e+00 */
    { 0x55b6a016,0x41f6d4c0 }, /* 395:  2.5099835e+13  3.0853882e+01 */
    { 0x0df9b52e,0xc2894afc }, /* 396:  1.5389427e-30 -6.8646454e+01 */
    { 0x1fc295c3,0xc22fc534 }, /* 397:  8.2409956e-20 -4.3942581e+01 */
    { 0x3e10443e,0xbffadb06 }, /* 398:  1.4088532e-01 -1.9598091e+00 */
    { 0x4193f904,0x403ab9bc }, /* 399:  1.8496590e+01  2.9175863e+00 */
    { 0x3a771445,0xc0def12d }, /* 400:  9.4253226e-04 -6.9669404e+00 */
    { 0x2d822e6c,0xc1c77dbf }, /* 401:  1.4799904e-11 -2.4936399e+01 */
    { 0x5540353b,0x41f1b1ec }, /* 402:  1.3208428e+13  3.0211876e+01 */
    { 0x327e62e3,0xc19039a7 }, /* 403:  1.4807230e-08 -1.8028151e+01 */
    { 0x52c4eead,0x41d629d3 }, /* 404:  4.2290895e+11  2.6770422e+01 */
    { 0x412d4dc6,0x40187a2f }, /* 405:  1.0831488e+01  2.3824575e+00 */
    { 0x38ab92d4,0xc11693c7 }, /* 406:  8.1812643e-05 -9.4110785e+00 */
    { 0x3d678572,0xc037e0c7 }, /* 407:  5.6523748e-02 -2.8730943e+00 */
    { 0x4c7d2c3e,0x419015f5 }, /* 408:  6.6367736e+07  1.8010721e+01 */
    { 0x2f9c1407,0xc1afdbeb }, /* 409:  2.8390465e-10 -2.1982382e+01 */
    { 0x45ce2fc6,0x410cb658 }, /* 410:  6.5979717e+03  8.7945175e+00 */
    { 0x05c545e9,0xc29ff1ed }, /* 411:  1.8551472e-35 -7.9972511e+01 */
    { 0x3f800000,0x00000000 }, /* 412:  1.0000000e+00  0.0000000e+00 */
    { 0x3e7edc4e,0xbfb20444 }, /* 413:  2.4888727e-01 -1.3907552e+00 */
    { 0x2e652d46,0xc1bd6be7 }, /* 414:  5.2108783e-11 -2.3677687e+01 */
    { 0x2e87a3ec,0xc1bc127d }, /* 415:  6.1682076e-11 -2.3509027e+01 */
    { 0x388f407a,0xc11976ba }, /* 416:  6.8307811e-05 -9.5914860e+00 */
    { 0x4385388e,0x40b2b999 }, /* 417:  2.6644183e+02  5.5851560e+00 */
    { 0x3268866a,0xc190f1ad }, /* 418:  1.3534740e-08 -1.8118006e+01 */
    { 0x3a687859,0xc0e0e475 }, /* 419:  8.8680309e-04 -7.0278878e+00 */
    { 0x38522fe0,0xc11e6b7b }, /* 420:  5.0112489e-05 -9.9012403e+00 */
    { 0x23f9f9d4,0xc218966f }, /* 421:  2.7102440e-17 -3.8146908e+01 */
    { 0x2886d219,0xc1fea9b0 }, /* 422:  1.4968104e-14 -3.1832855e+01 */
    { 0x39bab525,0xc0fe168d }, /* 423:  3.5611648e-04 -7.9402528e+00 */
    { 0x40f5efa2,0x4002847a }, /* 424:  7.6855021e+00  2.0393357e+00 */
    { 0x45d1046d,0x410cee32 }, /* 425:  6.6885532e+03  8.8081532e+00 */
    { 0x414d27c8,0x40234684 }, /* 426:  1.2822212e+01  2.5511789e+00 */
    { 0x3f800000,0x00000000 }, /* 427:  1.0000000e+00  0.0000000e+00 */
    { 0x40d393ef,0x3ff1c613 }, /* 428:  6.6118083e+00  1.8888572e+00 */
    { 0x4514917f,0x40f8c19c }, /* 429:  2.3770935e+03  7.7736340e+00 */
    { 0x2a494b4c,0xc1ead21c }, /* 430:  1.7878510e-13 -2.9352592e+01 */
    { 0x3f800000,0x00000000 }, /* 431:  1.0000000e+00  0.0000000e+00 */
    { 0x2da8ad70,0xc1c56b31 }, /* 432:  1.9176410e-11 -2.4677340e+01 */
    { 0x3e050eb6,0xc0029aad }, /* 433:  1.2993893e-01 -2.0406907e+00 */
    { 0x362d6243,0xc14ddc71 }, /* 434:  2.5836205e-06 -1.2866319e+01 */
    { 0x40d0eca9,0x3ff02887 }, /* 435:  6.5288892e+00  1.8762368e+00 */
    { 0x46454b9e,0x411718ed }, /* 436:  1.2626904e+04  9.4435854e+00 */
    { 0x3a418f5b,0xc0e6c105 }, /* 437:  7.3837274e-04 -7.2110620e+00 */
    { 0x3802988a,0xc12608ba }, /* 438:  3.1136478e-05 -1.0377131e+01 */
    { 0x4f95ad30,0x41b2b27f }, /* 439:  5.0223104e+09  2.2337156e+01 */
    { 0x3da34d1a,0xc021db82 }, /* 440:  7.9736903e-02 -2.5290227e+00 */
    { 0x45214bad,0x40fb62f0 }, /* 441:  2.5807297e+03  7.8558273e+00 */
    { 0x4654d5d4,0x41184f78 }, /* 442:  1.3621457e+04  9.5194016e+00 */
    { 0x3a7b0cd2,0xc0de6e91 }, /* 443:  9.5768005e-04 -6.9509969e+00 */
    { 0x3dc8ac9f,0xc014aafb }, /* 444:  9.7985499e-02 -2.3229358e+00 */
    { 0x3a2aa667,0xc0eac8fd }, /* 445:  6.5097812e-04 -7.3370347e+00 */
    { 0x532c6226,0x41daa4b9 }, /* 446:  7.4038103e+11  2.7330431e+01 */
    { 0x3e840365,0xbfad7e7a }, /* 447:  2.5783840e-01 -1.3554223e+00 */
    { 0x4375e6e1,0x40b02868 }, /* 448:  2.4590187e+02  5.5049324e+00 */
    { 0x460d0cdd,0x4111ba5d }, /* 449:  9.0272158e+03  9.1079988e+00 */
    { 0x469c3aee,0x411e742a }, /* 450:  1.9997465e+04  9.9033604e+00 */
    { 0x3915c305,0xc10da991 }, /* 451:  1.4282398e-04 -8.8538980e+00 */
    { 0x448e18b7,0x40e1267d }, /* 452:  1.1367723e+03  7.0359483e+00 */
    { 0x43ad355a,0x40bb1fe4 }, /* 453:  3.4641681e+02  5.8476429e+00 */
    { 0x47a2b866,0x41354925 }, /* 454:  8.3312797e+04  1.1330358e+01 */
    { 0x44cc5b71,0x40ecc728 }, /* 455:  1.6348575e+03  7.3993111e+00 */
    { 0x30c316d1,0xc1a2fbe2 }, /* 456:  1.4194602e-09 -2.0372990e+01 */
    { 0x3e3371a1,0xbfdeed0e }, /* 457:  1.7523815e-01 -1.7416093e+00 */
    { 0x2fce400a,0xc1ada113 }, /* 458:  3.7516684e-10 -2.1703650e+01 */
    { 0x469a2896,0x411e3d7d }, /* 459:  1.9732293e+04  9.8900118e+00 */
    { 0x3e7081ca,0xbfb96fbe }, /* 460:  2.3487011e-01 -1.4487226e+00 */
    { 0x43c83086,0x40bfc1d6 }, /* 461:  4.0037909e+02  5.9924116e+00 */
    { 0x3db8c93d,0xc019f267 }, /* 462:  9.0227582e-02 -2.4054201e+00 */
    { 0x4344b4d7,0x40a903c9 }, /* 463:  1.9670641e+02  5.2817121e+00 */
    { 0x3de4f044,0xc00c3c0e }, /* 464:  1.1178640e-01 -2.1911654e+00 */
    { 0x39a73504,0xc100cf1b }, /* 465:  3.1892222e-04 -8.0505629e+00 */
    { 0x3de2a918,0xc00cdfe6 }, /* 466:  1.1067408e-01 -2.2011657e+00 */
    { 0x33b1d34e,0xc182743f }, /* 467:  8.2806409e-08 -1.6306761e+01 */
    { 0x3a7b9b6b,0xc0de5c69 }, /* 468:  9.5980492e-04 -6.9487805e+00 */
    { 0x3a02a697,0xc0f354f7 }, /* 469:  4.9839303e-04 -7.6041217e+00 */
    { 0x3024d832,0xc1a9e071 }, /* 470:  5.9970084e-10 -2.1234591e+01 */
    { 0x5dfdadac,0x4229176b }, /* 471:  2.2849319e+18  4.2272869e+01 */
    { 0x43525054,0x40ab27bc }, /* 472:  2.1031378e+02  5.3486004e+00 */
    { 0x406600ef,0x3fa3bd39 }, /* 473:  3.5938070e+00  1.2792121e+00 */
    { 0x2d539775,0xc1c9268a }, /* 474:  1.2027592e-11 -2.5143818e+01 */
    { 0x3ac65f6a,0xc0cfc98f }, /* 475:  1.5134637e-03 -6.4933543e+00 */
    { 0x31450e8e,0xc19d5bc3 }, /* 476:  2.8675546e-09 -1.9669806e+01 */
    { 0x3de61508,0xc00bea6a }, /* 477:  1.1234480e-01 -2.1861825e+00 */
    { 0x43fef70b,0x40c77f2b }, /* 478:  5.0993002e+02  6.2342734e+00 */
    { 0x411ec45a,0x4012dece }, /* 479:  9.9229374e+00  2.2948489e+00 */
    { 0x540e78c1,0x41e4358d }, /* 480:  2.4476451e+12  2.8526148e+01 */
    { 0x40e1ae49,0x3ffa088b }, /* 481:  7.0525250e+00  1.9533857e+00 */
    { 0x45608c33,0x4102fca1 }, /* 482:  3.5927625e+03  8.1866770e+00 */
    { 0x3efb1a03,0xbf36643c }, /* 483:  4.9043283e-01 -7.1246696e-01 */
    { 0x398073b0,0xc1050722 }, /* 484:  2.4500256e-04 -8.3142414e+00 */
    { 0x3da6cf9b,0xc0207f1b }, /* 485:  8.1450664e-02 -2.5077579e+00 */
    { 0x3e0e0811,0xbffcdaa8 }, /* 486:  1.3870265e-01 -1.9754229e+00 */
    { 0x40a38852,0x3fd0cda6 }, /* 487:  5.1103907e+00  1.6312759e+00 */
    { 0x56cfc818,0x42017a17 }, /* 488:  1.1422915e+14  3.2369228e+01 */
    { 0x2e9fccee,0xc1bac2c8 }, /* 489:  7.2668857e-11 -2.3345108e+01 */
    { 0x31a9a95c,0xc19902c2 }, /* 490:  4.9378013e-09 -1.9126347e+01 */
    { 0x3a1a8105,0xc0edf73b }, /* 491:  5.8938592e-04 -7.4364295e+00 */
    { 0x3da8a0dc,0xc01fcd91 }, /* 492:  8.2338065e-02 -2.4969218e+00 */
    { 0x3de261f9,0xc00cf3fe }, /* 493:  1.1053843e-01 -2.2023921e+00 */
    { 0x417021ca,0x402d59b4 }, /* 494:  1.5008249e+01  2.7086000e+00 */
    { 0x41fd6bc1,0x405d28b8 }, /* 495:  3.1677614e+01  3.4556103e+00 */
    { 0x2e819aba,0xc1bc6fb7 }, /* 496:  5.8937258e-11 -2.3554548e+01 */
    { 0x3ad3a3f3,0xc0cdb733 }, /* 497:  1.6146883e-03 -6.4286132e+00 */
    { 0x39c121fd,0xc0fd0162 }, /* 498:  3.6837152e-04 -7.9064188e+00 */
    { 0x4677501b,0x411ab66d }, /* 499:  1.5828026e+04  9.6695375e+00 */
    { 0x0d3b30cf,0xc28b416b }, /* 500:  5.7682575e-31 -6.9627769e+01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = log (x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 1) x_exit (i+1);
    }
    return 0;
}
