/* Test for subnormal numbers.
   $Id: dtostre-subnrm.c,v 1.1 2007/02/06 12:36:58 dmix Exp $
 */
#include <stdlib.h>
#include <string.h>
#include "progmem.h"
#include "dtostre.h"

PROGMEM static const struct dtostre_s t[] = {

    { { 0x007fffff }, 7, 0,	"1.1754942e-38" },

    { { 0x00000001 }, 0, 0,	"1e-45" },
    { { 0x00000001 }, 1, 0,	"1.4e-45" },
    { { 0x00000001 }, 2, 0,	"1.40e-45" },
    { { 0x00000001 }, 3, 0,	"1.401e-45" },
    { { 0x00000001 }, 4, 0,	"1.4013e-45" },
    { { 0x00000001 }, 5, 0,	"1.40130e-45" },
/*    { { 0x00000001 }, 6, 0,	"1.401298e-45" },	*/
/*    { { 0x00000001 }, 7, 0,	"1.4012985e-45" },	*/

    { { 0x00000002 }, 0, 0,	"3e-45" },
    { { 0x00000002 }, 1, 0,	"2.8e-45" },
    { { 0x00000002 }, 2, 0,	"2.80e-45" },
    { { 0x00000002 }, 3, 0,	"2.803e-45" },
    { { 0x00000002 }, 4, 0,	"2.8026e-45" },
    { { 0x00000002 }, 5, 0,	"2.80260e-45" },
/*    { { 0x00000002 }, 6, 0,	"2.802597e-45" },	*/
/*    { { 0x00000002 }, 7, 0,	"2.8025969e-45" },	*/
};

int main ()
{
    int i;
    for (i= 0; (size_t)i != sizeof(t)/sizeof(t[0]); i++)
	run_dtostre (t+i, i+1);
    return 0;
}
