# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::self::completion::tcsh;
use base 'AXP::Command::self::completion';

sub collect_args {
	my $command = shift;
	my $name = $command->{name};

	my %options = $command->all_options;
	my @options = map { $command->long_option($_) } sort keys %options;

	my $string;
	if ($command->has_subcommands) {
		my @names = $command->all_subcommand_names;
		my $pref = defined $name? "n/$name": 'p/1';
		$string = " '$pref/(" . join(' ', @names, @options) . ")/'";
		foreach my $subcommand ($command->all_subcommands) {
			my ($substring, $suboptions) = collect_args($subcommand);
			$string .= $substring;
			push @options, @$suboptions;
		}
	} else {
		$string = "";
	}
	# support "tree" subcommands on the first level too
	if (!defined $name && $string =~ m!n/tree/\(help ([^\)]+)!) {
		my $tree_names = $1;
		$tree_names =~ s/ --.*//;
		$string =~ s!(p/1/\([^\)]+)!$1 $tree_names!;
	}
	return ($string, \@options);
}

sub execute {
	my $self = shift;
	my ($string, $global_options) = collect_args($self->{root});

	my %global_options = map { $_ => 1 } @$global_options;
	my @options = sort keys %global_options;
	$string .= " 'C/-/(" . join(' ', @options) . ")/'" if @options;
	$self->write("complete axp $string 'n/*/f/'\n");
}

1;
