/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

import nz.net.catalyst.Log;

/**
 * Hardcoded Socket Client for the LuceneServer.  This will create the
 * reader and writer from the socket and then call the communicate method on
 * the Session object.
 * 
 * @see nz.net.catalyst.lucene.server.Session
 */

public class SocketClient implements Runnable {
	Socket clientSocket; 

  private static String encoding = null;

  public SocketClient(Socket clientSocket) {
    this.clientSocket = clientSocket;
  }

	public void run() {
  	    String name = Util.name(clientSocket);
	    BufferedReader input   = null;
	    PrintWriter    output  = null;

		//get encoding property.
		if (encoding == null) {
		  encoding = System.getProperty("nz.net.catalyst.SocketEncoding");
		  Log.debug("socket Encoding set to: " + encoding);
		  //last resort.
		  if (encoding == null) {
			  encoding = "US-ASCII";
			  Log.debug("no encoding specified using internal default: US-ASCII");
		  }
		}

		try {
		  //get the input
		  input = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), encoding));
		  output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(clientSocket.getOutputStream()), encoding)));
		
		  new nz.net.catalyst.lucene.server.Session().communicate(input, output, name);
		
		} catch (IOException e) {
		  throw new RtException("Error initialising new client connection " + name, e);
		} finally {
		  try {
		    //hint to the garbage collector (this probably isn't needed however).
	        input.close();
	        output.close();
	        clientSocket.close();
    	    input = null;
	        output=null;
	        clientSocket = null;
		  } catch (IOException e) {
			Log.error("IOException during closure of client socket connection " + name);
			Log.error(e.toString());
			//throw new RtException("Error finalizing client connection " + name, e);
		  }
	    }
	}

}