#include <bakery/App/Dialog_OfferSave.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include <libintl.h>

namespace Bakery
{


Dialog_OfferSave::Dialog_OfferSave(const Glib::ustring& filepath)
: Gtk::MessageDialog(gettext("This document has unsaved changes. Would you like to save it?\n\nDocument:\n") + filepath, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_NONE)
{
  set_title(gettext("Save Changes?"));

  add_button(gettext("Discard"), BUTTON_Discard);
  add_button(Gtk::Stock::CANCEL, BUTTON_Cancel);
  add_button(Gtk::Stock::SAVE, BUTTON_Save);
}

Dialog_OfferSave::~Dialog_OfferSave()
{

}


} //namespace
