/* baobab-window.c generated by valac 0.32.0.59-edc5, the Vala compiler
 * generated from baobab-window.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;
typedef struct _BaobabWindowPrivate BaobabWindowPrivate;

#define BAOBAB_TYPE_LOCATION_LIST (baobab_location_list_get_type ())
#define BAOBAB_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList))
#define BAOBAB_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))
#define BAOBAB_IS_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_IS_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_LOCATION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))

typedef struct _BaobabLocationList BaobabLocationList;
typedef struct _BaobabLocationListClass BaobabLocationListClass;

#define BAOBAB_TYPE_CELL_RENDERER_SIZE (baobab_cell_renderer_size_get_type ())
#define BAOBAB_CELL_RENDERER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSize))
#define BAOBAB_CELL_RENDERER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSizeClass))
#define BAOBAB_IS_CELL_RENDERER_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CELL_RENDERER_SIZE))
#define BAOBAB_IS_CELL_RENDERER_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CELL_RENDERER_SIZE))
#define BAOBAB_CELL_RENDERER_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CELL_RENDERER_SIZE, BaobabCellRendererSizeClass))

typedef struct _BaobabCellRendererSize BaobabCellRendererSize;
typedef struct _BaobabCellRendererSizeClass BaobabCellRendererSizeClass;

#define BAOBAB_TYPE_CHART (baobab_chart_get_type ())
#define BAOBAB_CHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART, BaobabChart))
#define BAOBAB_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART, BaobabChartClass))
#define BAOBAB_IS_CHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART))
#define BAOBAB_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART))
#define BAOBAB_CHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART, BaobabChartClass))

typedef struct _BaobabChart BaobabChart;
typedef struct _BaobabChartClass BaobabChartClass;

#define BAOBAB_TYPE_LOCATION (baobab_location_get_type ())
#define BAOBAB_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION, BaobabLocation))
#define BAOBAB_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION, BaobabLocationClass))
#define BAOBAB_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION))
#define BAOBAB_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION))
#define BAOBAB_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION, BaobabLocationClass))

typedef struct _BaobabLocation BaobabLocation;
typedef struct _BaobabLocationClass BaobabLocationClass;

#define BAOBAB_WINDOW_TYPE_DND_TARGETS (baobab_window_dnd_targets_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))

#define BAOBAB_WINDOW_TYPE_ACTION_STATE (baobab_window_action_state_get_type ())
typedef struct _BaobabWindowActionState BaobabWindowActionState;

#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define BAOBAB_TYPE_SCANNER (baobab_scanner_get_type ())
#define BAOBAB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_SCANNER, BaobabScanner))
#define BAOBAB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_SCANNER, BaobabScannerClass))
#define BAOBAB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_SCANNER))
#define BAOBAB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_SCANNER))
#define BAOBAB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_SCANNER, BaobabScannerClass))

typedef struct _BaobabScanner BaobabScanner;
typedef struct _BaobabScannerClass BaobabScannerClass;
typedef struct _Block1Data Block1Data;

#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define BAOBAB_SCANNER_TYPE_COLUMNS (baobab_scanner_columns_get_type ())
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

#define BAOBAB_SCANNER_TYPE_STATE (baobab_scanner_state_get_type ())

struct _BaobabWindow {
	GtkApplicationWindow parent_instance;
	BaobabWindowPrivate * priv;
};

struct _BaobabWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _BaobabWindowPrivate {
	GSettings* ui_settings;
	GtkHeaderBar* header_bar;
	GtkButton* back_button;
	GtkButton* reload_button;
	GtkMenuButton* menu_button;
	GtkStack* main_stack;
	GtkWidget* home_page;
	GtkWidget* result_page;
	GtkInfoBar* infobar;
	GtkLabel* infobar_primary_label;
	GtkLabel* infobar_secondary_label;
	GtkButton* infobar_close_button;
	BaobabLocationList* location_list;
	GtkTreeView* treeview;
	GtkTreeViewColumn* size_column;
	BaobabCellRendererSize* size_column_size_renderer;
	GtkMenu* treeview_popup_menu;
	GtkMenuItem* treeview_popup_open;
	GtkMenuItem* treeview_popup_copy;
	GtkMenuItem* treeview_popup_trash;
	GtkStack* chart_stack;
	GtkStack* spinner_stack;
	GtkStackSwitcher* chart_stack_switcher;
	BaobabChart* rings_chart;
	BaobabChart* treemap_chart;
	GtkSpinner* spinner;
	BaobabLocation* active_location;
	gulong scan_completed_handler;
};

typedef enum  {
	BAOBAB_WINDOW_DND_TARGETS_URI_LIST
} BaobabWindowDndTargets;

struct _BaobabWindowActionState {
	gchar* name;
	gboolean enable;
};

typedef void (*BaobabLocationListLocationAction) (BaobabLocation* l, void* user_data);
struct _Block1Data {
	int _ref_count_;
	BaobabWindow* self;
	GtkFileChooserDialog* file_chooser;
	GtkCheckButton* check_button;
};

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;

struct _Block2Data {
	int _ref_count_;
	BaobabWindow* self;
	BaobabLocation* location;
};

typedef enum  {
	BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME,
	BAOBAB_SCANNER_COLUMNS_PARSE_NAME,
	BAOBAB_SCANNER_COLUMNS_PERCENT,
	BAOBAB_SCANNER_COLUMNS_SIZE,
	BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE,
	BAOBAB_SCANNER_COLUMNS_TIME_MODIFIED,
	BAOBAB_SCANNER_COLUMNS_ELEMENTS,
	BAOBAB_SCANNER_COLUMNS_STATE,
	BAOBAB_SCANNER_COLUMNS_ERROR,
	BAOBAB_SCANNER_COLUMNS_COLUMNS
} BaobabScannerColumns;

struct _Block3Data {
	int _ref_count_;
	BaobabWindow* self;
	GtkTreeSelection* selection;
};

struct _Block4Data {
	int _ref_count_;
	BaobabWindow* self;
	BaobabScanner* scanner;
};

typedef enum  {
	BAOBAB_SCANNER_STATE_SCANNING,
	BAOBAB_SCANNER_STATE_CANCELLED,
	BAOBAB_SCANNER_STATE_NEED_PERCENT,
	BAOBAB_SCANNER_STATE_ERROR,
	BAOBAB_SCANNER_STATE_CHILD_ERROR,
	BAOBAB_SCANNER_STATE_DONE
} BaobabScannerState;


static gpointer baobab_window_parent_class = NULL;
static GdkCursor* baobab_window_busy_cursor;
static GdkCursor* baobab_window_busy_cursor = NULL;

GType baobab_window_get_type (void) G_GNUC_CONST;
GType baobab_location_list_get_type (void) G_GNUC_CONST;
GType baobab_cell_renderer_size_get_type (void) G_GNUC_CONST;
GType baobab_chart_get_type (void) G_GNUC_CONST;
gpointer baobab_location_ref (gpointer instance);
void baobab_location_unref (gpointer instance);
GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location (GValue* value, gpointer v_object);
void baobab_value_take_location (GValue* value, gpointer v_object);
gpointer baobab_value_get_location (const GValue* value);
GType baobab_location_get_type (void) G_GNUC_CONST;
#define BAOBAB_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_WINDOW, BaobabWindowPrivate))
enum  {
	BAOBAB_WINDOW_DUMMY_PROPERTY
};
static GType baobab_window_dnd_targets_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void baobab_window_on_show_gear_menu_activate (BaobabWindow* self, GSimpleAction* action);
static void _baobab_window_on_show_gear_menu_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_show_home_page_activate (BaobabWindow* self);
static void _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_scan_folder_activate (BaobabWindow* self);
static void _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_reload_activate (BaobabWindow* self);
static void _baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_show_allocated (BaobabWindow* self);
static void _baobab_window_on_show_allocated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_expand_all (BaobabWindow* self);
static void _baobab_window_on_expand_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_collapse_all (BaobabWindow* self);
static void _baobab_window_on_collapse_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_help_activate (BaobabWindow* self);
static void _baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_about_activate (BaobabWindow* self);
static void _baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GType baobab_window_action_state_get_type (void) G_GNUC_CONST;
BaobabWindowActionState* baobab_window_action_state_dup (const BaobabWindowActionState* self);
void baobab_window_action_state_free (BaobabWindowActionState* self);
void baobab_window_action_state_copy (const BaobabWindowActionState* self, BaobabWindowActionState* dest);
void baobab_window_action_state_destroy (BaobabWindowActionState* self);
GType baobab_application_get_type (void) G_GNUC_CONST;
BaobabWindow* baobab_window_new (BaobabApplication* app);
BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app);
BaobabApplication* baobab_application_get_default (void);
GSettings* baobab_application_get_ui_settings (BaobabApplication* self);
void baobab_location_list_set_action (BaobabLocationList* self, BaobabLocationListLocationAction action, void* action_target, GDestroyNotify action_target_destroy_notify);
static void baobab_window_on_scan_location_activate (BaobabWindow* self, BaobabLocation* location);
static void _baobab_window_on_scan_location_activate_baobab_location_list_location_action (BaobabLocation* l, gpointer self);
static void baobab_window_setup_treeview (BaobabWindow* self);
static void __lambda18_ (BaobabWindow* self);
static void baobab_window_clear_message (BaobabWindow* self);
static void ___lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda19_ (BaobabWindow* self);
static void ___lambda19__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void baobab_window_on_chart_item_activated (BaobabWindow* self, BaobabChart* chart, GtkTreeIter* iter);
static void _baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender, GtkTreeIter* iter, gpointer self);
static void baobab_window_on_drag_data_received (BaobabWindow* self, GtkWidget* widget, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint target_type, guint time);
static void _baobab_window_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void baobab_window_enable_drop (BaobabWindow* self);
static gboolean __lambda20_ (BaobabWindow* self, GdkEventWindowState* event);
static gboolean ___lambda20__gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean __lambda21_ (BaobabWindow* self, GdkEventConfigure* event);
static gboolean ___lambda21__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static void baobab_window_set_ui_state (BaobabWindow* self, GtkWidget* child, gboolean busy);
GType baobab_scanner_get_type (void) G_GNUC_CONST;
BaobabScanner* baobab_location_get_scanner (BaobabLocation* self);
void baobab_scanner_cancel (BaobabScanner* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda9_ (Block1Data* _data1_, gint response);
GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
void baobab_window_scan_directory (BaobabWindow* self, GFile* directory, BaobabScanFlags flags);
static void ___lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void baobab_window_set_active_location (BaobabWindow* self, BaobabLocation* location);
void baobab_location_list_add_location (BaobabLocationList* self, BaobabLocation* location);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
gboolean baobab_location_get_is_volume (BaobabLocation* self);
void baobab_location_mount_volume (BaobabLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void baobab_location_mount_volume_finish (BaobabLocation* self, GAsyncResult* _res_, GError** error);
static void ___lambda11_ (Block2Data* _data2_, GObject* location_, GAsyncResult* res);
static void baobab_window_scan_active_location (BaobabWindow* self, gboolean force);
static void baobab_window_message (BaobabWindow* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType type);
static void ____lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void baobab_window_disable_drop (BaobabWindow* self);
static gboolean baobab_window_show_treeview_popup (BaobabWindow* self, GtkMenu* popup, GdkEventButton* event);
void baobab_window_open_item (BaobabWindow* self, GtkTreeIter* iter);
GType baobab_scanner_columns_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void baobab_window_copy_path (BaobabWindow* self, GtkTreeIter* iter);
void baobab_window_trash_file (BaobabWindow* self, GtkTreeIter* iter);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda12_ (BaobabWindow* self, GdkEventButton* event);
static gboolean ___lambda12__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda13_ (BaobabWindow* self);
static gboolean ___lambda13__gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
static void __lambda14_ (BaobabWindow* self);
static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda15_ (BaobabWindow* self);
static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda16_ (BaobabWindow* self);
static void ___lambda16__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda17_ (Block3Data* _data3_);
void baobab_chart_set_root (BaobabChart* self, GtkTreePath* value);
static void ___lambda17__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void baobab_window_set_busy (BaobabWindow* self, gboolean busy);
const gchar* baobab_location_get_name (BaobabLocation* self);
static void baobab_window_first_row_has_child (BaobabWindow* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void baobab_window_expand_first_row (BaobabWindow* self);
static void baobab_window_set_chart_model (BaobabWindow* self, GtkTreeModel* model, gboolean show_allocated_size);
void baobab_chart_set_model_with_columns (BaobabChart* self, GtkTreeModel* m, guint name_column_, guint size_column_, guint info_column_, guint percentage_column_, guint valid_column_, GtkTreePath* r);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda10_ (Block4Data* _data4_);
void baobab_scanner_finish (BaobabScanner* self, GError** error);
GType baobab_scanner_state_get_type (void) G_GNUC_CONST;
GFile* baobab_scanner_get_directory (BaobabScanner* self);
void baobab_cell_renderer_size_set_show_allocated_size (BaobabCellRendererSize* self, gboolean value);
static void ___lambda10__baobab_scanner_completed (BaobabScanner* _sender, gpointer self);
void baobab_scanner_scan (BaobabScanner* self, gboolean force);
BaobabLocation* baobab_location_new_for_file (GFile* file_, BaobabScanFlags flags);
BaobabLocation* baobab_location_construct_for_file (GType object_type, GFile* file_, BaobabScanFlags flags);
GFileInfo* baobab_location_get_info (BaobabLocation* self);
static void baobab_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry BAOBAB_WINDOW_action_entries[9] = {{"gear-menu", _baobab_window_on_show_gear_menu_activate_gsimple_action_activate_callback, NULL, "false", NULL}, {"show-home-page", _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback}, {"scan-folder", _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback}, {"reload", _baobab_window_on_reload_activate_gsimple_action_activate_callback}, {"show-allocated", _baobab_window_on_show_allocated_gsimple_action_activate_callback}, {"expand-all", _baobab_window_on_expand_all_gsimple_action_activate_callback}, {"collapse-all", _baobab_window_on_collapse_all_gsimple_action_activate_callback}, {"help", _baobab_window_on_help_activate_gsimple_action_activate_callback}, {"about", _baobab_window_on_about_activate_gsimple_action_activate_callback}};
static const BaobabWindowActionState BAOBAB_WINDOW_actions_while_scanning[4] = {{"scan-folder", FALSE}, {"show-allocated", FALSE}, {"expand-all", FALSE}, {"collapse-all", FALSE}};
static const GtkTargetEntry BAOBAB_WINDOW_dnd_target_list[1] = {{"text/uri-list", (guint) 0, (guint) BAOBAB_WINDOW_DND_TARGETS_URI_LIST}};

static GType baobab_window_dnd_targets_get_type (void) {
	static volatile gsize baobab_window_dnd_targets_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_dnd_targets_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_WINDOW_DND_TARGETS_URI_LIST, "BAOBAB_WINDOW_DND_TARGETS_URI_LIST", "uri-list"}, {0, NULL, NULL}};
		GType baobab_window_dnd_targets_type_id;
		baobab_window_dnd_targets_type_id = g_enum_register_static ("BaobabWindowDndTargets", values);
		g_once_init_leave (&baobab_window_dnd_targets_type_id__volatile, baobab_window_dnd_targets_type_id);
	}
	return baobab_window_dnd_targets_type_id__volatile;
}


static void _baobab_window_on_show_gear_menu_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_show_gear_menu_activate ((BaobabWindow*) self, action);
}


static void _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_show_home_page_activate ((BaobabWindow*) self);
}


static void _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_scan_folder_activate ((BaobabWindow*) self);
}


static void _baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_reload_activate ((BaobabWindow*) self);
}


static void _baobab_window_on_show_allocated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_show_allocated ((BaobabWindow*) self);
}


static void _baobab_window_on_expand_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_expand_all ((BaobabWindow*) self);
}


static void _baobab_window_on_collapse_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_collapse_all ((BaobabWindow*) self);
}


static void _baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_help_activate ((BaobabWindow*) self);
}


static void _baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_about_activate ((BaobabWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _baobab_window_on_scan_location_activate_baobab_location_list_location_action (BaobabLocation* l, gpointer self) {
	baobab_window_on_scan_location_activate ((BaobabWindow*) self, l);
}


static void __lambda18_ (BaobabWindow* self) {
	baobab_window_clear_message (self);
}


static void ___lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda18_ ((BaobabWindow*) self);
}


static void __lambda19_ (BaobabWindow* self) {
	GtkStack* _tmp0_ = NULL;
	_tmp0_ = self->priv->chart_stack;
	g_settings_unbind ((GObject*) _tmp0_, "visible-child-name");
}


static void ___lambda19__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda19_ ((BaobabWindow*) self);
}


static void _baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender, GtkTreeIter* iter, gpointer self) {
	baobab_window_on_chart_item_activated ((BaobabWindow*) self, _sender, iter);
}


static void _baobab_window_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	baobab_window_on_drag_data_received ((BaobabWindow*) self, _sender, context, x, y, selection_data, info, time_);
}


static gboolean __lambda20_ (BaobabWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	GdkEventWindowState* _tmp1_ = NULL;
	GdkWindowState _tmp2_ = 0;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->ui_settings;
	_tmp1_ = event;
	_tmp2_ = _tmp1_->new_window_state;
	g_settings_set_int (_tmp0_, "window-state", (gint) _tmp2_);
	result = FALSE;
	return result;
}


static gboolean ___lambda20__gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = __lambda20_ ((BaobabWindow*) self, event);
	return result;
}


static gboolean __lambda21_ (BaobabWindow* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	GdkWindow* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_window_get_state (_tmp0_);
	if (!((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED)) {
		GSettings* _tmp2_ = NULL;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkEventConfigure* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp2_ = self->priv->ui_settings;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->width;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->height;
		g_settings_set (_tmp2_, "window-size", "(ii)", _tmp4_, _tmp6_);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda21__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = __lambda21_ ((BaobabWindow*) self, event);
	return result;
}


BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app) {
	BaobabWindow * self = NULL;
	BaobabApplication* _tmp0_ = NULL;
	GdkCursor* _tmp1_ = NULL;
	BaobabApplication* _tmp4_ = NULL;
	BaobabApplication* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp9_ = NULL;
	GAction* _tmp10_ = NULL;
	GAction* _tmp11_ = NULL;
	BaobabLocationList* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	GtkStack* _tmp15_ = NULL;
	GtkStack* _tmp16_ = NULL;
	BaobabChart* _tmp17_ = NULL;
	BaobabChart* _tmp18_ = NULL;
	GdkWindowState window_state = 0;
	GSettings* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GdkWindowState _tmp21_ = 0;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp22_ = NULL;
	GtkWidget* _tmp23_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = app;
	self = (BaobabWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	_tmp1_ = baobab_window_busy_cursor;
	if (_tmp1_ == NULL) {
		GdkDisplay* _tmp2_ = NULL;
		GdkCursor* _tmp3_ = NULL;
		_tmp2_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_WATCH);
		_g_object_unref0 (baobab_window_busy_cursor);
		baobab_window_busy_cursor = _tmp3_;
	}
	_tmp4_ = baobab_application_get_default ();
	_tmp5_ = _tmp4_;
	_tmp6_ = baobab_application_get_ui_settings (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp8_;
	_g_object_unref0 (_tmp5_);
	g_action_map_add_action_entries ((GActionMap*) self, BAOBAB_WINDOW_action_entries, G_N_ELEMENTS (BAOBAB_WINDOW_action_entries), self);
	_tmp9_ = self->priv->ui_settings;
	_tmp10_ = g_settings_create_action (_tmp9_, "active-chart");
	action = _tmp10_;
	_tmp11_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp11_);
	_tmp12_ = self->priv->location_list;
	baobab_location_list_set_action (_tmp12_, _baobab_window_on_scan_location_activate_baobab_location_list_location_action, g_object_ref (self), g_object_unref);
	baobab_window_setup_treeview (self);
	_tmp13_ = self->priv->infobar_close_button;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda18__gtk_button_clicked, self, 0);
	_tmp14_ = self->priv->ui_settings;
	_tmp15_ = self->priv->chart_stack;
	g_settings_bind (_tmp14_, "active-chart", (GObject*) _tmp15_, "visible-child-name", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = self->priv->chart_stack;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "destroy", (GCallback) ___lambda19__gtk_widget_destroy, self, 0);
	_tmp17_ = self->priv->rings_chart;
	g_signal_connect_object (_tmp17_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	_tmp18_ = self->priv->treemap_chart;
	g_signal_connect_object (_tmp18_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _baobab_window_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	baobab_window_enable_drop (self);
	_tmp19_ = self->priv->ui_settings;
	_tmp20_ = g_settings_get_int (_tmp19_, "window-state");
	window_state = (GdkWindowState) _tmp20_;
	_tmp21_ = window_state;
	if ((_tmp21_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp22_ = self->priv->ui_settings;
	g_settings_get (_tmp22_, "window-size", "(ii)", &width, &height);
	gtk_window_resize ((GtkWindow*) self, width, height);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) ___lambda20__gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) ___lambda21__gtk_widget_configure_event, self, 0);
	_baobab_location_unref0 (self->priv->active_location);
	self->priv->active_location = NULL;
	self->priv->scan_completed_handler = (gulong) 0;
	_tmp23_ = self->priv->home_page;
	baobab_window_set_ui_state (self, _tmp23_, FALSE);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (action);
	return self;
}


BaobabWindow* baobab_window_new (BaobabApplication* app) {
	return baobab_window_construct (BAOBAB_TYPE_WINDOW, app);
}


static void baobab_window_on_show_gear_menu_activate (BaobabWindow* self, GSimpleAction* action) {
	gboolean state = FALSE;
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GSimpleAction* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_boolean (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	state = _tmp4_;
	_tmp5_ = action;
	_tmp6_ = g_variant_new_boolean (!state);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_simple_action_set_state (_tmp5_, _tmp7_);
	_g_variant_unref0 (_tmp7_);
}


static void baobab_window_on_show_home_page_activate (BaobabWindow* self) {
	gboolean _tmp0_ = FALSE;
	BaobabLocation* _tmp1_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->active_location;
	if (_tmp1_ != NULL) {
		BaobabLocation* _tmp2_ = NULL;
		BaobabScanner* _tmp3_ = NULL;
		BaobabScanner* _tmp4_ = NULL;
		_tmp2_ = self->priv->active_location;
		_tmp3_ = baobab_location_get_scanner (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BaobabLocation* _tmp5_ = NULL;
		BaobabScanner* _tmp6_ = NULL;
		BaobabScanner* _tmp7_ = NULL;
		_tmp5_ = self->priv->active_location;
		_tmp6_ = baobab_location_get_scanner (_tmp5_);
		_tmp7_ = _tmp6_;
		baobab_scanner_cancel (_tmp7_);
	}
	baobab_window_clear_message (self);
	_tmp8_ = self->priv->home_page;
	baobab_window_set_ui_state (self, _tmp8_, FALSE);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BaobabWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->check_button);
		_g_object_unref0 (_data1_->file_chooser);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda9_ (Block1Data* _data1_, gint response) {
	BaobabWindow* self;
	gint _tmp0_ = 0;
	self = _data1_->self;
	_tmp0_ = response;
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		BaobabScanFlags _tmp1_ = 0;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		BaobabScanFlags flags = 0;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		BaobabScanFlags _tmp6_ = 0;
		_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _data1_->check_button);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			_tmp1_ = BAOBAB_SCAN_FLAGS_NONE;
		} else {
			_tmp1_ = BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS;
		}
		flags = _tmp1_;
		_tmp4_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data1_->file_chooser);
		_tmp5_ = _tmp4_;
		_tmp6_ = flags;
		baobab_window_scan_directory (self, _tmp5_, _tmp6_);
		_g_object_unref0 (_tmp5_);
	}
	gtk_widget_destroy ((GtkWidget*) _data1_->file_chooser);
}


static void ___lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda9_ (self, response_id);
}


static void baobab_window_on_scan_folder_activate (BaobabWindow* self) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkCheckButton* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _ ("Select Folder");
	_tmp1_ = _ ("_Cancel");
	_tmp2_ = _ ("_Open");
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, _tmp1_, GTK_RESPONSE_CANCEL, _tmp2_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp3_);
	_data1_->file_chooser = _tmp3_;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _data1_->file_chooser, FALSE);
	gtk_file_chooser_set_create_folders ((GtkFileChooser*) _data1_->file_chooser, FALSE);
	gtk_window_set_modal ((GtkWindow*) _data1_->file_chooser, TRUE);
	_tmp4_ = _ ("Recursively analyze mount points");
	_tmp5_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_data1_->check_button = _tmp5_;
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _data1_->file_chooser, (GtkWidget*) _data1_->check_button);
	g_signal_connect_data ((GtkDialog*) _data1_->file_chooser, "response", (GCallback) ___lambda9__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data1_->file_chooser);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gpointer _baobab_location_ref0 (gpointer self) {
	return self ? baobab_location_ref (self) : NULL;
}


static void baobab_window_set_active_location (BaobabWindow* self, BaobabLocation* location) {
	gulong _tmp0_ = 0UL;
	BaobabLocation* _tmp5_ = NULL;
	BaobabLocation* _tmp6_ = NULL;
	BaobabLocationList* _tmp7_ = NULL;
	BaobabLocation* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->scan_completed_handler;
	if (_tmp0_ > ((gulong) 0)) {
		BaobabLocation* _tmp1_ = NULL;
		BaobabScanner* _tmp2_ = NULL;
		BaobabScanner* _tmp3_ = NULL;
		gulong _tmp4_ = 0UL;
		_tmp1_ = self->priv->active_location;
		_tmp2_ = baobab_location_get_scanner (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->scan_completed_handler;
		g_signal_handler_disconnect ((GObject*) _tmp3_, _tmp4_);
		self->priv->scan_completed_handler = (gulong) 0;
	}
	_tmp5_ = location;
	_tmp6_ = _baobab_location_ref0 (_tmp5_);
	_baobab_location_unref0 (self->priv->active_location);
	self->priv->active_location = _tmp6_;
	_tmp7_ = self->priv->location_list;
	_tmp8_ = location;
	baobab_location_list_add_location (_tmp7_, _tmp8_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BaobabWindow* self;
		self = _data2_->self;
		_baobab_location_unref0 (_data2_->location);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda11_ (Block2Data* _data2_, GObject* location_, GAsyncResult* res) {
	BaobabWindow* self;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		BaobabLocation* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data2_->location;
		_tmp1_ = res;
		baobab_location_mount_volume_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		baobab_window_scan_active_location (self, FALSE);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Could not analyze volume.");
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		baobab_window_message (self, _tmp2_, _tmp4_, GTK_MESSAGE_ERROR);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda11_ (self, source_object, res);
	block2_data_unref (self);
}


static void baobab_window_on_scan_location_activate (BaobabWindow* self, BaobabLocation* location) {
	Block2Data* _data2_;
	BaobabLocation* _tmp0_ = NULL;
	BaobabLocation* _tmp1_ = NULL;
	BaobabLocation* _tmp2_ = NULL;
	BaobabLocation* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = location;
	_tmp1_ = _baobab_location_ref0 (_tmp0_);
	_baobab_location_unref0 (_data2_->location);
	_data2_->location = _tmp1_;
	_tmp2_ = _data2_->location;
	baobab_window_set_active_location (self, _tmp2_);
	_tmp3_ = _data2_->location;
	_tmp4_ = baobab_location_get_is_volume (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		BaobabLocation* _tmp6_ = NULL;
		_tmp6_ = _data2_->location;
		baobab_location_mount_volume (_tmp6_, ____lambda11__gasync_ready_callback, block2_data_ref (_data2_));
	} else {
		baobab_window_scan_active_location (self, FALSE);
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void baobab_window_on_reload_activate (BaobabWindow* self) {
	BaobabLocation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_location;
	if (_tmp0_ != NULL) {
		BaobabLocation* _tmp1_ = NULL;
		BaobabScanner* _tmp2_ = NULL;
		BaobabScanner* _tmp3_ = NULL;
		_tmp1_ = self->priv->active_location;
		_tmp2_ = baobab_location_get_scanner (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			BaobabLocation* _tmp4_ = NULL;
			BaobabScanner* _tmp5_ = NULL;
			BaobabScanner* _tmp6_ = NULL;
			_tmp4_ = self->priv->active_location;
			_tmp5_ = baobab_location_get_scanner (_tmp4_);
			_tmp6_ = _tmp5_;
			baobab_scanner_cancel (_tmp6_);
		}
		baobab_window_scan_active_location (self, TRUE);
	}
}


static void baobab_window_on_show_allocated (BaobabWindow* self) {
	g_return_if_fail (self != NULL);
}


static void baobab_window_on_expand_all (BaobabWindow* self) {
	GtkTreeView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	gtk_tree_view_expand_all (_tmp0_);
}


static void baobab_window_on_collapse_all (BaobabWindow* self) {
	GtkTreeView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	gtk_tree_view_collapse_all (_tmp0_);
}


static void baobab_window_on_help_activate (BaobabWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GdkScreen* _tmp0_ = NULL;
		guint32 _tmp1_ = 0U;
		_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp1_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp0_, "help:baobab", _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Failed to show help");
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		baobab_window_message (self, _tmp2_, _tmp4_, GTK_MESSAGE_WARNING);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void baobab_window_on_about_activate (BaobabWindow* self) {
	static const gchar* authors[] = {"Ryan Lortie <desrt@desrt.ca>", "Fabio Marzocca <thesaltydog@gmail.com>", "Paolo Borelli <pborelli@gnome.com>", "Stefano Facchini <stefano.facchini@gmail.com>", "Benoît Dejean <benoit@placenet.org>", "Igalia (rings-chart and treemap widget) <www.igalia.com>", NULL};
	static const char copyright[] = "Copyright \xc2\xa9 2005-2011 Fabio Marzocca, Paolo Borelli, Benoît Dej" \
"ean, Igalia\n" "Copyright \xc2\xa9 2011-2012 Ryan Lortie, Paolo Borelli, Stefano Facch" \
"ini\n";
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Baobab");
	_tmp1_ = _ ("A graphical tool to analyze disk usage.");
	_tmp2_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", _tmp0_, "logo-icon-name", "baobab", "version", VERSION, "comments", _tmp1_, "copyright", copyright, "license-type", GTK_LICENSE_GPL_2_0, "wrap-license", FALSE, "authors", authors, "translator-credits", _tmp2_, NULL, NULL);
}


static void baobab_window_on_chart_item_activated (BaobabWindow* self, BaobabChart* chart, GtkTreeIter* iter) {
	GtkTreePath* path = NULL;
	BaobabLocation* _tmp0_ = NULL;
	BaobabScanner* _tmp1_ = NULL;
	BaobabScanner* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreePath* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkTreeView* _tmp10_ = NULL;
	GtkTreePath* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chart != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	_tmp4_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp2_, &_tmp3_);
	path = _tmp4_;
	_tmp5_ = self->priv->treeview;
	_tmp6_ = path;
	_tmp7_ = gtk_tree_view_row_expanded (_tmp5_, _tmp6_);
	if (!_tmp7_) {
		GtkTreeView* _tmp8_ = NULL;
		GtkTreePath* _tmp9_ = NULL;
		_tmp8_ = self->priv->treeview;
		_tmp9_ = path;
		gtk_tree_view_expand_to_path (_tmp8_, _tmp9_);
	}
	_tmp10_ = self->priv->treeview;
	_tmp11_ = path;
	gtk_tree_view_set_cursor (_tmp10_, _tmp11_, NULL, FALSE);
	_gtk_tree_path_free0 (path);
}


static void baobab_window_on_drag_data_received (BaobabWindow* self, GtkWidget* widget, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint target_type, guint time) {
	GFile* dir = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkSelectionData* _tmp2_ = NULL;
	GFile* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	dir = NULL;
	_tmp2_ = selection_data;
	if (_tmp2_ != NULL) {
		GtkSelectionData* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = selection_data;
		_tmp4_ = gtk_selection_data_get_length (_tmp3_);
		_tmp1_ = _tmp4_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		guint _tmp5_ = 0U;
		_tmp5_ = target_type;
		_tmp0_ = _tmp5_ == ((guint) BAOBAB_WINDOW_DND_TARGETS_URI_LIST);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** uris = NULL;
		GtkSelectionData* _tmp6_ = NULL;
		guchar* _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint uris_length1 = 0;
		gint _uris_size_ = 0;
		gboolean _tmp10_ = FALSE;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		_tmp6_ = selection_data;
		_tmp7_ = gtk_selection_data_get_data (_tmp6_);
		_tmp9_ = _tmp8_ = g_uri_list_extract_uris ((const gchar*) _tmp7_);
		uris = _tmp9_;
		uris_length1 = _vala_array_length (_tmp8_);
		_uris_size_ = uris_length1;
		_tmp11_ = uris;
		_tmp11__length1 = uris_length1;
		if (_tmp11_ != NULL) {
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			_tmp12_ = uris;
			_tmp12__length1 = uris_length1;
			_tmp10_ = _tmp12__length1 == 1;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			const gchar* _tmp14_ = NULL;
			GFile* _tmp15_ = NULL;
			_tmp13_ = uris;
			_tmp13__length1 = uris_length1;
			_tmp14_ = _tmp13_[0];
			_tmp15_ = g_file_new_for_uri (_tmp14_);
			_g_object_unref0 (dir);
			dir = _tmp15_;
		}
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = dir;
	if (_tmp16_ != NULL) {
		GdkDragContext* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		GFile* _tmp19_ = NULL;
		_tmp17_ = context;
		_tmp18_ = time;
		gtk_drag_finish (_tmp17_, TRUE, FALSE, (guint32) _tmp18_);
		_tmp19_ = dir;
		baobab_window_scan_directory (self, _tmp19_, BAOBAB_SCAN_FLAGS_NONE);
	} else {
		GdkDragContext* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		_tmp20_ = context;
		_tmp21_ = time;
		gtk_drag_finish (_tmp20_, FALSE, FALSE, (guint32) _tmp21_);
	}
	_g_object_unref0 (dir);
}


static void baobab_window_enable_drop (BaobabWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_drag_dest_set ((GtkWidget*) self, (GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_MOTION) | GTK_DEST_DEFAULT_HIGHLIGHT, BAOBAB_WINDOW_dnd_target_list, G_N_ELEMENTS (BAOBAB_WINDOW_dnd_target_list), GDK_ACTION_COPY);
}


static void baobab_window_disable_drop (BaobabWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_drag_dest_unset ((GtkWidget*) self);
}


static gboolean baobab_window_show_treeview_popup (BaobabWindow* self, GtkMenu* popup, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (popup != NULL, FALSE);
	_tmp0_ = event;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_ = NULL;
		GdkEventButton* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		GdkEventButton* _tmp4_ = NULL;
		guint32 _tmp5_ = 0U;
		_tmp1_ = popup;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->button;
		_tmp4_ = event;
		_tmp5_ = _tmp4_->time;
		gtk_menu_popup (_tmp1_, NULL, NULL, NULL, NULL, _tmp3_, _tmp5_);
	} else {
		GtkMenu* _tmp6_ = NULL;
		guint32 _tmp7_ = 0U;
		GtkMenu* _tmp8_ = NULL;
		_tmp6_ = popup;
		_tmp7_ = gtk_get_current_event_time ();
		gtk_menu_popup (_tmp6_, NULL, NULL, NULL, NULL, (guint) 0, _tmp7_);
		_tmp8_ = popup;
		gtk_menu_shell_select_first ((GtkMenuShell*) _tmp8_, FALSE);
	}
	result = TRUE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void baobab_window_open_item (BaobabWindow* self, GtkTreeIter* iter) {
	gchar* parse_name = NULL;
	BaobabLocation* _tmp0_ = NULL;
	BaobabScanner* _tmp1_ = NULL;
	BaobabScanner* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GFile* file = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, &parse_name, -1);
	_tmp4_ = parse_name;
	_tmp5_ = g_file_parse_name (_tmp4_);
	file = _tmp5_;
	{
		GFileInfo* info = NULL;
		GFile* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
		gchar* content = NULL;
		GFileInfo* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GAppInfo* appinfo = NULL;
		const gchar* _tmp11_ = NULL;
		GAppInfo* _tmp12_ = NULL;
		GdkAppLaunchContext* context = NULL;
		GdkDisplay* _tmp13_ = NULL;
		GdkAppLaunchContext* _tmp14_ = NULL;
		GdkAppLaunchContext* _tmp15_ = NULL;
		guint32 _tmp16_ = 0U;
		GList* files = NULL;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GAppInfo* _tmp19_ = NULL;
		GList* _tmp20_ = NULL;
		GdkAppLaunchContext* _tmp21_ = NULL;
		_tmp6_ = file;
		_tmp7_ = g_file_query_info (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error_);
		info = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_tmp8_ = info;
		_tmp9_ = g_file_info_get_content_type (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		content = _tmp10_;
		_tmp11_ = content;
		_tmp12_ = g_app_info_get_default_for_type (_tmp11_, TRUE);
		appinfo = _tmp12_;
		_tmp13_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp14_ = gdk_display_get_app_launch_context (_tmp13_);
		context = _tmp14_;
		_tmp15_ = context;
		_tmp16_ = gtk_get_current_event_time ();
		gdk_app_launch_context_set_timestamp (_tmp15_, _tmp16_);
		files = NULL;
		_tmp17_ = file;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		files = g_list_append (files, _tmp18_);
		_tmp19_ = appinfo;
		_tmp20_ = files;
		_tmp21_ = context;
		g_app_info_launch (_tmp19_, _tmp20_, (GAppLaunchContext*) _tmp21_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			__g_list_free__g_object_unref0_0 (files);
			_g_object_unref0 (context);
			_g_object_unref0 (appinfo);
			_g_free0 (content);
			_g_object_unref0 (info);
			goto __catch8_g_error;
		}
		__g_list_free__g_object_unref0_0 (files);
		_g_object_unref0 (context);
		_g_object_unref0 (appinfo);
		_g_free0 (content);
		_g_object_unref0 (info);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = _ ("Failed to open file");
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		baobab_window_message (self, _tmp22_, _tmp24_, GTK_MESSAGE_ERROR);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		_g_free0 (parse_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (parse_name);
}


void baobab_window_copy_path (BaobabWindow* self, GtkTreeIter* iter) {
	gchar* parse_name = NULL;
	BaobabLocation* _tmp0_ = NULL;
	BaobabScanner* _tmp1_ = NULL;
	BaobabScanner* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp4_ = NULL;
	GtkClipboard* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, &parse_name, -1);
	_tmp4_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	clipboard = _tmp5_;
	gtk_clipboard_set_text (clipboard, parse_name, -1);
	gtk_clipboard_store (clipboard);
	_g_object_unref0 (clipboard);
	_g_free0 (parse_name);
}


void baobab_window_trash_file (BaobabWindow* self, GtkTreeIter* iter) {
	gchar* parse_name = NULL;
	BaobabLocation* _tmp0_ = NULL;
	BaobabScanner* _tmp1_ = NULL;
	BaobabScanner* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GFile* file = NULL;
	GFile* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, &parse_name, -1);
	_tmp4_ = g_file_parse_name (parse_name);
	file = _tmp4_;
	{
		BaobabLocation* _tmp5_ = NULL;
		BaobabScanner* _tmp6_ = NULL;
		BaobabScanner* _tmp7_ = NULL;
		g_file_trash (file, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_tmp5_ = self->priv->active_location;
		_tmp6_ = baobab_location_get_scanner (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_tree_store_remove ((GtkTreeStore*) _tmp7_, iter);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _ ("Failed to move file to the trash");
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		baobab_window_message (self, _tmp8_, _tmp10_, GTK_MESSAGE_ERROR);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		_g_free0 (parse_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (parse_name);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BaobabWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->selection);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean __lambda12_ (BaobabWindow* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = gdk_event_triggers_context_menu ((GdkEvent*) _tmp0_);
	if (_tmp1_) {
		GtkTreePath* path = NULL;
		GtkTreeView* _tmp2_ = NULL;
		GdkEventButton* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		GtkTreePath* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp2_ = self->priv->treeview;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->x;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->y;
		_tmp8_ = gtk_tree_view_get_path_at_pos (_tmp2_, (gint) _tmp4_, (gint) _tmp6_, &_tmp7_, NULL, NULL, NULL);
		_gtk_tree_path_free0 (path);
		path = _tmp7_;
		if (_tmp8_) {
			GtkTreeView* _tmp9_ = NULL;
			GtkTreeSelection* _tmp10_ = NULL;
			GtkTreePath* _tmp11_ = NULL;
			GtkMenu* _tmp12_ = NULL;
			GdkEventButton* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp9_ = self->priv->treeview;
			_tmp10_ = gtk_tree_view_get_selection (_tmp9_);
			_tmp11_ = path;
			gtk_tree_selection_select_path (_tmp10_, _tmp11_);
			_tmp12_ = self->priv->treeview_popup_menu;
			_tmp13_ = event;
			_tmp14_ = baobab_window_show_treeview_popup (self, _tmp12_, _tmp13_);
			result = _tmp14_;
			_gtk_tree_path_free0 (path);
			return result;
		}
		_gtk_tree_path_free0 (path);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda12__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda12_ ((BaobabWindow*) self, event);
	return result;
}


static gboolean __lambda13_ (BaobabWindow* self) {
	gboolean result = FALSE;
	GtkMenu* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = self->priv->treeview_popup_menu;
	_tmp1_ = baobab_window_show_treeview_popup (self, _tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda13__gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = __lambda13_ ((BaobabWindow*) self);
	return result;
}


static void __lambda14_ (BaobabWindow* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		GtkTreeIter _tmp6_ = {0};
		_tmp6_ = iter;
		baobab_window_open_item (self, &_tmp6_);
	}
	_g_object_unref0 (selection);
}


static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda14_ ((BaobabWindow*) self);
}


static void __lambda15_ (BaobabWindow* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		GtkTreeIter _tmp6_ = {0};
		_tmp6_ = iter;
		baobab_window_copy_path (self, &_tmp6_);
	}
	_g_object_unref0 (selection);
}


static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda15_ ((BaobabWindow*) self);
}


static void __lambda16_ (BaobabWindow* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		GtkTreeIter _tmp6_ = {0};
		_tmp6_ = iter;
		baobab_window_trash_file (self, &_tmp6_);
	}
	_g_object_unref0 (selection);
}


static void ___lambda16__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda16_ ((BaobabWindow*) self);
}


static void __lambda17_ (Block3Data* _data3_) {
	BaobabWindow* self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	self = _data3_->self;
	_tmp1_ = gtk_tree_selection_get_selected (_data3_->selection, NULL, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreePath* path = NULL;
		BaobabLocation* _tmp2_ = NULL;
		BaobabScanner* _tmp3_ = NULL;
		BaobabScanner* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
		GtkTreePath* _tmp6_ = NULL;
		BaobabChart* _tmp7_ = NULL;
		GtkTreePath* _tmp8_ = NULL;
		BaobabChart* _tmp9_ = NULL;
		GtkTreePath* _tmp10_ = NULL;
		_tmp2_ = self->priv->active_location;
		_tmp3_ = baobab_location_get_scanner (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = iter;
		_tmp6_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp4_, &_tmp5_);
		path = _tmp6_;
		_tmp7_ = self->priv->rings_chart;
		_tmp8_ = path;
		baobab_chart_set_root (_tmp7_, _tmp8_);
		_tmp9_ = self->priv->treemap_chart;
		_tmp10_ = path;
		baobab_chart_set_root (_tmp9_, _tmp10_);
		_gtk_tree_path_free0 (path);
	}
}


static void ___lambda17__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda17_ (self);
}


static void baobab_window_setup_treeview (BaobabWindow* self) {
	Block3Data* _data3_;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
	GtkMenuItem* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeSelection* _tmp6_ = NULL;
	GtkTreeSelection* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp0_, "button-press-event", (GCallback) ___lambda12__gtk_widget_button_press_event, self, 0);
	_tmp1_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "popup-menu", (GCallback) ___lambda13__gtk_widget_popup_menu, self, 0);
	_tmp2_ = self->priv->treeview_popup_open;
	g_signal_connect_object (_tmp2_, "activate", (GCallback) ___lambda14__gtk_menu_item_activate, self, 0);
	_tmp3_ = self->priv->treeview_popup_copy;
	g_signal_connect_object (_tmp3_, "activate", (GCallback) ___lambda15__gtk_menu_item_activate, self, 0);
	_tmp4_ = self->priv->treeview_popup_trash;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda16__gtk_menu_item_activate, self, 0);
	_tmp5_ = self->priv->treeview;
	_tmp6_ = gtk_tree_view_get_selection (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_data3_->selection = _tmp7_;
	g_signal_connect_data (_data3_->selection, "changed", (GCallback) ___lambda17__gtk_tree_selection_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void baobab_window_message (BaobabWindow* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType type) {
	GtkInfoBar* _tmp0_ = NULL;
	GtkMessageType _tmp1_ = 0;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_msg != NULL);
	g_return_if_fail (secondary_msg != NULL);
	_tmp0_ = self->priv->infobar;
	_tmp1_ = type;
	gtk_info_bar_set_message_type (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->infobar_primary_label;
	_tmp3_ = primary_msg;
	_tmp4_ = g_strdup_printf ("<b>%s</b>", _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->infobar_secondary_label;
	_tmp7_ = secondary_msg;
	_tmp8_ = g_strdup_printf ("<small>%s</small>", _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->infobar;
	gtk_widget_show ((GtkWidget*) _tmp10_);
}


static void baobab_window_clear_message (BaobabWindow* self) {
	GtkInfoBar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void baobab_window_set_busy (BaobabWindow* self, gboolean busy) {
	GdkCursor* cursor = NULL;
	gboolean _tmp0_ = FALSE;
	GdkWindow* window = NULL;
	GdkWindow* _tmp11_ = NULL;
	GdkWindow* _tmp12_ = NULL;
	GdkWindow* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	cursor = NULL;
	_tmp0_ = busy;
	if (_tmp0_) {
		GdkCursor* _tmp1_ = NULL;
		GdkCursor* _tmp2_ = NULL;
		GtkStackSwitcher* _tmp3_ = NULL;
		GtkStack* _tmp4_ = NULL;
		GtkSpinner* _tmp5_ = NULL;
		GtkSpinner* _tmp6_ = NULL;
		_tmp1_ = baobab_window_busy_cursor;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (cursor);
		cursor = _tmp2_;
		baobab_window_disable_drop (self);
		_tmp3_ = self->priv->chart_stack_switcher;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->spinner_stack;
		_tmp5_ = self->priv->spinner;
		gtk_stack_set_visible_child (_tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->spinner;
		gtk_spinner_start (_tmp6_);
	} else {
		GtkSpinner* _tmp7_ = NULL;
		GtkStack* _tmp8_ = NULL;
		GtkStack* _tmp9_ = NULL;
		GtkStackSwitcher* _tmp10_ = NULL;
		baobab_window_enable_drop (self);
		_tmp7_ = self->priv->spinner;
		gtk_spinner_stop (_tmp7_);
		_tmp8_ = self->priv->spinner_stack;
		_tmp9_ = self->priv->chart_stack;
		gtk_stack_set_visible_child (_tmp8_, (GtkWidget*) _tmp9_);
		_tmp10_ = self->priv->chart_stack_switcher;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
	}
	_tmp11_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	window = _tmp12_;
	_tmp13_ = window;
	if (_tmp13_ != NULL) {
		GdkWindow* _tmp14_ = NULL;
		GdkCursor* _tmp15_ = NULL;
		_tmp14_ = window;
		_tmp15_ = cursor;
		gdk_window_set_cursor (_tmp14_, _tmp15_);
	}
	{
		BaobabWindowActionState* action_state_collection = NULL;
		gint action_state_collection_length1 = 0;
		gint _action_state_collection_size_ = 0;
		gint action_state_it = 0;
		action_state_collection = BAOBAB_WINDOW_actions_while_scanning;
		action_state_collection_length1 = G_N_ELEMENTS (BAOBAB_WINDOW_actions_while_scanning);
		for (action_state_it = 0; action_state_it < G_N_ELEMENTS (BAOBAB_WINDOW_actions_while_scanning); action_state_it = action_state_it + 1) {
			BaobabWindowActionState _tmp16_ = {0};
			BaobabWindowActionState action_state = {0};
			baobab_window_action_state_copy (&action_state_collection[action_state_it], &_tmp16_);
			action_state = _tmp16_;
			{
				GSimpleAction* action = NULL;
				BaobabWindowActionState _tmp17_ = {0};
				const gchar* _tmp18_ = NULL;
				GAction* _tmp19_ = NULL;
				GSimpleAction* _tmp20_ = NULL;
				GSimpleAction* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				BaobabWindowActionState _tmp23_ = {0};
				gboolean _tmp24_ = FALSE;
				_tmp17_ = action_state;
				_tmp18_ = _tmp17_.name;
				_tmp19_ = g_action_map_lookup_action ((GActionMap*) self, _tmp18_);
				_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp19_) : NULL);
				action = _tmp20_;
				_tmp21_ = action;
				_tmp22_ = busy;
				_tmp23_ = action_state;
				_tmp24_ = _tmp23_.enable;
				g_simple_action_set_enabled (_tmp21_, _tmp22_ == _tmp24_);
				_g_object_unref0 (action);
				baobab_window_action_state_destroy (&action_state);
			}
		}
	}
	_g_object_unref0 (window);
	_g_object_unref0 (cursor);
}


static void baobab_window_set_ui_state (BaobabWindow* self, GtkWidget* child, gboolean busy) {
	GtkMenuButton* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkStack* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->menu_button;
	_tmp1_ = child;
	_tmp2_ = self->priv->home_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _tmp1_ == _tmp2_);
	_tmp3_ = self->priv->reload_button;
	_tmp4_ = child;
	_tmp5_ = self->priv->result_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, _tmp4_ == _tmp5_);
	_tmp6_ = self->priv->back_button;
	_tmp7_ = child;
	_tmp8_ = self->priv->result_page;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp7_ == _tmp8_);
	_tmp9_ = busy;
	baobab_window_set_busy (self, _tmp9_);
	_tmp10_ = child;
	_tmp11_ = self->priv->home_page;
	if (_tmp10_ == _tmp11_) {
		GSimpleAction* action = NULL;
		GAction* _tmp12_ = NULL;
		GSimpleAction* _tmp13_ = NULL;
		GSimpleAction* _tmp14_ = NULL;
		GtkHeaderBar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "reload");
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp12_) : NULL);
		action = _tmp13_;
		_tmp14_ = action;
		g_simple_action_set_enabled (_tmp14_, FALSE);
		_tmp15_ = self->priv->header_bar;
		_tmp16_ = _ ("Devices & Locations");
		gtk_header_bar_set_title (_tmp15_, _tmp16_);
		_g_object_unref0 (action);
	} else {
		GSimpleAction* action = NULL;
		GAction* _tmp17_ = NULL;
		GSimpleAction* _tmp18_ = NULL;
		GSimpleAction* _tmp19_ = NULL;
		GtkHeaderBar* _tmp20_ = NULL;
		BaobabLocation* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "reload");
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp17_) : NULL);
		action = _tmp18_;
		_tmp19_ = action;
		g_simple_action_set_enabled (_tmp19_, TRUE);
		_tmp20_ = self->priv->header_bar;
		_tmp21_ = self->priv->active_location;
		_tmp22_ = baobab_location_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_header_bar_set_title (_tmp20_, _tmp23_);
		_g_object_unref0 (action);
	}
	_tmp24_ = self->priv->main_stack;
	_tmp25_ = child;
	gtk_stack_set_visible_child (_tmp24_, _tmp25_);
}


static void _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_window_first_row_has_child ((BaobabWindow*) self, _sender, path, iter);
}


static void baobab_window_first_row_has_child (BaobabWindow* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreeModel* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	g_signal_parse_name ("row-has-child-toggled", GTK_TYPE_TREE_MODEL, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled, self);
	_tmp2_ = self->priv->treeview;
	_tmp3_ = path;
	gtk_tree_view_expand_row (_tmp2_, _tmp3_, FALSE);
}


static void baobab_window_expand_first_row (BaobabWindow* self) {
	GtkTreeIter first = {0};
	gboolean _tmp0_ = FALSE;
	GtkTreeView* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->treeview;
	_tmp2_ = gtk_tree_view_get_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	first = _tmp4_;
	if (_tmp5_) {
		GtkTreeView* _tmp6_ = NULL;
		GtkTreeModel* _tmp7_ = NULL;
		GtkTreeModel* _tmp8_ = NULL;
		GtkTreeIter _tmp9_ = {0};
		gboolean _tmp10_ = FALSE;
		_tmp6_ = self->priv->treeview;
		_tmp7_ = gtk_tree_view_get_model (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = first;
		_tmp10_ = gtk_tree_model_iter_has_child (_tmp8_, &_tmp9_);
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreeView* _tmp11_ = NULL;
		GtkTreeView* _tmp12_ = NULL;
		GtkTreeModel* _tmp13_ = NULL;
		GtkTreeModel* _tmp14_ = NULL;
		GtkTreeIter _tmp15_ = {0};
		GtkTreePath* _tmp16_ = NULL;
		GtkTreePath* _tmp17_ = NULL;
		_tmp11_ = self->priv->treeview;
		_tmp12_ = self->priv->treeview;
		_tmp13_ = gtk_tree_view_get_model (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = first;
		_tmp16_ = gtk_tree_model_get_path (_tmp14_, &_tmp15_);
		_tmp17_ = _tmp16_;
		gtk_tree_view_expand_row (_tmp11_, _tmp17_, FALSE);
		_gtk_tree_path_free0 (_tmp17_);
	} else {
		GtkTreeView* _tmp18_ = NULL;
		GtkTreeModel* _tmp19_ = NULL;
		GtkTreeModel* _tmp20_ = NULL;
		_tmp18_ = self->priv->treeview;
		_tmp19_ = gtk_tree_view_get_model (_tmp18_);
		_tmp20_ = _tmp19_;
		g_signal_connect_object (_tmp20_, "row-has-child-toggled", (GCallback) _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled, self, 0);
	}
}


static void baobab_window_set_chart_model (BaobabWindow* self, GtkTreeModel* model, gboolean show_allocated_size) {
	GtkTreeModel* _tmp0_ = NULL;
	BaobabChart* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	BaobabChart* _tmp3_ = NULL;
	BaobabScannerColumns _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	BaobabChart* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	BaobabScannerColumns _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	BaobabChart* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	_tmp1_ = self->priv->rings_chart;
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "max-depth", (GObject*) _tmp1_, "max-depth", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp2_ = model;
	_tmp3_ = self->priv->treemap_chart;
	g_object_bind_property_with_closures ((GObject*) _tmp2_, "max-depth", (GObject*) _tmp3_, "max-depth", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp5_ = show_allocated_size;
	if (_tmp5_) {
		_tmp4_ = BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE;
	} else {
		_tmp4_ = BAOBAB_SCANNER_COLUMNS_SIZE;
	}
	_tmp6_ = self->priv->treemap_chart;
	_tmp7_ = model;
	baobab_chart_set_model_with_columns (_tmp6_, _tmp7_, (guint) BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, (guint) _tmp4_, (guint) BAOBAB_SCANNER_COLUMNS_PARSE_NAME, (guint) BAOBAB_SCANNER_COLUMNS_PERCENT, (guint) BAOBAB_SCANNER_COLUMNS_ELEMENTS, NULL);
	_tmp9_ = show_allocated_size;
	if (_tmp9_) {
		_tmp8_ = BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE;
	} else {
		_tmp8_ = BAOBAB_SCANNER_COLUMNS_SIZE;
	}
	_tmp10_ = self->priv->rings_chart;
	_tmp11_ = model;
	baobab_chart_set_model_with_columns (_tmp10_, _tmp11_, (guint) BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, (guint) _tmp8_, (guint) BAOBAB_SCANNER_COLUMNS_PARSE_NAME, (guint) BAOBAB_SCANNER_COLUMNS_PERCENT, (guint) BAOBAB_SCANNER_COLUMNS_ELEMENTS, NULL);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BaobabWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->scanner);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda10_ (Block4Data* _data4_) {
	BaobabWindow* self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp25_ = {0};
	guint64 alloc_size = 0ULL;
	GtkTreeIter _tmp26_ = {0};
	gboolean show_allocated_size = FALSE;
	guint64 _tmp27_ = 0ULL;
	BaobabCellRendererSize* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	BaobabScannerColumns _tmp30_ = 0;
	gboolean _tmp31_ = FALSE;
	GtkTreeViewColumn* _tmp32_ = NULL;
	BaobabLocation* _tmp33_ = NULL;
	BaobabScanner* _tmp34_ = NULL;
	BaobabScanner* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	GtkWidget* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	{
		baobab_scanner_finish (_data4_->scanner, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch10_g_io_error_cancelled;
			}
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_io_error_cancelled:
	{
		GError* e = NULL;
		gulong _tmp0_ = 0UL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = self->priv->scan_completed_handler;
		if (_tmp0_ > ((gulong) 0)) {
			gulong _tmp1_ = 0UL;
			_tmp1_ = self->priv->scan_completed_handler;
			g_signal_handler_disconnect ((GObject*) _data4_->scanner, _tmp1_);
			self->priv->scan_completed_handler = (gulong) 0;
		}
		_g_error_free0 (e);
		return;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GtkTreeIter iter = {0};
		BaobabScannerState state = 0;
		GtkTreeIter _tmp2_ = {0};
		GtkTreeIter _tmp3_ = {0};
		BaobabScannerState _tmp4_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		gtk_tree_model_get_iter_first ((GtkTreeModel*) _data4_->scanner, &_tmp2_);
		iter = _tmp2_;
		_tmp3_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _data4_->scanner, &_tmp3_, BAOBAB_SCANNER_COLUMNS_STATE, &state, -1);
		_tmp4_ = state;
		if (_tmp4_ == BAOBAB_SCANNER_STATE_ERROR) {
			gchar* primary = NULL;
			const gchar* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			GFile* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp5_ = _ ("Could not scan folder \"%s\"");
			_tmp6_ = baobab_scanner_get_directory (_data4_->scanner);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_file_get_parse_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf (_tmp5_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			primary = _tmp11_;
			_tmp12_ = primary;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			baobab_window_message (self, _tmp12_, _tmp14_, GTK_MESSAGE_ERROR);
			_g_free0 (primary);
		} else {
			gchar* primary = NULL;
			const gchar* _tmp15_ = NULL;
			GFile* _tmp16_ = NULL;
			GFile* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp15_ = _ ("Could not scan some of the folders contained in \"%s\"");
			_tmp16_ = baobab_scanner_get_directory (_data4_->scanner);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_file_get_parse_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf (_tmp15_, _tmp19_);
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp19_);
			primary = _tmp21_;
			_tmp22_ = primary;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			baobab_window_message (self, _tmp22_, _tmp24_, GTK_MESSAGE_WARNING);
			_g_free0 (primary);
		}
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_tree_model_get_iter_first ((GtkTreeModel*) _data4_->scanner, &_tmp25_);
	iter = _tmp25_;
	_tmp26_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _data4_->scanner, &_tmp26_, BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, &alloc_size, -1, -1);
	_tmp27_ = alloc_size;
	show_allocated_size = _tmp27_ > ((guint64) 0);
	_tmp28_ = self->priv->size_column_size_renderer;
	_tmp29_ = show_allocated_size;
	baobab_cell_renderer_size_set_show_allocated_size (_tmp28_, _tmp29_);
	_tmp31_ = show_allocated_size;
	if (_tmp31_) {
		_tmp30_ = BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE;
	} else {
		_tmp30_ = BAOBAB_SCANNER_COLUMNS_SIZE;
	}
	_tmp32_ = self->priv->size_column;
	gtk_tree_view_column_set_sort_column_id (_tmp32_, (gint) _tmp30_);
	_tmp33_ = self->priv->active_location;
	_tmp34_ = baobab_location_get_scanner (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = show_allocated_size;
	baobab_window_set_chart_model (self, (GtkTreeModel*) _tmp35_, _tmp36_);
	_tmp37_ = self->priv->result_page;
	baobab_window_set_ui_state (self, _tmp37_, FALSE);
	_tmp38_ = show_allocated_size;
	if (!_tmp38_) {
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		_tmp39_ = _ ("Could not detect occupied disk sizes.");
		_tmp40_ = _ ("Apparent sizes are shown instead.");
		baobab_window_message (self, _tmp39_, _tmp40_, GTK_MESSAGE_INFO);
	}
}


static void ___lambda10__baobab_scanner_completed (BaobabScanner* _sender, gpointer self) {
	__lambda10_ (self);
}


static void baobab_window_scan_active_location (BaobabWindow* self, gboolean force) {
	Block4Data* _data4_;
	BaobabLocation* _tmp0_ = NULL;
	BaobabScanner* _tmp1_ = NULL;
	BaobabScanner* _tmp2_ = NULL;
	BaobabScanner* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	GtkWidget* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkTreeView* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data4_->scanner = _tmp3_;
	_tmp4_ = g_signal_connect_data (_data4_->scanner, "completed", (GCallback) ___lambda10__baobab_scanner_completed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	self->priv->scan_completed_handler = _tmp4_;
	baobab_window_clear_message (self);
	_tmp5_ = self->priv->result_page;
	baobab_window_set_ui_state (self, _tmp5_, TRUE);
	_tmp6_ = force;
	baobab_scanner_scan (_data4_->scanner, _tmp6_);
	_tmp7_ = self->priv->treeview;
	gtk_tree_view_set_model (_tmp7_, (GtkTreeModel*) _data4_->scanner);
	baobab_window_expand_first_row (self);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


void baobab_window_scan_directory (BaobabWindow* self, GFile* directory, BaobabScanFlags flags) {
	BaobabLocation* location = NULL;
	GFile* _tmp0_ = NULL;
	BaobabScanFlags _tmp1_ = 0;
	BaobabLocation* _tmp2_ = NULL;
	BaobabLocation* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
	BaobabLocation* _tmp14_ = NULL;
	GFileInfo* _tmp15_ = NULL;
	GFileInfo* _tmp16_ = NULL;
	GFileType _tmp17_ = 0;
	BaobabLocation* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	_tmp0_ = directory;
	_tmp1_ = flags;
	_tmp2_ = baobab_location_new_for_file (_tmp0_, _tmp1_);
	location = _tmp2_;
	_tmp3_ = location;
	_tmp4_ = baobab_location_get_info (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		gchar* primary = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp6_ = _ ("\"%s\" is not a valid folder");
		_tmp7_ = directory;
		_tmp8_ = g_file_get_parse_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (_tmp6_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		primary = _tmp11_;
		_tmp12_ = primary;
		_tmp13_ = _ ("Could not analyze disk usage.");
		baobab_window_message (self, _tmp12_, _tmp13_, GTK_MESSAGE_ERROR);
		_g_free0 (primary);
		_baobab_location_unref0 (location);
		return;
	}
	_tmp14_ = location;
	_tmp15_ = baobab_location_get_info (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_file_info_get_file_type (_tmp16_);
	if (_tmp17_ != G_FILE_TYPE_DIRECTORY) {
		gchar* primary = NULL;
		const gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_tmp18_ = _ ("\"%s\" is not a valid folder");
		_tmp19_ = directory;
		_tmp20_ = g_file_get_parse_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf (_tmp18_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		primary = _tmp23_;
		_tmp24_ = primary;
		_tmp25_ = _ ("Could not analyze disk usage.");
		baobab_window_message (self, _tmp24_, _tmp25_, GTK_MESSAGE_ERROR);
		_g_free0 (primary);
		_baobab_location_unref0 (location);
		return;
	}
	_tmp26_ = location;
	baobab_window_set_active_location (self, _tmp26_);
	baobab_window_scan_active_location (self, FALSE);
	_baobab_location_unref0 (location);
}


void baobab_window_action_state_copy (const BaobabWindowActionState* self, BaobabWindowActionState* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).enable;
	(*dest).enable = _tmp2_;
}


void baobab_window_action_state_destroy (BaobabWindowActionState* self) {
	_g_free0 ((*self).name);
}


BaobabWindowActionState* baobab_window_action_state_dup (const BaobabWindowActionState* self) {
	BaobabWindowActionState* dup;
	dup = g_new0 (BaobabWindowActionState, 1);
	baobab_window_action_state_copy (self, dup);
	return dup;
}


void baobab_window_action_state_free (BaobabWindowActionState* self) {
	baobab_window_action_state_destroy (self);
	g_free (self);
}


GType baobab_window_action_state_get_type (void) {
	static volatile gsize baobab_window_action_state_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_action_state_type_id__volatile)) {
		GType baobab_window_action_state_type_id;
		baobab_window_action_state_type_id = g_boxed_type_register_static ("BaobabWindowActionState", (GBoxedCopyFunc) baobab_window_action_state_dup, (GBoxedFreeFunc) baobab_window_action_state_free);
		g_once_init_leave (&baobab_window_action_state_type_id__volatile, baobab_window_action_state_type_id);
	}
	return baobab_window_action_state_type_id__volatile;
}


static void baobab_window_class_init (BaobabWindowClass * klass) {
	gint BaobabWindow_private_offset;
	baobab_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = baobab_window_finalize;
	BaobabWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reload_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, reload_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "home_page", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, home_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "result_page", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, result_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_primary_label", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar_primary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_secondary_label", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar_secondary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "infobar_close_button", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, infobar_close_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_list", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, location_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "size_column", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, size_column));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "size_column_size_renderer", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, size_column_size_renderer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_popup_menu", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview_popup_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_popup_open", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview_popup_open));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_popup_copy", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview_popup_copy));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_popup_trash", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview_popup_trash));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "chart_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, chart_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, spinner_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "chart_stack_switcher", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, chart_stack_switcher));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rings_chart", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, rings_chart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treemap_chart", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treemap_chart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, spinner));
}


static void baobab_window_instance_init (BaobabWindow * self) {
	self->priv = BAOBAB_WINDOW_GET_PRIVATE (self);
	g_type_ensure (BAOBAB_TYPE_CHART);
	g_type_ensure (BAOBAB_TYPE_LOCATION_LIST);
	g_type_ensure (BAOBAB_TYPE_CELL_RENDERER_SIZE);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void baobab_window_finalize (GObject* obj) {
	BaobabWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_WINDOW, BaobabWindow);
	_g_object_unref0 (self->priv->ui_settings);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->reload_button);
	_g_object_unref0 (self->priv->menu_button);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->home_page);
	_g_object_unref0 (self->priv->result_page);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->infobar_primary_label);
	_g_object_unref0 (self->priv->infobar_secondary_label);
	_g_object_unref0 (self->priv->infobar_close_button);
	_g_object_unref0 (self->priv->location_list);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->size_column);
	_g_object_unref0 (self->priv->size_column_size_renderer);
	_g_object_unref0 (self->priv->treeview_popup_menu);
	_g_object_unref0 (self->priv->treeview_popup_open);
	_g_object_unref0 (self->priv->treeview_popup_copy);
	_g_object_unref0 (self->priv->treeview_popup_trash);
	_g_object_unref0 (self->priv->chart_stack);
	_g_object_unref0 (self->priv->spinner_stack);
	_g_object_unref0 (self->priv->chart_stack_switcher);
	_g_object_unref0 (self->priv->rings_chart);
	_g_object_unref0 (self->priv->treemap_chart);
	_g_object_unref0 (self->priv->spinner);
	_baobab_location_unref0 (self->priv->active_location);
	G_OBJECT_CLASS (baobab_window_parent_class)->finalize (obj);
}


GType baobab_window_get_type (void) {
	static volatile gsize baobab_window_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabWindow), 0, (GInstanceInitFunc) baobab_window_instance_init, NULL };
		GType baobab_window_type_id;
		baobab_window_type_id = g_type_register_static (gtk_application_window_get_type (), "BaobabWindow", &g_define_type_info, 0);
		g_once_init_leave (&baobab_window_type_id__volatile, baobab_window_type_id);
	}
	return baobab_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



