/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CLICKCURSORFEEDBACK_H
#define CLICKCURSORFEEDBACK_H

#include <qobject.h>
#include <qtimer.h>

class QWidget;

/** This class survey the keyboard every 0.1 seconds.
  * It change the cursor of the widget
  * @author Sbastien Laot
  */
class ClickCursorFeedback : public QObject
{
  Q_OBJECT
  public:
	ClickCursorFeedback(QObject *parent = 0, const char *name = 0);
	~ClickCursorFeedback();
	void setWidget(QWidget *widget, int curShape, int ctrlCurShape, int altCurShape);
	void stopWidget();
	QWidget* feedbackedWidget() { return m_widget; }
  signals:
	void shiftChanged(bool pressed);
  protected slots:
	void timeout(bool force = false);
  private:
	QWidget *m_widget;
	QTimer   m_timer;
	int      m_curShape;
	int      m_ctrlCurShape;
	int      m_altCurShape;
};

#endif // CLICKCURSORFEEDBACK_H
