/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ITEMDRAG_H
#define ITEMDRAG_H

#include <qdragobject.h>
#include <kmultipledrag.h>

#include <qstring.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <kurl.h>

#include "item.h"

class Basket;

/** QDragObject to drag and drop Items
  * ItemMultipleDrag should be used instead of this
  * @author Sbastien Laot
  */
class ItemDrag : public QDragObject
{
  Q_OBJECT
  public:
	ItemDrag(Item *item, bool cutting, QWidget *parent = 0, const char *name = 0);
	~ItemDrag();
	QString      fullPath() const;
	const char*  format(int i) const;
	QByteArray   encodedData(const char *mimeType) const;
	static bool  canDecode(QMimeSource *source);
	static Item* decode(QMimeSource *source, Basket *parent, bool move);

	/* Variables to handle item type and global properties */
	Item::Type m_type;
	bool       m_isChecked;
	QString    m_annotations;
	QString    m_fileName;
	QString    m_fullPath;

	/* Special variables to handle contents by type */
	QString m_text;
	int     m_textFontType;
//	bool    m_showSource;
	QPixmap m_pixmap;
	QColor  m_color;
	KURL    m_url;
	QString m_title;
	QString m_icon;
	bool    m_autoTitle;
	bool    m_autoIcon;

  public:
	static const char * item_mime_string;
	static QString createAndEmptyCuttingTmpDir();
};

/** QDragObject to drag and drop Items with alternate data representations
  * according to the type of the item
  * @author Sbastien Laot
  */
class ItemMultipleDrag : public KMultipleDrag
{
  Q_OBJECT
  public:
	ItemMultipleDrag(Item *item, bool cutting, QWidget *parent = 0, const char *name = 0);
	~ItemMultipleDrag();
	static QString htmlToText(const QString &html);
};

/** QTextDrag with capabilities to drop GNOME and Mozilla texts
  * as well as UTF-16 texts even if it was supposed to be encoded
  * with local encoding!
  * @author Sbastien Laot
  */
class ExtendedTextDrag : public QTextDrag
{
  Q_OBJECT
  public:
	static bool decode(const QMimeSource *e, QString &str);
	static bool decode(const QMimeSource *e, QString &str, QCString &subtype);
};

#endif // ITEMDRAG_H
