# Copyright (C) 1999, 2000 Jay Beale
# Licensed under the GNU General Public License

package Bastille::FilePermissions;
use lib "/usr/lib";
use strict;
use File::Find ();
use Bastille::API;


## TO DO:
#
#    1) Re-write file permissions from scratch, possibly creating a 
#       smarter chmod for the API...
#    2) Re-do the SUID audit, based on Mandrake and other distros...
#


#######################################################################
##                            File Permissions                       ##
#######################################################################

&GeneralPerms;
#&Activatelibsafe;
&SUIDAudit;
&WritableDirAudit;

sub GeneralPerms {

   &ActionLog("# sub GeneralPerms\n");

# First, we remove world read,execute,write access from some utitilies
# that ordinary users shouldn't need.  

#
# Remove world read, write, execute where it's unnecessary
# This borrowed from a SANS publication, which borrowed/modified it
# from a TrinityOS script.
# 

   my $distro=$GLOBAL_DISTRO;

   if (&getGlobalConfig("FilePermissions","generalperms_1_1") eq "Y") {

   if ($distro =~ /^RH/ or $distro =~ /^MN/ or $distro =~ /^DB/ or $distro =~ /^SE/ or $distro =~ /^TB/) {
	   &B_chmod_if_exists(0700,"/bin/linuxconf");
	   &B_chmod_if_exists(0750,"/bin/mt");
	   &B_chmod_if_exists(0750,"/bin/setserial");
	   &B_chmod_if_exists(0750,"/sbin/badblocks");
	   &B_chmod_if_exists(0750,"/sbin/ctrlaltdel");
	   &B_chmod_if_exists(0750,"/sbin/chkconfig");
	   &B_chmod_if_exists(0750,"/sbin/debugfs");
	   &B_chmod_if_exists(0750,"/sbin/depmod");
	   if ( $distro =~ /^DB/ ) {
		   &B_chmod_if_exists(0750,"/usr/bin/dpkg");
		   &B_chmod_if_exists(0750,"/usr/bin/apt-get");
	   }
	   &B_chmod_if_exists(06750,"/sbin/dump");
	   &B_chmod_if_exists(0750,"/sbin/dumpe2fs");
	   ####### Are there other dump___ programs to worry about?
	   &B_chmod_if_exists(0750,"/sbin/fdisk");
	   &B_chmod_if_exists(0750,"/sbin/fsck");
	   &B_chmod_if_exists(0750,"/sbin/fsck.ext2");
	   &B_chmod_if_exists(0750,"/sbin/fsck.minix");
	   &B_chmod_if_exists(0750,"/sbin/ftl_check");
	   &B_chmod_if_exists(0750,"/sbin/ftl_format");
	   &B_chmod_if_exists(0750,"/sbin/halt");
	   &B_chmod_if_exists(0750,"/sbin/hdparm");
	   &B_chmod_if_exists(0750,"/sbin/hwclock");
	   &B_chmod_if_exists(0750,"/sbin/ifconfig");
	   &B_chmod_if_exists(0750,"/sbin/ifdown");
	   &B_chmod_if_exists(0750,"/sbin/ifport");
	   &B_chmod_if_exists(0750,"/sbin/ifup");
	   &B_chmod_if_exists(0750,"/sbin/ifuser");
	   &B_chmod_if_exists(0750,"/sbin/init");
	   &B_chmod_if_exists(0750,"/sbin/insmod");
	   &B_chmod_if_exists(0750,"/sbin/isapnp");
	   &B_chmod_if_exists(0750,"/sbin/kerneld");
	   &B_chmod_if_exists(0750,"/sbin/killall5");
	   &B_chmod_if_exists(0750,"/sbin/lilo");
	   &B_chmod_if_exists(0750,"/sbin/mingetty");
	   &B_chmod_if_exists(0750,"/sbin/mkbootdisk");
	   &B_chmod_if_exists(0750,"/sbin/mke2fs");
	   &B_chmod_if_exists(0750,"/sbin/mkfs");
	   &B_chmod_if_exists(0750,"/sbin/mkfs.ext2");
	   &B_chmod_if_exists(0750,"/sbin/mkfs.minix");
	   &B_chmod_if_exists(0750,"/sbin/mkfs.msdos");
	   &B_chmod_if_exists(0750,"/sbin/mkinitrd");
	   &B_chmod_if_exists(0750,"/sbin/mkpv");
	   &B_chmod_if_exists(0750,"/sbin/mkraid");
	   &B_chmod_if_exists(0750,"/sbin/mkswap");
	   &B_chmod_if_exists(0750,"/sbin/modinfo");
	   &B_chmod_if_exists(0750,"/sbin/modprobe");
	   &B_chmod_if_exists(02750,"/sbin/netreport");

	   &B_chmod_if_exists(0750,"/sbin/pnpdump");
	   &B_chmod_if_exists(0750,"/sbin/portmap");
	   &B_chmod_if_exists(0750,"/sbin/quotaon");
	   &B_chmod_if_exists(06750,"/sbin/restore");
	   &B_chmod_if_exists(0750,"/sbin/runlevel");
	   &B_chmod_if_exists(0750,"/sbin/stinit");
	   &B_chmod_if_exists(0750,"/sbin/swapon");
	   &B_chmod_if_exists(0750,"/sbin/tune2fs");
	   &B_chmod_if_exists(0750,"/sbin/uugetty");
	   
	   # Comanche was removed from RH6.1 -- don't try to chmod if it doesn't exist
	   if ( $distro ne "RH6.0" and $distro ne "MN6.0" and $distro ne "SE7.2" and $distro ne "TB7.0") {
	       &B_chmod_if_exists(0750,"/usr/bin/comanche");
	   }
	   &B_chmod_if_exists(0750,"/usr/bin/control-panel");
	   &B_chmod_if_exists(0750,"/usr/bin/eject");
	   &B_chmod_if_exists(04750,"/usr/bin/gpasswd");
	   &B_chmod_if_exists(0750,"/usr/bin/kernelcfg");
	   
	   # Deviate from SAN/Trinity script.  Unless we create special 
	   # gnome/xwindows group, removing user access to gnome utilities 
	   # breaks things...
	   
	   # Don't modify any gnome stuff...

	   # Deviate from the SANS/Trinity script here: ordinary users should
	   # not be able to start the news server.  ( Chris Owen )
	   &B_chmod_if_exists(0500,"/usr/bin/inndstart");
	   &B_chmod_if_exists(0500,"/usr/bin/startinnfeed");
	   
	   &B_chmod_if_exists(0755,"/usr/bin/lpq");
	   &B_chmod_if_exists(0755,"/usr/bin/lpqall.faces");
	   &B_chmod_if_exists(0755,"/usr/bin/lprm");
	   &B_chmod_if_exists(0755,"/usr/bin/lptest");
	   &B_chmod_if_exists(0755,"/usr/bin/lpunlock");
	   &B_chmod_if_exists(04755,"/usr/bin/lpr");
	   
	   &B_chmod_if_exists(0750,"/usr/bin/minicom");
	   &B_chmod_if_exists(0750,"/usr/bin/netcfg");
	   
	   &B_chmod_if_exists(0750,"/usr/sbin/atd");
	   &B_chmod_if_exists(0750,"/usr/sbin/atrun");
	   &B_chmod_if_exists(0750,"/usr/sbin/crond");
	   &B_chmod_if_exists(0750,"/usr/sbin/dhcpd");
	   &B_chmod_if_exists(0750,"/usr/sbin/dhcrelay");
	   &B_chmod_if_exists(0750,"/usr/sbin/edquota");
	   &B_chmod_if_exists(0750,"/usr/sbin/exportfs");
	   &B_chmod_if_exists(0750,"/usr/sbin/groupadd");
	   &B_chmod_if_exists(0750,"/usr/sbin/groupdel");
	   &B_chmod_if_exists(0750,"/usr/sbin/groupmod");
	   &B_chmod_if_exists(0750,"/usr/sbin/grpck");
	   &B_chmod_if_exists(0750,"/usr/sbin/grpconv");
	   &B_chmod_if_exists(0750,"/usr/sbin/grpunconv");
	   &B_chmod_if_exists(0750,"/usr/sbin/imapd");
	   &B_chmod_if_exists(0750,"/usr/sbin/in.comsat");
	   &B_chmod_if_exists(0750,"/usr/sbin/in.fingerd");
	   &B_chmod_if_exists(0750,"/usr/sbin/in.identd");
	   &B_chmod_if_exists(0750,"/usr/sbin/in.ntalkd");
	   
	   # deviate from the SANS script for the in.r__d daemons -- these are 
	   # bad news!
	   &B_chmod_if_exists(0000,"/usr/sbin/in.rexecd");
	   &B_chmod_if_exists(0000,"/usr/sbin/in.rlogind");
	   &B_chmod_if_exists(0000,"/usr/sbin/in.rshd");
	   &B_chmod_if_exists(0750,"/usr/sbin/in.telnetd");
	   
	   # deviate from the SANS script -- tftpd has had serious vulnerabilities.
	   &B_chmod_if_exists(0000,"/usr/sbin/in.tftpd");
	   &B_chmod_if_exists(0750,"/usr/sbin/in.timed");
           &B_chmod_if_exists(0750,"/usr/sbin/inetd");
	   &B_chmod_if_exists(0750,"/usr/sbin/ipop2d");
	   &B_chmod_if_exists(0750,"/usr/sbin/ipop3d");
	   
	   # klogd was moved to /sbin in RH6.1, so modify the right file
	   &B_chmod_if_exists(0750,"/usr/sbin/klogd");
	   &B_chmod_if_exists(0750,"/sbin/klogd");
	   
	   &B_chmod_if_exists(0750,"/usr/sbin/logrotate");
	   &B_chmod_if_exists(02750,"/usr/sbin/lpc");
	   &B_chmod_if_exists(0740,"/usr/sbin/lpd");
	   &B_chmod_if_exists(0750,"/usr/sbin/lpf");
	   &B_chmod_if_exists(0755,"/usr/sbin/lsof");
	   &B_chmod_if_exists(0550,"/usr/sbin/makemap");
	   &B_chmod_if_exists(0750,"/usr/sbin/mouseconfig");
	   &B_chmod_if_exists(0750,"/usr/sbin/named");
	   &B_chmod_if_exists(0750,"/usr/sbin/named-xfer");
	   &B_chmod_if_exists(0750,"/usr/sbin/newusers");
	   &B_chmod_if_exists(0750,"/usr/sbin/nmbd");
	   &B_chmod_if_exists(0750,"/usr/sbin/ntpdate");
	   &B_chmod_if_exists(0750,"/usr/sbin/ntpq");
	   &B_chmod_if_exists(0750,"/usr/sbin/ntptime");
	   &B_chmod_if_exists(0750,"/usr/sbin/ntptrace");
	   &B_chmod_if_exists(0750,"/usr/sbin/ntsysv");
	   &B_chmod_if_exists(0750,"/usr/sbin/pppd");
	   &B_chmod_if_exists(0750,"/usr/sbin/pwck");
	   &B_chmod_if_exists(0750,"/usr/sbin/pwconv");
	   &B_chmod_if_exists(0750,"/usr/sbin/pwunconv");
	   &B_chmod_if_exists(0550,"/usr/sbin/quotastats");
	   &B_chmod_if_exists(0750,"/usr/sbin/rdev");
	   &B_chmod_if_exists(0550,"/usr/sbin/repquota");
	   &B_chmod_if_exists(0750,"/usr/sbin/rotatelogs");
	   
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.bootparamd");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.mountd");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.nfsd");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.rquotad");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.rstatd");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.rusersd");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.rwalld");
	   
	   # rpc.statd was moved to /sbin in RH6.1, so modify the right file 
	   
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.statd");
	   &B_chmod_if_exists(0750,"/sbin/rpc.statd");
	   
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.yppasswdd");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpc.ypxfrd");
	   &B_chmod_if_exists(0750,"/usr/sbin/rpcinfo");
	   &B_chmod_if_exists(0750,"/usr/sbin/samba");
	   &B_chmod_if_exists(0750,"/usr/sbin/setup");
	   &B_chmod_if_exists(0750,"/usr/sbin/showmount");
	   &B_chmod_if_exists(0750,"/usr/sbin/smbd");
	   &B_chmod_if_exists(0750,"/usr/sbin/squid");
	   
	   # syslogd was moved to /sbin in RH6.1, so modify the right file
	   
	   &B_chmod_if_exists(0750,"/usr/sbin/syslogd");
	   &B_chmod_if_exists(0750,"/sbin/syslogd");
	   
	   &B_chmod_if_exists(0750,"/usr/sbin/taper");
	   &B_chmod_if_exists(0750,"/usr/sbin/tcpd");
	   &B_chmod_if_exists(0750,"/usr/sbin/tcpdchk");
	   &B_chmod_if_exists(0750,"/usr/sbin/tcpdmatch");
	   &B_chmod_if_exists(0750,"/usr/sbin/tcpdump");
	   &B_chmod_if_exists(0750,"/usr/sbin/timeconfig");
	   &B_chmod_if_exists(0750,"/usr/sbin/timed");
	   &B_chmod_if_exists(0750,"/usr/sbin/tmpwatch");
	   &B_chmod_if_exists(0750,"/usr/sbin/tunelp");
	   &B_chmod_if_exists(0750,"/usr/sbin/useradd");
	   &B_chmod_if_exists(0750,"/usr/sbin/userdel");
	   &B_chmod_if_exists(04750,"/usr/sbin/userhelper");
	   &B_chmod_if_exists(0750,"/usr/sbin/usermod");
	   &B_chmod_if_exists(04750,"/usr/sbin/usernetctl");
	   &B_chmod_if_exists(0750,"/usr/sbin/vipw");
	   &B_chmod_if_exists(0750,"/usr/sbin/xntpd");
	   &B_chmod_if_exists(0750,"/usr/sbin/xntpdc");
       }
       else {
	   &ErrorLog("Didn't carry out general permissions modifications as they are very specific to Red Hat / Mandrake\n");
       }
   }
   if (&getGlobalConfig("FilePermissions", "generalperms_1_2_mandrake")) {
       &ActionLog("# sub GeneralPerms -- 1.2_mandrake");

       my $security_level = &getGlobalConfig("FilePermissions","generalperms_1_2_mandrake");

       # Check the security level
       my $security_level_is_ok = 0;
       my $lvl;
       foreach $lvl (0,1,2,3,4,5) {
	   if ($lvl eq $security_level) {
	       $security_level_is_ok =1;
	   }
       }

       # Change permissions according to Mandrake's level files
       # BUG!  This doesn't respect our B_PREFIX at all!
       unless ($security_level_is_ok) { $security_level = 3; }
       my $return = open PERMFILE, "/usr/share/Bastille/mandrake_perm.$security_level";
       if ($return) {
	   while (my $line = <PERMFILE>) {
	       if ($line = /^(.*)\s+([^\.]+).([^\.]+)\s+(\d+)/) {
		   my $file=$1;
		   my $owner=$2;
		   my $group=$3;
		   my $mode=$4;

		   # BUG: may get wrong value if $GLOBAL_PREFIX is not ''
		   my $uid = (getpwnam($owner))[2];
		   my $gid = (getgrnam($group))[2];
		   
		   &B_chown($uid,$file);
		   &B_chgrp($gid,$file);
		   &B_chmod_if_exists($mode,$file);
	       }
	   }
       }
       else {
	   &ErrorLog("Failed to open permfile /usr/share/Bastille/mandrake_perm.$security_level\nFile permissions not changed\n");
       }

   }

}


sub Activatelibsafe {

    &ActionLog("# sub Activatelibsafe\n");
    
    if (&getGlobalConfig("FilePermissions","libsafe") eq "Y") {

	&B_append_line("/etc/ld.so.preload","/lib/libsafe.so.1.3\n");
	
    }
}


sub SUIDAudit {
   &ActionLog("# sub SUIDAudit\n");
##
### SUID Audit / Correction
##


# First, we list all SUID ROOT programs in the Redhat 6.0 install.
# We include the full list here, at least during the development 
# cycle of this script, to 1) allow easy edits and 2) maintain an 
# easy-to-find list.  Comment lines with names of binaries, thus, are
# just listing a non-modified binary.

#/bin/login
#/bin/su
#	   

   if (&getGlobalConfig("FilePermissions","suidmount") eq "Y") {
       &B_remove_suid(&getGlobal('BIN',"mount"));
       &B_remove_suid(&getGlobal('BIN',"umount"));
       &B_remove_suid(&getGlobal('BIN',"smbmnt"));
       # these appear to be for Debian but are never defined?
       #&B_remove_suid(&getGlobal('BIN',"smbmount-2.2.x"));
       #&B_remove_suid(&getGlobal('BIN',"smbumount-2.2.x"));
       #&B_remove_suid(&getGlobal('BIN',"smbmount-2.0.x"));
       #&B_remove_suid(&getGlobal('BIN',"smbumount-2.0.x"));
   }

   if (&getGlobalConfig("FilePermissions","suidping") eq "Y") {
       &B_remove_suid(&getGlobal('BIN',"ping"));
       # this appears to be for Debian but is never defined?
       #&B_remove_suid(&getGlobal('BIN',"ping6"));
   }
    
#/sbin/pwdb_chkpwd

   if (&getGlobalConfig("FilePermissions","suiddump") eq "Y") {
       &B_remove_suid(&getGlobal('BIN',"dump"));
       &B_remove_suid(&getGlobal('BIN',"restore"));
   }

   if (&getGlobalConfig("FilePermissions","suidcard") eq "Y") {
      &B_remove_suid(&getGlobal('BIN',"cardctl"));
   }
    
#/usr/X11R6/bin/Xwrapper
    
   if (&getGlobalConfig("FilePermissions","suidat") eq "Y") {
       &B_remove_suid(&getGlobal('BIN',"at"));
   }

#/usr/bin/crontab
#/usr/bin/chage
#/usr/bin/gpasswd
#/usr/bin/chfn
#/usr/bin/chsh
#/usr/bin/newgrp 

   if (&getGlobalConfig("FilePermissions","suiddos") eq "Y") {
       &B_remove_suid(&getGlobal('BIN',"dos"));
   }

#/usr/bin/disable-paste ---?????????

   if (&getGlobalConfig("FilePermissions","suidnews") eq "Y") {
        &B_remove_suid( &getGlobal('BIN',"inndstart"));
        &B_remove_suid( &getGlobal('BIN',"startinnfeed"));
       
   }
# Note that these files have different names on HP-UX
# lprm=cancel / lpq=lpstat / lpr=lp (lp is the suid one)
   if (&getGlobalConfig("FilePermissions","suidprint") eq "Y") {
       &B_remove_suid(&getGlobal('BIN',"lpq"));
       &B_remove_suid(&getGlobal('BIN',"lpr"));
       &B_remove_suid(&getGlobal('BIN',"lprm"));
       if ($GLOBAL_DISTRO =~ "^HP-UX") {
	   &B_remove_suid(&getGlobal('BIN',"lpalt"));
       }	   
   }

#/usr/bin/passwd
#/usr/bin/suidperl
#/usr/bin/sperl5.00503
#/usr/bin/procmail

   if (&getGlobalConfig("FilePermissions","suidrtool") eq "Y") {
       &B_chmod_if_exists(000,&getGlobal('BIN',"rcp"));
       &B_chmod_if_exists(000,&getGlobal('BIN',"rlogin"));
       &B_chmod_if_exists(000,&getGlobal('BIN',"rsh"));
       if ( $GLOBAL_DISTRO =~ "^HP-UX") {
	   &B_chmod_if_exists(000,&getGlobal('BIN',"rdist"));
	   &B_chmod_if_exists(000,&getGlobal('BIN',"rexec"));
       }   
   }

#/usr/bin/zgv --- ????????? why does this have suid root?
#/usr/bin/ssh1

   if (&getGlobalConfig("FilePermissions","suidusernetctl") eq "Y") {
       &B_remove_suid(&getGlobal('BIN',"usernetctl"));
   }
    
#/usr/sbin/sendmail

   if (&getGlobalConfig("FilePermissions","suidtrace") eq "Y") {
       &B_remove_suid( &getGlobal('BIN',"traceroute"));
       # for Debian, but not defined?
       #&B_remove_suid( &getGlobal('BIN',"traceroute6"));
   }

#/usr/sbin/userhelper
#/usr/libexec/pt_chown
   
# The following "To Do" list logic applies to all suid files, but right now is asked only on HP-UX
   if (&getGlobalConfig("FilePermissions","suid_general") eq "Y") {
       my $suid_audit_text = 
	"Do an SUID audit to disable unnecessary SUID programs.  :\n    " .
        "The command is: \"find / -perm -4000\".  This will find all \n" .
        "files on your system with the SUID bit set.  Be sure not to \n" .
        "remove the SUID bit on \"su\" or \"login\", because you will be \n" .
        "unable to log back in as root to fix things.  Note that disabling \n" .
        "SUID status on files can break your system in sometimes \n" .
        "unpredictable ways, so be sure to test your changes on a \n" .
        "non-production system first. \n \n \n";
       &B_TODO($suid_audit_text);
   }
}    

#############################################################################
#  &WritableDirAudit;
#    This subroutine uses a perl find to generate a list of all of the
#    world writable directories for the target machine.  It then processes
#    the these permissions and bases on directory name and nesting it
#    generates a shell script with suggested values for permissions.
#
#    uses B_TODO B_append_line B_create_file B_blank_file
#############################################################################
sub WritableDirAudit {
    &ActionLog("# sub WritableDirAudit\n");
    if (&getGlobalConfig("FilePermissions","world_writeable") eq "Y") {
# Set the variable $File::Find::dont_use_nlink if you're using AFS,
# since AFS cheats.

# for the convenience of &wanted calls, including -eval statements:
    use vars qw/*name *dir *prune/;
    *name   = *File::Find::name;
    *dir    = *File::Find::dir;
    *prune  = *File::Find::prune;
    my $strShell = ""; # Keeps all of the directories found by find.

    &B_TODO("The directories listed in the shell script are world-writable.\n" .
            "With the exception of /tmp and /var/tmp, world-writable \n" .
            "directories are vulnerabilities.  You should examine \n" .
            "each of the directories in the sh script to see if you want to \n" .
            "leave it this way.  You should chmod +t <dirname> in \n" .
            "most cases to ensure the default owner is the one who made \n" .
            "the file.\n" .
	    "The output has been formated in a shell script.\n" .
	    "The shell script is can be found in the following location:\n" . 
	    &getGlobal('BFILE',"directory-perms.sh") . "\n" . 
	    "The values in this shell script are just suggestions\n" . 
	    "and should be modified as you see fit.\n" . 
	    "Note: Do not run the shell script without examining\n" . 
	    "it closely. It will break some applications and therefore\n" . 
	    "should be customized to your specific needs.\n\n");

    &B_create_file(&getGlobal('BFILE', "directory-perms.sh"));
    # the unmatchable regexp will insure that the file is always 
    # blanked "a$b" or 'a' endofstring 'b'
    &B_blank_file(&getGlobal('BFILE', "directory-perms.sh"),'a$b');
    &B_append_line(&getGlobal('BFILE', "directory-perms.sh"),"0",
		   "# Please review the following shell script and modify\n" . 
		   "# it to suit the needs of the system.\n" .
		   "# If you comment out a chmod also comment out the echo\n" .
		   "# one line below it\n\n");
    
    


    my @rwx = qw(--- --x -w- -wx r-- r-x rw- rwx);
    my @moname = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
    my (%uid, %user);
    while (my ($name, $pw, $uid) = getpwent) {
	$user{$uid} = $name unless exists $user{$uid};
    }
    my (%gid, %group);
    while (my ($name, $pw, $gid) = getgrent) {
	$group{$gid} = $name unless exists $group{$gid};
    }
# Traverse desired filesystems
  File::Find::find({wanted => \&wanted}, '/');
    
    sub wanted {
	my ($dev,$ino,$mode,$nlink,$uid,$gid);
	
	(($dev,$ino,$mode,$nlink,$uid,$gid) = lstat($_)) &&
	    ! ($dev >= 0) &&
		($File::Find::prune = 1)
		    ||
			(($mode & 02) == 02) && -d _ && &ls;
    }

sub sizemm {
    my $rdev = shift;
    sprintf("%3d, %3d", ($rdev >> 8) & 0xff, $rdev & 0xff);
}

sub ls {
    my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
        $atime,$mtime,$ctime,$blksize,$blocks) = lstat(_);
    my $pname = $name;
    
    $blocks
        or $blocks = int(($size + 1023) / 1024);
    my $newperm = "";
    my $oldperm = "";
    my $perms = "";

    if($pname !~ /tmp/){
	$newperm = ($mode & 7) - 2;
	$oldperm = ($mode & 7);
	$perms = $rwx[$mode & 7];
	$mode >>= 3;

	$newperm = ($mode & 7) . $newperm;
	$oldperm = ($mode & 7) . $oldperm;
	$perms = $rwx[$mode & 7] . $perms;
	$mode >>= 3;
	
	$oldperm = ($mode & 7) . $oldperm;
	$newperm = ($mode & 7) . $newperm;
	$perms = $rwx[$mode & 7] . $perms;
    }
    else {
	$newperm = ($mode & 7);
	$oldperm = ($mode & 7);
	$perms = $rwx[$mode & 7];
	$mode >>= 3;

	$newperm = ($mode & 7) . $newperm;
	$oldperm = ($mode & 7) . $oldperm;
	$perms = $rwx[$mode & 7] . $perms;
	$mode >>= 3;
	
	$newperm = ($mode & 7) . $newperm;
	$oldperm = ($mode & 7) . $oldperm;
	$perms = $rwx[$mode & 7] . $perms;
	$newperm = "1" . $newperm;
	$oldperm = "0" . $oldperm;
    }
    substr($perms, 2, 1) =~ tr/-x/Ss/ if -u _;
    substr($perms, 5, 1) =~ tr/-x/Ss/ if -g _;
    substr($perms, 8, 1) =~ tr/-x/Tt/ if -k _;
    if    (-f _) { $perms = '-' . $perms; }
    elsif (-d _) { $perms = 'd' . $perms; }
    elsif (-l _) { $perms = 'l' . $perms; $pname .= ' -> ' . readlink($_); }
    elsif (-c _) { $perms = 'c' . $perms; $size = sizemm($rdev); }
    elsif (-b _) { $perms = 'b' . $perms; $size = sizemm($rdev); }
    elsif (-p _) { $perms = 'p' . $perms; }
    elsif (-S _) { $perms = 's' . $perms; }
    else         { $perms = '?' . $perms; }
    
    my $user = $user{$uid} || $uid;
    my $group = $group{$gid} || $gid;
    my ($sec,$min,$hour,$mday,$mon,$timeyear) = localtime($mtime);
    if (-M _ > 365.25 / 2) {
        $timeyear += 1900;
    } else {
        $timeyear = sprintf("%02d:%02d", $hour, $min);
    }
    my $swString = "";
    if(defined &getGlobalSwlist("$pname")){
	# defining additional swmodify command if directory is in IPD. 
	$swString = "; " . &getGlobal('BIN',"swmodify") . 
	    " -x files=\'$pname\' " . &getGlobalSwlist("$pname");
    } 
    # Generating WORLD WRITEABLE DIR shell commands for directory-perms.sh
    $strShell .= "# $perms   $user   $group   $moname[$mon]   $mday   " . 
            "$timeyear   $pname \n" . 
	     &getGlobal('BIN', "chmod") . " $newperm \'$pname\'" . $swString .
	     "\n" . &getGlobal('BIN',"echo") . " \"" .
	     &getGlobal('BIN', "chmod") . " $oldperm \'$pname\'" . $swString .
	     "\" >> " . &getGlobal('BFILE',"undo-directory-perms.sh") . "\n";
			;
} # ls subroutine

# This section prepends undo-directory-perms.sh to the undo-actions file.
# undo-directory-perms is generated by directory-perms.sh and unmakes the
# script's permission changes.
$strShell .= &getGlobal('BIN',"mv") . " " . &getGlobal('BFILE',"undo-actions") .
    " " . &getGlobal('BFILE',"undo-actions") . ".bastille\n" .
    &getGlobal('BIN',"echo") . " \"" . &getGlobal('BFILE',"undo-directory-perms.sh") .
    "\" > " .  &getGlobal('BFILE',"undo-actions") . "\n" . 
    &getGlobal('BIN',"echo") . " \"" . &getGlobal('BIN',"mv") . " " .
    &getGlobal('BFILE',"undo-directory-perms.sh") . " " . &getGlobal('BFILE',"undo-directory-perms.sh") .
    ".last\" >> " .  &getGlobal('BFILE',"undo-actions") . "\n" . 
    &getGlobal('BIN',"echo") . " \"" . &getGlobal('BIN',"chmod") . " 500 " .
    &getGlobal('BFILE',"undo-directory-perms.sh") . ".last\" >> " .  
    &getGlobal('BFILE',"undo-actions") . "\n" . 
    &getGlobal('BIN',"cat") . " " .  &getGlobal('BFILE',"undo-actions") . ".bastille" .
    " >>" .  &getGlobal('BFILE',"undo-actions") . "\n" .
    &getGlobal('BIN',"rm") . " " .  &getGlobal('BFILE',"undo-actions") . ".bastille\n" .
    &getGlobal('BIN',"chown") . " root:sys " .  &getGlobal('BFILE',"undo-actions") . "\n" .
    &getGlobal('BIN',"chmod") . " 0500 " .  &getGlobal('BFILE',"undo-actions") . "\n" .
    &getGlobal('BIN',"chown") . " root:sys " .  &getGlobal('BFILE',"undo-directory-perms.sh") . "\n" .
    &getGlobal('BIN',"chmod") . " 0500 " .  &getGlobal('BFILE',"undo-directory-perms.sh") . "\n";
&B_append_line(&getGlobal('BFILE', "directory-perms.sh"),"0",$strShell);

} # if question is yes
} # End Audit Subroutine
1;




























