// resource.hh for bbppp - a ppp connection manager for Blackbox
//
//  Copyright (c) 1998-2000 John Kennis, jkennis@chello.nl
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "bbppp.hh"
#include "Baseresource.hh"

struct FRAME
{
	int width;
	int height;
	BTexture texture;
	int bevelWidth;
	int withdrawn_bevelWidth;
	XFontStruct *font;
};

struct POSITION
{
	int x;
	int y;
	int mask;
};

struct LABEL
{
	int width;
	int width0, width1, width2, width3;
	int height;
	bool transparent;
	BTexture texture;
	XFontStruct *font;
	BColor textColor;
};

struct BUTTON
{
	int width;
	int height;
	int bevelWidth;
	BTexture texture;
	BTexture texture_pressed;
	BColor tx_on_color;
	BColor tx_off_color;
	BColor rx_on_color;
	BColor rx_off_color;
	BColor switch_on_color;
	BColor switch_off_color;
	BColor switch_switching_color;
};

struct SHOW
{
	bool upTimeLabel;
	bool thruputLabel;
	bool showsecs;
};

struct REPORT
{
	bool auto_raise;
	unsigned int check_delay;
	char *startCommand;
	char *stopCommand;
	char *resumeCommand;
};


class Resource : public BaseResource
{
public:
	Resource(ToolWindow *);
	~Resource(void);

	struct FRAME frame;
	struct LABEL label;
	struct POSITION position;
	struct SHOW show;
	struct REPORT report;
	struct BUTTON button;
	bool compact;
	bool vertOrient;

protected:
	virtual void  LoadBBToolResource(void);

private:
	char defaultFont[100];

	void ButtonStyle();
	void SetDefaultFont();
	void Frame(void);
	void SizeAndPosition(void);
	void MailCheckSettings(void);
	void Label(void);
	void Show(void);
	void Button(void);
	void Envelope(void);
	void MailboxDep(void);
	void Menu(void);
	void GetActions(void);
	void Clean(void);
};
#endif /* __RESOURCE_HH */
