/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998, 1999, 2000 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * bsehunkmixer.h: BSE chunk mixing functions
 */
#ifndef __BSE_HUNK_MIXER_H__
#define __BSE_HUNK_MIXER_H__

#include        <bse/bsechunk.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* --- defines --- */
#define BSE_CLIP_SAMPLE_VALUE(value)	(_bse_sample_value_clip (value))


/* --- prototypes --- */
void	bse_hunk_mix			(guint                 n_dest_tracks,
					 BseSampleValue       *dest_hunk,
					 const gfloat         *dest_volumes,
					 guint                 n_src_tracks,
					 const BseSampleValue *src_hunk);
void	bse_hunk_fill			(guint		       n_tracks,
					 BseSampleValue	      *hunk,
					 BseSampleValue	       value);
void	bse_hunk_clip_from_mix_buffer	(guint                 n_tracks,
					 BseSampleValue       *dest_hunk,
					 gfloat                master_volume,
					 BseMixValue          *src_mix_buffer);


/* --- implementation details --- */
#ifdef  __GNUC__
#define _bse_sample_value_clip(value)	\
({ \
  __typeof__ (value) __tmp_value = (value); \
  if (__tmp_value > BSE_MAX_SAMPLE_VALUE) \
    __tmp_value = BSE_MAX_SAMPLE_VALUE; \
  else if (__tmp_value < -BSE_MAX_SAMPLE_VALUE) \
    __tmp_value = -BSE_MAX_SAMPLE_VALUE; \
  __tmp_value; \
})
#else /* !__GNUC__ */
static inline BseSampleValue
_bse_sample_value_clip (BseMixValue value)
{
  if (value > BSE_MAX_SAMPLE_VALUE)
    return BSE_MAX_SAMPLE_VALUE;
  else if (value < -BSE_MAX_SAMPLE_VALUE)
    return -BSE_MAX_SAMPLE_VALUE;
  else
    return value;
}
#endif /* !__GNUC__ */




#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __BSE_HUNK_MIXER_H__ */
