/*  beef - Flexible Brainfuck interpreter
 *  Copyright (C) 2005-2007  KiyuKo <eof AT kiyuko DOT org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Homepage: http://www.kiyuko.org/beef
 */

#include "beef.h"

struct instruction *load (FILE *fp, char debug)
{
  struct instruction *first;
  struct instruction *current;
  char c, d;
  long i;

  /* Create a new instruction */
  current = (struct instruction *) malloc (sizeof (struct instruction));
  first = current;

  /* Read first character */
  c = fgetc (fp);

  /* Possibly a sha-bang line */
  if (c == '#') {

    /* Read second character */
    d = fgetc (fp);

     /* It matches. Ignore the first line */
    if (d == '!') {
      while ((d != '\n') && (!feof (fp))) {
        d = fgetc (fp);
      }

      /* Read first useful character */
      c = fgetc (fp);
    }

    /* Not a sha-bang line. Put the second character back to the input
     * stream */
    else {
      ungetc (d, fp);
    }
  }

  /* Stop when end of file is reached */
  while (!feof (fp)) {
    /* Reset the quantity counter */
    i = 0;

    switch (c) {
      case '[':
        current->type = c;
        current->quantity = 1;
        /* Read the loop calling this same function */
        current->loop = load (fp, debug);
        break;

      case ']':
        current->type = c;
        current->quantity = 1;
        /* We're finished reading the loop, return the code */
        return first;
        break;

      case '<': case '>':
      case '+': case '-':
      case '.': case ',':
      case '#':
        /* Ignore any # if debug is turned off */
        if (((c == '#') && (debug == ON)) || (c != '#')) {
          current->type = c;
          if (!feof (fp)) {
            /* Stop at end of file, or at the firts different char */
            do {
              /* Increase the counter */
              i++;
              /* Read another char */
              d = fgetc (fp);
            } while ((!feof (fp)) && (c == d));
            /* Return the last char to the input stream */
            ungetc (d, fp);
            current->quantity = i;
          }
        }
        break;

      default:
        /* Ignore any other char */
        break;
    }
    
    /* Instruction stored correctly: create a new one */
    if (current->quantity != 0) {
      current->next =(struct instruction *) malloc (sizeof(struct instruction));
      current = current->next;
    }

    /* Read a char from the input stream */
    c = fgetc (fp);
  }

  /* This is the closing instruction */
  current->type = ']';
  return first;
}

