/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __DIALOGS_H__
#define __DIALOGS_H__

#include "servers.h"

#define DIALOG_CALLBACK(c) \
        void c(void *data)    

/* ------------------------------CHOICE_DIALOG---------------------------- */
typedef struct _ChoiceData {
  GtkWidget *dialog;
  void *user_data;
  void (*positive_func)(void *data);
  void (*negative_func)(void *data);
} ChoiceData;

void choice_dialog(void *user_data,
		   char *title,
		   char *question,
		   char *positive,
		   char *negative,
		   void (*positive_func)(void *data),
		   void (*negative_func)(void *data));
/* ----------------------------------------------------------------------- */

/* -----------------------FILE_SELECTION_DIALOG--------------------------- */
typedef struct _FileSelData {
  GtkWidget *window;
  void *user_data;
  int (*ok_func)(char *filename, void *data);
  void (*cancel_func)(void *data);
} FileSelData;

#define FILESEL_OK_CALLBACK(c) \
        int c(char *filename, void *data)    

#define FILESEL_CANCEL_CALLBACK(c) \
        void c(void *data)

void file_selection_dialog(void *user_data, int (*ok_func)(char *filename, void *data), 
			   void (*cancel_func)(void *data));
/* ----------------------------------------------------------------------- */

/* --------------------------PROGRESS_DIALOG------------------------------ */
typedef struct _ProgressData {
  GtkWidget *dialog;
  GtkWidget *progress_bar;
  void *user_data;
  void (*cancel_func)(void *data);
} ProgressData;

void progress_cancel(GtkWidget *widget, ProgressData *progress_data);
void progress_done(ProgressData *progress_data);
void progress_update(float value, ProgressData *progress_data);
ProgressData *progress_dialog(void *user_data, char *title, char *text, void (*cancel_func)(void *data));
/* ----------------------------------------------------------------------- */

/* ------------------------PREFERENCES_DIALOG----------------------------- */
typedef struct _PreferencesData {
  GtkWidget *dialog;
  GtkWidget *notebook;
  GdkPixmap *book_open;
  GdkPixmap *book_closed;
  GdkBitmap *book_open_mask;
  GdkBitmap *book_closed_mask;
} PreferencesData;

typedef struct _NotebookPage {
  char *name;
  void *data;
  GtkWidget*  (*create)(void **pref_data);
  gint  (*save)(void *pref_data);
  void  (*reset)(void *pref_data);
} NotebookPage;

typedef struct _UserPrefsData {
  GtkWidget *nick;
  GtkWidget *name;
  GtkWidget *server;
  GtkWidget *port;
} UserPrefsData;

typedef enum {
  FONT_NORMAL,
  FONT_BOLD,
  FONT_ITALIC,
  FONT_BOLD_ITALIC
} Font_Type;

typedef struct _FontPrefsData {
  GtkWidget *std_frame;
  GtkWidget *adv_frame;
  GtkWidget *std_type_omenu;
  GtkWidget *std_size_omenu;
  GtkWidget *adv_button;
  GtkWidget *adv_normal_label;
  GtkWidget *adv_bold_label;
  GtkWidget *adv_italic_label;
  GtkWidget *adv_bold_italic_label;
  
  char *adv;
  char *type;
  char *size;

  GtkWidget *font_sel;
  Font_Type changing_font;
  char *normal_font;
  char *bold_font;
  char *italic_font;
  char *bold_italic_font;
} FontPrefsData;

/* This has to agree with 'NotebookPage pages[]' struct in dialogs.c */
typedef enum {
  PREFS_DEFAULT = -1,
  PREFS_PERSONA_PAGE=0,
  PREFS_FONTS_PAGE,
  PREFS_SERVERS_PAGE,
} Prefs_Page;

void preferences_dialog(Prefs_Page start_page);
/* ----------------------------------------------------------------------- */

/* ------------------------NICK_DIALOG----------------------------- */

typedef struct _NickData {
  GtkWidget *dialog;
  GtkWidget *entry;

  Connection *connection;
} Nick_Data;

void nick_dialog(Connection *connection, char *message);
void about_dialog();
int script_dialog();

#endif /* __DIALOGS_H__ */
