/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __MESSAGE_H__
#define __MESSAGE_H__

#include <glib.h>
#include <gdk/gdk.h>

#include "servers.h"

typedef enum {
  MT_CONSOLE,
  MT_CHANNEL,
  MT_NICK,
} MsgType;

typedef struct _MessagePart {
  GdkColor *fg_colour;
  GdkColor *bg_colour;
  GdkFont  *font;
  char *text;
} MessagePart;

typedef struct _Message {
  int type;
  struct _Connection *connection;
  char *source;
  GSList *parts;
} Message;

Message *message_new(MsgType type, Connection *connection, char *source);
MessagePart *message_part_new(GdkColor *fg_colour, GdkColor *bg_colour, GdkFont *font, char *text);
GSList *message_part_parse_new(GSList *parts_list, GdkColor *default_colour, char *text);
void messages_write();

#endif /* __MESSAGE_H__ */
